/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.transformer;

import java.util.List;
import java.util.Map;
import net.sf.jxls.controller.SheetTransformationController;
import net.sf.jxls.processor.RowProcessor;
import net.sf.jxls.tag.Block;
import net.sf.jxls.transformation.ResultTransformation;
import net.sf.jxls.transformer.Row;
import net.sf.jxls.transformer.RowTransformer;
import net.sf.jxls.transformer.Sheet;
import net.sf.jxls.transformer.SheetTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChainTransformer {
    protected static final Log log = LogFactory.getLog(ChainTransformer.class);
    List transformers;
    Sheet sheet;
    List rowProcessors;
    Row parentRow;

    public ChainTransformer(List transformers, Sheet sheet, List rowProcessors, Row parentRow) {
        this.transformers = transformers;
        this.sheet = sheet;
        this.rowProcessors = rowProcessors;
        this.parentRow = parentRow;
    }

    public ChainTransformer(List transformers, List rowProcessors, Row parentRow) {
        this.transformers = transformers;
        this.rowProcessors = rowProcessors;
        this.parentRow = parentRow;
    }

    public ChainTransformer(List transformers, List rowProcessors) {
        this.transformers = transformers;
        this.rowProcessors = rowProcessors;
    }

    public ChainTransformer(List transformers) {
        this.transformers = transformers;
    }

    ResultTransformation transform(SheetTransformationController stc, SheetTransformer sheetTransformer, Map beans) {
        ResultTransformation resultTransformation = new ResultTransformation();
        int i = 0;
        int c = this.transformers.size();
        while (i < c) {
            RowTransformer rowTransformer = (RowTransformer)this.transformers.get(i);
            Block transformationBlock = rowTransformer.getTransformationBlock();
            transformationBlock = resultTransformation.transformBlock(transformationBlock);
            rowTransformer.setTransformationBlock(transformationBlock);
            log.debug((Object)(String.valueOf(rowTransformer.getClass().getName()) + ", " + rowTransformer.getTransformationBlock()));
            Row row = rowTransformer.getRow();
            row.setParentRow(this.parentRow);
            this.applyRowProcessors(row);
            resultTransformation.add(rowTransformer.transform(stc, sheetTransformer, beans, resultTransformation));
            ++i;
        }
        return resultTransformation;
    }

    private void applyRowProcessors(Row row) {
        int i = 0;
        int c = this.rowProcessors.size();
        while (i < c) {
            RowProcessor rowProcessor = (RowProcessor)this.rowProcessors.get(i);
            rowProcessor.processRow(row, this.sheet.getNamedCells());
            ++i;
        }
    }
}

