/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.transformer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jxls.controller.SheetTransformationController;
import net.sf.jxls.parser.Cell;
import net.sf.jxls.processor.CellProcessor;
import net.sf.jxls.transformation.ResultTransformation;
import net.sf.jxls.transformer.BaseRowTransformer;
import net.sf.jxls.transformer.CellTransformer;
import net.sf.jxls.transformer.Configuration;
import net.sf.jxls.transformer.Row;
import net.sf.jxls.transformer.Sheet;
import net.sf.jxls.transformer.SheetTransformer;

public class SimpleRowTransformer
extends BaseRowTransformer {
    Configuration configuration;
    List cellProcessors;
    List cells = new ArrayList();
    private ResultTransformation resultTransformation;

    public SimpleRowTransformer(Row row, List cellProcessors, Configuration configuration) {
        this.row = row;
        this.cellProcessors = cellProcessors;
        this.configuration = configuration;
    }

    public void addCell(Cell cell) {
        if (!cell.isEmpty()) {
            this.cells.add(cell);
        }
    }

    public ResultTransformation getTransformationResult() {
        return this.resultTransformation;
    }

    public List getCells() {
        return this.cells;
    }

    public ResultTransformation transform(SheetTransformationController stc, SheetTransformer sheetTransformer, Map beans, ResultTransformation previousTransformation) {
        CellTransformer cellTransformer = new CellTransformer(this.configuration);
        if (this.cells.isEmpty()) {
            int j = 0;
            int c = this.row.getCells().size();
            while (j < c) {
                Cell cell = (Cell)this.row.getCells().get(j);
                if (this.configuration.getCellKeyName() != null) {
                    beans.put(this.configuration.getCellKeyName(), cell.getPoiCell());
                }
                this.applyCellProcessors(this.row.getSheet(), cell);
                cellTransformer.transform(cell);
                ++j;
            }
        } else {
            int i = 0;
            int c = this.cells.size();
            while (i < c) {
                Cell cell = (Cell)this.cells.get(i);
                if (this.configuration.getCellKeyName() != null) {
                    beans.put(this.configuration.getCellKeyName(), cell.getPoiCell());
                }
                if (previousTransformation != null && cell.getPoiCell().getColumnIndex() >= previousTransformation.getStartCellShift() && previousTransformation.getStartCellShift() != 0) {
                    cell.replaceCellWithNewShiftedBy(previousTransformation.getLastCellShift());
                }
                this.applyCellProcessors(this.row.getSheet(), cell);
                cellTransformer.transform(cell);
                ++i;
            }
        }
        this.resultTransformation = new ResultTransformation();
        return this.resultTransformation;
    }

    private void applyCellProcessors(Sheet sheet, Cell cell) {
        int i = 0;
        int c = this.cellProcessors.size();
        while (i < c) {
            CellProcessor cellProcessor = (CellProcessor)this.cellProcessors.get(i);
            cellProcessor.processCell(cell, sheet.getNamedCells());
            ++i;
        }
    }
}

