/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.transformer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jxls.formula.FormulaController;
import net.sf.jxls.formula.FormulaControllerImpl;
import net.sf.jxls.transformer.Configuration;
import net.sf.jxls.transformer.Sheet;
import net.sf.jxls.util.SheetHelper;

public class Workbook {
    List sheets = new ArrayList();
    org.apache.poi.ss.usermodel.Workbook hssfWorkbook;
    FormulaController formulaController;
    Configuration configuration = new Configuration();

    public Workbook(org.apache.poi.ss.usermodel.Workbook hssfWorkbook) {
        this.hssfWorkbook = hssfWorkbook;
    }

    public Workbook(org.apache.poi.ss.usermodel.Workbook hssfWorkbook, Configuration configuration) {
        this.hssfWorkbook = hssfWorkbook;
        this.configuration = configuration;
    }

    public Workbook(org.apache.poi.ss.usermodel.Workbook hssfWorkbook, List sheets) {
        this.hssfWorkbook = hssfWorkbook;
        this.sheets = sheets;
    }

    public Workbook(org.apache.poi.ss.usermodel.Workbook hssfWorkbook, List sheets, Configuration configuration) {
        this.hssfWorkbook = hssfWorkbook;
        this.sheets = sheets;
        this.configuration = configuration;
    }

    public org.apache.poi.ss.usermodel.Workbook getPoiWorkbook() {
        return this.hssfWorkbook;
    }

    public void setPoiWorkbook(org.apache.poi.ss.usermodel.Workbook hssfWorkbook) {
        this.hssfWorkbook = hssfWorkbook;
    }

    public void addSheet(Sheet sheet) {
        this.sheets.add(sheet);
        sheet.setWorkbook(this);
    }

    public void initSheetNames() {
        int i = 0;
        int c = this.sheets.size();
        while (i < c) {
            Sheet sheet = (Sheet)this.sheets.get(i);
            sheet.initSheetName();
            ++i;
        }
    }

    public Map getListRanges() {
        HashMap listRanges = new HashMap();
        int i = 0;
        int c = this.sheets.size();
        while (i < c) {
            Sheet sheet = (Sheet)this.sheets.get(i);
            listRanges.putAll(sheet.getListRanges());
            ++i;
        }
        return listRanges;
    }

    public List findFormulas() {
        ArrayList formulas = new ArrayList();
        int i = 0;
        int c = this.sheets.size();
        while (i < c) {
            Sheet sheet = (Sheet)this.sheets.get(i);
            formulas.addAll(SheetHelper.findFormulas(sheet));
            ++i;
        }
        return formulas;
    }

    public Map createFormulaSheetMap() {
        HashMap<String, List> formulas = new HashMap<String, List>();
        int i = 0;
        int c = this.sheets.size();
        while (i < c) {
            Sheet sheet = (Sheet)this.sheets.get(i);
            formulas.put(sheet.getSheetName(), SheetHelper.findFormulas(sheet));
            ++i;
        }
        return formulas;
    }

    public FormulaController createFormulaController() {
        this.formulaController = new FormulaControllerImpl(this);
        return this.formulaController;
    }

    public FormulaController getFormulaController() {
        return this.formulaController;
    }

    public List getSheets() {
        return this.sheets;
    }

    public int getNumberOfSheets() {
        return this.sheets.size();
    }

    public Sheet getSheetAt(int sheetNo) {
        return (Sheet)this.sheets.get(sheetNo);
    }

    public void removeSheetAt(int sheetNo) {
        this.hssfWorkbook.removeSheetAt(sheetNo);
        this.sheets.remove(sheetNo);
    }
}

