/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.Namespace;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;

final class T4CTTIokeyval
extends T4CTTIfun {
    static final byte KVASET_KPDUSR = 1;
    static final byte KVACLA_KPDUSR = 2;
    private byte[] namespaceByteArr;
    private char[] charArr;
    private byte[][] attrArr;
    private int[] attrArrSize;
    private byte[][] valueArr;
    private int[] valueArrSize;
    private byte[] kvalflg;
    private int nbNamespaceBytes;
    private int nbKeyVal;
    private boolean clear;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Feb_23_16:38:22_PST_2010";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    T4CTTIokeyval(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)17);
        this.setFunCode((short)154);
        this.namespaceByteArr = new byte[100];
        this.charArr = new char[100];
        this.attrArr = new byte[10][];
        this.attrArrSize = new int[10];
        this.valueArr = new byte[10][];
        this.valueArrSize = new int[10];
        this.kvalflg = new byte[10];
    }

    void doOKEYVAL(Namespace namespace) throws IOException, SQLException {
        String string = namespace.name;
        String[] stringArray = namespace.keys;
        String[] stringArray2 = namespace.values;
        this.clear = namespace.clear;
        this.nbKeyVal = namespace.nbPairs;
        int n2 = string.length() * this.meg.conv.cMaxCharSize;
        if (n2 > this.namespaceByteArr.length) {
            this.namespaceByteArr = new byte[n2];
        }
        if (string.length() > this.charArr.length) {
            this.charArr = new char[string.length()];
        }
        string.getChars(0, string.length(), this.charArr, 0);
        this.nbNamespaceBytes = this.meg.conv.javaCharsToCHARBytes(this.charArr, 0, this.namespaceByteArr, 0, string.length());
        if (this.nbKeyVal > 0) {
            if (this.nbKeyVal > this.attrArr.length) {
                this.attrArr = new byte[this.nbKeyVal][];
                this.attrArrSize = new int[this.nbKeyVal];
                this.valueArr = new byte[this.nbKeyVal][];
                this.valueArrSize = new int[this.nbKeyVal];
                this.kvalflg = new byte[this.nbKeyVal];
            }
            for (int i2 = 0; i2 < this.nbKeyVal; ++i2) {
                String string2 = stringArray[i2];
                String string3 = stringArray2[i2];
                int n3 = string2.length() * this.meg.conv.cMaxCharSize;
                if (this.attrArr[i2] == null || this.attrArr[i2].length < n3) {
                    this.attrArr[i2] = new byte[n3];
                }
                int n4 = string3.length() * this.meg.conv.cMaxCharSize;
                if (this.valueArr[i2] == null || this.valueArr[i2].length < n4) {
                    this.valueArr[i2] = new byte[n4];
                }
                if (string2.length() > this.charArr.length) {
                    this.charArr = new char[string2.length()];
                }
                string2.getChars(0, string2.length(), this.charArr, 0);
                this.attrArrSize[i2] = this.meg.conv.javaCharsToCHARBytes(this.charArr, 0, this.attrArr[i2], 0, string2.length());
                if (string3.length() > this.charArr.length) {
                    this.charArr = new char[string3.length()];
                }
                string3.getChars(0, string3.length(), this.charArr, 0);
                this.valueArrSize[i2] = this.meg.conv.javaCharsToCHARBytes(this.charArr, 0, this.valueArr[i2], 0, string3.length());
            }
        }
        this.doPigRPC();
    }

    void marshal() throws IOException {
        this.meg.marshalPTR();
        this.meg.marshalUB4(this.nbNamespaceBytes);
        if (this.nbKeyVal > 0) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalUB4(this.nbKeyVal);
        int n2 = 0;
        if (this.nbKeyVal > 0) {
            n2 = 1;
        }
        if (this.clear) {
            n2 |= 2;
        }
        this.meg.marshalUB2(n2);
        this.meg.marshalNULLPTR();
        this.meg.marshalCHR(this.namespaceByteArr, 0, this.nbNamespaceBytes);
        if (this.nbKeyVal > 0) {
            this.meg.marshalKEYVAL(this.attrArr, this.attrArrSize, this.valueArr, this.valueArrSize, this.kvalflg, this.nbKeyVal);
        }
    }
}

