/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.text.DateFormatSymbols;
import java.util.TimeZone;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.TimestampAccessor;

class T4CTimestampAccessor
extends TimestampAccessor {
    T4CMAREngine mare;
    boolean underlyingLongRaw = false;
    final int[] meta = new int[1];
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Feb_23_16:38:22_PST_2010";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    T4CTimestampAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2, s2, n3, bl);
        this.mare = t4CMAREngine;
    }

    T4CTimestampAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2, int n8, int n9, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2 == -1 ? n9 : n2, bl, n3, n4, n5, n6, n7, s2);
        this.mare = t4CMAREngine;
        this.definedColumnType = n8;
        this.definedColumnSize = n9;
        if (n2 == -1) {
            this.underlyingLongRaw = true;
        }
    }

    void processIndicator(int n2) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalUB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (this.statement.sqlKind != 1 && this.statement.sqlKind != 4) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind == 1 || this.statement.sqlKind == 4 || this.isDMLReturnedParam) {
            this.mare.processIndicator(n2 <= 0, n2);
        }
    }

    boolean unmarshalOneRow() throws SQLException, IOException {
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        if (this.rowSpaceIndicator == null) {
            byte[] byArray = new byte[16000];
            this.mare.unmarshalCLR(byArray, 0, this.meta);
            this.processIndicator(this.meta[0]);
            ++this.lastRowProcessed;
            return false;
        }
        int n2 = this.indicatorIndex + this.lastRowProcessed;
        int n3 = this.lengthIndex + this.lastRowProcessed;
        if (this.isNullByDescribe) {
            this.rowSpaceIndicator[n2] = -1;
            this.rowSpaceIndicator[n3] = 0;
            ++this.lastRowProcessed;
            if (this.statement.connection.versionNumber < 9200) {
                this.processIndicator(0);
            }
            return false;
        }
        int n4 = this.columnIndex + this.lastRowProcessed * this.byteLength;
        this.mare.unmarshalCLR(this.rowSpaceByte, n4, this.meta, this.byteLength);
        this.processIndicator(this.meta[0]);
        if (this.meta[0] == 0) {
            this.rowSpaceIndicator[n2] = -1;
            this.rowSpaceIndicator[n3] = 0;
        } else {
            this.rowSpaceIndicator[n3] = (short)this.meta[0];
            this.rowSpaceIndicator[n2] = 0;
        }
        ++this.lastRowProcessed;
        return false;
    }

    void copyRow() throws SQLException, IOException {
        int n2 = this.lastRowProcessed == 0 ? this.statement.rowPrefetchInLastFetch - 1 : this.lastRowProcessed - 1;
        int n3 = this.columnIndex + this.lastRowProcessed * this.byteLength;
        int n4 = this.columnIndex + n2 * this.byteLength;
        int n5 = this.indicatorIndex + this.lastRowProcessed;
        int n6 = this.indicatorIndex + n2;
        int n7 = this.lengthIndex + this.lastRowProcessed;
        int n8 = this.lengthIndex + n2;
        short s2 = this.rowSpaceIndicator[n8];
        int n9 = this.metaDataIndex + this.lastRowProcessed * 1;
        int n10 = this.metaDataIndex + n2 * 1;
        this.rowSpaceIndicator[n7] = s2;
        this.rowSpaceIndicator[n5] = this.rowSpaceIndicator[n6];
        if (!this.isNullByDescribe) {
            System.arraycopy(this.rowSpaceByte, n4, this.rowSpaceByte, n3, s2);
        }
        System.arraycopy(this.rowSpaceMetaData, n10, this.rowSpaceMetaData, n9, 1);
        ++this.lastRowProcessed;
    }

    void saveDataFromOldDefineBuffers(byte[] byArray, char[] cArray, short[] sArray, int n2, int n3) throws SQLException {
        int n4 = this.columnIndex + (n3 - 1) * this.byteLength;
        int n5 = this.columnIndexLastRow + (n2 - 1) * this.byteLength;
        int n6 = this.indicatorIndex + n3 - 1;
        int n7 = this.indicatorIndexLastRow + n2 - 1;
        int n8 = this.lengthIndex + n3 - 1;
        int n9 = this.lengthIndexLastRow + n2 - 1;
        short s2 = sArray[n9];
        this.rowSpaceIndicator[n8] = s2;
        this.rowSpaceIndicator[n6] = sArray[n7];
        if (s2 != 0) {
            System.arraycopy(byArray, n5, this.rowSpaceByte, n4, s2);
        }
    }

    String getString(int n2) throws SQLException {
        String string = super.getString(n2);
        if (string != null && this.definedColumnSize > 0 && string.length() > this.definedColumnSize) {
            string = string.substring(0, this.definedColumnSize);
        }
        return string;
    }

    String toText(int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, String string) throws SQLException {
        if (this.definedColumnType == 0 || this.definedColumnType == 93) {
            return super.toText(n2, n3, n4, n5, n6, n7, n8, bl, string);
        }
        String string2 = (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM");
        return T4CTimestampAccessor.nlsFormatToText(n2, n3, n4, n5, n6, n7, n8, bl, string, string2);
    }

    private static final String nlsFormatToText(int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, String string, String string2) throws SQLException {
        char[] cArray = (string2 + "      ").toCharArray();
        int n9 = string2.length();
        StringBuffer stringBuffer = new StringBuffer(n9 + 25);
        String[] stringArray = null;
        String[] stringArray2 = null;
        TimeZone timeZone = null;
        block11: for (int i2 = 0; i2 < n9; ++i2) {
            switch (cArray[i2]) {
                case 'R': 
                case 'r': {
                    if (cArray[i2 + 1] != 'R' && cArray[i2 + 1] != 'r') continue block11;
                    if (!(cArray[i2 + 2] != 'R' && cArray[i2 + 2] != 'r' || cArray[i2 + 3] != 'R' && cArray[i2 + 3] != 'r')) {
                        if (n2 < 1000) {
                            stringBuffer.append("0" + n2);
                        } else if (n2 < 100) {
                            stringBuffer.append("00" + n2);
                        } else if (n2 < 10) {
                            stringBuffer.append("000" + n2);
                        } else {
                            stringBuffer.append(n2);
                        }
                        i2 += 3;
                        continue block11;
                    }
                    if (n2 >= 100) {
                        n2 %= 100;
                    }
                    if (n2 < 10) {
                        stringBuffer.append("0" + n2);
                    } else {
                        stringBuffer.append(n2);
                    }
                    ++i2;
                    continue block11;
                }
                case 'Y': 
                case 'y': {
                    if (cArray[i2 + 1] != 'Y' && cArray[i2 + 1] != 'y') continue block11;
                    if (!(cArray[i2 + 2] != 'Y' && cArray[i2 + 2] != 'y' || cArray[i2 + 3] != 'Y' && cArray[i2 + 3] != 'y')) {
                        if (n2 < 1000) {
                            stringBuffer.append("0" + n2);
                        } else if (n2 < 100) {
                            stringBuffer.append("00" + n2);
                        } else if (n2 < 10) {
                            stringBuffer.append("000" + n2);
                        } else {
                            stringBuffer.append(n2);
                        }
                        i2 += 3;
                        continue block11;
                    }
                    if (n2 >= 100) {
                        n2 %= 100;
                    }
                    if (n2 < 10) {
                        stringBuffer.append("0" + n2);
                    } else {
                        stringBuffer.append(n2);
                    }
                    ++i2;
                    continue block11;
                }
                case 'D': 
                case 'd': {
                    if (cArray[i2 + 1] != 'D' && cArray[i2 + 1] != 'd') continue block11;
                    stringBuffer.append((n4 < 10 ? "0" : "") + n4);
                    ++i2;
                    continue block11;
                }
                case 'M': 
                case 'm': {
                    if (cArray[i2 + 1] == 'M' || cArray[i2 + 1] == 'm') {
                        stringBuffer.append((n3 < 10 ? "0" : "") + n3);
                        ++i2;
                        continue block11;
                    }
                    if (cArray[i2 + 1] == 'I' || cArray[i2 + 1] == 'i') {
                        stringBuffer.append((n6 < 10 ? "0" : "") + n6);
                        ++i2;
                        continue block11;
                    }
                    if (cArray[i2 + 1] != 'O' && cArray[i2 + 1] != 'o' || cArray[i2 + 2] != 'N' && cArray[i2 + 2] != 'n') continue block11;
                    if (!(cArray[i2 + 3] != 'T' && cArray[i2 + 3] != 't' || cArray[i2 + 4] != 'H' && cArray[i2 + 4] != 'h')) {
                        if (stringArray2 == null) {
                            stringArray2 = new DateFormatSymbols().getMonths();
                        }
                        stringBuffer.append(stringArray2[n3 - 1]);
                        i2 += 4;
                        continue block11;
                    }
                    if (stringArray == null) {
                        stringArray = new DateFormatSymbols().getShortMonths();
                    }
                    stringBuffer.append(stringArray[n3 - 1]);
                    i2 += 2;
                    continue block11;
                }
                case 'H': 
                case 'h': {
                    if (cArray[i2 + 1] != 'H' && cArray[i2 + 1] != 'h') continue block11;
                    if (cArray[i2 + 2] == '2' || cArray[i2 + 3] == '4') {
                        stringBuffer.append((n5 < 10 ? "0" : "") + n5);
                        i2 += 3;
                        continue block11;
                    }
                    if (n5 > 12) {
                        n5 -= 12;
                    }
                    stringBuffer.append((n5 < 10 ? "0" : "") + n5);
                    ++i2;
                    continue block11;
                }
                case 'S': 
                case 's': {
                    if (cArray[i2 + 1] != 'S' && cArray[i2 + 1] != 's') continue block11;
                    stringBuffer.append((n7 < 10 ? "0" : "") + n7);
                    if (cArray[++i2 + 1] != 'X' && cArray[i2 + 1] != 'x' || cArray[i2 + 2] != 'F' && cArray[i2 + 2] != 'f' || cArray[i2 + 3] != 'F' && cArray[i2 + 3] != 'f') continue block11;
                    stringBuffer.append(".");
                    ++i2;
                    continue block11;
                }
                case 'F': 
                case 'f': {
                    if (cArray[i2 + 1] != 'F' && cArray[i2 + 1] != 'f') continue block11;
                    stringBuffer.append(n8);
                    ++i2;
                    continue block11;
                }
                case 'T': 
                case 't': {
                    long l2;
                    if (cArray[i2 + 1] != 'Z' && cArray[i2 + 1] != 'z') continue block11;
                    if (cArray[i2 + 2] == 'R' || cArray[i2 + 2] == 'r') {
                        if (string.length() > 3 && string.startsWith("GMT")) {
                            stringBuffer.append(string.substring(3));
                        } else {
                            stringBuffer.append(string.toUpperCase());
                        }
                        i2 += 2;
                        continue block11;
                    }
                    if (cArray[i2 + 2] == 'H' || cArray[i2 + 2] == 'h') {
                        if (timeZone == null) {
                            timeZone = TimeZone.getTimeZone(string);
                        }
                        l2 = timeZone.getRawOffset() / 3600000;
                        stringBuffer.append(l2);
                        i2 += 2;
                        continue block11;
                    }
                    if (cArray[i2 + 2] != 'M' && cArray[i2 + 2] != 'm') continue block11;
                    if (timeZone == null) {
                        timeZone = TimeZone.getTimeZone(string);
                    }
                    l2 = Math.abs(timeZone.getRawOffset()) % 3600000 / 60000;
                    stringBuffer.append((l2 < 10L ? "0" : "") + l2);
                    i2 += 2;
                    continue block11;
                }
                case 'A': 
                case 'P': 
                case 'a': 
                case 'p': {
                    if (cArray[i2 + 1] != 'M' && cArray[i2 + 1] != 'm') continue block11;
                    stringBuffer.append(bl ? "AM" : "PM");
                    ++i2;
                    continue block11;
                }
                default: {
                    stringBuffer.append(cArray[i2]);
                }
            }
        }
        return stringBuffer.substring(0, stringBuffer.length());
    }

    Object getObject(int n2) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getObject(n2);
        }
        Object var2_2 = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            switch (this.definedColumnType) {
                case -1: 
                case 1: 
                case 12: {
                    return this.getString(n2);
                }
                case 93: {
                    return this.getTimestamp(n2);
                }
                case 91: {
                    return this.getDate(n2);
                }
                case 92: {
                    return this.getTime(n2);
                }
                case -4: 
                case -3: 
                case -2: {
                    return this.getBytes(n2);
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return var2_2;
    }
}

