/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.jexl2.Debugger;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.Interpreter;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.Script;
import org.apache.commons.jexl2.parser.ASTJexlScript;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionImpl
implements Expression,
Script {
    protected final JexlEngine jexl;
    protected final String expression;
    protected final ASTJexlScript script;

    protected ExpressionImpl(JexlEngine engine, String expr, ASTJexlScript ref) {
        this.jexl = engine;
        this.expression = expr;
        this.script = ref;
    }

    @Override
    public Object evaluate(JexlContext context) {
        if (this.script.jjtGetNumChildren() < 1) {
            return null;
        }
        Interpreter interpreter = this.jexl.createInterpreter(context);
        interpreter.setFrame(this.script.createFrame(null));
        return interpreter.interpret(this.script.jjtGetChild(0));
    }

    @Override
    public String dump() {
        Debugger debug = new Debugger();
        boolean d = debug.debug(this.script);
        return String.valueOf(debug.data()) + (d ? " /*" + debug.start() + ":" + debug.end() + "*/" : "/*?:?*/ ");
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    public String toString() {
        String expr = this.getExpression();
        return expr == null ? "" : expr;
    }

    @Override
    public String getText() {
        return this.toString();
    }

    @Override
    public Object execute(JexlContext context) {
        Interpreter interpreter = this.jexl.createInterpreter(context);
        interpreter.setFrame(this.script.createFrame(null));
        return interpreter.interpret(this.script);
    }

    @Override
    public Object execute(JexlContext context, Object ... args) {
        Interpreter interpreter = this.jexl.createInterpreter(context);
        interpreter.setFrame(this.script.createFrame(args));
        return interpreter.interpret(this.script);
    }

    @Override
    public String[] getParameters() {
        return this.script.getParameters();
    }

    @Override
    public String[] getLocalVariables() {
        return this.script.getLocalVariables();
    }

    @Override
    public Set<List<String>> getVariables() {
        return this.jexl.getVariables(this);
    }

    @Override
    public Callable<Object> callable(JexlContext context) {
        return this.callable(context, null);
    }

    @Override
    public Callable<Object> callable(JexlContext context, Object ... args) {
        final Interpreter interpreter = this.jexl.createInterpreter(context);
        interpreter.setFrame(this.script.createFrame(args));
        return new Callable<Object>(){
            private Object result;
            {
                this.result = interpreter2;
            }

            @Override
            public Object call() throws Exception {
                if (this.result == interpreter) {
                    this.result = interpreter.interpret(ExpressionImpl.this.script);
                }
                return this.result;
            }
        };
    }
}

