/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.parser;

public class StringParser {
    private static final int UCHAR_LEN = 4;
    private static final int SHIFT = 12;
    private static final int BASE10 = 10;
    private static final char LAST_ASCII = '\u007f';
    private static final char FIRST_ASCII = ' ';

    public static String buildString(CharSequence str, boolean eatsep) {
        StringBuilder strb = new StringBuilder(str.length());
        char sep = eatsep ? str.charAt(0) : (char)'\u0000';
        int end = str.length() - (eatsep ? 1 : 0);
        int begin = eatsep ? 1 : 0;
        StringParser.read(strb, str, begin, end, sep);
        return strb.toString();
    }

    public static int readString(StringBuilder strb, CharSequence str, int index, char sep) {
        return StringParser.read(strb, str, index, str.length(), sep);
    }

    private static int read(StringBuilder strb, CharSequence str, int begin, int end, char sep) {
        boolean escape = false;
        int index = begin;
        while (index < end) {
            char c = str.charAt(index);
            if (escape) {
                if (c == 'u' && index + 4 < end && StringParser.readUnicodeChar(strb, str, index + 1) > 0) {
                    index += 4;
                } else {
                    boolean notSeparator;
                    boolean bl = sep == '\u0000' ? c != '\'' && c != '\"' : (notSeparator = c != sep);
                    if (notSeparator && c != '\\') {
                        strb.append('\\');
                    }
                    strb.append(c);
                }
                escape = false;
            } else if (c == '\\') {
                escape = true;
            } else {
                strb.append(c);
                if (c == sep) break;
            }
            ++index;
        }
        return index;
    }

    private static int readUnicodeChar(StringBuilder strb, CharSequence str, int begin) {
        char xc = '\u0000';
        int bits = 12;
        int value = 0;
        int offset = 0;
        while (offset < 4) {
            char c = str.charAt(begin + offset);
            if (c >= '0' && c <= '9') {
                value = c - 48;
            } else if (c >= 'a' && c <= 'h') {
                value = c - 97 + 10;
            } else if (c >= 'A' && c <= 'H') {
                value = c - 65 + 10;
            } else {
                return 0;
            }
            xc = (char)(xc | value << bits);
            bits -= 4;
            ++offset;
        }
        strb.append(xc);
        return 4;
    }

    public static String escapeString(String str, char delim) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        StringBuilder strb = new StringBuilder(length + 2);
        strb.append(delim);
        int i = 0;
        while (i < length) {
            char c = str.charAt(i);
            switch (c) {
                case '\u0000': {
                    break;
                }
                case '\b': {
                    strb.append("\\b");
                    break;
                }
                case '\t': {
                    strb.append("\\t");
                    break;
                }
                case '\n': {
                    strb.append("\\n");
                    break;
                }
                case '\f': {
                    strb.append("\\f");
                    break;
                }
                case '\r': {
                    strb.append("\\r");
                    break;
                }
                case '\"': {
                    strb.append("\\\"");
                    break;
                }
                case '\'': {
                    strb.append("\\'");
                    break;
                }
                case '\\': {
                    strb.append("\\\\");
                    break;
                }
                default: {
                    if (c >= ' ' && c <= '\u007f') {
                        strb.append(c);
                        break;
                    }
                    strb.append('\\');
                    strb.append('u');
                    String hex = Integer.toHexString(c);
                    int h = hex.length();
                    while (h < 4) {
                        strb.append('0');
                        ++h;
                    }
                    strb.append(hex);
                }
            }
            ++i;
        }
        strb.append(delim);
        return strb.toString();
    }
}

