/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.actions;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public abstract class DownloadAction
extends Action {
    protected static final int DEFAULT_BUFFER_SIZE = 4096;

    protected abstract StreamInfo getStreamInfo(ActionMapping var1, ActionForm var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;

    protected int getBufferSize() {
        return 4096;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ActionForward execute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        StreamInfo streamInfo = this.getStreamInfo(actionMapping, actionForm, httpServletRequest, httpServletResponse);
        String string = streamInfo.getContentType();
        InputStream inputStream = streamInfo.getInputStream();
        try {
            httpServletResponse.setContentType(string);
            this.copy(inputStream, (OutputStream)httpServletResponse.getOutputStream());
            Object var9_8 = null;
            if (inputStream == null) return null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return null;
    }

    public int copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[this.getBufferSize()];
        int n = 0;
        int n2 = 0;
        while (-1 != (n2 = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n2);
            n += n2;
        }
        return n;
    }

    public static class FileStreamInfo
    implements StreamInfo {
        private String contentType;
        private File file;

        public FileStreamInfo(String string, File file) {
            this.contentType = string;
            this.file = file;
        }

        public String getContentType() {
            return this.contentType;
        }

        public InputStream getInputStream() throws IOException {
            FileInputStream fileInputStream = new FileInputStream(this.file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            return bufferedInputStream;
        }
    }

    public static class ResourceStreamInfo
    implements StreamInfo {
        private String contentType;
        private ServletContext context;
        private String path;

        public ResourceStreamInfo(String string, ServletContext servletContext, String string2) {
            this.contentType = string;
            this.context = servletContext;
            this.path = string2;
        }

        public String getContentType() {
            return this.contentType;
        }

        public InputStream getInputStream() throws IOException {
            return this.context.getResourceAsStream(this.path);
        }
    }

    public static interface StreamInfo {
        public String getContentType();

        public InputStream getInputStream() throws IOException;
    }
}

