/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.html;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.RequestUtils;

public class FormTag
extends TagSupport {
    protected String action = null;
    protected ModuleConfig moduleConfig = null;
    protected String enctype = null;
    protected String focus = null;
    protected String focusIndex = null;
    protected static String lineEnd = System.getProperty("line.separator");
    protected ActionMapping mapping = null;
    protected static MessageResources messages = MessageResources.getMessageResources("org.apache.struts.taglib.html.LocalStrings");
    protected String method = null;
    protected String onreset = null;
    protected String onsubmit = null;
    protected boolean scriptLanguage = true;
    protected ActionServlet servlet = null;
    protected String style = null;
    protected String styleClass = null;
    protected String styleId = null;
    protected String target = null;
    protected String beanName = null;
    protected String beanScope = null;
    protected String beanType = null;
    protected String acceptCharset = null;
    private boolean disabled = false;
    protected boolean readonly = false;

    public String getBeanName() {
        return this.beanName;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String string) {
        this.action = string;
    }

    public String getEnctype() {
        return this.enctype;
    }

    public void setEnctype(String string) {
        this.enctype = string;
    }

    public String getFocus() {
        return this.focus;
    }

    public void setFocus(String string) {
        this.focus = string;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String string) {
        this.method = string;
    }

    public String getOnreset() {
        return this.onreset;
    }

    public void setOnreset(String string) {
        this.onreset = string;
    }

    public String getOnsubmit() {
        return this.onsubmit;
    }

    public void setOnsubmit(String string) {
        this.onsubmit = string;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String string) {
        this.style = string;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String string) {
        this.styleClass = string;
    }

    public String getStyleId() {
        return this.styleId;
    }

    public void setStyleId(String string) {
        this.styleId = string;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public String getAcceptCharset() {
        return this.acceptCharset;
    }

    public void setAcceptCharset(String string) {
        this.acceptCharset = string;
    }

    public void setDisabled(boolean bl) {
        this.disabled = bl;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setReadonly(boolean bl) {
        this.readonly = bl;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public int doStartTag() throws JspException {
        this.lookup();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.renderFormStartElement());
        stringBuffer.append(this.renderToken());
        TagUtils.getInstance().write(this.pageContext, stringBuffer.toString());
        this.pageContext.setAttribute("org.apache.struts.taglib.html.FORM", (Object)this, 2);
        this.initFormBean();
        return 1;
    }

    protected void initFormBean() throws JspException {
        Object object;
        int n = 3;
        if ("request".equalsIgnoreCase(this.beanScope)) {
            n = 2;
        }
        if ((object = this.pageContext.getAttribute(this.beanName, n)) == null) {
            object = RequestUtils.createActionForm((HttpServletRequest)this.pageContext.getRequest(), this.mapping, this.moduleConfig, this.servlet);
            if (object instanceof ActionForm) {
                ((ActionForm)object).reset(this.mapping, (HttpServletRequest)this.pageContext.getRequest());
            }
            if (object == null) {
                throw new JspException(messages.getMessage("formTag.create", (Object)this.beanType));
            }
            this.pageContext.setAttribute(this.beanName, object, n);
        }
        this.pageContext.setAttribute("org.apache.struts.taglib.html.BEAN", object, 2);
    }

    protected String renderFormStartElement() {
        StringBuffer stringBuffer = new StringBuffer("<form");
        if (!this.isXhtml()) {
            this.renderName(stringBuffer);
        }
        this.renderAttribute(stringBuffer, "method", this.getMethod() == null ? "post" : this.getMethod());
        this.renderAction(stringBuffer);
        this.renderAttribute(stringBuffer, "accept-charset", this.getAcceptCharset());
        this.renderAttribute(stringBuffer, "class", this.getStyleClass());
        this.renderAttribute(stringBuffer, "enctype", this.getEnctype());
        this.renderAttribute(stringBuffer, "onreset", this.getOnreset());
        this.renderAttribute(stringBuffer, "onsubmit", this.getOnsubmit());
        this.renderAttribute(stringBuffer, "style", this.getStyle());
        this.renderAttribute(stringBuffer, "id", this.getStyleId());
        this.renderAttribute(stringBuffer, "target", this.getTarget());
        this.renderOtherAttributes(stringBuffer);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    protected void renderName(StringBuffer stringBuffer) {
        stringBuffer.append(" name=\"");
        stringBuffer.append(this.beanName);
        stringBuffer.append("\"");
    }

    protected void renderAction(StringBuffer stringBuffer) {
        HttpServletResponse httpServletResponse = (HttpServletResponse)this.pageContext.getResponse();
        stringBuffer.append(" action=\"");
        stringBuffer.append(httpServletResponse.encodeURL(TagUtils.getInstance().getActionMappingURL(this.action, this.pageContext)));
        stringBuffer.append("\"");
    }

    protected void renderOtherAttributes(StringBuffer stringBuffer) {
    }

    protected String renderToken() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        HttpSession httpSession = this.pageContext.getSession();
        if (httpSession != null && (string = (String)httpSession.getAttribute("org.apache.struts.action.TOKEN")) != null) {
            stringBuffer.append("<div><input type=\"hidden\" name=\"");
            stringBuffer.append("org.apache.struts.taglib.html.TOKEN");
            stringBuffer.append("\" value=\"");
            stringBuffer.append(string);
            if (this.isXhtml()) {
                stringBuffer.append("\" />");
            } else {
                stringBuffer.append("\">");
            }
            stringBuffer.append("</div>");
        }
        return stringBuffer.toString();
    }

    protected void renderAttribute(StringBuffer stringBuffer, String string, String string2) {
        if (string2 != null) {
            stringBuffer.append(" ");
            stringBuffer.append(string);
            stringBuffer.append("=\"");
            stringBuffer.append(string2);
            stringBuffer.append("\"");
        }
    }

    public int doEndTag() throws JspException {
        this.pageContext.removeAttribute("org.apache.struts.taglib.html.BEAN", 2);
        this.pageContext.removeAttribute("org.apache.struts.taglib.html.FORM", 2);
        StringBuffer stringBuffer = new StringBuffer("</form>");
        if (this.focus != null) {
            stringBuffer.append(this.renderFocusJavascript());
        }
        JspWriter jspWriter = this.pageContext.getOut();
        try {
            jspWriter.print(stringBuffer.toString());
        }
        catch (IOException iOException) {
            throw new JspException(messages.getMessage("common.io", (Object)iOException.toString()));
        }
        return 6;
    }

    protected String renderFocusJavascript() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(lineEnd);
        stringBuffer.append("<script type=\"text/javascript\"");
        if (!this.isXhtml() && this.scriptLanguage) {
            stringBuffer.append(" language=\"JavaScript\"");
        }
        stringBuffer.append(">");
        stringBuffer.append(lineEnd);
        if (!this.isXhtml()) {
            stringBuffer.append("  <!--");
            stringBuffer.append(lineEnd);
        }
        StringBuffer stringBuffer2 = new StringBuffer("document.forms[\"");
        stringBuffer2.append(this.beanName);
        stringBuffer2.append("\"].elements[\"");
        stringBuffer2.append(this.focus);
        stringBuffer2.append("\"]");
        stringBuffer.append("  var focusControl = ");
        stringBuffer.append(stringBuffer2.toString());
        stringBuffer.append(";");
        stringBuffer.append(lineEnd);
        stringBuffer.append(lineEnd);
        stringBuffer.append("  if (focusControl.type != \"hidden\" && !focusControl.disabled) {");
        stringBuffer.append(lineEnd);
        String string = "";
        if (this.focusIndex != null) {
            StringBuffer stringBuffer3 = new StringBuffer("[");
            stringBuffer3.append(this.focusIndex);
            stringBuffer3.append("]");
            string = stringBuffer3.toString();
        }
        stringBuffer.append("     focusControl");
        stringBuffer.append(string);
        stringBuffer.append(".focus();");
        stringBuffer.append(lineEnd);
        stringBuffer.append("  }");
        stringBuffer.append(lineEnd);
        if (!this.isXhtml()) {
            stringBuffer.append("  // -->");
            stringBuffer.append(lineEnd);
        }
        stringBuffer.append("</script>");
        stringBuffer.append(lineEnd);
        return stringBuffer.toString();
    }

    public void release() {
        super.release();
        this.action = null;
        this.moduleConfig = null;
        this.enctype = null;
        this.disabled = false;
        this.focus = null;
        this.focusIndex = null;
        this.mapping = null;
        this.method = null;
        this.onreset = null;
        this.onsubmit = null;
        this.readonly = false;
        this.servlet = null;
        this.style = null;
        this.styleClass = null;
        this.styleId = null;
        this.target = null;
        this.acceptCharset = null;
    }

    protected void lookup() throws JspException {
        this.moduleConfig = TagUtils.getInstance().getModuleConfig(this.pageContext);
        if (this.moduleConfig == null) {
            JspException jspException = new JspException(messages.getMessage("formTag.collections"));
            this.pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)jspException, 2);
            throw jspException;
        }
        this.servlet = (ActionServlet)((Object)this.pageContext.getServletContext().getAttribute("org.apache.struts.action.ACTION_SERVLET"));
        String string = TagUtils.getInstance().getActionMappingName(this.action);
        this.mapping = (ActionMapping)this.moduleConfig.findActionConfig(string);
        if (this.mapping == null) {
            JspException jspException = new JspException(messages.getMessage("formTag.mapping", (Object)string));
            this.pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)jspException, 2);
            throw jspException;
        }
        FormBeanConfig formBeanConfig = this.moduleConfig.findFormBeanConfig(this.mapping.getName());
        if (formBeanConfig == null) {
            JspException jspException = new JspException(messages.getMessage("formTag.formBean", (Object)this.mapping.getName(), (Object)this.action));
            this.pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)jspException, 2);
            throw jspException;
        }
        this.beanName = this.mapping.getAttribute();
        this.beanScope = this.mapping.getScope();
        this.beanType = formBeanConfig.getType();
    }

    private boolean isXhtml() {
        return TagUtils.getInstance().isXhtml(this.pageContext);
    }

    public String getFocusIndex() {
        return this.focusIndex;
    }

    public void setFocusIndex(String string) {
        this.focusIndex = string;
    }

    public boolean getScriptLanguage() {
        return this.scriptLanguage;
    }

    public void setScriptLanguage(boolean bl) {
        this.scriptLanguage = bl;
    }
}

