/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles.definition;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.ComponentDefinitionsFactory;
import org.apache.struts.tiles.DefinitionsFactory;
import org.apache.struts.tiles.DefinitionsFactoryConfig;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.NoSuchDefinitionException;
import org.apache.struts.util.RequestUtils;

public class ComponentDefinitionsFactoryWrapper
implements DefinitionsFactory {
    private ComponentDefinitionsFactory factory = null;
    private DefinitionsFactoryConfig config = null;

    public ComponentDefinitionsFactoryWrapper(ComponentDefinitionsFactory componentDefinitionsFactory) {
        this.factory = componentDefinitionsFactory;
    }

    public ComponentDefinitionsFactoryWrapper() {
    }

    public ComponentDefinition getDefinition(String string, ServletRequest servletRequest, ServletContext servletContext) throws NoSuchDefinitionException, DefinitionsFactoryException {
        return this.factory.getDefinition(string, servletRequest, servletContext);
    }

    public void init(DefinitionsFactoryConfig definitionsFactoryConfig, ServletContext servletContext) throws DefinitionsFactoryException {
        this.config = definitionsFactoryConfig;
        if (this.factory == null) {
            this.factory = this.createFactoryInstance(definitionsFactoryConfig.getFactoryClassname());
        }
        this.factory.initFactory(servletContext, ComponentDefinitionsFactoryWrapper.createConfigMap(definitionsFactoryConfig));
    }

    public void destroy() {
        this.factory = null;
    }

    public void setConfig(DefinitionsFactoryConfig definitionsFactoryConfig, ServletContext servletContext) throws DefinitionsFactoryException {
        ComponentDefinitionsFactory componentDefinitionsFactory = this.createFactoryInstance(definitionsFactoryConfig.getFactoryClassname());
        componentDefinitionsFactory.initFactory(servletContext, ComponentDefinitionsFactoryWrapper.createConfigMap(definitionsFactoryConfig));
        this.factory = componentDefinitionsFactory;
    }

    public DefinitionsFactoryConfig getConfig() {
        return this.config;
    }

    public ComponentDefinitionsFactory getInternalFactory() {
        return this.factory;
    }

    protected ComponentDefinitionsFactory createFactoryInstance(String string) throws DefinitionsFactoryException {
        try {
            Class clazz = RequestUtils.applicationClass(string);
            Object t = clazz.newInstance();
            return (ComponentDefinitionsFactory)t;
        }
        catch (ClassCastException classCastException) {
            throw new DefinitionsFactoryException("Error - createDefinitionsFactory : Factory class '" + string + " must implement 'DefinitionsFactory'.", classCastException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DefinitionsFactoryException("Error - createDefinitionsFactory : Bad class name '" + string + "'.", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new DefinitionsFactoryException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DefinitionsFactoryException(illegalAccessException);
        }
    }

    public String toString() {
        return this.getInternalFactory().toString();
    }

    public static Map createConfigMap(DefinitionsFactoryConfig definitionsFactoryConfig) {
        HashMap<String, String> hashMap = new HashMap<String, String>(definitionsFactoryConfig.getAttributes());
        hashMap.put("definitions-config", definitionsFactoryConfig.getDefinitionConfigFiles());
        hashMap.put("definitions-parser-validate", definitionsFactoryConfig.getParserValidate() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        if (!"org.apache.struts.tiles.xmlDefinition.I18nFactorySet".equals(definitionsFactoryConfig.getFactoryClassname())) {
            hashMap.put("definitions-factory-class", definitionsFactoryConfig.getFactoryClassname());
        }
        return hashMap;
    }
}

