/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.upload;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.upload.FormFile;
import org.apache.struts.upload.MultipartRequestHandler;
import org.apache.struts.upload.MultipartRequestWrapper;

public class CommonsMultipartRequestHandler
implements MultipartRequestHandler {
    public static final long DEFAULT_SIZE_MAX = 0xFA00000L;
    public static final int DEFAULT_SIZE_THRESHOLD = 262144;
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$struts$upload$CommonsMultipartRequestHandler == null ? (class$org$apache$struts$upload$CommonsMultipartRequestHandler = CommonsMultipartRequestHandler.class$("org.apache.struts.upload.CommonsMultipartRequestHandler")) : class$org$apache$struts$upload$CommonsMultipartRequestHandler));
    private Hashtable elementsAll;
    private Hashtable elementsFile;
    private Hashtable elementsText;
    private ActionMapping mapping;
    private ActionServlet servlet;
    static /* synthetic */ Class class$org$apache$struts$upload$CommonsMultipartRequestHandler;

    public ActionServlet getServlet() {
        return this.servlet;
    }

    public void setServlet(ActionServlet actionServlet) {
        this.servlet = actionServlet;
    }

    public ActionMapping getMapping() {
        return this.mapping;
    }

    public void setMapping(ActionMapping actionMapping) {
        this.mapping = actionMapping;
    }

    public void handleRequest(HttpServletRequest httpServletRequest) throws ServletException {
        ModuleConfig moduleConfig = (ModuleConfig)httpServletRequest.getAttribute("org.apache.struts.action.MODULE");
        DiskFileUpload diskFileUpload = new DiskFileUpload();
        diskFileUpload.setHeaderEncoding(httpServletRequest.getCharacterEncoding());
        diskFileUpload.setSizeMax(this.getSizeMax(moduleConfig));
        diskFileUpload.setSizeThreshold((int)this.getSizeThreshold(moduleConfig));
        diskFileUpload.setRepositoryPath(this.getRepositoryPath(moduleConfig));
        this.elementsText = new Hashtable();
        this.elementsFile = new Hashtable();
        this.elementsAll = new Hashtable();
        List list = null;
        try {
            list = diskFileUpload.parseRequest(httpServletRequest);
        }
        catch (FileUploadBase.SizeLimitExceededException sizeLimitExceededException) {
            httpServletRequest.setAttribute("org.apache.struts.upload.MaxLengthExceeded", (Object)Boolean.TRUE);
            return;
        }
        catch (FileUploadException fileUploadException) {
            log.error((Object)"Failed to parse multipart request", (Throwable)fileUploadException);
            throw new ServletException((Throwable)fileUploadException);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            FileItem fileItem = (FileItem)iterator.next();
            if (fileItem.isFormField()) {
                this.addTextParameter(httpServletRequest, fileItem);
                continue;
            }
            this.addFileParameter(fileItem);
        }
    }

    public Hashtable getTextElements() {
        return this.elementsText;
    }

    public Hashtable getFileElements() {
        return this.elementsFile;
    }

    public Hashtable getAllElements() {
        return this.elementsAll;
    }

    public void rollback() {
        Iterator iterator = this.elementsFile.values().iterator();
        while (iterator.hasNext()) {
            FormFile formFile = (FormFile)iterator.next();
            formFile.destroy();
        }
    }

    public void finish() {
        this.rollback();
    }

    protected long getSizeMax(ModuleConfig moduleConfig) {
        return this.convertSizeToBytes(moduleConfig.getControllerConfig().getMaxFileSize(), 0xFA00000L);
    }

    protected long getSizeThreshold(ModuleConfig moduleConfig) {
        return this.convertSizeToBytes(moduleConfig.getControllerConfig().getMemFileSize(), 262144L);
    }

    protected long convertSizeToBytes(String string, long l) {
        int n = 1;
        if (string.endsWith("K")) {
            n = 1024;
        } else if (string.endsWith("M")) {
            n = 0x100000;
        } else if (string.endsWith("G")) {
            n = 0x40000000;
        }
        if (n != 1) {
            string = string.substring(0, string.length() - 1);
        }
        long l2 = 0L;
        try {
            l2 = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            log.warn((Object)("Invalid format for file size ('" + string + "'). Using default."));
            l2 = l;
            n = 1;
        }
        return l2 * (long)n;
    }

    protected String getRepositoryPath(ModuleConfig moduleConfig) {
        String string = moduleConfig.getControllerConfig().getTempDir();
        if (string == null || string.length() == 0) {
            if (this.servlet != null) {
                ServletContext servletContext = this.servlet.getServletContext();
                File file = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
                string = file.getAbsolutePath();
            }
            if (string == null || string.length() == 0) {
                string = System.getProperty("java.io.tmpdir");
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("File upload temp dir: " + string));
        }
        return string;
    }

    protected void addTextParameter(HttpServletRequest httpServletRequest, FileItem fileItem) {
        String[] stringArray;
        String[] stringArray2;
        String string = fileItem.getFieldName();
        String string2 = null;
        boolean bl = false;
        String string3 = httpServletRequest.getCharacterEncoding();
        if (string3 != null) {
            try {
                string2 = fileItem.getString(string3);
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            try {
                string2 = fileItem.getString("ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string2 = fileItem.getString();
            }
            bl = true;
        }
        if (httpServletRequest instanceof MultipartRequestWrapper) {
            stringArray2 = (String[])httpServletRequest;
            stringArray2.setParameter(string, string2);
        }
        if ((stringArray2 = (String[])this.elementsText.get(string)) != null) {
            stringArray = new String[stringArray2.length + 1];
            System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
            stringArray[stringArray2.length] = string2;
        } else {
            stringArray = new String[]{string2};
        }
        this.elementsText.put(string, stringArray);
        this.elementsAll.put(string, stringArray);
    }

    protected void addFileParameter(FileItem fileItem) {
        CommonsFormFile commonsFormFile = new CommonsFormFile(fileItem);
        this.elementsFile.put(fileItem.getFieldName(), commonsFormFile);
        this.elementsAll.put(fileItem.getFieldName(), commonsFormFile);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class CommonsFormFile
    implements FormFile,
    Serializable {
        FileItem fileItem;

        public CommonsFormFile(FileItem fileItem) {
            this.fileItem = fileItem;
        }

        public String getContentType() {
            return this.fileItem.getContentType();
        }

        public void setContentType(String string) {
            throw new UnsupportedOperationException("The setContentType() method is not supported.");
        }

        public int getFileSize() {
            return (int)this.fileItem.getSize();
        }

        public void setFileSize(int n) {
            throw new UnsupportedOperationException("The setFileSize() method is not supported.");
        }

        public String getFileName() {
            return this.getBaseFileName(this.fileItem.getName());
        }

        public void setFileName(String string) {
            throw new UnsupportedOperationException("The setFileName() method is not supported.");
        }

        public byte[] getFileData() throws FileNotFoundException, IOException {
            return this.fileItem.get();
        }

        public InputStream getInputStream() throws FileNotFoundException, IOException {
            return this.fileItem.getInputStream();
        }

        public void destroy() {
            this.fileItem.delete();
        }

        protected String getBaseFileName(String string) {
            String string2 = new File(string).getName();
            int n = string2.indexOf(":");
            if (n == -1) {
                n = string2.indexOf("\\\\");
            }
            int n2 = string2.lastIndexOf("\\");
            if (n > -1 && n2 > -1) {
                string2 = string2.substring(n2 + 1);
            }
            return string2;
        }

        public String toString() {
            return this.getFileName();
        }
    }
}

