/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.upload;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.upload.MultipartBoundaryInputStream;
import org.apache.struts.upload.MultipartElement;

public class MultipartIterator {
    private static final String DEFAULT_ENCODING = "iso-8859-1";
    private static final int TEXT_BUFFER_SIZE = 1000;
    public static String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String MESSAGE_CANNOT_RETRIEVE_BOUNDARY = "MultipartIterator: cannot retrieve boundary for multipart request";
    private static final String PARAMETER_BOUNDARY = "boundary=";
    private static final String FILE_PREFIX = "strts";
    protected HttpServletRequest request;
    protected MultipartBoundaryInputStream inputStream;
    protected String boundary;
    protected long maxSize = -1L;
    protected int contentLength;
    protected int diskBufferSize = 20480;
    protected int bufferSize = 4096;
    protected String tempDir;
    protected String contentType;
    protected boolean maxLengthExceeded;

    public MultipartIterator(HttpServletRequest httpServletRequest) throws IOException {
        this(httpServletRequest, -1);
    }

    public MultipartIterator(HttpServletRequest httpServletRequest, int n) throws IOException {
        this(httpServletRequest, n, -1L);
    }

    public MultipartIterator(HttpServletRequest httpServletRequest, int n, long l) throws IOException {
        this(httpServletRequest, n, l, null);
    }

    public MultipartIterator(HttpServletRequest httpServletRequest, int n, long l, String string) throws IOException {
        this.request = httpServletRequest;
        this.maxSize = l;
        if (n > -1) {
            this.bufferSize = n;
        }
        this.tempDir = string != null ? string : System.getProperty("java.io.tmpdir");
        this.maxLengthExceeded = false;
        this.inputStream = new MultipartBoundaryInputStream();
        this.parseRequest();
    }

    protected void parseRequest() throws IOException {
        this.getContentTypeOfRequest();
        this.contentLength = this.request.getContentLength();
        this.getBoundaryFromContentType();
        this.inputStream.setMaxLength(this.contentLength + 1);
        if (this.maxSize > -1L && (long)this.contentLength > this.maxSize) {
            this.maxLengthExceeded = true;
        } else {
            ServletInputStream servletInputStream = this.request.getInputStream();
            if (servletInputStream.markSupported()) {
                servletInputStream.mark(this.contentLength + 1);
            }
            this.inputStream.setBoundary(this.boundary);
            this.inputStream.setInputStream((InputStream)servletInputStream);
        }
    }

    public MultipartElement getNextElement() throws IOException {
        MultipartElement multipartElement = null;
        if (!this.isMaxLengthExceeded() && !this.inputStream.isFinalBoundaryEncountered()) {
            if (this.inputStream.isElementFile()) {
                multipartElement = this.createFileMultipartElement();
            } else {
                String string = this.getElementEncoding();
                multipartElement = this.createTextMultipartElement(string);
            }
            this.inputStream.resetForNextBoundary();
        }
        return multipartElement;
    }

    protected String getElementEncoding() {
        String string = this.inputStream.getElementCharset();
        if (string == null && (string = this.request.getCharacterEncoding()) == null) {
            string = DEFAULT_ENCODING;
        }
        return string;
    }

    protected MultipartElement createTextMultipartElement(String string) throws IOException {
        int n = 0;
        byte[] byArray = new byte[1000];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = this.inputStream.read(byArray, 0, 1000)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        String string2 = byteArrayOutputStream.toString(string);
        MultipartElement multipartElement = new MultipartElement(this.inputStream.getElementName(), string2);
        return multipartElement;
    }

    protected MultipartElement createFileMultipartElement() throws IOException {
        File file = this.createLocalFile();
        MultipartElement multipartElement = new MultipartElement(this.inputStream.getElementName(), this.inputStream.getElementFileName(), this.inputStream.getElementContentType(), file);
        return multipartElement;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setMaxSize(long l) {
        this.maxSize = l;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public boolean isMaxLengthExceeded() {
        return this.maxLengthExceeded || this.inputStream.isMaxLengthMet();
    }

    private final void getBoundaryFromContentType() throws IOException {
        if (this.contentType.lastIndexOf(PARAMETER_BOUNDARY) != -1) {
            String string = this.contentType.substring(this.contentType.lastIndexOf(PARAMETER_BOUNDARY) + 9);
            if (string.endsWith("\n")) {
                this.boundary = string.substring(0, string.length() - 1);
            }
            this.boundary = string;
        } else {
            this.boundary = null;
        }
        if (this.boundary == null || this.boundary.length() < 1) {
            throw new IOException(MESSAGE_CANNOT_RETRIEVE_BOUNDARY);
        }
    }

    private final void getContentTypeOfRequest() {
        this.contentType = this.request.getContentType();
        if (this.contentType == null) {
            this.contentType = this.request.getHeader(HEADER_CONTENT_TYPE);
        }
    }

    protected File createLocalFile() throws IOException {
        File file = File.createTempFile(FILE_PREFIX, null, new File(this.tempDir));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file), this.diskBufferSize);
        int n = 0;
        byte[] byArray = new byte[this.diskBufferSize];
        while ((n = this.inputStream.read(byArray, 0, this.diskBufferSize)) > 0) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        return file;
    }
}

