/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class TokenProcessor {
    private static TokenProcessor instance = new TokenProcessor();
    private long previous;

    public static TokenProcessor getInstance() {
        return instance;
    }

    protected TokenProcessor() {
    }

    public synchronized boolean isTokenValid(HttpServletRequest httpServletRequest) {
        return this.isTokenValid(httpServletRequest, false);
    }

    public synchronized boolean isTokenValid(HttpServletRequest httpServletRequest, boolean bl) {
        String string;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            return false;
        }
        String string2 = (String)httpSession.getAttribute("org.apache.struts.action.TOKEN");
        if (string2 == null) {
            return false;
        }
        if (bl) {
            this.resetToken(httpServletRequest);
        }
        if ((string = httpServletRequest.getParameter("org.apache.struts.taglib.html.TOKEN")) == null) {
            return false;
        }
        return string2.equals(string);
    }

    public synchronized void resetToken(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            return;
        }
        httpSession.removeAttribute("org.apache.struts.action.TOKEN");
    }

    public synchronized void saveToken(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession();
        String string = this.generateToken(httpServletRequest);
        if (string != null) {
            httpSession.setAttribute("org.apache.struts.action.TOKEN", (Object)string);
        }
    }

    public synchronized String generateToken(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession();
        try {
            byte[] byArray = httpSession.getId().getBytes();
            long l = System.currentTimeMillis();
            if (l == this.previous) {
                ++l;
            }
            this.previous = l;
            byte[] byArray2 = new Long(l).toString().getBytes();
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byArray);
            messageDigest.update(byArray2);
            return this.toHex(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    private String toHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(Character.forDigit((byArray[n] & 0xF0) >> 4, 16));
            stringBuffer.append(Character.forDigit(byArray[n] & 0xF, 16));
            ++n;
        }
        return stringBuffer.toString();
    }
}

