/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.commons.jexl2.DebugInfo;
import org.apache.commons.jexl2.Debugger;
import org.apache.commons.jexl2.JexlInfo;
import org.apache.commons.jexl2.parser.JexlNode;
import org.apache.commons.jexl2.parser.ParseException;
import org.apache.commons.jexl2.parser.TokenMgrError;

public class JexlException
extends RuntimeException {
    protected final transient JexlNode mark;
    protected final transient JexlInfo info;
    public static final String NULL_OPERAND = "jexl.null";
    private static final int MIN_EXCHARLOC = 5;
    private static final int MAX_EXCHARLOC = 10;

    public JexlException(JexlNode node, String msg) {
        super(msg);
        this.mark = node;
        this.info = node != null ? node.debugInfo() : null;
    }

    public JexlException(JexlNode node, String msg, Throwable cause) {
        super(msg, JexlException.unwrap(cause));
        this.mark = node;
        this.info = node != null ? node.debugInfo() : null;
    }

    public JexlException(JexlInfo dbg, String msg) {
        super(msg);
        this.mark = null;
        this.info = dbg;
    }

    public JexlException(JexlInfo dbg, String msg, Throwable cause) {
        super(msg, JexlException.unwrap(cause));
        this.mark = null;
        this.info = dbg;
    }

    private static Throwable unwrap(Throwable xthrow) {
        if (xthrow instanceof InvocationTargetException) {
            return ((InvocationTargetException)xthrow).getTargetException();
        }
        if (xthrow instanceof UndeclaredThrowableException) {
            return ((UndeclaredThrowableException)xthrow).getUndeclaredThrowable();
        }
        return xthrow;
    }

    protected String detailedMessage() {
        return super.getMessage();
    }

    protected String parserError(String prefix, String expr) {
        int length;
        int begin = this.info.debugInfo().getColumn();
        int end = begin + 5;
        if ((begin -= 5) < 0) {
            end += 5;
            begin = 0;
        }
        if ((length = expr.length()) < 10) {
            return String.valueOf(prefix) + " error in '" + expr + "'";
        }
        return String.valueOf(prefix) + " error near '... " + expr.substring(begin, end > length ? length : end) + " ...'";
    }

    public String getInfo(int[] offsets) {
        Debugger dbg = new Debugger();
        if (dbg.debug(this.mark)) {
            if (offsets != null && offsets.length >= 2) {
                offsets[0] = dbg.start();
                offsets[1] = dbg.end();
            }
            return dbg.data();
        }
        return "";
    }

    public String getMessage() {
        Debugger dbg = new Debugger();
        StringBuilder msg = new StringBuilder();
        if (this.info != null) {
            msg.append(this.info.debugString());
        }
        if (dbg.debug(this.mark)) {
            msg.append("![");
            msg.append(dbg.start());
            msg.append(",");
            msg.append(dbg.end());
            msg.append("]: '");
            msg.append(dbg.data());
            msg.append("'");
        }
        msg.append(' ');
        msg.append(this.detailedMessage());
        Throwable cause = this.getCause();
        if (cause != null && NULL_OPERAND == cause.getMessage()) {
            msg.append(" caused by null operand");
        }
        return msg.toString();
    }

    protected static class Cancel
    extends JexlException {
        protected Cancel(JexlNode node) {
            super(node, "execution cancelled", null);
        }
    }

    public static class Method
    extends JexlException {
        public Method(JexlNode node, String name) {
            super(node, name);
        }

        public String getMethod() {
            return super.detailedMessage();
        }

        protected String detailedMessage() {
            return "unknown, ambiguous or inaccessible method " + this.getMethod();
        }
    }

    public static class Parsing
    extends JexlException {
        public Parsing(JexlInfo node, CharSequence expr, ParseException cause) {
            super(Parsing.merge(node, cause), expr.toString(), (Throwable)cause);
        }

        private static DebugInfo merge(JexlInfo node, ParseException cause) {
            DebugInfo dbgn;
            DebugInfo debugInfo = dbgn = node != null ? node.debugInfo() : null;
            if (cause == null) {
                return dbgn;
            }
            if (dbgn == null) {
                return new DebugInfo("", cause.getLine(), cause.getColumn());
            }
            return new DebugInfo(dbgn.getName(), cause.getLine(), cause.getColumn());
        }

        public String getExpression() {
            return super.detailedMessage();
        }

        protected String detailedMessage() {
            return this.parserError("parsing", this.getExpression());
        }
    }

    public static class Property
    extends JexlException {
        public Property(JexlNode node, String var) {
            super(node, var);
        }

        public String getProperty() {
            return super.detailedMessage();
        }

        protected String detailedMessage() {
            return "inaccessible or unknown property " + this.getProperty();
        }
    }

    protected static class Return
    extends JexlException {
        private final Object result;

        protected Return(JexlNode node, String msg, Object value) {
            super(node, msg);
            this.result = value;
        }

        public Object getValue() {
            return this.result;
        }
    }

    public static class Tokenization
    extends JexlException {
        public Tokenization(JexlInfo node, CharSequence expr, TokenMgrError cause) {
            super(Tokenization.merge(node, cause), expr.toString(), (Throwable)cause);
        }

        private static DebugInfo merge(JexlInfo node, TokenMgrError cause) {
            DebugInfo dbgn;
            DebugInfo debugInfo = dbgn = node != null ? node.debugInfo() : null;
            if (cause == null) {
                return dbgn;
            }
            if (dbgn == null) {
                return new DebugInfo("", cause.getLine(), cause.getColumn());
            }
            return new DebugInfo(dbgn.getName(), cause.getLine(), cause.getColumn());
        }

        public String getExpression() {
            return super.detailedMessage();
        }

        protected String detailedMessage() {
            return this.parserError("tokenization", this.getExpression());
        }
    }

    public static class Variable
    extends JexlException {
        public Variable(JexlNode node, String var) {
            super(node, var);
        }

        public String getVariable() {
            return super.detailedMessage();
        }

        protected String detailedMessage() {
            return "undefined variable " + this.getVariable();
        }
    }
}

