/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.introspection;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Sandbox {
    private final Map<String, Permissions> sandbox;
    private static final Names WHITE_NAMES = new Names(){

        public boolean add(String name) {
            return false;
        }
    };
    private static final Permissions ALL_WHITE = new Permissions(WHITE_NAMES, WHITE_NAMES, WHITE_NAMES);

    public Sandbox() {
        this(new HashMap<String, Permissions>());
    }

    protected Sandbox(Map<String, Permissions> map) {
        this.sandbox = map;
    }

    public String read(Class<?> clazz, String name) {
        return this.read(clazz.getName(), name);
    }

    public String read(String clazz, String name) {
        Permissions permissions = this.sandbox.get(clazz);
        if (permissions == null) {
            return name;
        }
        return permissions.read().get(name);
    }

    public String write(Class<?> clazz, String name) {
        return this.write(clazz.getName(), name);
    }

    public String write(String clazz, String name) {
        Permissions permissions = this.sandbox.get(clazz);
        if (permissions == null) {
            return name;
        }
        return permissions.write().get(name);
    }

    public String execute(Class<?> clazz, String name) {
        return this.execute(clazz.getName(), name);
    }

    public String execute(String clazz, String name) {
        Permissions permissions = this.sandbox.get(clazz);
        if (permissions == null) {
            return name;
        }
        return permissions.execute().get(name);
    }

    public Permissions permissions(String clazz, boolean readFlag, boolean writeFlag, boolean executeFlag) {
        Permissions box = new Permissions(readFlag, writeFlag, executeFlag);
        this.sandbox.put(clazz, box);
        return box;
    }

    public Permissions white(String clazz) {
        return this.permissions(clazz, true, true, true);
    }

    public Permissions black(String clazz) {
        return this.permissions(clazz, false, false, false);
    }

    public Permissions get(String clazz) {
        Permissions permissions = this.sandbox.get(clazz);
        if (permissions == null) {
            return ALL_WHITE;
        }
        return permissions;
    }

    public static final class BlackSet
    extends Names {
        private Set<String> names = null;

        public boolean add(String name) {
            if (this.names == null) {
                this.names = new HashSet<String>();
            }
            return this.names.add(name);
        }

        public String get(String name) {
            return this.names != null && !this.names.contains(name) ? name : null;
        }
    }

    public static abstract class Names {
        public abstract boolean add(String var1);

        public boolean alias(String name, String alias) {
            return false;
        }

        public String get(String name) {
            return name;
        }
    }

    public static final class Permissions {
        private final Names read;
        private final Names write;
        private final Names execute;

        Permissions(boolean readFlag, boolean writeFlag, boolean executeFlag) {
            this(readFlag ? new WhiteSet() : new BlackSet(), writeFlag ? new WhiteSet() : new BlackSet(), executeFlag ? new WhiteSet() : new BlackSet());
        }

        Permissions(Names nread, Names nwrite, Names nexecute) {
            this.read = nread != null ? nread : WHITE_NAMES;
            this.write = nwrite != null ? nwrite : WHITE_NAMES;
            this.execute = nexecute != null ? nexecute : WHITE_NAMES;
        }

        public Permissions read(String ... pnames) {
            String[] stringArray = pnames;
            int n = pnames.length;
            int n2 = 0;
            while (n2 < n) {
                String pname = stringArray[n2];
                this.read.add(pname);
                ++n2;
            }
            return this;
        }

        public Permissions write(String ... pnames) {
            String[] stringArray = pnames;
            int n = pnames.length;
            int n2 = 0;
            while (n2 < n) {
                String pname = stringArray[n2];
                this.write.add(pname);
                ++n2;
            }
            return this;
        }

        public Permissions execute(String ... mnames) {
            String[] stringArray = mnames;
            int n = mnames.length;
            int n2 = 0;
            while (n2 < n) {
                String mname = stringArray[n2];
                this.execute.add(mname);
                ++n2;
            }
            return this;
        }

        public Names read() {
            return this.read;
        }

        public Names write() {
            return this.write;
        }

        public Names execute() {
            return this.execute;
        }
    }

    public static final class WhiteSet
    extends Names {
        private Map<String, String> names = null;

        public boolean add(String name) {
            if (this.names == null) {
                this.names = new HashMap<String, String>();
            }
            return this.names.put(name, name) == null;
        }

        public boolean alias(String name, String alias) {
            if (this.names == null) {
                this.names = new HashMap<String, String>();
            }
            return this.names.put(alias, name) == null;
        }

        public String get(String name) {
            if (this.names == null) {
                return name;
            }
            return this.names.get(name);
        }
    }
}

