/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester.plugins;

import java.util.List;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.plugins.Declaration;
import org.apache.commons.digester.plugins.InitializableRule;
import org.apache.commons.digester.plugins.LogUtils;
import org.apache.commons.digester.plugins.PluginConfigurationException;
import org.apache.commons.digester.plugins.PluginException;
import org.apache.commons.digester.plugins.PluginInvalidInputException;
import org.apache.commons.digester.plugins.PluginManager;
import org.apache.commons.digester.plugins.PluginRules;
import org.apache.commons.digester.plugins.RuleLoader;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;

public class PluginCreateRule
extends Rule
implements InitializableRule {
    private String pluginClassAttrNs = null;
    private String pluginClassAttr = null;
    private String pluginIdAttrNs = null;
    private String pluginIdAttr = null;
    private String pattern;
    private Class baseClass = null;
    private Declaration defaultPlugin;
    private PluginConfigurationException initException;
    static /* synthetic */ Class class$java$lang$Object;

    public PluginCreateRule(Class clazz) {
        this.baseClass = clazz;
    }

    public PluginCreateRule(Class clazz, Class clazz2) {
        this.baseClass = clazz;
        if (clazz2 != null) {
            this.defaultPlugin = new Declaration(clazz2);
        }
    }

    public PluginCreateRule(Class clazz, Class clazz2, RuleLoader ruleLoader) {
        this.baseClass = clazz;
        if (clazz2 != null) {
            this.defaultPlugin = new Declaration(clazz2, ruleLoader);
        }
    }

    public void setPluginClassAttribute(String string, String string2) {
        this.pluginClassAttrNs = string;
        this.pluginClassAttr = string2;
    }

    public void setPluginIdAttribute(String string, String string2) {
        this.pluginIdAttrNs = string;
        this.pluginIdAttr = string2;
    }

    public void postRegisterInit(String string) throws PluginConfigurationException {
        Log log = LogUtils.getLogger(this.digester);
        boolean bl = log.isDebugEnabled();
        if (bl) {
            log.debug((Object)("PluginCreateRule.postRegisterInit: rule registered for pattern [" + string + "]"));
        }
        if (this.digester == null) {
            this.initException = new PluginConfigurationException("Invalid invocation of postRegisterInit: digester not set.");
            throw this.initException;
        }
        if (this.pattern != null) {
            this.initException = new PluginConfigurationException("A single PluginCreateRule instance has been mapped to multiple patterns; this is not supported.");
            throw this.initException;
        }
        if (string.indexOf(42) != -1) {
            this.initException = new PluginConfigurationException("A PluginCreateRule instance has been mapped to pattern [" + string + "]." + " This pattern includes a wildcard character." + " This is not supported by the plugin architecture.");
            throw this.initException;
        }
        if (this.baseClass == null) {
            this.baseClass = class$java$lang$Object == null ? (class$java$lang$Object = PluginCreateRule.class$("java.lang.Object")) : class$java$lang$Object;
        }
        PluginRules pluginRules = (PluginRules)this.digester.getRules();
        PluginManager pluginManager = pluginRules.getPluginManager();
        if (this.defaultPlugin != null) {
            if (!this.baseClass.isAssignableFrom(this.defaultPlugin.getPluginClass())) {
                this.initException = new PluginConfigurationException("Default class [" + this.defaultPlugin.getPluginClass().getName() + "] does not inherit from [" + this.baseClass.getName() + "].");
                throw this.initException;
            }
            try {
                this.defaultPlugin.init(this.digester, pluginManager);
            }
            catch (PluginException pluginException) {
                throw new PluginConfigurationException(pluginException.getMessage(), pluginException.getCause());
            }
        }
        this.pattern = string;
        if (this.pluginClassAttr == null) {
            this.pluginClassAttrNs = pluginRules.getPluginClassAttrNs();
            this.pluginClassAttr = pluginRules.getPluginClassAttr();
            if (bl) {
                log.debug((Object)("init: pluginClassAttr set to per-digester values [ns=" + this.pluginClassAttrNs + ", name=" + this.pluginClassAttr + "]"));
            }
        } else if (bl) {
            log.debug((Object)("init: pluginClassAttr set to rule-specific values [ns=" + this.pluginClassAttrNs + ", name=" + this.pluginClassAttr + "]"));
        }
        if (this.pluginIdAttr == null) {
            this.pluginIdAttrNs = pluginRules.getPluginIdAttrNs();
            this.pluginIdAttr = pluginRules.getPluginIdAttr();
            if (bl) {
                log.debug((Object)("init: pluginIdAttr set to per-digester values [ns=" + this.pluginIdAttrNs + ", name=" + this.pluginIdAttr + "]"));
            }
        } else if (bl) {
            log.debug((Object)("init: pluginIdAttr set to rule-specific values [ns=" + this.pluginIdAttrNs + ", name=" + this.pluginIdAttr + "]"));
        }
    }

    public void begin(String string, String string2, Attributes attributes) throws Exception {
        Log log = this.digester.getLogger();
        boolean bl = log.isDebugEnabled();
        if (bl) {
            log.debug((Object)("PluginCreateRule.begin: pattern=[" + this.pattern + "]" + " match=[" + this.digester.getMatch() + "]"));
        }
        if (this.initException != null) {
            throw this.initException;
        }
        String string3 = this.digester.getMatch();
        PluginRules pluginRules = (PluginRules)this.digester.getRules();
        PluginRules pluginRules2 = new PluginRules(string3, pluginRules);
        this.digester.setRules(pluginRules2);
        PluginManager pluginManager = pluginRules2.getPluginManager();
        Declaration declaration = null;
        if (bl) {
            log.debug((Object)("PluginCreateRule.begin: installing new plugin: oldrules=" + pluginRules.toString() + ", newrules=" + pluginRules2.toString()));
        }
        String string4 = this.pluginClassAttrNs == null ? attributes.getValue(this.pluginClassAttr) : attributes.getValue(this.pluginClassAttrNs, this.pluginClassAttr);
        String string5 = this.pluginIdAttrNs == null ? attributes.getValue(this.pluginIdAttr) : attributes.getValue(this.pluginIdAttrNs, this.pluginIdAttr);
        if (string4 != null) {
            declaration = pluginManager.getDeclarationByClass(string4);
            if (declaration == null) {
                declaration = new Declaration(string4);
                try {
                    declaration.init(this.digester, pluginManager);
                }
                catch (PluginException pluginException) {
                    throw new PluginInvalidInputException(pluginException.getMessage(), pluginException.getCause());
                }
                pluginManager.addDeclaration(declaration);
            }
        } else if (string5 != null) {
            declaration = pluginManager.getDeclarationById(string5);
            if (declaration == null) {
                throw new PluginInvalidInputException("Plugin id [" + string5 + "] is not defined.");
            }
        } else if (this.defaultPlugin != null) {
            declaration = this.defaultPlugin;
        } else {
            throw new PluginInvalidInputException("No plugin class specified for element " + this.pattern);
        }
        declaration.configure(this.digester, this.pattern);
        Class clazz = declaration.getPluginClass();
        Object t = clazz.newInstance();
        this.getDigester().push(t);
        if (bl) {
            log.debug((Object)("PluginCreateRule.begin: pattern=[" + this.pattern + "]" + " match=[" + this.digester.getMatch() + "]" + " pushed instance of plugin [" + clazz.getName() + "]"));
        }
        List list = pluginRules2.getDecoratedRules().match(string, string3);
        this.fireBeginMethods(list, string, string2, attributes);
    }

    public void body(String string, String string2, String string3) throws Exception {
        String string4 = this.digester.getMatch();
        PluginRules pluginRules = (PluginRules)this.digester.getRules();
        List list = pluginRules.getDecoratedRules().match(string, string4);
        this.fireBodyMethods(list, string, string2, string3);
    }

    public void end(String string, String string2) throws Exception {
        String string3 = this.digester.getMatch();
        PluginRules pluginRules = (PluginRules)this.digester.getRules();
        List list = pluginRules.getDecoratedRules().match(string, string3);
        this.fireEndMethods(list, string, string2);
        this.digester.setRules(pluginRules.getParent());
        this.digester.pop();
    }

    public String getPattern() {
        return this.pattern;
    }

    public void fireBeginMethods(List list, String string, String string2, Attributes attributes) throws Exception {
        if (list != null && list.size() > 0) {
            Log log = this.digester.getLogger();
            boolean bl = log.isDebugEnabled();
            int n = 0;
            while (n < list.size()) {
                try {
                    Rule rule = (Rule)list.get(n);
                    if (bl) {
                        log.debug((Object)("  Fire begin() for " + rule));
                    }
                    rule.begin(string, string2, attributes);
                }
                catch (Exception exception) {
                    throw this.digester.createSAXException(exception);
                }
                catch (Error error) {
                    throw error;
                }
                ++n;
            }
        }
    }

    private void fireBodyMethods(List list, String string, String string2, String string3) throws Exception {
        if (list != null && list.size() > 0) {
            Log log = this.digester.getLogger();
            boolean bl = log.isDebugEnabled();
            int n = 0;
            while (n < list.size()) {
                try {
                    Rule rule = (Rule)list.get(n);
                    if (bl) {
                        log.debug((Object)("  Fire body() for " + rule));
                    }
                    rule.body(string, string2, string3);
                }
                catch (Exception exception) {
                    throw this.digester.createSAXException(exception);
                }
                catch (Error error) {
                    throw error;
                }
                ++n;
            }
        }
    }

    public void fireEndMethods(List list, String string, String string2) throws Exception {
        if (list != null) {
            Log log = this.digester.getLogger();
            boolean bl = log.isDebugEnabled();
            int n = 0;
            while (n < list.size()) {
                int n2 = list.size() - n - 1;
                try {
                    Rule rule = (Rule)list.get(n2);
                    if (bl) {
                        log.debug((Object)("  Fire end() for " + rule));
                    }
                    rule.end(string, string2);
                }
                catch (Exception exception) {
                    throw this.digester.createSAXException(exception);
                }
                catch (Error error) {
                    throw error;
                }
                ++n;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

