/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.config.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ActionConfigMatcher;
import org.apache.struts.config.ControllerConfig;
import org.apache.struts.config.DataSourceConfig;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.MessageResourcesConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.PlugInConfig;

public class ModuleConfigImpl
implements Serializable,
ModuleConfig {
    protected HashMap actionConfigs = null;
    protected List actionConfigList = null;
    protected HashMap dataSources = null;
    protected HashMap exceptions = null;
    protected HashMap formBeans = null;
    protected HashMap forwards = null;
    protected HashMap messageResources = null;
    protected ArrayList plugIns = null;
    protected boolean configured = false;
    protected ControllerConfig controllerConfig = null;
    protected String prefix = null;
    protected String actionFormBeanClass = "org.apache.struts.action.ActionFormBean";
    protected String actionMappingClass = "org.apache.struts.action.ActionMapping";
    protected String actionForwardClass = "org.apache.struts.action.ActionForward";
    protected ActionConfigMatcher matcher = null;

    public ModuleConfigImpl(String string) {
        this.prefix = string;
        this.actionConfigs = new HashMap();
        this.actionConfigList = new ArrayList();
        this.actionFormBeanClass = "org.apache.struts.action.ActionFormBean";
        this.actionMappingClass = "org.apache.struts.action.ActionMapping";
        this.actionForwardClass = "org.apache.struts.action.ActionForward";
        this.configured = false;
        this.controllerConfig = null;
        this.dataSources = new HashMap();
        this.exceptions = new HashMap();
        this.formBeans = new HashMap();
        this.forwards = new HashMap();
        this.messageResources = new HashMap();
        this.plugIns = new ArrayList();
    }

    public boolean getConfigured() {
        return this.configured;
    }

    public ControllerConfig getControllerConfig() {
        if (this.controllerConfig == null) {
            this.controllerConfig = new ControllerConfig();
        }
        return this.controllerConfig;
    }

    public void setControllerConfig(ControllerConfig controllerConfig) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.controllerConfig = controllerConfig;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.prefix = string;
    }

    public String getActionFormBeanClass() {
        return this.actionFormBeanClass;
    }

    public void setActionFormBeanClass(String string) {
        this.actionFormBeanClass = string;
    }

    public String getActionMappingClass() {
        return this.actionMappingClass;
    }

    public void setActionMappingClass(String string) {
        this.actionMappingClass = string;
    }

    public void addActionConfig(ActionConfig actionConfig) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        actionConfig.setModuleConfig(this);
        this.actionConfigs.put(actionConfig.getPath(), actionConfig);
        this.actionConfigList.add(actionConfig);
    }

    public void addDataSourceConfig(DataSourceConfig dataSourceConfig) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.dataSources.put(dataSourceConfig.getKey(), dataSourceConfig);
    }

    public void addExceptionConfig(ExceptionConfig exceptionConfig) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.exceptions.put(exceptionConfig.getType(), exceptionConfig);
    }

    public void addFormBeanConfig(FormBeanConfig formBeanConfig) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.formBeans.put(formBeanConfig.getName(), formBeanConfig);
    }

    public String getActionForwardClass() {
        return this.actionForwardClass;
    }

    public void setActionForwardClass(String string) {
        this.actionForwardClass = string;
    }

    public void addForwardConfig(ForwardConfig forwardConfig) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.forwards.put(forwardConfig.getName(), forwardConfig);
    }

    public void addMessageResourcesConfig(MessageResourcesConfig messageResourcesConfig) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.messageResources.put(messageResourcesConfig.getKey(), messageResourcesConfig);
    }

    public void addPlugInConfig(PlugInConfig plugInConfig) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.plugIns.add(plugInConfig);
    }

    public ActionConfig findActionConfig(String string) {
        ActionConfig actionConfig = (ActionConfig)this.actionConfigs.get(string);
        if (actionConfig == null) {
            actionConfig = this.matcher.match(string);
        }
        return actionConfig;
    }

    public ActionConfig[] findActionConfigs() {
        ActionConfig[] actionConfigArray = new ActionConfig[this.actionConfigList.size()];
        return this.actionConfigList.toArray(actionConfigArray);
    }

    public DataSourceConfig findDataSourceConfig(String string) {
        return (DataSourceConfig)this.dataSources.get(string);
    }

    public DataSourceConfig[] findDataSourceConfigs() {
        DataSourceConfig[] dataSourceConfigArray = new DataSourceConfig[this.dataSources.size()];
        return this.dataSources.values().toArray(dataSourceConfigArray);
    }

    public ExceptionConfig findExceptionConfig(String string) {
        return (ExceptionConfig)this.exceptions.get(string);
    }

    public ExceptionConfig[] findExceptionConfigs() {
        ExceptionConfig[] exceptionConfigArray = new ExceptionConfig[this.exceptions.size()];
        return this.exceptions.values().toArray(exceptionConfigArray);
    }

    public FormBeanConfig findFormBeanConfig(String string) {
        return (FormBeanConfig)this.formBeans.get(string);
    }

    public FormBeanConfig[] findFormBeanConfigs() {
        FormBeanConfig[] formBeanConfigArray = new FormBeanConfig[this.formBeans.size()];
        return this.formBeans.values().toArray(formBeanConfigArray);
    }

    public ForwardConfig findForwardConfig(String string) {
        return (ForwardConfig)this.forwards.get(string);
    }

    public ForwardConfig[] findForwardConfigs() {
        ForwardConfig[] forwardConfigArray = new ForwardConfig[this.forwards.size()];
        return this.forwards.values().toArray(forwardConfigArray);
    }

    public MessageResourcesConfig findMessageResourcesConfig(String string) {
        return (MessageResourcesConfig)this.messageResources.get(string);
    }

    public MessageResourcesConfig[] findMessageResourcesConfigs() {
        MessageResourcesConfig[] messageResourcesConfigArray = new MessageResourcesConfig[this.messageResources.size()];
        return this.messageResources.values().toArray(messageResourcesConfigArray);
    }

    public PlugInConfig[] findPlugInConfigs() {
        PlugInConfig[] plugInConfigArray = new PlugInConfig[this.plugIns.size()];
        return this.plugIns.toArray(plugInConfigArray);
    }

    public void freeze() {
        this.configured = true;
        ActionConfig[] actionConfigArray = this.findActionConfigs();
        int n = 0;
        while (n < actionConfigArray.length) {
            actionConfigArray[n].freeze();
            ++n;
        }
        this.matcher = new ActionConfigMatcher(actionConfigArray);
        this.getControllerConfig().freeze();
        DataSourceConfig[] dataSourceConfigArray = this.findDataSourceConfigs();
        int n2 = 0;
        while (n2 < dataSourceConfigArray.length) {
            dataSourceConfigArray[n2].freeze();
            ++n2;
        }
        ExceptionConfig[] exceptionConfigArray = this.findExceptionConfigs();
        int n3 = 0;
        while (n3 < exceptionConfigArray.length) {
            exceptionConfigArray[n3].freeze();
            ++n3;
        }
        FormBeanConfig[] formBeanConfigArray = this.findFormBeanConfigs();
        int n4 = 0;
        while (n4 < formBeanConfigArray.length) {
            formBeanConfigArray[n4].freeze();
            ++n4;
        }
        ForwardConfig[] forwardConfigArray = this.findForwardConfigs();
        int n5 = 0;
        while (n5 < forwardConfigArray.length) {
            forwardConfigArray[n5].freeze();
            ++n5;
        }
        MessageResourcesConfig[] messageResourcesConfigArray = this.findMessageResourcesConfigs();
        int n6 = 0;
        while (n6 < messageResourcesConfigArray.length) {
            messageResourcesConfigArray[n6].freeze();
            ++n6;
        }
        PlugInConfig[] plugInConfigArray = this.findPlugInConfigs();
        int n7 = 0;
        while (n7 < plugInConfigArray.length) {
            plugInConfigArray[n7].freeze();
            ++n7;
        }
    }

    public void removeActionConfig(ActionConfig actionConfig) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        actionConfig.setModuleConfig(null);
        this.actionConfigs.remove(actionConfig.getPath());
        this.actionConfigList.remove(actionConfig);
    }

    public void removeExceptionConfig(ExceptionConfig exceptionConfig) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.exceptions.remove(exceptionConfig.getType());
    }

    public void removeDataSourceConfig(DataSourceConfig dataSourceConfig) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.dataSources.remove(dataSourceConfig.getKey());
    }

    public void removeFormBeanConfig(FormBeanConfig formBeanConfig) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.formBeans.remove(formBeanConfig.getName());
    }

    public void removeForwardConfig(ForwardConfig forwardConfig) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.forwards.remove(forwardConfig.getName());
    }

    public void removeMessageResourcesConfig(MessageResourcesConfig messageResourcesConfig) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.messageResources.remove(messageResourcesConfig.getKey());
    }
}

