/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.bean;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.util.MessageResources;

public class WriteTag
extends TagSupport {
    public static final String SQL_TIMESTAMP_FORMAT_KEY = "org.apache.struts.taglib.bean.format.sql.timestamp";
    public static final String SQL_DATE_FORMAT_KEY = "org.apache.struts.taglib.bean.format.sql.date";
    public static final String SQL_TIME_FORMAT_KEY = "org.apache.struts.taglib.bean.format.sql.time";
    public static final String DATE_FORMAT_KEY = "org.apache.struts.taglib.bean.format.date";
    public static final String INT_FORMAT_KEY = "org.apache.struts.taglib.bean.format.int";
    public static final String FLOAT_FORMAT_KEY = "org.apache.struts.taglib.bean.format.float";
    protected static MessageResources messages = MessageResources.getMessageResources("org.apache.struts.taglib.bean.LocalStrings");
    protected boolean filter = true;
    protected boolean ignore = false;
    protected String name = null;
    protected String property = null;
    protected String scope = null;
    protected String formatStr = null;
    protected String formatKey = null;
    protected String localeKey = null;
    protected String bundle = null;

    public boolean getFilter() {
        return this.filter;
    }

    public void setFilter(boolean bl) {
        this.filter = bl;
    }

    public boolean getIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean bl) {
        this.ignore = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String string) {
        this.property = string;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String string) {
        this.scope = string;
    }

    public String getFormat() {
        return this.formatStr;
    }

    public void setFormat(String string) {
        this.formatStr = string;
    }

    public String getFormatKey() {
        return this.formatKey;
    }

    public void setFormatKey(String string) {
        this.formatKey = string;
    }

    public String getLocale() {
        return this.localeKey;
    }

    public void setLocale(String string) {
        this.localeKey = string;
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String string) {
        this.bundle = string;
    }

    public int doStartTag() throws JspException {
        if (this.ignore && TagUtils.getInstance().lookup(this.pageContext, this.name, this.scope) == null) {
            return 0;
        }
        Object object = TagUtils.getInstance().lookup(this.pageContext, this.name, this.property, this.scope);
        if (object == null) {
            return 0;
        }
        String string = this.formatValue(object);
        if (this.filter) {
            TagUtils.getInstance().write(this.pageContext, TagUtils.getInstance().filter(string));
        } else {
            TagUtils.getInstance().write(this.pageContext, string);
        }
        return 0;
    }

    protected String retrieveFormatString(String string) throws JspException {
        String string2 = TagUtils.getInstance().message(this.pageContext, this.bundle, this.localeKey, string);
        if (!(string2 == null || string2.startsWith("???") && string2.endsWith("???"))) {
            return string2;
        }
        return null;
    }

    protected String formatValue(Object object) throws JspException {
        Format format = null;
        Object object2 = object;
        Locale locale = TagUtils.getInstance().getUserLocale(this.pageContext, this.localeKey);
        boolean bl = false;
        String string = this.formatStr;
        if (object2 instanceof String) {
            return (String)object2;
        }
        if (string == null && this.formatKey != null && (string = this.retrieveFormatString(this.formatKey)) != null) {
            bl = true;
        }
        if (object2 instanceof Number) {
            if (string == null) {
                if (object2 instanceof Byte || object2 instanceof Short || object2 instanceof Integer || object2 instanceof Long || object2 instanceof BigInteger) {
                    string = this.retrieveFormatString(INT_FORMAT_KEY);
                } else if (object2 instanceof Float || object2 instanceof Double || object2 instanceof BigDecimal) {
                    string = this.retrieveFormatString(FLOAT_FORMAT_KEY);
                }
                if (string != null) {
                    bl = true;
                }
            }
            if (string != null) {
                try {
                    format = NumberFormat.getNumberInstance(locale);
                    if (bl) {
                        ((DecimalFormat)format).applyLocalizedPattern(string);
                    }
                    ((DecimalFormat)format).applyPattern(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    JspException jspException = new JspException(messages.getMessage("write.format", (Object)string));
                    TagUtils.getInstance().saveException(this.pageContext, jspException);
                    throw jspException;
                }
            }
        } else if (object2 instanceof java.util.Date) {
            if (string == null) {
                if (object2 instanceof Timestamp) {
                    string = this.retrieveFormatString(SQL_TIMESTAMP_FORMAT_KEY);
                } else if (object2 instanceof Date) {
                    string = this.retrieveFormatString(SQL_DATE_FORMAT_KEY);
                } else if (object2 instanceof Time) {
                    string = this.retrieveFormatString(SQL_TIME_FORMAT_KEY);
                } else if (object2 instanceof java.util.Date) {
                    string = this.retrieveFormatString(DATE_FORMAT_KEY);
                }
            }
            if (string != null) {
                format = new SimpleDateFormat(string, locale);
            }
        }
        if (format != null) {
            return format.format(object2);
        }
        return object2.toString();
    }

    public void release() {
        super.release();
        this.filter = true;
        this.ignore = false;
        this.name = null;
        this.property = null;
        this.scope = null;
        this.formatStr = null;
        this.formatKey = null;
        this.localeKey = null;
        this.bundle = null;
    }
}

