/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.nested.logic;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.taglib.logic.IterateTag;
import org.apache.struts.taglib.nested.NestedNameSupport;
import org.apache.struts.taglib.nested.NestedPropertyHelper;

public class NestedIterateTag
extends IterateTag
implements NestedNameSupport {
    private String nesting = null;
    private String originalName = null;
    private String originalProperty = null;
    private String originalNesting = null;
    private String originalNestingName = null;

    public int doStartTag() throws JspException {
        this.originalName = this.getName();
        this.originalProperty = this.getProperty();
        if (this.id == null || this.id.trim().length() == 0) {
            this.id = this.property;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)((TagSupport)this).pageContext.getRequest();
        this.originalNesting = NestedPropertyHelper.getCurrentProperty(httpServletRequest);
        this.originalNestingName = NestedPropertyHelper.getCurrentName(httpServletRequest, this);
        this.nesting = this.getName() == null ? NestedPropertyHelper.getAdjustedProperty(httpServletRequest, this.getProperty()) : this.getProperty();
        NestedPropertyHelper.setNestedProperties(httpServletRequest, this);
        int n = super.doStartTag();
        NestedPropertyHelper.setName(httpServletRequest, this.getName());
        NestedPropertyHelper.setProperty(httpServletRequest, this.deriveNestedProperty());
        return n;
    }

    private String deriveNestedProperty() {
        Object object = ((TagSupport)this).pageContext.getAttribute(this.id);
        if (object instanceof Map.Entry) {
            return this.nesting + "(" + ((Map.Entry)object).getKey() + ")";
        }
        return this.nesting + "[" + this.getIndex() + "]";
    }

    public int doAfterBody() throws JspException {
        int n = super.doAfterBody();
        HttpServletRequest httpServletRequest = (HttpServletRequest)((TagSupport)this).pageContext.getRequest();
        if (n != 0) {
            NestedPropertyHelper.setProperty(httpServletRequest, this.deriveNestedProperty());
        }
        return n;
    }

    public int doEndTag() throws JspException {
        int n = super.doEndTag();
        HttpServletRequest httpServletRequest = (HttpServletRequest)((TagSupport)this).pageContext.getRequest();
        super.setName(this.originalName);
        super.setProperty(this.originalProperty);
        if (this.originalNesting == null) {
            NestedPropertyHelper.deleteReference(httpServletRequest);
        } else {
            NestedPropertyHelper.setProperty(httpServletRequest, this.originalNesting);
            NestedPropertyHelper.setName(httpServletRequest, this.originalNestingName);
        }
        return n;
    }

    public void release() {
        super.release();
        this.originalName = null;
        this.originalProperty = null;
        this.originalNesting = null;
        this.originalNestingName = null;
    }
}

