/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.digester.BeanPropertySetterRule;
import org.apache.commons.digester.CallMethodRule;
import org.apache.commons.digester.CallParamRule;
import org.apache.commons.digester.FactoryCreateRule;
import org.apache.commons.digester.ObjectCreateRule;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.commons.digester.ObjectParamRule;
import org.apache.commons.digester.ParserFeatureSetterFactory;
import org.apache.commons.digester.PathCallParamRule;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.digester.Rules;
import org.apache.commons.digester.RulesBase;
import org.apache.commons.digester.SetNestedPropertiesRule;
import org.apache.commons.digester.SetNextRule;
import org.apache.commons.digester.SetPropertiesRule;
import org.apache.commons.digester.SetPropertyRule;
import org.apache.commons.digester.SetRootRule;
import org.apache.commons.digester.SetTopRule;
import org.apache.commons.digester.Substitutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Digester
extends DefaultHandler {
    protected StringBuffer bodyText = new StringBuffer();
    protected ArrayStack bodyTexts = new ArrayStack();
    protected ArrayStack matches = new ArrayStack(10);
    protected ClassLoader classLoader = null;
    protected boolean configured = false;
    protected EntityResolver entityResolver;
    protected HashMap entityValidator = new HashMap();
    protected ErrorHandler errorHandler = null;
    protected SAXParserFactory factory = null;
    protected String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    protected Locator locator = null;
    protected String match = "";
    protected boolean namespaceAware = false;
    protected HashMap namespaces = new HashMap();
    protected ArrayStack params = new ArrayStack();
    protected SAXParser parser = null;
    protected String publicId = null;
    protected XMLReader reader = null;
    protected Object root = null;
    protected Rules rules = null;
    protected String schemaLanguage = "http://www.w3.org/2001/XMLSchema";
    protected String schemaLocation = null;
    protected ArrayStack stack = new ArrayStack();
    protected boolean useContextClassLoader = false;
    protected boolean validating = false;
    protected Log log = LogFactory.getLog((String)"org.apache.commons.digester.Digester");
    protected Log saxLog = LogFactory.getLog((String)"org.apache.commons.digester.Digester.sax");
    protected static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    protected Substitutor substitutor;
    private HashMap stacksByName = new HashMap();

    public Digester() {
    }

    public Digester(SAXParser sAXParser) {
        this.parser = sAXParser;
    }

    public Digester(XMLReader xMLReader) {
        this.reader = xMLReader;
    }

    public String findNamespaceURI(String string) {
        ArrayStack arrayStack = (ArrayStack)this.namespaces.get(string);
        if (arrayStack == null) {
            return null;
        }
        try {
            return (String)arrayStack.peek();
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader;
        if (this.classLoader != null) {
            return this.classLoader;
        }
        if (this.useContextClassLoader && (classLoader = Thread.currentThread().getContextClassLoader()) != null) {
            return classLoader;
        }
        return this.getClass().getClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public int getCount() {
        return this.stack.size();
    }

    public String getCurrentElementName() {
        String string = this.match;
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public int getDebug() {
        return 0;
    }

    public void setDebug(int n) {
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public SAXParserFactory getFactory() {
        if (this.factory == null) {
            this.factory = SAXParserFactory.newInstance();
            this.factory.setNamespaceAware(this.namespaceAware);
            this.factory.setValidating(this.validating);
        }
        return this.factory;
    }

    public boolean getFeature(String string) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        return this.getFactory().getFeature(string);
    }

    public void setFeature(String string, boolean bl) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        this.getFactory().setFeature(string, bl);
    }

    public Log getLogger() {
        return this.log;
    }

    public void setLogger(Log log) {
        this.log = log;
    }

    public Log getSAXLogger() {
        return this.saxLog;
    }

    public void setSAXLogger(Log log) {
        this.saxLog = log;
    }

    public String getMatch() {
        return this.match;
    }

    public boolean getNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean bl) {
        this.namespaceAware = bl;
    }

    public void setPublicId(String string) {
        this.publicId = string;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getRuleNamespaceURI() {
        return this.getRules().getNamespaceURI();
    }

    public void setRuleNamespaceURI(String string) {
        this.getRules().setNamespaceURI(string);
    }

    public SAXParser getParser() {
        if (this.parser != null) {
            return this.parser;
        }
        try {
            if (this.validating) {
                Properties properties = new Properties();
                properties.put("SAXParserFactory", this.getFactory());
                if (this.schemaLocation != null) {
                    properties.put("schemaLocation", this.schemaLocation);
                    properties.put("schemaLanguage", this.schemaLanguage);
                }
                this.parser = ParserFeatureSetterFactory.newSAXParser(properties);
            } else {
                this.parser = this.getFactory().newSAXParser();
            }
        }
        catch (Exception exception) {
            this.log.error((Object)"Digester.getParser: ", (Throwable)exception);
            return null;
        }
        return this.parser;
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.getParser().getProperty(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.getParser().setProperty(string, object);
    }

    public XMLReader getReader() {
        try {
            return this.getXMLReader();
        }
        catch (SAXException sAXException) {
            this.log.error((Object)"Cannot get XMLReader", (Throwable)sAXException);
            return null;
        }
    }

    public Rules getRules() {
        if (this.rules == null) {
            this.rules = new RulesBase();
            this.rules.setDigester(this);
        }
        return this.rules;
    }

    public void setRules(Rules rules) {
        this.rules = rules;
        this.rules.setDigester(this);
    }

    public String getSchema() {
        return this.schemaLocation;
    }

    public void setSchema(String string) {
        this.schemaLocation = string;
    }

    public String getSchemaLanguage() {
        return this.schemaLanguage;
    }

    public void setSchemaLanguage(String string) {
        this.schemaLanguage = string;
    }

    public boolean getUseContextClassLoader() {
        return this.useContextClassLoader;
    }

    public void setUseContextClassLoader(boolean bl) {
        this.useContextClassLoader = bl;
    }

    public boolean getValidating() {
        return this.validating;
    }

    public void setValidating(boolean bl) {
        this.validating = bl;
    }

    public XMLReader getXMLReader() throws SAXException {
        if (this.reader == null) {
            this.reader = this.getParser().getXMLReader();
        }
        this.reader.setDTDHandler(this);
        this.reader.setContentHandler(this);
        if (this.entityResolver == null) {
            this.reader.setEntityResolver(this);
        } else {
            this.reader.setEntityResolver(this.entityResolver);
        }
        this.reader.setErrorHandler(this);
        return this.reader;
    }

    public Substitutor getSubstitutor() {
        return this.substitutor;
    }

    public void setSubstitutor(Substitutor substitutor) {
        this.substitutor = substitutor;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug((Object)("characters(" + new String(cArray, n, n2) + ")"));
        }
        this.bodyText.append(cArray, n, n2);
    }

    public void endDocument() throws SAXException {
        if (this.saxLog.isDebugEnabled()) {
            if (this.getCount() > 1) {
                this.saxLog.debug((Object)("endDocument():  " + this.getCount() + " elements left"));
            } else {
                this.saxLog.debug((Object)"endDocument()");
            }
        }
        while (this.getCount() > 1) {
            this.pop();
        }
        Iterator iterator = this.getRules().rules().iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            try {
                rule.finish();
            }
            catch (Exception exception) {
                this.log.error((Object)"Finish event threw exception", (Throwable)exception);
                throw this.createSAXException(exception);
            }
            catch (Error error) {
                this.log.error((Object)"Finish event threw error", (Throwable)error);
                throw error;
            }
        }
        this.clear();
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        int n;
        List list;
        String string4;
        boolean bl = this.log.isDebugEnabled();
        if (bl) {
            if (this.saxLog.isDebugEnabled()) {
                this.saxLog.debug((Object)("endElement(" + string + "," + string2 + "," + string3 + ")"));
            }
            this.log.debug((Object)("  match='" + this.match + "'"));
            this.log.debug((Object)("  bodyText='" + this.bodyText + "'"));
        }
        if ((string4 = string2) == null || string4.length() < 1) {
            string4 = string3;
        }
        if ((list = (List)this.matches.pop()) != null && list.size() > 0) {
            String string5 = this.bodyText.toString();
            Substitutor substitutor = this.getSubstitutor();
            if (substitutor != null) {
                string5 = substitutor.substitute(string5);
            }
            int n2 = 0;
            while (n2 < list.size()) {
                try {
                    Rule rule = (Rule)list.get(n2);
                    if (bl) {
                        this.log.debug((Object)("  Fire body() for " + rule));
                    }
                    rule.body(string, string4, string5);
                }
                catch (Exception exception) {
                    this.log.error((Object)"Body event threw exception", (Throwable)exception);
                    throw this.createSAXException(exception);
                }
                catch (Error error) {
                    this.log.error((Object)"Body event threw error", (Throwable)error);
                    throw error;
                }
                ++n2;
            }
        } else if (bl) {
            this.log.debug((Object)("  No rules found matching '" + this.match + "'."));
        }
        this.bodyText = (StringBuffer)this.bodyTexts.pop();
        if (bl) {
            this.log.debug((Object)("  Popping body text '" + this.bodyText.toString() + "'"));
        }
        if (list != null) {
            int n3 = 0;
            while (n3 < list.size()) {
                int n4 = list.size() - n3 - 1;
                try {
                    Rule rule = (Rule)list.get(n4);
                    if (bl) {
                        this.log.debug((Object)("  Fire end() for " + rule));
                    }
                    rule.end(string, string4);
                }
                catch (Exception exception) {
                    this.log.error((Object)"End event threw exception", (Throwable)exception);
                    throw this.createSAXException(exception);
                }
                catch (Error error) {
                    this.log.error((Object)"End event threw error", (Throwable)error);
                    throw error;
                }
                ++n3;
            }
        }
        this.match = (n = this.match.lastIndexOf(47)) >= 0 ? this.match.substring(0, n) : "";
    }

    public void endPrefixMapping(String string) throws SAXException {
        ArrayStack arrayStack;
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug((Object)("endPrefixMapping(" + string + ")"));
        }
        if ((arrayStack = (ArrayStack)this.namespaces.get(string)) == null) {
            return;
        }
        try {
            arrayStack.pop();
            if (arrayStack.empty()) {
                this.namespaces.remove(string);
            }
        }
        catch (EmptyStackException emptyStackException) {
            throw this.createSAXException("endPrefixMapping popped too many times");
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug((Object)("ignorableWhitespace(" + new String(cArray, n, n2) + ")"));
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug((Object)("processingInstruction('" + string + "','" + string2 + "')"));
        }
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    public void setDocumentLocator(Locator locator) {
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug((Object)("setDocumentLocator(" + locator + ")"));
        }
        this.locator = locator;
    }

    public void skippedEntity(String string) throws SAXException {
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug((Object)("skippedEntity(" + string + ")"));
        }
    }

    public void startDocument() throws SAXException {
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug((Object)"startDocument()");
        }
        this.configure();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        boolean bl = this.log.isDebugEnabled();
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug((Object)("startElement(" + string + "," + string2 + "," + string3 + ")"));
        }
        this.bodyTexts.push((Object)this.bodyText);
        if (bl) {
            this.log.debug((Object)("  Pushing body text '" + this.bodyText.toString() + "'"));
        }
        this.bodyText = new StringBuffer();
        String string4 = string2;
        if (string4 == null || string4.length() < 1) {
            string4 = string3;
        }
        StringBuffer stringBuffer = new StringBuffer(this.match);
        if (this.match.length() > 0) {
            stringBuffer.append('/');
        }
        stringBuffer.append(string4);
        this.match = stringBuffer.toString();
        if (bl) {
            this.log.debug((Object)("  New match='" + this.match + "'"));
        }
        List list = this.getRules().match(string, this.match);
        this.matches.push((Object)list);
        if (list != null && list.size() > 0) {
            Substitutor substitutor = this.getSubstitutor();
            if (substitutor != null) {
                attributes = substitutor.substitute(attributes);
            }
            int n = 0;
            while (n < list.size()) {
                try {
                    Rule rule = (Rule)list.get(n);
                    if (bl) {
                        this.log.debug((Object)("  Fire begin() for " + rule));
                    }
                    rule.begin(string, string4, attributes);
                }
                catch (Exception exception) {
                    this.log.error((Object)"Begin event threw exception", (Throwable)exception);
                    throw this.createSAXException(exception);
                }
                catch (Error error) {
                    this.log.error((Object)"Begin event threw error", (Throwable)error);
                    throw error;
                }
                ++n;
            }
        } else if (bl) {
            this.log.debug((Object)("  No rules found matching '" + this.match + "'."));
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        ArrayStack arrayStack;
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug((Object)("startPrefixMapping(" + string + "," + string2 + ")"));
        }
        if ((arrayStack = (ArrayStack)this.namespaces.get(string)) == null) {
            arrayStack = new ArrayStack();
            this.namespaces.put(string, arrayStack);
        }
        arrayStack.push((Object)string2);
    }

    public void notationDecl(String string, String string2, String string3) {
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug((Object)("notationDecl(" + string + "," + string2 + "," + string3 + ")"));
        }
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug((Object)("unparsedEntityDecl(" + string + "," + string2 + "," + string3 + "," + string4 + ")"));
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug((Object)("resolveEntity('" + string + "', '" + string2 + "')"));
        }
        if (string != null) {
            this.publicId = string;
        }
        String string3 = null;
        if (string != null) {
            string3 = (String)this.entityValidator.get(string);
        }
        if (this.schemaLocation != null && string3 == null && string2 != null) {
            string3 = (String)this.entityValidator.get(string2);
        }
        if (string3 == null) {
            if (string2 == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(" Cannot resolve entity: '" + string3 + "'"));
                }
                return null;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(" Trying to resolve using system ID '" + string2 + "'"));
            }
            string3 = string2;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(" Resolving to alternate DTD '" + string3 + "'"));
        }
        try {
            return new InputSource(string3);
        }
        catch (Exception exception) {
            throw this.createSAXException(exception);
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.log.error((Object)("Parse Error at line " + sAXParseException.getLineNumber() + " column " + sAXParseException.getColumnNumber() + ": " + sAXParseException.getMessage()), (Throwable)sAXParseException);
        if (this.errorHandler != null) {
            this.errorHandler.error(sAXParseException);
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.log.error((Object)("Parse Fatal Error at line " + sAXParseException.getLineNumber() + " column " + sAXParseException.getColumnNumber() + ": " + sAXParseException.getMessage()), (Throwable)sAXParseException);
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(sAXParseException);
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (this.errorHandler != null) {
            this.log.warn((Object)("Parse Warning Error at line " + sAXParseException.getLineNumber() + " column " + sAXParseException.getColumnNumber() + ": " + sAXParseException.getMessage()), (Throwable)sAXParseException);
            this.errorHandler.warning(sAXParseException);
        }
    }

    public void log(String string) {
        this.log.info((Object)string);
    }

    public void log(String string, Throwable throwable) {
        this.log.error((Object)string, throwable);
    }

    public Object parse(File file) throws IOException, SAXException {
        this.configure();
        InputSource inputSource = new InputSource(new FileInputStream(file));
        inputSource.setSystemId("file://" + file.getAbsolutePath());
        this.getXMLReader().parse(inputSource);
        return this.root;
    }

    public Object parse(InputSource inputSource) throws IOException, SAXException {
        this.configure();
        this.getXMLReader().parse(inputSource);
        return this.root;
    }

    public Object parse(InputStream inputStream) throws IOException, SAXException {
        this.configure();
        InputSource inputSource = new InputSource(inputStream);
        this.getXMLReader().parse(inputSource);
        return this.root;
    }

    public Object parse(Reader reader) throws IOException, SAXException {
        this.configure();
        InputSource inputSource = new InputSource(reader);
        this.getXMLReader().parse(inputSource);
        return this.root;
    }

    public Object parse(String string) throws IOException, SAXException {
        this.configure();
        InputSource inputSource = new InputSource(string);
        this.getXMLReader().parse(inputSource);
        return this.root;
    }

    public void register(String string, String string2) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("register('" + string + "', '" + string2 + "'"));
        }
        this.entityValidator.put(string, string2);
    }

    public void addRule(String string, Rule rule) {
        rule.setDigester(this);
        this.getRules().add(string, rule);
    }

    public void addRuleSet(RuleSet ruleSet) {
        String string = this.getRuleNamespaceURI();
        String string2 = ruleSet.getNamespaceURI();
        if (this.log.isDebugEnabled()) {
            if (string2 == null) {
                this.log.debug((Object)"addRuleSet() with no namespace URI");
            } else {
                this.log.debug((Object)("addRuleSet() with namespace URI " + string2));
            }
        }
        this.setRuleNamespaceURI(string2);
        ruleSet.addRuleInstances(this);
        this.setRuleNamespaceURI(string);
    }

    public void addBeanPropertySetter(String string) {
        this.addRule(string, new BeanPropertySetterRule());
    }

    public void addBeanPropertySetter(String string, String string2) {
        this.addRule(string, new BeanPropertySetterRule(string2));
    }

    public void addCallMethod(String string, String string2) {
        this.addRule(string, new CallMethodRule(string2));
    }

    public void addCallMethod(String string, String string2, int n) {
        this.addRule(string, new CallMethodRule(string2, n));
    }

    public void addCallMethod(String string, String string2, int n, String[] stringArray) {
        this.addRule(string, new CallMethodRule(string2, n, stringArray));
    }

    public void addCallMethod(String string, String string2, int n, Class[] classArray) {
        this.addRule(string, new CallMethodRule(string2, n, classArray));
    }

    public void addCallParam(String string, int n) {
        this.addRule(string, new CallParamRule(n));
    }

    public void addCallParam(String string, int n, String string2) {
        this.addRule(string, new CallParamRule(n, string2));
    }

    public void addCallParam(String string, int n, boolean bl) {
        this.addRule(string, new CallParamRule(n, bl));
    }

    public void addCallParam(String string, int n, int n2) {
        this.addRule(string, new CallParamRule(n, n2));
    }

    public void addCallParamPath(String string, int n) {
        this.addRule(string, new PathCallParamRule(n));
    }

    public void addObjectParam(String string, int n, Object object) {
        this.addRule(string, new ObjectParamRule(n, object));
    }

    public void addFactoryCreate(String string, String string2) {
        this.addFactoryCreate(string, string2, false);
    }

    public void addFactoryCreate(String string, Class clazz) {
        this.addFactoryCreate(string, clazz, false);
    }

    public void addFactoryCreate(String string, String string2, String string3) {
        this.addFactoryCreate(string, string2, string3, false);
    }

    public void addFactoryCreate(String string, Class clazz, String string2) {
        this.addFactoryCreate(string, clazz, string2, false);
    }

    public void addFactoryCreate(String string, ObjectCreationFactory objectCreationFactory) {
        this.addFactoryCreate(string, objectCreationFactory, false);
    }

    public void addFactoryCreate(String string, String string2, boolean bl) {
        this.addRule(string, new FactoryCreateRule(string2, bl));
    }

    public void addFactoryCreate(String string, Class clazz, boolean bl) {
        this.addRule(string, new FactoryCreateRule(clazz, bl));
    }

    public void addFactoryCreate(String string, String string2, String string3, boolean bl) {
        this.addRule(string, new FactoryCreateRule(string2, string3, bl));
    }

    public void addFactoryCreate(String string, Class clazz, String string2, boolean bl) {
        this.addRule(string, new FactoryCreateRule(clazz, string2, bl));
    }

    public void addFactoryCreate(String string, ObjectCreationFactory objectCreationFactory, boolean bl) {
        objectCreationFactory.setDigester(this);
        this.addRule(string, new FactoryCreateRule(objectCreationFactory, bl));
    }

    public void addObjectCreate(String string, String string2) {
        this.addRule(string, new ObjectCreateRule(string2));
    }

    public void addObjectCreate(String string, Class clazz) {
        this.addRule(string, new ObjectCreateRule(clazz));
    }

    public void addObjectCreate(String string, String string2, String string3) {
        this.addRule(string, new ObjectCreateRule(string2, string3));
    }

    public void addObjectCreate(String string, String string2, Class clazz) {
        this.addRule(string, new ObjectCreateRule(string2, clazz));
    }

    public void addSetNestedProperties(String string) {
        this.addRule(string, new SetNestedPropertiesRule());
    }

    public void addSetNestedProperties(String string, String string2, String string3) {
        this.addRule(string, new SetNestedPropertiesRule(string2, string3));
    }

    public void addSetNestedProperties(String string, String[] stringArray, String[] stringArray2) {
        this.addRule(string, new SetNestedPropertiesRule(stringArray, stringArray2));
    }

    public void addSetNext(String string, String string2) {
        this.addRule(string, new SetNextRule(string2));
    }

    public void addSetNext(String string, String string2, String string3) {
        this.addRule(string, new SetNextRule(string2, string3));
    }

    public void addSetRoot(String string, String string2) {
        this.addRule(string, new SetRootRule(string2));
    }

    public void addSetRoot(String string, String string2, String string3) {
        this.addRule(string, new SetRootRule(string2, string3));
    }

    public void addSetProperties(String string) {
        this.addRule(string, new SetPropertiesRule());
    }

    public void addSetProperties(String string, String string2, String string3) {
        this.addRule(string, new SetPropertiesRule(string2, string3));
    }

    public void addSetProperties(String string, String[] stringArray, String[] stringArray2) {
        this.addRule(string, new SetPropertiesRule(stringArray, stringArray2));
    }

    public void addSetProperty(String string, String string2, String string3) {
        this.addRule(string, new SetPropertyRule(string2, string3));
    }

    public void addSetTop(String string, String string2) {
        this.addRule(string, new SetTopRule(string2));
    }

    public void addSetTop(String string, String string2, String string3) {
        this.addRule(string, new SetTopRule(string2, string3));
    }

    public void clear() {
        this.match = "";
        this.bodyTexts.clear();
        this.params.clear();
        this.publicId = null;
        this.stack.clear();
    }

    public Object peek() {
        try {
            return this.stack.peek();
        }
        catch (EmptyStackException emptyStackException) {
            this.log.warn((Object)"Empty stack (returning null)");
            return null;
        }
    }

    public Object peek(int n) {
        try {
            return this.stack.peek(n);
        }
        catch (EmptyStackException emptyStackException) {
            this.log.warn((Object)"Empty stack (returning null)");
            return null;
        }
    }

    public Object pop() {
        try {
            return this.stack.pop();
        }
        catch (EmptyStackException emptyStackException) {
            this.log.warn((Object)"Empty stack (returning null)");
            return null;
        }
    }

    public void push(Object object) {
        if (this.stack.size() == 0) {
            this.root = object;
        }
        this.stack.push(object);
    }

    public void push(String string, Object object) {
        ArrayStack arrayStack = (ArrayStack)this.stacksByName.get(string);
        if (arrayStack == null) {
            arrayStack = new ArrayStack();
            this.stacksByName.put(string, arrayStack);
        }
        arrayStack.push(object);
    }

    public Object pop(String string) {
        Object object = null;
        ArrayStack arrayStack = (ArrayStack)this.stacksByName.get(string);
        if (arrayStack == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Stack '" + string + "' is empty"));
            }
            throw new EmptyStackException();
        }
        object = arrayStack.pop();
        return object;
    }

    public Object peek(String string) {
        Object object = null;
        ArrayStack arrayStack = (ArrayStack)this.stacksByName.get(string);
        if (arrayStack == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Stack '" + string + "' is empty"));
            }
            throw new EmptyStackException();
        }
        object = arrayStack.peek();
        return object;
    }

    public boolean isEmpty(String string) {
        boolean bl = true;
        ArrayStack arrayStack = (ArrayStack)this.stacksByName.get(string);
        if (arrayStack != null) {
            bl = arrayStack.isEmpty();
        }
        return bl;
    }

    public Object getRoot() {
        return this.root;
    }

    protected void configure() {
        if (this.configured) {
            return;
        }
        this.initialize();
        this.configured = true;
    }

    protected void initialize() {
    }

    Map getRegistrations() {
        return this.entityValidator;
    }

    List getRules(String string) {
        return this.getRules().match(string);
    }

    public Object peekParams() {
        try {
            return this.params.peek();
        }
        catch (EmptyStackException emptyStackException) {
            this.log.warn((Object)"Empty stack (returning null)");
            return null;
        }
    }

    public Object peekParams(int n) {
        try {
            return this.params.peek(n);
        }
        catch (EmptyStackException emptyStackException) {
            this.log.warn((Object)"Empty stack (returning null)");
            return null;
        }
    }

    public Object popParams() {
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Popping params");
            }
            return this.params.pop();
        }
        catch (EmptyStackException emptyStackException) {
            this.log.warn((Object)"Empty stack (returning null)");
            return null;
        }
    }

    public void pushParams(Object object) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Pushing params");
        }
        this.params.push(object);
    }

    public SAXException createSAXException(String string, Exception exception) {
        Object object;
        if (exception != null && exception instanceof InvocationTargetException && (object = ((InvocationTargetException)exception).getTargetException()) != null && object instanceof Exception) {
            exception = (Exception)object;
        }
        if (this.locator != null) {
            object = "Error at (" + this.locator.getLineNumber() + ", " + this.locator.getColumnNumber() + ": " + string;
            if (exception != null) {
                return new SAXParseException((String)object, this.locator, exception);
            }
            return new SAXParseException((String)object, this.locator);
        }
        this.log.error((Object)"No Locator!");
        if (exception != null) {
            return new SAXException(string, exception);
        }
        return new SAXException(string);
    }

    public SAXException createSAXException(Exception exception) {
        Throwable throwable;
        if (exception instanceof InvocationTargetException && (throwable = ((InvocationTargetException)exception).getTargetException()) != null && throwable instanceof Exception) {
            exception = (Exception)throwable;
        }
        return this.createSAXException(exception.getMessage(), exception);
    }

    public SAXException createSAXException(String string) {
        return this.createSAXException(string, null);
    }
}

