/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.Rules;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;

public class SetNestedPropertiesRule
extends Rule {
    private static final String PROP_IGNORE = "ignore-me";
    private Log log = null;
    private AnyChildRule anyChildRule = new AnyChildRule();
    private AnyChildRules newRules = new AnyChildRules(this.anyChildRule);
    private Rules oldRules = null;
    private boolean trimData = true;
    private boolean allowUnknownChildElements = false;
    private HashMap elementNames = new HashMap();

    public SetNestedPropertiesRule() {
    }

    public SetNestedPropertiesRule(String string, String string2) {
        this.elementNames.put(string, string2);
    }

    public SetNestedPropertiesRule(String[] stringArray, String[] stringArray2) {
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String string = null;
            if (n < stringArray2.length) {
                string = stringArray2[n];
            }
            if (string == null) {
                this.elementNames.put(stringArray[n], PROP_IGNORE);
            } else {
                this.elementNames.put(stringArray[n], string);
            }
            ++n;
        }
    }

    public void setDigester(Digester digester) {
        super.setDigester(digester);
        this.log = digester.getLogger();
        this.anyChildRule.setDigester(digester);
    }

    public void setTrimData(boolean bl) {
        this.trimData = bl;
    }

    public boolean getTrimData() {
        return this.trimData;
    }

    public void setAllowUnknownChildElements(boolean bl) {
        this.allowUnknownChildElements = bl;
    }

    public boolean getAllowUnknownChildElements() {
        return this.allowUnknownChildElements;
    }

    public void begin(String string, String string2, Attributes attributes) throws Exception {
        this.oldRules = this.digester.getRules();
        this.newRules.init(this.digester.getMatch() + "/", this.oldRules);
        this.digester.setRules(this.newRules);
    }

    public void body(String string) throws Exception {
        this.digester.setRules(this.oldRules);
    }

    public void addAlias(String string, String string2) {
        if (string2 == null) {
            this.elementNames.put(string, PROP_IGNORE);
        } else {
            this.elementNames.put(string, string2);
        }
    }

    public String toString() {
        return "SetNestedPropertiesRule";
    }

    private class AnyChildRule
    extends Rule {
        private String currChildNamespaceURI = null;
        private String currChildElementName = null;

        private AnyChildRule() {
        }

        public void begin(String string, String string2, Attributes attributes) throws Exception {
            this.currChildNamespaceURI = string;
            this.currChildElementName = string2;
        }

        public void body(String string) throws Exception {
            PropertyDescriptor propertyDescriptor;
            DynaProperty dynaProperty;
            boolean bl = SetNestedPropertiesRule.this.log.isDebugEnabled();
            String string2 = (String)SetNestedPropertiesRule.this.elementNames.get(this.currChildElementName);
            if (string2 == SetNestedPropertiesRule.PROP_IGNORE) {
                return;
            }
            if (string2 == null) {
                string2 = this.currChildElementName;
            }
            if (this.digester.log.isDebugEnabled()) {
                this.digester.log.debug((Object)("[SetNestedPropertiesRule]{" + this.digester.match + "} Setting property '" + string2 + "' to '" + string + "'"));
            }
            Object object = this.digester.peek();
            if (this.digester.log.isDebugEnabled()) {
                if (object != null) {
                    this.digester.log.debug((Object)("[SetNestedPropertiesRule]{" + this.digester.match + "} Set " + object.getClass().getName() + " properties"));
                } else {
                    this.digester.log.debug((Object)("[SetPropertiesRule]{" + this.digester.match + "} Set NULL properties"));
                }
            }
            if (SetNestedPropertiesRule.this.trimData) {
                string = string.trim();
            }
            if (!SetNestedPropertiesRule.this.allowUnknownChildElements && (object instanceof DynaBean ? (dynaProperty = ((DynaBean)object).getDynaClass().getDynaProperty(string2)) == null : (propertyDescriptor = PropertyUtils.getPropertyDescriptor((Object)object, (String)string2)) == null)) {
                throw new NoSuchMethodException("Bean has no property named " + string2);
            }
            BeanUtils.setProperty((Object)object, (String)string2, (Object)string);
        }

        public void end(String string, String string2) throws Exception {
            this.currChildElementName = null;
        }
    }

    private class AnyChildRules
    implements Rules {
        private String matchPrefix = null;
        private Rules decoratedRules = null;
        private ArrayList rules = new ArrayList(1);
        private AnyChildRule rule;

        public AnyChildRules(AnyChildRule anyChildRule) {
            this.rule = anyChildRule;
            this.rules.add(anyChildRule);
        }

        public Digester getDigester() {
            return null;
        }

        public void setDigester(Digester digester) {
        }

        public String getNamespaceURI() {
            return null;
        }

        public void setNamespaceURI(String string) {
        }

        public void add(String string, Rule rule) {
        }

        public void clear() {
        }

        public List match(String string) {
            return this.match(null, string);
        }

        public List match(String string, String string2) {
            List list = this.decoratedRules.match(string, string2);
            if (string2.startsWith(this.matchPrefix) && string2.indexOf(47, this.matchPrefix.length()) == -1) {
                if (list == null || list.size() == 0) {
                    return this.rules;
                }
                LinkedList<AnyChildRule> linkedList = new LinkedList<AnyChildRule>(list);
                linkedList.addLast(this.rule);
                return linkedList;
            }
            return list;
        }

        public List rules() {
            throw new RuntimeException("AnyChildRules.rules not implemented.");
        }

        public void init(String string, Rules rules) {
            this.matchPrefix = string;
            this.decoratedRules = rules;
        }
    }
}

