/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester.plugins;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.plugins.PluginAssertionFailure;
import org.apache.commons.digester.plugins.PluginException;
import org.apache.commons.digester.plugins.PluginManager;
import org.apache.commons.digester.plugins.RuleLoader;
import org.apache.commons.logging.Log;

public class Declaration {
    private Class pluginClass;
    private String pluginClassName;
    private String id;
    private Properties properties = new Properties();
    private boolean initialized = false;
    private RuleLoader ruleLoader = null;

    public Declaration(String string) {
        this.pluginClassName = string;
    }

    public Declaration(Class clazz) {
        this.pluginClass = clazz;
        this.pluginClassName = clazz.getName();
    }

    public Declaration(Class clazz, RuleLoader ruleLoader) {
        this.pluginClass = clazz;
        this.pluginClassName = clazz.getName();
        this.ruleLoader = ruleLoader;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    public void setProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    public Class getPluginClass() {
        return this.pluginClass;
    }

    public void init(Digester digester, PluginManager pluginManager) throws PluginException {
        Log log = digester.getLogger();
        boolean bl = log.isDebugEnabled();
        if (bl) {
            log.debug((Object)"init being called!");
        }
        if (this.initialized) {
            throw new PluginAssertionFailure("Init called multiple times.");
        }
        if (this.pluginClass == null && this.pluginClassName != null) {
            try {
                this.pluginClass = digester.getClassLoader().loadClass(this.pluginClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new PluginException("Unable to load class " + this.pluginClassName, classNotFoundException);
            }
        }
        if (this.ruleLoader == null) {
            log.debug((Object)"Searching for ruleloader...");
            this.ruleLoader = pluginManager.findLoader(digester, this.id, this.pluginClass, this.properties);
        } else {
            log.debug((Object)"This declaration has an explicit ruleLoader.");
        }
        if (bl) {
            if (this.ruleLoader == null) {
                log.debug((Object)("No ruleLoader found for plugin declaration id [" + this.id + "]" + ", class [" + this.pluginClass.getClass().getName() + "]."));
            } else {
                log.debug((Object)("RuleLoader of type [" + this.ruleLoader.getClass().getName() + "] associated with plugin declaration" + " id [" + this.id + "]" + ", class [" + this.pluginClass.getClass().getName() + "]."));
            }
        }
        this.initialized = true;
    }

    public void configure(Digester digester, String string) throws PluginException {
        Log log = digester.getLogger();
        boolean bl = log.isDebugEnabled();
        if (bl) {
            log.debug((Object)"configure being called!");
        }
        if (!this.initialized) {
            throw new PluginAssertionFailure("Not initialized.");
        }
        if (this.ruleLoader != null) {
            this.ruleLoader.addRules(digester, string);
        }
    }
}

