/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.PLPInputStream;
import com.microsoft.sqlserver.jdbc.PLPXMLInputStream;
import com.microsoft.sqlserver.jdbc.SQLServerBlob;
import com.microsoft.sqlserver.jdbc.SQLServerClob;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;

final class DDC {
    static final int STREAM_NONE = 0;
    static final int STREAM_BINARY = 1;
    static final int STREAM_CHARACTER = 2;
    static final int STREAM_ASCII = 3;
    static final Integer zeroInteger = new Integer(0);
    static final Double zeroDouble = new Double(0.0);
    static final Long zeroLong = new Long(0L);
    static final Float zeroFloat = new Float(0.0f);
    static final BigDecimal zeroBigDecimal = new BigDecimal(0.0);
    private static final BigInteger maxRPCDecimalValue = new BigInteger("99999999999999999999999999999999999999");

    DDC() {
    }

    static final Object convertIntegerToObject(Integer n, int n2, int n3) {
        switch (n2) {
            case 4: {
                return n;
            }
            case -6: 
            case 5: {
                return new Short(n.shortValue());
            }
            case -7: 
            case 16: {
                return new Boolean(!n.equals(zeroInteger));
            }
            case -5: {
                return new Long(n.intValue());
            }
            case 2: 
            case 3: {
                return new BigDecimal(n.toString());
            }
            case 8: {
                return new Double(n.intValue());
            }
            case 6: 
            case 7: {
                return new Float(n.intValue());
            }
        }
        if (2 == n3) {
            return new StringReader(n.toString());
        }
        return n.toString();
    }

    static final Object convertLongToObject(Long l, int n, int n2) {
        switch (n) {
            case -5: {
                return l;
            }
            case 4: {
                return new Integer(l.intValue());
            }
            case -6: 
            case 5: {
                return new Short(l.shortValue());
            }
            case -7: 
            case 16: {
                return new Boolean(!l.equals(zeroLong));
            }
            case 2: 
            case 3: {
                return new BigDecimal(l.toString());
            }
            case 8: {
                return new Double(l.longValue());
            }
            case 6: 
            case 7: {
                return new Float(l.longValue());
            }
        }
        if (2 == n2) {
            return new StringReader(l.toString());
        }
        return l.toString();
    }

    static final Object convertFloatToObject(Float f, int n, int n2) {
        switch (n) {
            case 6: 
            case 7: {
                return f;
            }
            case 4: {
                return new Integer(f.intValue());
            }
            case -6: 
            case 5: {
                return new Short(f.shortValue());
            }
            case -7: 
            case 16: {
                return new Boolean(!f.equals(zeroFloat));
            }
            case -5: {
                return new Long(f.longValue());
            }
            case 2: 
            case 3: {
                return new BigDecimal(f.toString());
            }
            case 8: {
                return new Double(f.doubleValue());
            }
        }
        String string = f.toString();
        if (2 == n2) {
            return new StringReader(string);
        }
        return string;
    }

    static final Object convertDoubleToObject(Double d, int n, int n2) {
        switch (n) {
            case 8: {
                return d;
            }
            case 6: 
            case 7: {
                return new Float(d.floatValue());
            }
            case 4: {
                return new Integer(d.intValue());
            }
            case -6: 
            case 5: {
                return new Short(d.shortValue());
            }
            case -7: 
            case 16: {
                return new Boolean(!d.equals(zeroDouble));
            }
            case -5: {
                return new Long(d.longValue());
            }
            case 2: 
            case 3: {
                return new BigDecimal(d.toString());
            }
        }
        String string = d.toString();
        if (2 == n2) {
            return new StringReader(string);
        }
        return string;
    }

    static final Object convertBigDecimalToObject(BigDecimal bigDecimal, int n, int n2) {
        switch (n) {
            case 2: 
            case 3: {
                return bigDecimal;
            }
            case 8: {
                return new Double(bigDecimal.doubleValue());
            }
            case 6: 
            case 7: {
                return new Float(bigDecimal.floatValue());
            }
            case 4: {
                return new Integer(bigDecimal.intValue());
            }
            case -6: 
            case 5: {
                return new Short(bigDecimal.shortValue());
            }
            case -7: 
            case 16: {
                return new Boolean(0 != bigDecimal.compareTo(zeroBigDecimal));
            }
            case -5: {
                return new Long(bigDecimal.longValue());
            }
        }
        if (2 == n2) {
            return new StringReader(bigDecimal.toString());
        }
        return bigDecimal.toString();
    }

    static final Object convertTimestampToObject(Timestamp timestamp, int n, int n2) {
        switch (n) {
            case 93: {
                return timestamp;
            }
            case 91: {
                return DDC.convertTimestampToDate(timestamp);
            }
            case 92: {
                return DDC.convertTimestampToTime(timestamp);
            }
        }
        if (2 == n2) {
            return new StringReader(timestamp.toString());
        }
        return timestamp.toString();
    }

    static final Object convertStringToObject(String string, int n, int n2) throws SQLServerException {
        switch (n) {
            case 2: 
            case 3: {
                return new BigDecimal(string.trim());
            }
            case 8: {
                return Double.valueOf(string.trim());
            }
            case 6: 
            case 7: {
                return Float.valueOf(string.trim());
            }
            case 4: {
                return Integer.valueOf(string.trim());
            }
            case -6: 
            case 5: {
                return Short.valueOf(string.trim());
            }
            case -7: 
            case 16: {
                return Boolean.valueOf(string.trim());
            }
            case -5: {
                return Long.valueOf(string.trim());
            }
            case 93: {
                return Timestamp.valueOf(string.trim());
            }
            case 91: {
                return Date.valueOf(DDC.getDatePart(string.trim()));
            }
            case 92: {
                Timestamp timestamp = Timestamp.valueOf("1970-01-01 " + DDC.getTimePart(string.trim()));
                return new Time(timestamp.getTime());
            }
            case 2005: {
                return new SQLServerClob(null, string);
            }
        }
        switch (n2) {
            case 2: {
                return new StringReader(string);
            }
            case 3: {
                try {
                    return new ByteArrayInputStream(string.getBytes("US-ASCII"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLServerException(null, unsupportedEncodingException.getMessage(), null, 0, true);
                }
            }
            case 1: {
                return new ByteArrayInputStream(string.getBytes());
            }
        }
        return string;
    }

    static final Object binaryPLPToObject(PLPInputStream pLPInputStream, int n, int n2, int n3) throws IOException, SQLServerException {
        Object object;
        if (3 == n3 || 1 == n3) {
            return pLPInputStream;
        }
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                if (2 == n3) {
                    return new StringReader(pLPInputStream.getHexizedString());
                }
                return pLPInputStream.getHexizedString();
            }
        }
        byte[] byArray = new byte[pLPInputStream.getDataLength()];
        pLPInputStream.read(byArray);
        if (2004 == n2) {
            SQLServerBlob sQLServerBlob;
            object = sQLServerBlob;
            sQLServerBlob = new SQLServerBlob(null, byArray);
        } else {
            object = byArray;
        }
        return object;
    }

    static final Object xmlPLPToObject(byte[] byArray, int n, int n2, int n3, int n4) throws IOException, UnsupportedEncodingException, SQLServerException {
        switch (n3) {
            case -1: 
            case 1: 
            case 12: {
                PLPInputStream pLPInputStream = new PLPInputStream(byArray, n);
                if (2 == n4) {
                    return pLPInputStream.getCharacterStream("UTF-16LE");
                }
                if (3 == n4) {
                    return pLPInputStream.getCharacterStream("US-ASCII");
                }
                return pLPInputStream.getString("UTF-16LE", pLPInputStream.getDataLength() / 2);
            }
            case 2005: {
                PLPInputStream pLPInputStream = new PLPInputStream(byArray, n);
                return new SQLServerClob(null, pLPInputStream.getString("UTF-16LE", pLPInputStream.getDataLength() / 2));
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                Object object;
                byte[] byArray2;
                PLPXMLInputStream pLPXMLInputStream = new PLPXMLInputStream(byArray, n);
                if (1 == n4) {
                    return pLPXMLInputStream;
                }
                if (0 == pLPXMLInputStream.getDataLengthWithoutBOM()) {
                    byArray2 = new byte[]{};
                } else {
                    byArray2 = new byte[pLPXMLInputStream.getDataLength()];
                    pLPXMLInputStream.read(byArray2);
                }
                if (2004 == n3) {
                    SQLServerBlob sQLServerBlob;
                    object = sQLServerBlob;
                    sQLServerBlob = new SQLServerBlob(null, byArray2);
                } else {
                    object = byArray2;
                }
                return object;
            }
        }
        return null;
    }

    static final Object characterPLPToObject(PLPInputStream pLPInputStream, TypeInfo typeInfo, int n, int n2) throws IOException, UnsupportedEncodingException, SQLServerException {
        String string = null;
        int n3 = typeInfo.getNativeType();
        if (-2 == n) {
            if (1 == n2) {
                return pLPInputStream;
            }
            byte[] byArray = new byte[pLPInputStream.getDataLength()];
            pLPInputStream.read(byArray);
            return byArray;
        }
        if (2 == n2) {
            if (167 == typeInfo.getNativeType()) {
                return pLPInputStream.getCharacterStream(typeInfo.getCharset());
            }
            if (231 == typeInfo.getNativeType()) {
                return pLPInputStream.getCharacterStream("UTF-16LE");
            }
        } else {
            if (3 == n2) {
                if (167 == typeInfo.getNativeType()) {
                    string = pLPInputStream.getString(typeInfo.getCharset(), pLPInputStream.getDataLength());
                } else if (231 == typeInfo.getNativeType()) {
                    string = pLPInputStream.getString("UTF-16LE", pLPInputStream.getDataLength() / 2);
                }
                return new ByteArrayInputStream(string.getBytes("US-ASCII"));
            }
            if (167 == typeInfo.getNativeType()) {
                string = pLPInputStream.getString(typeInfo.getCharset(), pLPInputStream.getDataLength());
            } else if (231 == typeInfo.getNativeType()) {
                string = pLPInputStream.getString("UTF-16LE", pLPInputStream.getDataLength() / 2);
            }
        }
        return DDC.convertStringToObject(string, n, n2);
    }

    static final byte[] convertTDSBytesToRoundTrippableBytes(byte[] byArray, int n, int n2, TypeInfo typeInfo) {
        byte[] byArray2 = null;
        switch (typeInfo.getNativeType()) {
            case 11: 
            case 14: 
            case 16: 
            case 38: 
            case 109: {
                byArray2 = new byte[n2];
                DDC.reverseAllBytes(byArray, n, byArray2, n2);
                break;
            }
            case 110: {
                byArray2 = new byte[n2];
                DDC.reverseMoneyBytes(byArray, n, byArray2, n2);
                break;
            }
            case 106: 
            case 108: {
                byArray2 = new byte[n2 + 3];
                byArray2[0] = (byte)typeInfo.getPrecision();
                byArray2[1] = (byte)typeInfo.getScale();
                byArray2[2] = 0;
                System.arraycopy(byArray, n, byArray2, 3, n2);
                break;
            }
            default: {
                byArray2 = new byte[n2];
                System.arraycopy(byArray, n, byArray2, 0, n2);
            }
        }
        return byArray2;
    }

    private static final void reverseAllBytes(byte[] byArray, int n, byte[] byArray2, int n2) {
        switch (n2) {
            case 2: {
                byArray2[0] = byArray[n + 1];
                byArray2[1] = byArray[n];
                break;
            }
            case 4: {
                byArray2[0] = byArray[n + 3];
                byArray2[1] = byArray[n + 2];
                byArray2[2] = byArray[n + 1];
                byArray2[3] = byArray[n];
                break;
            }
            case 8: {
                byArray2[0] = byArray[n + 7];
                byArray2[1] = byArray[n + 6];
                byArray2[2] = byArray[n + 5];
                byArray2[3] = byArray[n + 4];
                byArray2[4] = byArray[n + 3];
                byArray2[5] = byArray[n + 2];
                byArray2[6] = byArray[n + 1];
                byArray2[7] = byArray[n];
            }
        }
    }

    private static final void reverseMoneyBytes(byte[] byArray, int n, byte[] byArray2, int n2) {
        switch (n2) {
            case 4: {
                byArray2[0] = byArray[n + 1];
                byArray2[1] = byArray[n];
                byArray2[2] = byArray[n + 3];
                byArray2[3] = byArray[n + 2];
                break;
            }
            case 8: {
                byArray2[0] = byArray[n + 3];
                byArray2[1] = byArray[n + 2];
                byArray2[2] = byArray[n + 1];
                byArray2[3] = byArray[n];
                byArray2[4] = byArray[n + 7];
                byArray2[5] = byArray[n + 6];
                byArray2[6] = byArray[n + 5];
                byArray2[7] = byArray[n + 4];
            }
        }
    }

    private static final String getDatePart(String string) {
        int n = string.indexOf(32);
        if (-1 == n) {
            return string;
        }
        return string.substring(0, n);
    }

    private static final String getTimePart(String string) {
        int n = string.indexOf(32);
        if (-1 == n) {
            return string;
        }
        return string.substring(n + 1);
    }

    static final boolean exceedsMaxRPCDecimalPrecisionOrScale(BigDecimal bigDecimal) {
        BigInteger bigInteger;
        if (null == bigDecimal) {
            return false;
        }
        if (bigDecimal.scale() > 38) {
            return true;
        }
        BigInteger bigInteger2 = bigInteger = bigDecimal.scale() < 0 ? bigDecimal.setScale(0).unscaledValue() : bigDecimal.unscaledValue();
        if (bigDecimal.signum() < 0) {
            bigInteger = bigInteger.negate();
        }
        return bigInteger.compareTo(maxRPCDecimalValue) > 0;
    }

    static final Time convertTimestampToTime(Timestamp timestamp) {
        if (null == timestamp) {
            return null;
        }
        return new Time(DDC.stripDateFromTimestamp(timestamp).getTime());
    }

    static final Date convertTimestampToDate(Timestamp timestamp) {
        if (null == timestamp) {
            return null;
        }
        return new Date(DDC.stripTimeFromTimestamp(timestamp).getTime());
    }

    static Timestamp stripDateFromTimestamp(Timestamp timestamp) {
        timestamp.setYear(70);
        timestamp.setMonth(0);
        timestamp.setDate(1);
        return new Timestamp(timestamp.getTime());
    }

    static Timestamp stripTimeFromTimestamp(Timestamp timestamp) {
        timestamp.setHours(0);
        timestamp.setMinutes(0);
        timestamp.setSeconds(0);
        timestamp.setNanos(0);
        return new Timestamp(timestamp.getTime());
    }

    static String convertReaderToString(Reader reader, int n) throws SQLServerException {
        if (null == reader) {
            return null;
        }
        if (0 == n) {
            return "";
        }
        try {
            if (-1 == n) {
                int n2;
                StringBuffer stringBuffer = new StringBuffer(4000);
                char[] cArray = new char[4000];
                while ((n2 = reader.read(cArray, 0, cArray.length)) > 0) {
                    stringBuffer.append(cArray, 0, n2);
                }
                return stringBuffer.toString();
            }
            char[] cArray = new char[n];
            int n3 = reader.read(cArray);
            if (n3 != n) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_prematureEndOfCharacterStream"));
                Object[] objectArray = new Object[]{new Integer(n3), new Integer(n)};
                SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, true);
            }
            return new String(cArray);
        }
        catch (IOException iOException) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_unexpectedIOExceptionProcessingReader"), null, true);
            return null;
        }
    }
}

