/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DBComms;
import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.PLPInputStream;
import com.microsoft.sqlserver.jdbc.Parameter;
import com.microsoft.sqlserver.jdbc.SQLServerClob;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerPreparedStatement;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.StreamRetValue;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;

public final class SQLServerCallableStatement
extends SQLServerPreparedStatement
implements CallableStatement {
    private ArrayList paramNames;
    boolean lastGetWasNull = false;
    int nOutParams = 0;
    int accessCounter = 0;

    SQLServerCallableStatement(SQLServerConnection sQLServerConnection, DBComms dBComms, String string, boolean bl, int n, int n2, boolean bl2) throws SQLServerException {
        super(sQLServerConnection, dBComms, string, bl, n, n2, false, bl2);
        this.nStatementType = 2;
    }

    private void sendProcedureNameAndParams() throws SQLServerException {
        this.bufferAppendShort((short)this.procedureName.length());
        this.bufferAppendString(this.procedureName);
        this.bufferAppendByte((byte)0);
        this.bufferAppendByte((byte)0);
        this.sendParamsByRPC();
    }

    public final int[] executeBatch() throws SQLServerException, BatchUpdateException {
        this.checkClosed();
        this.trackAccess();
        this.detachRS();
        if (this.batchParameters == null) {
            this.clearBatch();
            return new int[0];
        }
        int n = this.batchParameters.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            this.inOutParam = (Parameter[])this.batchParameters.get(i);
            this.sendProcedureNameAndParams();
            if (i < n - 1) {
                this.bufferAppendByte((byte)this.nBatchStatementDelimiter);
            }
            if (this.nOutIndex > this.maxPacketPayloadBytes()) {
                this.interimStreamSend();
            }
            nArray[i] = -2;
        }
        String string = null;
        for (int i = 0; i < n; ++i) {
            try {
                boolean bl = false;
                bl = i == 0 ? super.doExecute((byte)3) : this.getMoreResults();
                if (bl) {
                    nArray[i] = -3;
                    if (string != null) continue;
                    string = "Batched procedures can only return an update count but a result set was returned by batch " + (i + 1);
                    continue;
                }
                int n2 = this.getUpdateCount();
                if (n2 == -1) {
                    if (string != null) continue;
                    string = "The returned update count was -1. Either a procedure returned a result set or not every procedure returned an update count. The driver expects " + n + " update counts to be returned " + "from this batch.";
                    continue;
                }
                nArray[i] = n2;
                continue;
            }
            catch (SQLException sQLException) {
                if (string == null) {
                    string = "An error occured in procedure call " + (i + 1) + " [" + sQLException.getMessage() + "]";
                }
                nArray[i] = -3;
            }
        }
        this.clearBatch();
        if (string != null) {
            throw new BatchUpdateException(string, "", 0, nArray);
        }
        return nArray;
    }

    public void registerOutParameter(int n, int n2) throws SQLServerException {
        this.checkClosed();
        this.trackAccess();
        if (--n < 0 || n >= this.inOutParam.length) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_indexOutOfRange"));
            Object[] objectArray = new Object[]{new Integer(n + 1)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), "7009", false);
        }
        if (this.inOutParam[n] == null) {
            this.inOutParam[n] = new Parameter();
        }
        if (!this.inOutParam[n].isOutput()) {
            this.inOutParam[n].registerForOutput(n2);
            ++this.nOutParams;
        }
    }

    private final void getOutParameters() throws SQLServerException {
        this.seekToOutParams();
        this.indexOutParams();
        this.bOutParamsGot = true;
    }

    void indexOutParams() throws SQLServerException {
        int n = this.nInIndex;
        int n2 = 0;
        StreamRetValue streamRetValue = null;
        for (int i = 0; i < this.nOutParams; ++i) {
            Object[] objectArray;
            int n3;
            byte by;
            if ((by = this.binDataBuffer[n++]) == -85) {
                n3 = Util.readUnsignedShort(this.binDataBuffer, n);
                n += n3 + 2;
                by = this.binDataBuffer[n++];
            }
            if (by != -84 && by != 121) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_insufficientOutput"));
                objectArray = new Object[]{this.procedureName, new Integer(this.nOutParams), new Integer(i)};
                SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, false);
            }
            if (by == 121) {
                if (this.isInternal && this.bReturnValueSyntax) {
                    n = this.inOutParam[n2++].setFromReturnStatus(n, this.binDataBuffer);
                    continue;
                }
                --i;
                n += 4;
                continue;
            }
            if (this.tdsVersion.isYukonOrLater()) {
                n3 = Util.readUnsignedShort(this.binDataBuffer, n);
                n += 2;
                if (this.isInternal) {
                    if (this.bReturnValueSyntax) {
                        ++n3;
                    }
                } else if (0 == this.prepStmtHandle) {
                    if (0 == n3) {
                        streamRetValue = new StreamRetValue(new Parameter());
                        n = streamRetValue.deserialize(this.binDataBuffer, n, this.tdsVersion);
                        --i;
                        continue;
                    }
                    n3 -= 3;
                } else {
                    --n3;
                }
            } else {
                if (!this.isInternal && 0 == this.prepStmtHandle && null == streamRetValue) {
                    n += 2;
                    streamRetValue = new StreamRetValue(new Parameter());
                    n = streamRetValue.deserialize(this.binDataBuffer, n, this.tdsVersion);
                    --i;
                    continue;
                }
                while (!this.inOutParam[n2].isOutput()) {
                    ++n2;
                }
                n3 = n2++;
                n += 2;
            }
            objectArray = new StreamRetValue(this.inOutParam[n3]);
            n = objectArray.deserialize(this.binDataBuffer, n, this.tdsVersion);
        }
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLServerException {
        this.checkClosed();
        this.registerOutParameter(n, n2);
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLServerException {
        this.checkClosed();
        this.registerOutParameter(n, n2);
        this.inOutParam[n - 1].setOutScale(n3);
    }

    private Parameter getterGetParam(int n) throws SQLServerException {
        Object[] objectArray;
        MessageFormat messageFormat;
        if (n < 1 || n > this.inOutParam.length) {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidOutputParameter"));
            objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), "07009", false);
        }
        if (!this.inOutParam[n - 1].isOutput()) {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_outputParameterNotRegisteredForOutput"));
            objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), "07009", true);
        }
        if (!this.bOutParamsGot) {
            this.getOutParameters();
        }
        this.lastGetWasNull = this.inOutParam[n - 1].isNull();
        return this.inOutParam[n - 1];
    }

    public int getInt(int n) throws SQLServerException {
        this.checkClosed();
        return this.getterGetParam(n).getInt();
    }

    public int getInt(String string) throws SQLServerException {
        this.checkClosed();
        return this.getInt(this.findColumn(string));
    }

    public String getString(int n) throws SQLServerException {
        this.checkClosed();
        Object object = this.getterGetParam(n).getValue(1);
        if (object == null) {
            return null;
        }
        return (String)object;
    }

    public String getString(String string) throws SQLServerException {
        this.checkClosed();
        return this.getString(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLServerException {
        this.checkClosed();
        return (BigDecimal)this.getterGetParam(n).getValue(3);
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLServerException {
        this.checkClosed();
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public boolean getBoolean(int n) throws SQLServerException {
        this.checkClosed();
        Object object = this.getterGetParam(n).getValue(-7);
        if (object == null) {
            return false;
        }
        return (Boolean)object;
    }

    public boolean getBoolean(String string) throws SQLServerException {
        this.checkClosed();
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(int n) throws SQLServerException {
        this.checkClosed();
        return this.getterGetParam(n).getByte();
    }

    public byte getByte(String string) throws SQLServerException {
        this.checkClosed();
        return this.getByte(this.findColumn(string));
    }

    public byte[] getBytes(int n) throws SQLServerException {
        this.checkClosed();
        return (byte[])this.getterGetParam(n).getValue(-2);
    }

    public byte[] getBytes(String string) throws SQLServerException {
        this.checkClosed();
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(int n) throws SQLServerException {
        this.checkClosed();
        return this.getDate(n, null);
    }

    public Date getDate(String string) throws SQLServerException {
        this.checkClosed();
        return this.getDate(this.findColumn(string), null);
    }

    public Date getDate(int n, Calendar calendar) throws SQLServerException {
        this.checkClosed();
        Timestamp timestamp = this.getTimestamp(n, calendar);
        if (null == timestamp) {
            return null;
        }
        return DDC.convertTimestampToDate(timestamp);
    }

    public Date getDate(String string, Calendar calendar) throws SQLServerException {
        this.checkClosed();
        return this.getDate(this.findColumn(string), calendar);
    }

    public double getDouble(int n) throws SQLServerException {
        this.checkClosed();
        Object object = this.getterGetParam(n).getValue(8);
        if (object == null) {
            return 0.0;
        }
        return (Double)object;
    }

    public double getDouble(String string) throws SQLServerException {
        this.checkClosed();
        return this.getDouble(this.findColumn(string));
    }

    public float getFloat(int n) throws SQLServerException {
        this.checkClosed();
        Object object = this.getterGetParam(n).getValue(6);
        if (object == null) {
            return 0.0f;
        }
        return ((Float)object).floatValue();
    }

    public float getFloat(String string) throws SQLServerException {
        this.checkClosed();
        return this.getFloat(this.findColumn(string));
    }

    public long getLong(int n) throws SQLServerException {
        this.checkClosed();
        Object object = this.getterGetParam(n).getValue(-5);
        if (object == null) {
            return 0L;
        }
        return (Long)object;
    }

    public long getLong(String string) throws SQLServerException {
        this.checkClosed();
        return this.getLong(this.findColumn(string));
    }

    public Object getObject(int n) throws SQLServerException {
        Object object;
        this.checkClosed();
        Parameter parameter = this.getterGetParam(n);
        int n2 = parameter.getJdbcType();
        if (6 == n2) {
            n2 = 8;
        }
        if ((object = parameter.getValue(n2)) instanceof PLPInputStream) {
            ((PLPInputStream)object).setParentCallableStatement(this);
        }
        return object;
    }

    public Object getObject(String string) throws SQLServerException {
        this.checkClosed();
        return this.getObject(this.findColumn(string));
    }

    public short getShort(int n) throws SQLServerException {
        this.checkClosed();
        return this.getterGetParam(n).getShort();
    }

    public short getShort(String string) throws SQLServerException {
        this.checkClosed();
        return this.getShort(this.findColumn(string));
    }

    public Time getTime(int n) throws SQLServerException {
        this.checkClosed();
        return this.getTime(n, null);
    }

    public Time getTime(String string) throws SQLServerException {
        this.checkClosed();
        return this.getTime(this.findColumn(string), null);
    }

    public Time getTime(int n, Calendar calendar) throws SQLServerException {
        this.checkClosed();
        Timestamp timestamp = this.getTimestamp(n, calendar);
        if (null == timestamp) {
            return null;
        }
        return DDC.convertTimestampToTime(timestamp);
    }

    public Time getTime(String string, Calendar calendar) throws SQLServerException {
        this.checkClosed();
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLServerException {
        this.checkClosed();
        return this.getTimestamp(n, null);
    }

    public Timestamp getTimestamp(String string) throws SQLServerException {
        this.checkClosed();
        return this.getTimestamp(this.findColumn(string), null);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLServerException {
        this.checkClosed();
        return (Timestamp)this.getterGetParam(n).getValue(93, calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLServerException {
        this.checkClosed();
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public boolean wasNull() throws SQLServerException {
        this.checkClosed();
        return this.lastGetWasNull;
    }

    public BigDecimal getBigDecimal(int n) throws SQLServerException {
        this.checkClosed();
        return (BigDecimal)this.getterGetParam(n).getValue(3);
    }

    public BigDecimal getBigDecimal(String string) throws SQLServerException {
        this.checkClosed();
        return this.getBigDecimal(this.findColumn(string));
    }

    public Blob getBlob(int n) throws SQLServerException {
        this.checkClosed();
        return (Blob)this.getterGetParam(n).getValue(2004);
    }

    public Blob getBlob(String string) throws SQLServerException {
        this.checkClosed();
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(int n) throws SQLServerException {
        this.checkClosed();
        SQLServerClob sQLServerClob = (SQLServerClob)this.getterGetParam(n).getValue(2005);
        if (null != sQLServerClob) {
            sQLServerClob.setSQLCollation(this.connection.getDbCom().getDatabaseCollation());
        }
        return sQLServerClob;
    }

    public Clob getClob(String string) throws SQLServerException {
        this.checkClosed();
        return this.getClob(this.findColumn(string));
    }

    public Object getObject(int n, Map map) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public Object getObject(String string, Map map) throws SQLServerException {
        this.checkClosed();
        return this.getObject(this.findColumn(string), map);
    }

    public Ref getRef(int n) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public Ref getRef(String string) throws SQLServerException {
        this.checkClosed();
        return this.getRef(this.findColumn(string));
    }

    public Array getArray(int n) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public Array getArray(String string) throws SQLServerException {
        this.checkClosed();
        return this.getArray(this.findColumn(string));
    }

    private int findColumn(String string) throws SQLServerException {
        Object object;
        if (this.paramNames == null) {
            try {
                SQLServerStatement sQLServerStatement = this.connection.createInternalStatement();
                ResultSet resultSet = sQLServerStatement.executeQuery("exec sp_sproc_columns " + this.procedureName + ", @ODBCVer=3");
                this.paramNames = new ArrayList();
                while (resultSet.next()) {
                    String string2 = resultSet.getString(4);
                    this.paramNames.add(string2.trim());
                }
            }
            catch (SQLException sQLException) {
                SQLServerException.makeFromDriverError(this.connection, this, sQLException.toString(), null, false);
            }
        }
        int n = 0;
        if (this.paramNames != null) {
            n = this.paramNames.size();
        }
        int n2 = 0;
        int n3 = -1;
        for (n2 = 0; n2 < n; ++n2) {
            object = (String)this.paramNames.get(n2);
            if (!((String)(object = ((String)object).substring(1, ((String)object).length()))).equals(string)) continue;
            n3 = n2;
            break;
        }
        if (-1 == n3) {
            for (n2 = 0; n2 < n; ++n2) {
                object = (String)this.paramNames.get(n2);
                if (!((String)(object = ((String)object).substring(1, ((String)object).length()))).equalsIgnoreCase(string)) continue;
                n3 = n2;
                break;
            }
        }
        if (-1 == n3) {
            object = new MessageFormat(SQLServerException.getErrString("R_parameterNotDefinedForProcedure"));
            Object[] objectArray = new Object[]{string, this.procedureName};
            SQLServerException.makeFromDriverError(this.connection, this, ((Format)object).format(objectArray), "07009", false);
        }
        if (this.bReturnValueSyntax) {
            return n3 + 1;
        }
        return n3;
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLServerException {
        this.checkClosed();
        this.setTimestamp(this.findColumn(string), timestamp, calendar);
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLServerException {
        this.checkClosed();
        this.setTime(this.findColumn(string), time, calendar);
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLServerException {
        this.checkClosed();
        this.setDate(this.findColumn(string), date, calendar);
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLServerException {
        this.checkClosed();
        this.setCharacterStream(this.findColumn(string), reader, n);
    }

    public void setObject(String string, Object object) throws SQLServerException {
        this.checkClosed();
        this.setObject(this.findColumn(string), object);
    }

    public void setObject(String string, Object object, int n) throws SQLServerException {
        this.checkClosed();
        this.setObject(this.findColumn(string), object, n);
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLServerException {
        this.checkClosed();
        this.setObject(this.findColumn(string), object, n, n2);
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLServerException {
        this.checkClosed();
        this.setBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLServerException {
        this.checkClosed();
        this.setAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLServerException {
        this.checkClosed();
        this.setTimestamp(this.findColumn(string), timestamp);
    }

    public void setDate(String string, Date date) throws SQLServerException {
        this.checkClosed();
        this.setDate(this.findColumn(string), date);
    }

    public void setTime(String string, Time time) throws SQLServerException {
        this.checkClosed();
        this.setTime(this.findColumn(string), time);
    }

    public void setBytes(String string, byte[] byArray) throws SQLServerException {
        this.checkClosed();
        this.setBytes(this.findColumn(string), byArray);
    }

    public void setByte(String string, byte by) throws SQLServerException {
        this.checkClosed();
        this.setByte(this.findColumn(string), by);
    }

    public void setString(String string, String string2) throws SQLServerException {
        this.checkClosed();
        this.setString(this.findColumn(string), string2);
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLServerException {
        this.checkClosed();
        this.setBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void setDouble(String string, double d) throws SQLServerException {
        this.checkClosed();
        this.setDouble(this.findColumn(string), d);
    }

    public void setFloat(String string, float f) throws SQLServerException {
        this.checkClosed();
        this.setFloat(this.findColumn(string), f);
    }

    public void setInt(String string, int n) throws SQLServerException {
        this.checkClosed();
        this.setInt(this.findColumn(string), n);
    }

    public void setLong(String string, long l) throws SQLServerException {
        this.checkClosed();
        this.setLong(this.findColumn(string), l);
    }

    public void setShort(String string, short s) throws SQLServerException {
        this.checkClosed();
        this.setShort(this.findColumn(string), s);
    }

    public void setBoolean(String string, boolean bl) throws SQLServerException {
        this.checkClosed();
        this.setBoolean(this.findColumn(string), bl);
    }

    public void setNull(String string, int n) throws SQLServerException {
        this.checkClosed();
        this.setNull(this.findColumn(string), n);
    }

    public void setNull(String string, int n, String string2) throws SQLServerException {
        this.checkClosed();
        this.setNull(this.findColumn(string), n);
    }

    public void setURL(String string, URL uRL) throws SQLServerException {
        this.checkClosed();
        this.setURL(this.findColumn(string), uRL);
    }

    public URL getURL(int n) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public URL getURL(String string) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLServerException {
        this.checkClosed();
        this.registerOutParameter(this.findColumn(string), n, string2);
    }

    public void registerOutParameter(String string, int n, int n2) throws SQLServerException {
        this.checkClosed();
        this.registerOutParameter(this.findColumn(string), n, n2);
    }

    public void registerOutParameter(String string, int n) throws SQLServerException {
        this.registerOutParameter(this.findColumn(string), n);
    }

    private void trackAccess() {
        ++this.accessCounter;
    }

    int getAccessCounter() {
        return this.accessCounter;
    }
}

