/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ResultSetCursor;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.ServerFetchBuffer;

final class ScrollableDynamicServerCursor
extends ResultSetCursor {
    private SQLServerStatement stmt;
    private ServerFetchBuffer fetchBuffer;
    private boolean isOnValidRow = false;

    ScrollableDynamicServerCursor(SQLServerResultSet sQLServerResultSet) {
        this.fetchBuffer = new ServerFetchBuffer(sQLServerResultSet);
        this.stmt = sQLServerResultSet.stmt;
    }

    void close() throws SQLServerException {
        this.fetchBuffer.close();
    }

    final boolean isOnValidRow() {
        return this.isOnValidRow;
    }

    final void getterRefreshCurrentRow() throws SQLServerException {
        this.fetchBuffer.getterRefreshCurrentRow();
    }

    final void beforeFirst() throws SQLServerException {
        this.fetchBuffer.beforeFirst();
    }

    final boolean isBeforeFirst() throws SQLServerException {
        SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_unsupportedCursorOperation"), null, true);
        return false;
    }

    final boolean first() throws SQLServerException {
        this.isOnValidRow = this.fetchBuffer.first();
        return this.isOnValidRow;
    }

    final boolean isFirst() throws SQLServerException {
        SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_unsupportedCursorOperation"), null, true);
        return false;
    }

    final void afterLast() throws SQLServerException {
        this.fetchBuffer.afterLast();
    }

    final boolean isAfterLast() throws SQLServerException {
        SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_unsupportedCursorOperation"), null, true);
        return false;
    }

    final boolean last() throws SQLServerException {
        this.isOnValidRow = this.fetchBuffer.last();
        return this.isOnValidRow;
    }

    final boolean isLast() throws SQLServerException {
        SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_unsupportedCursorOperation"), null, true);
        return false;
    }

    final int getRow() throws SQLServerException {
        SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_unsupportedCursorOperation"), null, true);
        return 0;
    }

    final boolean next() throws SQLServerException {
        return this.relative(1);
    }

    final boolean previous() throws SQLServerException {
        return this.relative(-1);
    }

    final boolean relative(int n) throws SQLServerException {
        if (0 == n) {
            return this.isOnValidRow;
        }
        this.isOnValidRow = this.fetchBuffer.relative(n);
        return this.isOnValidRow;
    }

    final boolean absolute(int n) throws SQLServerException {
        SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_unsupportedCursorOperation"), null, true);
        return false;
    }

    final void refreshRow() throws SQLServerException {
        this.fetchBuffer.refresh();
    }

    final boolean rowDeleted() throws SQLServerException {
        return this.fetchBuffer.rowDeleted();
    }

    final void insertRow() throws SQLServerException {
        this.fetchBuffer.insertRow();
    }

    final void updateRow() throws SQLServerException {
        this.fetchBuffer.updateRow();
    }

    final void deleteRow() throws SQLServerException {
        this.fetchBuffer.deleteRow();
    }
}

