/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.image.BufferedImage;
import sun.java2d.SurfaceData;
import sun.java2d.SurfaceManagerFactory;
import sun.java2d.loops.CompositeType;

public abstract class SurfaceManager {
    private static ImageAccessor imgaccessor;

    public static void setImageAccessor(ImageAccessor imageAccessor) {
        if (imgaccessor != null) {
            throw new InternalError("Attempt to set ImageAccessor twice");
        }
        imgaccessor = imageAccessor;
    }

    public static SurfaceManager getManager(Image image) {
        SurfaceManager surfaceManager = imgaccessor.getSurfaceManager(image);
        if (surfaceManager == null) {
            try {
                BufferedImage bufferedImage = (BufferedImage)image;
                surfaceManager = SurfaceManagerFactory.createCachingManager(bufferedImage);
                SurfaceManager.setManager(bufferedImage, surfaceManager);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("Invalid Image variant");
            }
        }
        return surfaceManager;
    }

    public static void setManager(Image image, SurfaceManager surfaceManager) {
        imgaccessor.setSurfaceManager(image, surfaceManager);
    }

    public abstract SurfaceData getSourceSurfaceData(SurfaceData var1, CompositeType var2, Color var3, boolean var4);

    public abstract SurfaceData getDestSurfaceData();

    public abstract SurfaceData restoreContents();

    public void acceleratedSurfaceLost() {
    }

    public ImageCapabilities getCapabilities(GraphicsConfiguration graphicsConfiguration) {
        return new ImageCapabilities(false);
    }

    public void flush() {
    }

    public void setAccelerationPriority(float f) {
    }

    public static abstract class ImageAccessor {
        public abstract SurfaceManager getSurfaceManager(Image var1);

        public abstract void setSurfaceManager(Image var1, SurfaceManager var2);
    }
}

