/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.OracleStatementWrapper;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

class OracleResultSetMetaData
implements oracle.jdbc.internal.OracleResultSetMetaData {
    PhysicalConnection connection;
    OracleStatement statement;
    int m_beginColumnIndex;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Feb_23_16:38:22_PST_2010";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    public OracleResultSetMetaData() {
    }

    public OracleResultSetMetaData(PhysicalConnection physicalConnection, OracleStatement oracleStatement) throws SQLException {
        this.connection = physicalConnection;
        this.statement = oracleStatement;
        oracleStatement.describe();
        this.m_beginColumnIndex = 0;
    }

    OracleResultSetMetaData(PhysicalConnection physicalConnection, OracleStatement oracleStatement, int n2) throws SQLException {
        this.connection = physicalConnection;
        this.statement = oracleStatement;
        oracleStatement.describe();
        this.m_beginColumnIndex = n2;
    }

    public OracleResultSetMetaData(OracleResultSet oracleResultSet) throws SQLException {
        this.statement = (OracleStatement)((OracleStatementWrapper)oracleResultSet.getStatement()).statement;
        this.connection = (PhysicalConnection)this.statement.getConnection();
        this.statement.describe();
        this.m_beginColumnIndex = oracleResultSet.getFirstUserColumnIndex();
    }

    public int getColumnCount() throws SQLException {
        return this.statement.getNumberOfColumns() - this.m_beginColumnIndex;
    }

    public boolean isAutoIncrement(int n2) throws SQLException {
        return false;
    }

    int getValidColumnIndex(int n2) throws SQLException {
        int n3 = n2 + this.m_beginColumnIndex - 1;
        if (n3 < 0 || n3 >= this.statement.getNumberOfColumns()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getValidColumnIndex");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return n3;
    }

    public boolean isCaseSensitive(int n2) throws SQLException {
        int n3 = this.getColumnType(n2);
        return n3 == 1 || n3 == 12 || n3 == -1;
    }

    public boolean isSearchable(int n2) throws SQLException {
        int n3 = this.getColumnType(n2);
        return n3 != -4 && n3 != -1 && n3 != 2004 && n3 != 2005 && n3 != -13 && n3 != 2002 && n3 != 2008 && n3 != 2007 && n3 != 2003 && n3 != 2006 && n3 != -10;
    }

    public boolean isCurrency(int n2) throws SQLException {
        int n3 = this.getColumnType(n2);
        return n3 == 2 || n3 == 6;
    }

    public int isNullable(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        return this.getDescription()[n3].nullable ? 1 : 0;
    }

    public boolean isSigned(int n2) throws SQLException {
        return true;
    }

    public int getColumnDisplaySize(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        return this.getDescription()[n3].describeMaxLength;
    }

    public String getColumnLabel(int n2) throws SQLException {
        return this.getColumnName(n2);
    }

    public String getColumnName(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        return this.statement.getDescriptionWithNames()[n3].columnName;
    }

    public String getSchemaName(int n2) throws SQLException {
        return "";
    }

    public int getPrecision(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        int n4 = this.getDescription()[n3].describeType;
        switch (n4) {
            case 112: 
            case 113: {
                return -1;
            }
            case 8: 
            case 24: {
                return Integer.MAX_VALUE;
            }
            case 1: 
            case 96: {
                return this.getDescription()[n3].describeMaxLength;
            }
        }
        return this.getDescription()[n3].precision;
    }

    public OracleResultSetMetaData.SecurityAttribute getSecurityAttribute(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        return this.getDescription()[n3].securityAttribute;
    }

    public int getScale(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        int n4 = this.getDescription()[n3].scale;
        return n4 == -127 && this.statement.connection.j2ee13Compliant ? 0 : n4;
    }

    public String getTableName(int n2) throws SQLException {
        return "";
    }

    public String getCatalogName(int n2) throws SQLException {
        return "";
    }

    public int getColumnType(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        int n4 = this.getDescription()[n3].describeType;
        switch (n4) {
            case 96: {
                return 1;
            }
            case 1: {
                return 12;
            }
            case 8: {
                return -1;
            }
            case 2: 
            case 6: {
                if (this.statement.connection.j2ee13Compliant && this.getDescription()[n3].precision != 0 && this.getDescription()[n3].scale == -127) {
                    return 6;
                }
                return 2;
            }
            case 100: {
                return 100;
            }
            case 101: {
                return 101;
            }
            case 23: {
                return -3;
            }
            case 24: {
                return -4;
            }
            case 104: {
                return -8;
            }
            case 102: {
                return -10;
            }
            case 12: {
                return this.connection.mapDateToTimestamp ? 93 : 91;
            }
            case 180: {
                return 93;
            }
            case 181: {
                return -101;
            }
            case 231: {
                return -102;
            }
            case 113: {
                return 2004;
            }
            case 112: {
                return 2005;
            }
            case 114: {
                return -13;
            }
            case 109: {
                OracleNamedType oracleNamedType = (OracleNamedType)this.getDescription()[n3].describeOtype;
                TypeDescriptor typeDescriptor = TypeDescriptor.getTypeDescriptor(oracleNamedType.getFullName(), this.connection);
                if (typeDescriptor != null) {
                    return typeDescriptor.getTypeCode();
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            case 111: {
                return 2006;
            }
            case 182: {
                return -103;
            }
            case 183: {
                return -104;
            }
        }
        return 1111;
    }

    public String getColumnTypeName(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        int n4 = this.getDescription()[n3].describeType;
        switch (n4) {
            case 96: {
                return "CHAR";
            }
            case 1: {
                return "VARCHAR2";
            }
            case 8: {
                return "LONG";
            }
            case 2: 
            case 6: {
                if (this.statement.connection.j2ee13Compliant && this.getDescription()[n3].precision != 0 && this.getDescription()[n3].scale == -127) {
                    return "FLOAT";
                }
                return "NUMBER";
            }
            case 100: {
                return "BINARY_FLOAT";
            }
            case 101: {
                return "BINARY_DOUBLE";
            }
            case 23: {
                return "RAW";
            }
            case 24: {
                return "LONG RAW";
            }
            case 104: {
                return "ROWID";
            }
            case 102: {
                return "REFCURSOR";
            }
            case 12: {
                return "DATE";
            }
            case 180: {
                return "TIMESTAMP";
            }
            case 181: {
                return "TIMESTAMP WITH TIME ZONE";
            }
            case 231: {
                return "TIMESTAMP WITH LOCAL TIME ZONE";
            }
            case 113: {
                return "BLOB";
            }
            case 112: {
                return "CLOB";
            }
            case 114: {
                return "BFILE";
            }
            case 109: {
                OracleTypeADT oracleTypeADT = (OracleTypeADT)this.getDescription()[n3].describeOtype;
                return oracleTypeADT.getFullName();
            }
            case 111: {
                OracleTypeADT oracleTypeADT = (OracleTypeADT)this.getDescription()[n3].describeOtype;
                return oracleTypeADT.getFullName();
            }
            case 182: {
                return "INTERVALYM";
            }
            case 183: {
                return "INTERVALDS";
            }
        }
        return null;
    }

    public boolean isReadOnly(int n2) throws SQLException {
        return false;
    }

    public boolean isWritable(int n2) throws SQLException {
        return true;
    }

    public boolean isDefinitelyWritable(int n2) throws SQLException {
        return false;
    }

    public String getColumnClassName(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        int n4 = this.getDescription()[n3].describeType;
        switch (n4) {
            case 1: 
            case 8: 
            case 96: 
            case 999: {
                return "java.lang.String";
            }
            case 2: 
            case 6: {
                if (this.getDescription()[n3].precision != 0 && this.getDescription()[n3].scale == -127) {
                    return "java.lang.Double";
                }
                return "java.math.BigDecimal";
            }
            case 23: 
            case 24: {
                return "byte[]";
            }
            case 12: {
                return "java.sql.Timestamp";
            }
            case 180: {
                if (this.statement.connection.j2ee13Compliant) {
                    return "java.sql.Timestamp";
                }
                return "oracle.sql.TIMESTAMP";
            }
            case 181: {
                return "oracle.sql.TIMESTAMPTZ";
            }
            case 231: {
                return "oracle.sql.TIMESTAMPLTZ";
            }
            case 182: {
                return "oracle.sql.INTERVALYM";
            }
            case 183: {
                return "oracle.sql.INTERVALDS";
            }
            case 104: {
                return "oracle.sql.ROWID";
            }
            case 113: {
                return "oracle.sql.BLOB";
            }
            case 112: {
                return "oracle.sql.CLOB";
            }
            case 114: {
                return "oracle.sql.BFILE";
            }
            case 102: {
                return "OracleResultSet";
            }
            case 109: {
                switch (this.getColumnType(n2)) {
                    case 2003: {
                        return "oracle.sql.ARRAY";
                    }
                    case 2007: {
                        return "oracle.sql.OPAQUE";
                    }
                    case 2008: {
                        Class clazz;
                        OracleNamedType oracleNamedType = (OracleNamedType)this.getDescription()[n3].describeOtype;
                        Map map = this.connection.getJavaObjectTypeMap();
                        if (map != null && (clazz = (Class)map.get(oracleNamedType.getFullName())) != null) {
                            return clazz.getName();
                        }
                        return StructDescriptor.getJavaObjectClassName(this.connection, oracleNamedType.getSchemaName(), oracleNamedType.getSimpleName());
                    }
                    case 2002: {
                        Class clazz;
                        Map map = this.connection.getTypeMap();
                        if (map != null && (clazz = (Class)map.get(((OracleNamedType)this.getDescription()[n3].describeOtype).getFullName())) != null) {
                            return clazz.getName();
                        }
                        return "oracle.sql.STRUCT";
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            case 111: {
                return "oracle.sql.REF";
            }
        }
        return null;
    }

    public boolean isNCHAR(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        return this.getDescription()[n3].formOfUse == 2;
    }

    Accessor[] getDescription() throws SQLException {
        return this.statement.getDescription();
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }
}

