/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.ShortBuffer;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.BfileAccessor;
import oracle.jdbc.driver.BinaryDoubleAccessor;
import oracle.jdbc.driver.BinaryFloatAccessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.BlobAccessor;
import oracle.jdbc.driver.CharAccessor;
import oracle.jdbc.driver.ClobAccessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateAccessor;
import oracle.jdbc.driver.IntervaldsAccessor;
import oracle.jdbc.driver.IntervalymAccessor;
import oracle.jdbc.driver.LongAccessor;
import oracle.jdbc.driver.LongRawAccessor;
import oracle.jdbc.driver.NamedTypeAccessor;
import oracle.jdbc.driver.NumberAccessor;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.RawAccessor;
import oracle.jdbc.driver.RefTypeAccessor;
import oracle.jdbc.driver.RowidAccessor;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T2CResultSetAccessor;
import oracle.jdbc.driver.T2CStatement;
import oracle.jdbc.driver.TimestampAccessor;
import oracle.jdbc.driver.TimestampltzAccessor;
import oracle.jdbc.driver.TimestamptzAccessor;
import oracle.jdbc.driver.VarcharAccessor;
import oracle.jdbc.oracore.OracleTypeADT;

class T2CCallableStatement
extends OracleCallableStatement {
    T2CConnection connection = null;
    int userResultSetType = -1;
    int userResultSetConcur = -1;
    static int T2C_EXTEND_BUFFER = -3;
    long[] t2cOutput = new long[10];
    static final int T2C_OUTPUT_USE_NIO = 5;
    static final int T2C_OUTPUT_STMT_LOB_PREFETCH_SIZE = 6;
    int extractedCharOffset;
    int extractedByteOffset;
    static final byte T2C_LOB_PREFETCH_SIZE_THIS_COLUMN_OFFSET = 0;
    static final byte T2C_LOB_PREFETCH_LOB_LENGTH_OFFSET = 1;
    static final byte T2C_LOB_PREFETCH_FORM_OFFSET = 2;
    static final byte T2C_LOB_PREFETCH_CHUNK_OFFSET = 3;
    static final byte T2C_LOB_PREFETCH_DATA_OFFSET = 4;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Feb_23_16:38:22_PST_2010";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    T2CCallableStatement(T2CConnection t2CConnection, String string, int n2, int n3, int n4, int n5) throws SQLException {
        super(t2CConnection, string, n2, n3, n4, n5);
        this.userResultSetType = n4;
        this.userResultSetConcur = n5;
        this.connection = t2CConnection;
    }

    String bytes2String(byte[] byArray, int n2, int n3) throws SQLException {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return this.connection.conversion.CharBytesToString(byArray2, n3);
    }

    void processDescribeData() throws SQLException {
        this.described = true;
        this.describedWithNames = true;
        if (this.accessors == null || this.numberOfDefinePositions > this.accessors.length) {
            this.accessors = new Accessor[this.numberOfDefinePositions];
        }
        int n2 = this.connection.queryMetaData1Offset;
        int n3 = this.connection.queryMetaData2Offset;
        short[] sArray = this.connection.queryMetaData1;
        byte[] byArray = this.connection.queryMetaData2;
        int n4 = 0;
        while (n4 < this.numberOfDefinePositions) {
            Accessor accessor;
            short s2 = sArray[n2 + 0];
            short s3 = sArray[n2 + 1];
            short s4 = sArray[n2 + 11];
            boolean bl = sArray[n2 + 2] != 0;
            short s5 = sArray[n2 + 3];
            short s6 = sArray[n2 + 4];
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            short s7 = sArray[n2 + 5];
            short s8 = sArray[n2 + 6];
            String string = this.bytes2String(byArray, n3, s8);
            short s9 = sArray[n2 + 12];
            String string2 = null;
            OracleTypeADT oracleTypeADT = null;
            n3 += s8;
            if (s9 > 0) {
                string2 = this.bytes2String(byArray, n3, s9);
                n3 += s9;
                oracleTypeADT = new OracleTypeADT(string2, (Connection)this.connection);
                oracleTypeADT.tdoCState = ((long)sArray[n2 + 7] & 0xFFFFL) << 48 | ((long)sArray[n2 + 8] & 0xFFFFL) << 32 | ((long)sArray[n2 + 9] & 0xFFFFL) << 16 | (long)sArray[n2 + 10] & 0xFFFFL;
            }
            if ((accessor = this.accessors[n4]) != null && !accessor.useForDescribeIfPossible(s2, s3, bl, n5, s5, s6, n6, n7, s7, string2)) {
                accessor = null;
            }
            if (accessor == null) {
                switch (s2) {
                    case 1: {
                        accessor = new VarcharAccessor(this, s3, bl, n5, s5, s6, n6, n7, s7);
                        if (s4 <= 0) break;
                        accessor.setDisplaySize(s4);
                        break;
                    }
                    case 96: {
                        accessor = new CharAccessor(this, s3, bl, n5, s5, s6, n6, n7, s7);
                        if (s4 <= 0) break;
                        accessor.setDisplaySize(s4);
                        break;
                    }
                    case 2: {
                        accessor = new NumberAccessor(this, s3, bl, n5, s5, s6, n6, n7, s7);
                        break;
                    }
                    case 23: {
                        accessor = new RawAccessor(this, s3, bl, n5, s5, s6, n6, n7, s7);
                        break;
                    }
                    case 100: {
                        accessor = new BinaryFloatAccessor(this, s3, bl, n5, s5, s6, n6, n7, s7);
                        break;
                    }
                    case 101: {
                        accessor = new BinaryDoubleAccessor(this, s3, bl, n5, s5, s6, n6, n7, s7);
                        break;
                    }
                    case 8: {
                        accessor = new LongAccessor(this, n4 + 1, s3, bl, n5, s5, s6, n6, n7, s7);
                        this.rowPrefetch = 1;
                        break;
                    }
                    case 24: {
                        accessor = new LongRawAccessor(this, n4 + 1, s3, bl, n5, s5, s6, n6, n7, s7);
                        this.rowPrefetch = 1;
                        break;
                    }
                    case 104: {
                        accessor = new RowidAccessor(this, s3, bl, n5, s5, s6, n6, n7, s7);
                        break;
                    }
                    case 102: 
                    case 116: {
                        accessor = new T2CResultSetAccessor(this, s3, bl, n5, s5, s6, n6, n7, s7);
                        break;
                    }
                    case 12: {
                        accessor = new DateAccessor(this, s3, bl, n5, s5, s6, n6, n7, s7);
                        break;
                    }
                    case 180: {
                        accessor = new TimestampAccessor(this, s3, bl, n5, s5, s6, n6, n7, s7);
                        break;
                    }
                    case 181: {
                        accessor = new TimestamptzAccessor(this, s3, bl, n5, s5, s6, n6, n7, s7);
                        break;
                    }
                    case 231: {
                        accessor = new TimestampltzAccessor(this, s3, bl, n5, s5, s6, n6, n7, s7);
                        break;
                    }
                    case 182: {
                        accessor = new IntervalymAccessor(this, s3, bl, n5, s5, s6, n6, n7, s7);
                        break;
                    }
                    case 183: {
                        accessor = new IntervaldsAccessor(this, s3, bl, n5, s5, s6, n6, n7, s7);
                        break;
                    }
                    case 112: {
                        accessor = new ClobAccessor(this, s3, bl, n5, s5, s6, n6, n7, s7);
                        break;
                    }
                    case 113: {
                        accessor = new BlobAccessor(this, s3, bl, n5, s5, s6, n6, n7, s7);
                        break;
                    }
                    case 114: {
                        accessor = new BfileAccessor(this, s3, bl, n5, s5, s6, n6, n7, s7);
                        break;
                    }
                    case 109: {
                        accessor = new NamedTypeAccessor(this, s3, bl, n5, s5, s6, n6, n7, s7, string2, oracleTypeADT);
                        break;
                    }
                    case 111: {
                        accessor = new RefTypeAccessor(this, s3, bl, n5, s5, s6, n6, n7, s7, string2, oracleTypeADT);
                        break;
                    }
                    default: {
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unknown or unimplemented accessor type: " + s2);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                }
                this.accessors[n4] = accessor;
            } else if (oracleTypeADT != null) {
                accessor.initMetadata();
            }
            accessor.columnName = string;
            ++n4;
            n2 += 13;
        }
    }

    void executeForDescribe() throws SQLException {
        boolean bl;
        this.t2cOutput[0] = 0L;
        this.t2cOutput[2] = 0L;
        this.lobPrefetchMetaData = null;
        boolean bl2 = !this.described;
        boolean bl3 = false;
        do {
            bl = false;
            if (this.connection.endToEndAnyChanged) {
                this.pushEndToEndValues();
                this.connection.endToEndAnyChanged = false;
            }
            byte[] byArray = this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals);
            int n2 = T2CStatement.t2cParseExecuteDescribe(this, this.c_state, this.numberOfBindPositions, this.numberOfBindRowsAllocated, this.firstRowInBatch, this.currentRowBindAccessors != null, this.needToParse, bl2, bl3, byArray, byArray.length, this.sqlKind, this.rowPrefetch, this.batch, this.bindIndicators, this.bindIndicatorOffset, this.bindBytes, this.bindChars, this.bindByteOffset, this.bindCharOffset, this.ibtBindIndicators, this.ibtBindIndicatorOffset, this.ibtBindIndicatorSize, this.ibtBindBytes, this.ibtBindChars, this.ibtBindByteOffset, this.ibtBindCharOffset, this.returnParamMeta, this.connection.queryMetaData1, this.connection.queryMetaData2, this.connection.queryMetaData1Offset, this.connection.queryMetaData2Offset, this.connection.queryMetaData1Size, this.connection.queryMetaData2Size, this.preparedAllBinds, this.preparedCharBinds, this.outBindAccessors, this.parameterDatum, this.t2cOutput, this.defineBytes, this.accessorByteOffset, this.defineChars, this.accessorCharOffset, this.defineIndicators, this.accessorShortOffset, this.connection.plsqlCompilerWarnings);
            this.validRows = (int)this.t2cOutput[1];
            if (n2 == -1 || n2 == -4) {
                this.connection.checkError(n2);
            } else if (n2 == T2C_EXTEND_BUFFER) {
                n2 = this.connection.queryMetaData1Size * 2;
            }
            if (this.t2cOutput[3] != 0L) {
                this.foundPlsqlCompilerWarning();
            } else if (this.t2cOutput[2] != 0L) {
                this.sqlWarning = this.connection.checkError(1, this.sqlWarning);
            }
            this.connection.endToEndECIDSequenceNumber = (short)this.t2cOutput[4];
            this.needToParse = false;
            bl3 = true;
            if (this.sqlKind == 0) {
                this.numberOfDefinePositions = n2;
                if (this.numberOfDefinePositions <= this.connection.queryMetaData1Size) continue;
                bl = true;
                bl3 = true;
                this.connection.reallocateQueryMetaData(this.numberOfDefinePositions, this.numberOfDefinePositions * 8);
                continue;
            }
            this.numberOfDefinePositions = 0;
            this.validRows = n2;
        } while (bl);
        this.processDescribeData();
    }

    void pushEndToEndValues() throws SQLException {
        T2CConnection t2CConnection = this.connection;
        byte[] byArray = new byte[]{};
        byte[] byArray2 = new byte[]{};
        byte[] byArray3 = new byte[]{};
        byte[] byArray4 = new byte[]{};
        if (t2CConnection.endToEndValues != null) {
            String string;
            if (t2CConnection.endToEndHasChanged[0]) {
                string = t2CConnection.endToEndValues[0];
                if (string != null) {
                    byArray = DBConversion.stringToDriverCharBytes(string, t2CConnection.m_clientCharacterSet);
                }
                t2CConnection.endToEndHasChanged[0] = false;
            }
            if (t2CConnection.endToEndHasChanged[1]) {
                string = t2CConnection.endToEndValues[1];
                if (string != null) {
                    byArray2 = DBConversion.stringToDriverCharBytes(string, t2CConnection.m_clientCharacterSet);
                }
                t2CConnection.endToEndHasChanged[1] = false;
            }
            if (t2CConnection.endToEndHasChanged[2]) {
                string = t2CConnection.endToEndValues[2];
                if (string != null) {
                    byArray3 = DBConversion.stringToDriverCharBytes(string, t2CConnection.m_clientCharacterSet);
                }
                t2CConnection.endToEndHasChanged[2] = false;
            }
            if (t2CConnection.endToEndHasChanged[3]) {
                string = t2CConnection.endToEndValues[3];
                if (string != null) {
                    byArray4 = DBConversion.stringToDriverCharBytes(string, t2CConnection.m_clientCharacterSet);
                }
                t2CConnection.endToEndHasChanged[3] = false;
            }
            T2CStatement.t2cEndToEndUpdate(this.c_state, byArray, byArray.length, byArray2, byArray2.length, byArray3, byArray3.length, byArray4, byArray4.length, t2CConnection.endToEndECIDSequenceNumber);
        }
    }

    void executeForRows(boolean bl) throws SQLException {
        if (this.connection.endToEndAnyChanged) {
            this.pushEndToEndValues();
            this.connection.endToEndAnyChanged = false;
        }
        if (!bl) {
            if (this.numberOfDefinePositions > 0) {
                this.doDefineExecuteFetch();
            } else {
                this.executeForDescribe();
            }
        } else if (this.numberOfDefinePositions > 0) {
            this.doDefineFetch();
        }
        this.needToPrepareDefineBuffer = false;
    }

    void setupForDefine() throws SQLException {
        if (this.numberOfDefinePositions > this.connection.queryMetaData1Size) {
            int n2 = this.numberOfDefinePositions / 100 + 1;
            this.connection.reallocateQueryMetaData(this.connection.queryMetaData1Size * n2, this.connection.queryMetaData2Size * n2 * 8);
        }
        short[] sArray = this.connection.queryMetaData1;
        int n3 = this.connection.queryMetaData1Offset;
        int n4 = 0;
        while (n4 < this.numberOfDefinePositions) {
            Accessor accessor = this.accessors[n4];
            if (accessor == null) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            sArray[n3 + 0] = (short)accessor.defineType;
            sArray[n3 + 11] = (short)accessor.charLength;
            sArray[n3 + 1] = (short)accessor.byteLength;
            sArray[n3 + 5] = accessor.formOfUse;
            if (accessor.internalOtype != null) {
                long l2 = ((OracleTypeADT)accessor.internalOtype).getTdoCState();
                sArray[n3 + 7] = (short)((l2 & 0xFFFF000000000000L) >> 48);
                sArray[n3 + 8] = (short)((l2 & 0xFFFF00000000L) >> 32);
                sArray[n3 + 9] = (short)((l2 & 0xFFFF0000L) >> 16);
                sArray[n3 + 10] = (short)(l2 & 0xFFFFL);
            }
            switch (accessor.internalType) {
                case 112: 
                case 113: {
                    if (accessor.lobPrefetchSizeForThisColumn == -1) {
                        accessor.lobPrefetchSizeForThisColumn = this.defaultLobPrefetchSize;
                    }
                    sArray[n3 + 7] = (short)accessor.lobPrefetchSizeForThisColumn;
                }
            }
            ++n4;
            n3 += 13;
        }
    }

    Object[] getLobPrefetchMetaData() {
        int n2;
        Object[] objectArray = null;
        Object var2_2 = null;
        int[] nArray = null;
        int n3 = 0;
        int n4 = 0;
        if (this.accessors != null) {
            block7: for (n2 = 0; n2 < this.numberOfDefinePositions; ++n2) {
                switch (this.accessors[n2].internalType) {
                    case 8: 
                    case 24: {
                        n4 = n2;
                        continue block7;
                    }
                    case 112: 
                    case 113: {
                        if (this.accessors[n2].lobPrefetchSizeForThisColumn == -1) continue block7;
                        ++n3;
                        if (nArray == null) {
                            nArray = new int[this.accessors.length];
                        }
                        nArray[n2] = this.accessors[n2].lobPrefetchSizeForThisColumn;
                    }
                }
            }
        }
        if (n3 > 0) {
            if (objectArray == null) {
                objectArray = new Object[]{null, new long[this.rowPrefetch * n3], new byte[this.accessors.length], new int[this.accessors.length], new Object[this.rowPrefetch * n3]};
            }
            for (n2 = 0; n2 < n4; ++n2) {
                switch (this.accessors[n2].internalType) {
                    case 112: 
                    case 113: {
                        this.accessors[n2].lobPrefetchSizeForThisColumn = -1;
                        nArray[n2] = -1;
                    }
                }
            }
            objectArray[0] = nArray;
        }
        return objectArray;
    }

    void processLobPrefetchMetaData(Object[] objectArray) {
        int n2 = 0;
        int n3 = this.validRows == -2 ? 1 : this.validRows;
        byte[] byArray = (byte[])objectArray[2];
        int[] nArray = (int[])objectArray[3];
        long[] lArray = (long[])objectArray[1];
        Object[] objectArray2 = (Object[])objectArray[4];
        int[] nArray2 = (int[])objectArray[0];
        if (this.accessors != null) {
            block3: for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
                switch (this.accessors[i2].internalType) {
                    case 112: 
                    case 113: {
                        if (this.accessors[i2].lobPrefetchSizeForThisColumn < 0) continue block3;
                        Accessor accessor = this.accessors[i2];
                        if (accessor.prefetchedLobDataL == null || accessor.prefetchedLobDataL.length < this.rowPrefetch) {
                            if (accessor.internalType == 112) {
                                accessor.prefetchedLobCharData = new char[this.rowPrefetch][];
                            } else {
                                accessor.prefetchedLobData = new byte[this.rowPrefetch][];
                            }
                            accessor.prefetchedLobChunkSize = new int[this.rowPrefetch];
                            accessor.prefetchedClobFormOfUse = new byte[this.rowPrefetch];
                            accessor.prefetchedLobDataL = new int[this.rowPrefetch];
                            accessor.prefetchedLobSize = new long[this.rowPrefetch];
                        }
                        int n4 = n3 * n2;
                        for (int i3 = 0; i3 < n3; ++i3) {
                            accessor.prefetchedLobChunkSize[i3] = nArray[i2];
                            accessor.prefetchedClobFormOfUse[i3] = byArray[i2];
                            accessor.prefetchedLobSize[i3] = lArray[n4 + i3];
                            accessor.prefetchedLobDataL[i3] = 0;
                            if (nArray2[i2] <= 0 || lArray[n4 + i3] <= 0L) continue;
                            if (accessor.internalType == 112) {
                                accessor.prefetchedLobCharData[i3] = (char[])objectArray2[n4 + i3];
                                if (accessor.prefetchedLobCharData[i3] == null) continue;
                                accessor.prefetchedLobDataL[i3] = accessor.prefetchedLobCharData[i3].length;
                                continue;
                            }
                            accessor.prefetchedLobData[i3] = (byte[])objectArray2[n4 + i3];
                            if (accessor.prefetchedLobData[i3] == null) continue;
                            accessor.prefetchedLobDataL[i3] = accessor.prefetchedLobData[i3].length;
                        }
                        ++n2;
                        continue block3;
                    }
                }
            }
        }
    }

    void doDefineFetch() throws SQLException {
        if (!this.needToPrepareDefineBuffer) {
            throw new Error("doDefineFetch called when needToPrepareDefineBuffer=false " + this.sqlObject.getSql(this.processEscapes, this.convertNcharLiterals));
        }
        this.setupForDefine();
        this.t2cOutput[2] = 0L;
        this.t2cOutput[5] = this.connection.useNio ? 1 : 0;
        this.t2cOutput[6] = this.defaultLobPrefetchSize;
        if (this.connection.useNio) {
            this.resetNioAttributesBeforeFetch();
            this.allocateNioBuffersIfRequired(this.defineChars == null ? 0 : this.defineChars.length, this.defineBytes == null ? 0 : this.defineBytes.length, this.defineIndicators == null ? 0 : this.defineIndicators.length);
        }
        if (this.lobPrefetchMetaData == null) {
            this.lobPrefetchMetaData = this.getLobPrefetchMetaData();
        }
        this.validRows = T2CStatement.t2cDefineFetch(this, this.c_state, this.rowPrefetch, this.connection.queryMetaData1, this.connection.queryMetaData2, this.connection.queryMetaData1Offset, this.connection.queryMetaData2Offset, this.accessors, this.defineBytes, this.accessorByteOffset, this.defineChars, this.accessorCharOffset, this.defineIndicators, this.accessorShortOffset, this.t2cOutput, this.nioBuffers, this.lobPrefetchMetaData);
        if (this.validRows == -1 || this.validRows == -4) {
            this.connection.checkError(this.validRows);
        }
        if (this.t2cOutput[2] != 0L) {
            this.sqlWarning = this.connection.checkError(1, this.sqlWarning);
        }
        if (this.connection.useNio && (this.validRows > 0 || this.validRows == -2)) {
            this.extractNioDefineBuffers(0);
        }
        if (this.lobPrefetchMetaData != null) {
            this.processLobPrefetchMetaData(this.lobPrefetchMetaData);
        }
    }

    void allocateNioBuffersIfRequired(int n2, int n3, int n4) throws SQLException {
        if (this.nioBuffers == null) {
            this.nioBuffers = new ByteBuffer[4];
        }
        if (n3 > 0) {
            if (this.nioBuffers[0] == null || this.nioBuffers[0].capacity() < n3) {
                this.nioBuffers[0] = ByteBuffer.allocateDirect(n3);
            } else if (this.nioBuffers[0] != null) {
                this.nioBuffers[0].rewind();
            }
        }
        if ((n2 *= 2) > 0) {
            if (this.nioBuffers[1] == null || this.nioBuffers[1].capacity() < n2) {
                this.nioBuffers[1] = ByteBuffer.allocateDirect(n2);
            } else if (this.nioBuffers[1] != null) {
                this.nioBuffers[1].rewind();
            }
        }
        if ((n4 *= 2) > 0) {
            if (this.nioBuffers[2] == null || this.nioBuffers[2].capacity() < n4) {
                this.nioBuffers[2] = ByteBuffer.allocateDirect(n4);
            } else if (this.nioBuffers[2] != null) {
                this.nioBuffers[2].rewind();
            }
        }
    }

    void doDefineExecuteFetch() throws SQLException {
        short[] sArray = null;
        if (this.needToPrepareDefineBuffer || this.needToParse) {
            this.setupForDefine();
            sArray = this.connection.queryMetaData1;
        }
        this.t2cOutput[0] = 0L;
        this.t2cOutput[2] = 0L;
        byte[] byArray = this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals);
        this.t2cOutput[5] = this.connection.useNio ? 1 : 0;
        this.t2cOutput[6] = this.defaultLobPrefetchSize;
        if (this.connection.useNio) {
            this.resetNioAttributesBeforeFetch();
            this.allocateNioBuffersIfRequired(this.defineChars == null ? 0 : this.defineChars.length, this.defineBytes == null ? 0 : this.defineBytes.length, this.defineIndicators == null ? 0 : this.defineIndicators.length);
        }
        if (this.lobPrefetchMetaData == null) {
            this.lobPrefetchMetaData = this.getLobPrefetchMetaData();
        }
        this.validRows = T2CStatement.t2cDefineExecuteFetch(this, this.c_state, this.numberOfDefinePositions, this.numberOfBindPositions, this.numberOfBindRowsAllocated, this.firstRowInBatch, this.currentRowBindAccessors != null, this.needToParse, byArray, byArray.length, this.sqlKind, this.rowPrefetch, this.batch, this.bindIndicators, this.bindIndicatorOffset, this.bindBytes, this.bindChars, this.bindByteOffset, this.bindCharOffset, sArray, this.connection.queryMetaData2, this.connection.queryMetaData1Offset, this.connection.queryMetaData2Offset, this.preparedAllBinds, this.preparedCharBinds, this.outBindAccessors, this.parameterDatum, this.t2cOutput, this.defineBytes, this.accessorByteOffset, this.defineChars, this.accessorCharOffset, this.defineIndicators, this.accessorShortOffset, this.nioBuffers, this.lobPrefetchMetaData);
        if (this.validRows == -1) {
            this.connection.checkError(this.validRows);
        }
        if (this.t2cOutput[2] != 0L) {
            this.sqlWarning = this.connection.checkError(1, this.sqlWarning);
        }
        this.connection.endToEndECIDSequenceNumber = (short)this.t2cOutput[4];
        if (this.connection.useNio && (this.validRows > 0 || this.validRows == -2)) {
            this.extractNioDefineBuffers(0);
        }
        if (this.lobPrefetchMetaData != null) {
            this.processLobPrefetchMetaData(this.lobPrefetchMetaData);
        }
        this.needToParse = false;
    }

    void fetch() throws SQLException {
        if (this.numberOfDefinePositions > 0) {
            if (this.needToPrepareDefineBuffer) {
                this.doDefineFetch();
            } else {
                this.t2cOutput[2] = 0L;
                this.t2cOutput[5] = this.connection.useNio ? 1 : 0;
                this.t2cOutput[6] = this.defaultLobPrefetchSize;
                if (this.connection.useNio) {
                    this.resetNioAttributesBeforeFetch();
                    this.allocateNioBuffersIfRequired(this.defineChars == null ? 0 : this.defineChars.length, this.defineBytes == null ? 0 : this.defineBytes.length, this.defineIndicators == null ? 0 : this.defineIndicators.length);
                }
                if (this.lobPrefetchMetaData == null) {
                    this.lobPrefetchMetaData = this.getLobPrefetchMetaData();
                }
                this.validRows = T2CStatement.t2cFetch(this.c_state, this.needToPrepareDefineBuffer, this.rowPrefetch, this.accessors, this.defineBytes, this.accessorByteOffset, this.defineChars, this.accessorCharOffset, this.defineIndicators, this.accessorShortOffset, this.t2cOutput, this.nioBuffers, this.lobPrefetchMetaData);
                if (this.validRows == -1 || this.validRows == -4) {
                    this.connection.checkError(this.validRows);
                }
                if (this.t2cOutput[2] != 0L) {
                    this.sqlWarning = this.connection.checkError(1, this.sqlWarning);
                }
                if (this.lobPrefetchMetaData != null) {
                    this.processLobPrefetchMetaData(this.lobPrefetchMetaData);
                }
                if (this.connection.useNio && (this.validRows > 0 || this.validRows == -2)) {
                    this.extractNioDefineBuffers(0);
                }
            }
        }
    }

    void resetNioAttributesBeforeFetch() {
        this.extractedCharOffset = 0;
        this.extractedByteOffset = 0;
    }

    void extractNioDefineBuffers(int n2) throws SQLException {
        Buffer buffer;
        if (this.accessors == null || this.defineIndicators == null || n2 == this.numberOfDefinePositions) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (!this.hasStream) {
            n3 = this.defineBytes != null ? this.defineBytes.length : 0;
            n4 = this.defineChars != null ? this.defineChars.length : 0;
            n5 = this.defineIndicators.length;
        } else {
            if (this.numberOfDefinePositions > n2) {
                n7 = this.accessors[n2].indicatorIndex;
                n6 = this.accessors[n2].lengthIndex;
            }
            block3: for (int i2 = n2; i2 < this.numberOfDefinePositions; ++i2) {
                switch (this.accessors[i2].internalType) {
                    case 8: 
                    case 24: {
                        break block3;
                    }
                    default: {
                        n3 += this.accessors[i2].byteLength;
                        n4 += this.accessors[i2].charLength;
                        ++n5;
                        continue block3;
                    }
                }
            }
        }
        ByteBuffer byteBuffer = this.nioBuffers[0];
        if (byteBuffer != null && this.defineBytes != null && n3 > 0) {
            byteBuffer.position(this.extractedByteOffset);
            byteBuffer.get(this.defineBytes, this.extractedByteOffset, n3);
            this.extractedByteOffset += n3;
        }
        if (this.nioBuffers[1] != null && this.defineChars != null) {
            byteBuffer = this.nioBuffers[1].order(ByteOrder.LITTLE_ENDIAN);
            buffer = byteBuffer.asCharBuffer();
            if (n4 > 0) {
                ((CharBuffer)buffer).position(this.extractedCharOffset);
                ((CharBuffer)buffer).get(this.defineChars, this.extractedCharOffset, n4);
                this.extractedCharOffset += n4;
            }
        }
        if (this.nioBuffers[2] != null) {
            byteBuffer = this.nioBuffers[2].order(ByteOrder.LITTLE_ENDIAN);
            buffer = byteBuffer.asShortBuffer();
            if (this.hasStream) {
                if (n5 > 0) {
                    ((ShortBuffer)buffer).position(n7);
                    ((ShortBuffer)buffer).get(this.defineIndicators, n7, n5);
                    ((ShortBuffer)buffer).position(n6);
                    ((ShortBuffer)buffer).get(this.defineIndicators, n6, n5);
                }
            } else {
                ((ShortBuffer)buffer).get(this.defineIndicators);
            }
        }
    }

    void doClose() throws SQLException {
        if (this.defineBytes != null) {
            this.defineBytes = null;
            this.accessorByteOffset = 0;
        }
        if (this.defineChars != null) {
            this.defineChars = null;
            this.accessorCharOffset = 0;
        }
        if (this.defineIndicators != null) {
            this.defineIndicators = null;
            this.accessorShortOffset = 0;
        }
        int n2 = T2CStatement.t2cCloseStatement(this.c_state);
        this.nioBuffers = null;
        if (n2 != 0) {
            this.connection.checkError(n2);
        }
        this.t2cOutput = null;
    }

    void closeQuery() throws SQLException {
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
    }

    Accessor allocateAccessor(int n2, int n3, int n4, int n5, short s2, String string, boolean bl) throws SQLException {
        if (n2 == 116 || n2 == 102) {
            if (bl && string != null) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + n3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            T2CResultSetAccessor t2CResultSetAccessor = new T2CResultSetAccessor(this, n5, s2, n3, bl);
            return t2CResultSetAccessor;
        }
        return super.allocateAccessor(n2, n3, n4, n5, s2, string, bl);
    }

    void closeUsedStreams(int n2) throws SQLException {
        while (this.nextStream != null && this.nextStream.columnIndex < n2) {
            try {
                this.nextStream.close();
            }
            catch (IOException iOException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.nextStream = this.nextStream.nextStream;
        }
        if (this.nextStream != null) {
            try {
                this.nextStream.needBytes();
            }
            catch (IOException iOException) {
                this.interalCloseOnIOException(iOException);
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
    }

    void interalCloseOnIOException(IOException iOException) throws SQLException {
        this.closed = true;
        if (this.currentResultSet != null) {
            this.currentResultSet.closed = true;
        }
        this.doClose();
    }

    void fetchDmlReturnParams() throws SQLException {
        this.rowsDmlReturned = T2CStatement.t2cGetRowsDmlReturned(this.c_state);
        if (this.rowsDmlReturned != 0) {
            this.allocateDmlReturnStorage();
            int n2 = T2CStatement.t2cFetchDmlReturnParams(this.c_state, this.returnParamAccessors, this.returnParamBytes, this.returnParamChars, this.returnParamIndicators);
            if (n2 == -1 || n2 == -4) {
                this.connection.checkError(n2);
            }
            if (this.t2cOutput[2] != 0L) {
                this.sqlWarning = this.connection.checkError(1, this.sqlWarning);
            }
            if (this.connection.useNio && (n2 > 0 || n2 == -2)) {
                this.extractNioDefineBuffers(0);
            }
        }
        this.returnParamsFetched = true;
    }

    void initializeIndicatorSubRange() {
        this.bindIndicatorSubRange = this.numberOfBindPositions * 5;
    }

    void prepareBindPreambles(int n2, int n3) {
        int n4 = this.bindIndicatorSubRange;
        this.initializeIndicatorSubRange();
        int n5 = this.bindIndicatorSubRange;
        this.bindIndicatorSubRange = n4;
        int n6 = this.bindIndicatorSubRange - n5;
        OracleTypeADT[] oracleTypeADTArray = this.parameterOtype == null ? null : this.parameterOtype[this.firstRowInBatch];
        for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
            int n7;
            OracleTypeADT oracleTypeADT;
            Binder binder = this.lastBinders[i2];
            if (binder == this.theReturnParamBinder) {
                oracleTypeADT = (OracleTypeADT)this.returnParamAccessors[i2].internalOtype;
                n7 = 0;
            } else {
                OracleTypeADT oracleTypeADT2 = oracleTypeADT = oracleTypeADTArray == null ? null : oracleTypeADTArray[i2];
                if (this.outBindAccessors == null) {
                    n7 = 0;
                } else {
                    Accessor accessor = this.outBindAccessors[i2];
                    if (accessor == null) {
                        n7 = 0;
                    } else if (binder == this.theOutBinder) {
                        n7 = 1;
                        if (oracleTypeADT == null) {
                            oracleTypeADT = (OracleTypeADT)accessor.internalOtype;
                        }
                    } else {
                        n7 = 2;
                    }
                }
                if (binder == this.theSetCHARBinder) {
                    n7 = (short)(n7 | 4);
                }
            }
            this.bindIndicators[n6++] = n7;
            if (oracleTypeADT != null) {
                long l2 = oracleTypeADT.getTdoCState();
                this.bindIndicators[n6 + 0] = (short)(l2 >> 48 & 0xFFFFL);
                this.bindIndicators[n6 + 1] = (short)(l2 >> 32 & 0xFFFFL);
                this.bindIndicators[n6 + 2] = (short)(l2 >> 16 & 0xFFFFL);
                this.bindIndicators[n6 + 3] = (short)(l2 & 0xFFFFL);
            }
            n6 += 4;
        }
    }

    void releaseBuffers() {
        super.releaseBuffers();
    }

    void doDescribe(boolean bl) throws SQLException {
        boolean bl2;
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.described) {
            return;
        }
        if (!this.isOpen) {
            this.connection.open(this);
            this.isOpen = true;
        }
        do {
            bl2 = false;
            boolean bl3 = this.sqlKind == 0 && this.needToParse && (!this.described || !this.serverCursor);
            byte[] byArray = bl3 ? this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals) : PhysicalConnection.EMPTY_BYTE_ARRAY;
            this.numberOfDefinePositions = T2CStatement.t2cDescribe(this.c_state, this.connection.queryMetaData1, this.connection.queryMetaData2, this.connection.queryMetaData1Offset, this.connection.queryMetaData2Offset, this.connection.queryMetaData1Size, this.connection.queryMetaData2Size, byArray, byArray.length, bl3);
            if (!this.described) {
                this.described = true;
            }
            if (this.numberOfDefinePositions == -1) {
                this.connection.checkError(this.numberOfDefinePositions);
            }
            if (this.numberOfDefinePositions != T2C_EXTEND_BUFFER) continue;
            bl2 = true;
            this.connection.reallocateQueryMetaData(this.connection.queryMetaData1Size * 2, this.connection.queryMetaData2Size * 2);
        } while (bl2);
        this.processDescribeData();
    }

    void registerOutParameterInternal(int n2, int n3, int n4, int n5, String string) throws SQLException {
        int n6 = n2 - 1;
        if (n6 < 0 || n2 > this.numberOfBindPositions) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n7 = this.getInternalType(n3);
        if (n7 == 995) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.resetBatch();
        this.currentRowNeedToPrepareBinds = true;
        if (this.currentRowBindAccessors == null) {
            this.currentRowBindAccessors = new Accessor[this.numberOfBindPositions];
        }
        switch (n3) {
            case -4: 
            case -3: 
            case -1: 
            case 1: 
            case 12: 
            case 70: {
                break;
            }
            default: {
                n5 = 0;
            }
        }
        this.currentRowBindAccessors[n6] = this.allocateAccessor(n7, n3, n2, n5, this.currentRowFormOfUse[n6], string, true);
    }
}

