/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.legacy;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.legacy.GenericConnection;

public class GenericDataSource
implements DataSource {
    private static final String SQLEXCEPTION_GETCONNECTION = "getConnection(String username, String password)  Method not supported. Use getConnection() instead.";
    protected boolean closed = false;
    protected LinkedList connections = new LinkedList();
    protected Driver driver = null;
    protected Log log = LogFactory.getLog(this.getClass());
    protected int loginTimeout = 0;
    protected PrintWriter logWriter = null;
    protected int activeCount = 0;
    protected boolean autoCommit = true;
    protected int debug = 0;
    protected String description = null;
    protected String driverClass = null;
    protected int maxCount = 2;
    protected int minCount = 1;
    protected String password = null;
    protected String pingCommand = null;
    protected String pingQuery = null;
    protected Properties properties = new Properties();
    protected boolean readOnly = false;
    protected String url = null;
    protected int useCount = 0;
    protected String user = null;
    static /* synthetic */ Class class$org$apache$struts$legacy$GenericDataSource;

    private static Class applicationClass(String string) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = (class$org$apache$struts$legacy$GenericDataSource == null ? (class$org$apache$struts$legacy$GenericDataSource = GenericDataSource.class$("org.apache.struts.legacy.GenericDataSource")) : class$org$apache$struts$legacy$GenericDataSource).getClassLoader();
        }
        return classLoader.loadClass(string);
    }

    private static Object applicationInstance(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return GenericDataSource.applicationClass(string).newInstance();
    }

    public void addProperty(String string, String string2) {
        ((Hashtable)this.properties).put(string, string2);
    }

    public int getActiveCount() {
        return this.activeCount;
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean bl) {
        this.autoCommit = bl;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int n) {
        this.debug = n;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String string) {
        this.driverClass = string;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int n) {
        this.maxCount = n;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public void setMinCount(int n) {
        this.minCount = n;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
        this.addProperty("password", this.password);
    }

    public String getPingCommand() {
        return this.pingCommand;
    }

    public void setPingCommand(String string) {
        this.pingCommand = string;
    }

    public String getPingQuery() {
        return this.pingQuery;
    }

    public void setPingQuery(String string) {
        this.pingQuery = string;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public int getUseCount() {
        return this.useCount;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.user = string;
        this.addProperty("user", this.user);
    }

    public Connection getConnection() throws SQLException {
        int n = 0;
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"  getConnection()");
        }
        if (this.closed) {
            throw new SQLException("getConnection:  Data source is closed");
        }
        if (this.driver == null) {
            this.open();
        }
        while (true) {
            Connection connection;
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("   Check for timeout, activeCount=" + this.activeCount + ", useCount=" + this.useCount));
            }
            if (this.loginTimeout > 0 && n >= this.loginTimeout) break;
            LinkedList linkedList = this.connections;
            synchronized (linkedList) {
                if (!this.connections.isEmpty()) {
                    connection = (GenericConnection)this.connections.removeFirst();
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)"   Found available connection");
                    }
                    ((GenericConnection)connection).setClosed(false);
                    try {
                        this.ping(connection);
                    }
                    catch (SQLException sQLException) {
                        this.log.warn((Object)"   Connection stale, releasing");
                        try {
                            ((GenericConnection)connection).getConnection().close();
                        }
                        catch (SQLException sQLException2) {
                            // empty catch block
                        }
                        --this.activeCount;
                        continue;
                    }
                    ++this.useCount;
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)("   Return allocated connection, activeCount=" + this.activeCount + ", useCount=" + this.useCount));
                    }
                    Connection connection2 = connection;
                    return connection2;
                }
            }
            if (this.activeCount < this.maxCount && (connection = this.createConnection()) != null) {
                this.ping(connection);
                ++this.useCount;
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("   Return new connection, activeCount=" + this.activeCount + ", useCount=" + this.useCount));
                }
                return connection;
            }
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"   Sleep until next test");
            }
            try {
                Thread.sleep(1000L);
                ++n;
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"   Timeout awaiting connection");
        }
        throw new SQLException("getConnection: Timeout awaiting connection");
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        throw new SQLException(SQLEXCEPTION_GETCONNECTION);
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.loginTimeout = n;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.logWriter = printWriter;
    }

    public void close() throws SQLException {
        if (this.closed) {
            throw new SQLException("close:  Data Source already closed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)" close()");
        }
        while (this.activeCount > 0) {
            GenericConnection genericConnection = (GenericConnection)this.getConnection();
            genericConnection.getConnection().close();
            --this.activeCount;
        }
        this.closed = true;
        this.driver = null;
    }

    public void open() throws SQLException {
        if (this.driver != null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)" open()");
        }
        try {
            this.driver = (Driver)GenericDataSource.applicationInstance(this.driverClass);
        }
        catch (Throwable throwable) {
            throw new SQLException("open: " + throwable);
        }
        LinkedList linkedList = this.connections;
        synchronized (linkedList) {
            int n = 0;
            while (n < this.minCount) {
                this.connections.addLast(this.createConnection());
                ++n;
            }
        }
        this.closed = false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("GenericDataSource[");
        stringBuffer.append("activeCount=");
        stringBuffer.append(this.activeCount);
        stringBuffer.append(", autoCommit=");
        stringBuffer.append(this.autoCommit);
        stringBuffer.append(", closed=");
        stringBuffer.append(this.closed);
        if (this.description != null) {
            stringBuffer.append(", description=");
            stringBuffer.append(this.description);
        }
        stringBuffer.append(", driverClass=");
        stringBuffer.append(this.driverClass);
        stringBuffer.append(", loginTimeout=");
        stringBuffer.append(this.loginTimeout);
        stringBuffer.append(", maxCount=");
        stringBuffer.append(this.maxCount);
        stringBuffer.append(", minCount=");
        stringBuffer.append(this.minCount);
        stringBuffer.append(", password=");
        stringBuffer.append(this.password);
        stringBuffer.append(", readOnly=");
        stringBuffer.append(this.readOnly);
        stringBuffer.append(", url=");
        stringBuffer.append(this.url);
        stringBuffer.append(", useCount=");
        stringBuffer.append(this.useCount);
        stringBuffer.append(", user=");
        stringBuffer.append(this.user);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected synchronized Connection createConnection() throws SQLException {
        if (this.activeCount < this.maxCount) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"   createConnection()");
            }
            Connection connection = this.driver.connect(this.url, this.properties);
            ++this.activeCount;
            return new GenericConnection(this, connection, this.autoCommit, this.readOnly);
        }
        this.log.error((Object)"   createConnection() returning null");
        return null;
    }

    protected void log(String string) {
        if (this.logWriter != null) {
            this.logWriter.print("GenericDataSource[");
            this.logWriter.print(this.description);
            this.logWriter.print("]: ");
            this.logWriter.println(string);
        }
    }

    protected void log(String string, Throwable throwable) {
        if (this.logWriter != null) {
            this.logWriter.print("GenericDataSource[");
            this.logWriter.print(this.description);
            this.logWriter.print("]: ");
            this.logWriter.println(string);
            throwable.printStackTrace(this.logWriter);
        }
    }

    protected void ping(Connection connection) throws SQLException {
        AutoCloseable autoCloseable;
        if (this.pingCommand != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("    ping(" + this.pingCommand + ")"));
            }
            autoCloseable = connection.createStatement();
            try {
                autoCloseable.execute(this.pingCommand);
                autoCloseable.close();
            }
            catch (SQLException sQLException) {
                this.log.warn((Object)("ping failed:  " + sQLException.getMessage()), (Throwable)sQLException);
                try {
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
                throw sQLException;
            }
        }
        if (this.pingQuery != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("    ping(" + this.pingQuery + ")"));
            }
            autoCloseable = null;
            Statement statement = connection.createStatement();
            try {
                autoCloseable = statement.executeQuery(this.pingQuery);
                while (autoCloseable.next()) {
                }
                autoCloseable.close();
                statement.close();
            }
            catch (SQLException sQLException) {
                this.log.warn((Object)("ping failed: " + sQLException.getMessage()), (Throwable)sQLException);
                try {
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                catch (SQLException sQLException3) {
                    // empty catch block
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException4) {
                    // empty catch block
                }
                throw sQLException;
            }
        }
    }

    void returnConnection(GenericConnection genericConnection) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("  releaseConnection(), activeCount=" + this.activeCount + ", useCount=" + (this.useCount - 1)));
        }
        LinkedList linkedList = this.connections;
        synchronized (linkedList) {
            this.connections.addLast(genericConnection);
            --this.useCount;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

