/*
 * Decompiled with CFR 0.152.
 */
package snaq.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import snaq.db.StatementListener;
import snaq.util.Reusable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedStatement
implements Statement,
Reusable {
    protected StatementListener listener;
    protected Statement st;
    protected boolean open = true;

    public CachedStatement(Statement st) {
        this.st = st;
    }

    protected String getParametersString() {
        StringBuffer sb = new StringBuffer();
        try {
            switch (this.getResultSetType()) {
                case 1004: {
                    sb.append("TYPE_SCROLL_INSENSITIVE");
                    break;
                }
                case 1005: {
                    sb.append("TYPE_SCROLL_SENSITIVE");
                    break;
                }
                default: {
                    sb.append("TYPE_FORWARD_ONLY");
                    break;
                }
            }
        }
        catch (SQLException sqle) {
            sb.append("TYPE_UNKNOWN");
        }
        sb.append(',');
        try {
            switch (this.getResultSetConcurrency()) {
                case 1008: {
                    sb.append("CONCUR_UPDATABLE");
                    break;
                }
                default: {
                    sb.append("CONCUR_READ_ONLY");
                    break;
                }
            }
        }
        catch (SQLException sqle) {
            sb.append("CONCUR_UNKNOWN");
        }
        sb.append(',');
        try {
            switch (this.getResultSetHoldability()) {
                case 2: {
                    sb.append("CLOSE_CURSORS_AT_COMMIT");
                    break;
                }
                case 1: {
                    sb.append("HOLD_CURSORS_OVER_COMMIT");
                }
            }
        }
        catch (SQLException sqle) {
            sb.append("HOLD_UNKNOWN");
        }
        return sb.toString();
    }

    @Override
    public void recycle() throws SQLException {
        ResultSet rs = this.st.getResultSet();
        if (rs != null) {
            rs.close();
        }
        try {
            this.st.clearWarnings();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.st.clearBatch();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void close() throws SQLException {
        if (!this.open) {
            return;
        }
        this.open = false;
        if (this.listener != null) {
            this.listener.statementClosed(this);
        } else {
            this.release();
        }
    }

    public void release() throws SQLException {
        this.st.close();
    }

    void setOpen() {
        this.open = true;
    }

    void setStatementListener(StatementListener x) {
        this.listener = x;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.st.executeQuery(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.st.executeUpdate(sql);
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.st.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.st.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.st.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.st.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.st.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.st.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.st.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.st.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.st.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.st.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.st.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.st.execute(sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.st.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.st.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.st.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.st.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.st.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.st.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.st.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.st.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.st.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.st.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.st.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.st.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.st.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.st.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.st.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.st.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.st.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.st.executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.st.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.st.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.st.execute(sql, columnNames);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.st.getResultSetHoldability();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }
}

