/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DTV;
import com.microsoft.sqlserver.jdbc.DTVExecuteOp;
import com.microsoft.sqlserver.jdbc.DTVImpl;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.InputStreamArgs;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.ServerDTVImpl;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;

final class AppDTVImpl
extends DTVImpl {
    private int jdbcType;
    private Object value;
    private Object setterArgs;
    static /* synthetic */ Class class$java$sql$Array;
    static /* synthetic */ Class class$java$sql$Ref;
    static /* synthetic */ Class class$java$net$URL;

    AppDTVImpl() {
    }

    int setFromTDS(DTV dTV, TypeInfo typeInfo, int n, byte[] byArray, boolean bl) throws SQLServerException {
        dTV.setImpl(new ServerDTVImpl());
        return dTV.setFromTDS(typeInfo, n, byArray, bl);
    }

    void checkSupportedConversionFromJDBCTypeToJDBCType(int n, int n2) throws SQLServerException {
        if (!DataTypes.canConvertFromJDBCTypeToJDBCType(n, n2)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionFromTo"));
            Object[] objectArray = new Object[]{Util.javaSqlTypeToString(n), Util.javaSqlTypeToString(n2)};
            SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, true);
        }
    }

    void setValue(DTV dTV, int n, Object object, Object object2) throws SQLServerException {
        if (null == object && (2000 == n || 1111 == n || 2006 == n || 2002 == n)) {
            n = -2;
        }
        SetValueOp setValueOp = new SetValueOp(object2);
        DTV.executeOp(dTV, setValueOp, object, n);
        this.value = setValueOp.getValue();
        this.jdbcType = setValueOp.getJdbcType();
        this.setterArgs = setValueOp.getSetterArgs();
    }

    Object getSetterArgs() {
        return this.setterArgs;
    }

    boolean isNull() {
        return null == this.value;
    }

    int getJdbcType() throws SQLServerException {
        return this.jdbcType;
    }

    Object getValue(DTV dTV, int n, boolean bl, Object object) throws SQLServerException {
        if (this.jdbcType != n) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionFromTo"));
            Object[] objectArray = new Object[]{Util.javaSqlTypeToString(this.jdbcType), Util.javaSqlTypeToString(n)};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, false);
        }
        return this.value;
    }

    int getInt() {
        return (Integer)this.value;
    }

    short getShort() {
        return (Short)this.value;
    }

    byte getByte(DTV dTV) throws SQLServerException {
        if (!(this.value instanceof Byte)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionFromTo"));
            Object[] objectArray = new Object[]{Util.javaSqlTypeToString(this.jdbcType), "Byte"};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, false);
        }
        return (Byte)this.value;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    final class SetValueOp
    extends DTVExecuteOp {
        private int jdbcType;
        private Object value;
        private Object setterArgs;

        int getJdbcType() {
            return this.jdbcType;
        }

        Object getValue() {
            return this.value;
        }

        Object getSetterArgs() {
            return this.setterArgs;
        }

        SetValueOp(Object object) {
            this.setterArgs = object;
        }

        void execute(String string, int n) throws SQLServerException {
            if (999 == n) {
                n = 1;
            } else {
                AppDTVImpl.this.checkSupportedConversionFromJDBCTypeToJDBCType(1, n);
            }
            this.value = string;
            this.jdbcType = n;
        }

        void execute(Clob clob, int n) throws SQLServerException {
            if (999 == n) {
                n = 2005;
            } else {
                AppDTVImpl.this.checkSupportedConversionFromJDBCTypeToJDBCType(2005, n);
            }
            this.value = clob;
            this.jdbcType = n;
        }

        void execute(Byte by, int n) throws SQLServerException {
            if (999 == n) {
                n = -6;
            } else {
                AppDTVImpl.this.checkSupportedConversionFromJDBCTypeToJDBCType(-6, n);
            }
            this.value = by;
            this.jdbcType = n;
        }

        void execute(Integer n, int n2) throws SQLServerException {
            if (999 == n2) {
                n2 = 4;
            } else {
                AppDTVImpl.this.checkSupportedConversionFromJDBCTypeToJDBCType(4, n2);
            }
            this.value = n;
            this.jdbcType = n2;
        }

        void execute(Time time, DTV dTV, int n) throws SQLServerException {
            if (999 == n) {
                n = 92;
            } else {
                AppDTVImpl.this.checkSupportedConversionFromJDBCTypeToJDBCType(92, n);
            }
            this.value = time;
            this.jdbcType = n;
        }

        void execute(Date date, DTV dTV, int n) throws SQLServerException {
            if (999 == n) {
                n = 91;
            } else {
                AppDTVImpl.this.checkSupportedConversionFromJDBCTypeToJDBCType(91, n);
            }
            this.value = date;
            this.jdbcType = n;
        }

        void execute(Timestamp timestamp, DTV dTV, int n) throws SQLServerException {
            if (999 == n) {
                n = 93;
            } else {
                AppDTVImpl.this.checkSupportedConversionFromJDBCTypeToJDBCType(93, n);
            }
            this.value = timestamp;
            this.jdbcType = n;
        }

        void execute(Float f, int n) throws SQLServerException {
            if (999 == n) {
                n = 7;
            } else {
                AppDTVImpl.this.checkSupportedConversionFromJDBCTypeToJDBCType(7, n);
            }
            this.value = f;
            this.jdbcType = n;
        }

        void execute(Double d, int n) throws SQLServerException {
            if (999 == n) {
                n = 8;
            } else {
                AppDTVImpl.this.checkSupportedConversionFromJDBCTypeToJDBCType(8, n);
            }
            this.value = d;
            this.jdbcType = n;
        }

        void execute(BigDecimal bigDecimal, int n) throws SQLServerException {
            if (999 == n) {
                n = 3;
            } else {
                AppDTVImpl.this.checkSupportedConversionFromJDBCTypeToJDBCType(3, n);
            }
            this.value = bigDecimal;
            this.jdbcType = n;
        }

        void execute(Long l, int n) throws SQLServerException {
            if (999 == n) {
                n = -5;
            } else {
                AppDTVImpl.this.checkSupportedConversionFromJDBCTypeToJDBCType(-5, n);
            }
            this.value = l;
            this.jdbcType = n;
        }

        void execute(Short s, int n) throws SQLServerException {
            if (999 == n) {
                n = 5;
            } else {
                AppDTVImpl.this.checkSupportedConversionFromJDBCTypeToJDBCType(5, n);
            }
            this.value = s;
            this.jdbcType = n;
        }

        void execute(Boolean bl, int n) throws SQLServerException {
            if (999 == n) {
                n = -7;
            } else {
                AppDTVImpl.this.checkSupportedConversionFromJDBCTypeToJDBCType(-7, n);
            }
            this.value = bl;
            this.jdbcType = n;
        }

        void execute(byte[] byArray, int n) throws SQLServerException {
            if (999 == n) {
                n = -2;
            } else {
                AppDTVImpl.this.checkSupportedConversionFromJDBCTypeToJDBCType(-2, n);
            }
            this.value = byArray;
            this.jdbcType = n;
        }

        void execute(Blob blob, int n) throws SQLServerException {
            if (999 == n) {
                n = 2004;
            } else {
                AppDTVImpl.this.checkSupportedConversionFromJDBCTypeToJDBCType(2004, n);
            }
            this.value = blob;
            this.jdbcType = n;
        }

        void execute(InputStream inputStream, DTV dTV, int n) throws SQLServerException {
            if (1 != n && 12 != n && -1 != n) {
                n = -2;
            }
            if (null == this.setterArgs) {
                this.setterArgs = new InputStreamArgs(-2 == n ? 1 : 3, -1, 0);
            }
            this.value = inputStream;
            this.jdbcType = n;
        }

        void execute(Reader reader, DTV dTV, int n) throws SQLServerException {
            if (999 == n) {
                n = -1;
            } else {
                AppDTVImpl.this.checkSupportedConversionFromJDBCTypeToJDBCType(-1, n);
            }
            if (null == this.setterArgs) {
                this.setterArgs = new Integer(-1);
            }
            this.value = reader;
            this.jdbcType = n;
        }

        void executeDefault(Object object, int n) throws SQLServerException {
            if ((class$java$sql$Array == null ? (class$java$sql$Array = AppDTVImpl.class$("java.sql.Array")) : class$java$sql$Array).isInstance(object) || (class$java$sql$Ref == null ? (class$java$sql$Ref = AppDTVImpl.class$("java.sql.Ref")) : class$java$sql$Ref).isInstance(object) || (class$java$net$URL == null ? (class$java$net$URL = AppDTVImpl.class$("java.net.URL")) : class$java$net$URL).isInstance(object)) {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_notSupported"), null, false);
            } else {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unknownType"));
                Object[] objectArray = new Object[]{new String(object.getClass().getName())};
                SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, false);
            }
        }
    }
}

