/*
 * Decompiled with CFR 0.152.
 */
package snaq.util;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import snaq.util.LogUtil;
import snaq.util.ObjectPoolEvent;
import snaq.util.ObjectPoolListener;
import snaq.util.Reusable;
import snaq.util.TimeWrapper;

public abstract class ObjectPool
extends LogUtil {
    private static final int ACCESS_FIFO = 1;
    private static final int ACCESS_LIFO = 2;
    private static final int ACCESS_RANDOM = 3;
    private int accessMethod = 2;
    private String name;
    private List free;
    private List used;
    private int poolSize;
    private int maxSize;
    private long expiryTime;
    private long requests;
    private long hits;
    private boolean released = false;
    private boolean asyncDestroy = false;
    private DateFormat dateFormat;
    private Cleaner cleaner;
    private InitThread initer;
    private static int cleanerCount = 0;
    private List listeners = new ArrayList();

    protected ObjectPool(String name, int poolSize, int maxSize, long expiryTime) {
        Class type = this.getPoolClass();
        if (!List.class.isAssignableFrom(type)) {
            throw new RuntimeException("Invalid pool class type specified: " + type.getName() + " (must implement java.util.List)");
        }
        try {
            this.free = (List)type.newInstance();
            this.used = (List)type.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate pool class type: " + type.getName());
        }
        this.name = name;
        this.setParameters(poolSize, maxSize, expiryTime);
    }

    protected ObjectPool(String name, int poolSize, int maxSize, int expiryTime) {
        this(name, poolSize, maxSize, (long)expiryTime);
    }

    public final void init(int num) {
        if (num == 0) {
            return;
        }
        if (num > 0 && num <= this.getMaxSize()) {
            if (this.initer != null) {
                this.initer.halt();
                try {
                    this.initer.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid number of items specified for initialization");
        }
        this.initer = new InitThread(num);
        this.initer.start();
    }

    protected final synchronized Reusable checkOut() throws Exception {
        boolean hit;
        if (this.released) {
            throw new RuntimeException("Pool no longer valid for use");
        }
        int oldTotalConns = this.used.size() + this.free.size();
        TimeWrapper tw = null;
        Reusable o = null;
        if (this.free.size() > 0) {
            switch (this.accessMethod) {
                case 1: {
                    tw = (TimeWrapper)this.free.remove(0);
                    break;
                }
                case 3: {
                    tw = (TimeWrapper)this.free.remove((int)((double)this.free.size() * Math.random()));
                    break;
                }
                default: {
                    tw = (TimeWrapper)this.free.remove(this.free.size() - 1);
                }
            }
            o = (Reusable)tw.getObject();
            boolean valid = this.isValid(o);
            while (!valid && this.free.size() > 0) {
                this.destroyObject(o);
                this.log("Removed invalid item from pool");
                tw = (TimeWrapper)this.free.remove(0);
                o = (Reusable)tw.getObject();
                valid = this.isValid(o);
            }
            if (this.free.size() == 0 && !valid) {
                o = null;
            }
        }
        boolean bl = hit = o != null;
        if (o == null) {
            if (this.maxSize > 0 && this.used.size() == this.maxSize) {
                this.fireMaxSizeLimitErrorEvent();
            } else if (!(this.used.size() >= this.maxSize && this.maxSize != 0 || this.isValid(o = this.create()))) {
                throw new RuntimeException("Unable to create a valid connection");
            }
        }
        if (o != null) {
            this.used.add(o);
            ++this.requests;
            if (hit) {
                ++this.hits;
            }
            this.firePoolCheckOutEvent();
            int totalConns = this.used.size() + this.free.size();
            if (totalConns == this.poolSize && totalConns > oldTotalConns) {
                this.fireMaxPoolLimitReachedEvent();
            } else if (totalConns == this.poolSize + 1 && totalConns > oldTotalConns) {
                this.fireMaxPoolLimitExceededEvent();
            }
            if (totalConns == this.maxSize && totalConns > oldTotalConns) {
                this.fireMaxSizeLimitReachedEvent();
            }
        }
        if (this.debug) {
            String ratio = String.valueOf(this.used.size()) + "/" + (this.used.size() + this.free.size());
            String hitRate = " (HitRate=" + this.getHitRate() + "%)";
            this.log("Checkout - " + ratio + hitRate + (o == null ? " - null returned" : ""));
        }
        return o;
    }

    protected final synchronized Reusable checkOut(long timeout) throws Exception {
        long time = System.currentTimeMillis();
        Reusable o = null;
        o = this.checkOut();
        while (o == null && System.currentTimeMillis() - time < timeout) {
            try {
                if (this.debug) {
                    this.log("No pooled items spare...waiting for up to " + timeout + "ms");
                }
                this.wait(timeout);
                o = this.checkOut();
            }
            catch (InterruptedException e) {
                this.log(e, "Connection checkout interrupted");
            }
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void checkIn(Reusable o) {
        if (o == null) {
            this.log("Attempt to return null item");
            return;
        }
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            this.firePoolCheckInEvent();
            if (!this.used.remove(o)) {
                this.log("Attempt to return item not belonging to pool");
                throw new RuntimeException("Attempt to return item not belonging to pool " + this.name);
            }
            boolean kill = this.maxSize > 0 && this.free.size() + this.used.size() >= this.poolSize;
            boolean bl = kill = kill || this.maxSize == 0 && this.free.size() >= this.poolSize;
            if (kill) {
                this.destroyObject(o);
                if (this.debug) {
                    this.log("Checkin* - " + this.used.size() + "/" + (this.used.size() + this.free.size()));
                }
            } else {
                try {
                    o.recycle();
                    this.free.add(new TimeWrapper(null, o, this.expiryTime));
                    if (this.debug) {
                        this.log("Checkin  - " + this.used.size() + "/" + (this.used.size() + this.free.size()));
                    }
                    this.notifyAll();
                }
                catch (Exception e) {
                    this.destroyObject(o);
                    this.log(e, "Unable to recycle item - destroyed");
                }
            }
        }
    }

    public final void release() {
        this.release(false);
    }

    public final synchronized void releaseAsync() {
        this.releaseAsync(false);
    }

    public final void releaseForcibly() {
        this.release(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void release(boolean forced) {
        if (this.released) {
            return;
        }
        this.released = true;
        if (this.cleaner != null) {
            this.cleaner.halt();
            try {
                this.cleaner.join();
            }
            catch (InterruptedException ie) {
                this.log(ie, "Interrupted during halting of old cleaner thread");
            }
            this.cleaner = null;
        }
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            int rel = 0;
            int failed = 0;
            TimeWrapper tw2 = null;
            Reusable o2 = null;
            if (forced) {
                for (Reusable o2 : this.used) {
                    try {
                        this.destroy(o2);
                        ++rel;
                    }
                    catch (Exception ex) {
                        ++failed;
                        this.log(ex, "Unable to release item in pool");
                    }
                }
                this.used.clear();
            } else {
                if (this.debug && this.used.size() > 0) {
                    this.log("Waiting for used items to be checked-in...");
                }
                while (this.used.size() > 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException iter) {
                        // empty catch block
                    }
                }
            }
            for (TimeWrapper tw2 : this.free) {
                o2 = (Reusable)tw2.getObject();
                try {
                    this.destroy(o2);
                    ++rel;
                }
                catch (Exception ex) {
                    ++failed;
                    this.log(ex, "Unable to release item in pool");
                }
            }
            this.free.clear();
            if (this.debug) {
                String s = "Released " + rel + (rel > 1 ? " items" : " item");
                if (failed > 0) {
                    s = String.valueOf(s) + " (failed to release " + failed + (failed > 1 ? " items)" : " item)");
                }
                this.log(s);
            }
            this.firePoolReleasedEvent();
            this.listeners.clear();
            super.close();
        }
    }

    private final void releaseAsync(final boolean forced) {
        Thread t = new Thread(new Runnable(){

            public void run() {
                ObjectPool.this.release(forced);
            }
        });
        t.start();
    }

    protected abstract Reusable create() throws Exception;

    protected abstract boolean isValid(Reusable var1);

    protected abstract void destroy(Reusable var1);

    private final void destroyObject(final Reusable o) {
        if (o == null) {
            return;
        }
        if (this.asyncDestroy) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    ObjectPool.this.destroy(o);
                }
            });
            t.start();
        } else {
            this.destroy(o);
        }
    }

    public final void setAsyncDestroy(boolean b) {
        this.asyncDestroy = b;
    }

    public final boolean isAsyncDestroy() {
        return this.asyncDestroy;
    }

    public void log(String logEntry) {
        this.log(String.valueOf(this.name) + ": ", logEntry);
    }

    public void log(Throwable e, String logEntry) {
        this.log(e, String.valueOf(this.name) + ": ", logEntry);
    }

    public final String getName() {
        return this.name;
    }

    public final int getPoolSize() {
        return this.poolSize;
    }

    public final int getMaxSize() {
        return this.maxSize;
    }

    public final long getExpiryTime() {
        return this.expiryTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setParameters(int poolSize, int maxSize, long expiryTime) {
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            if (this.cleaner != null) {
                this.cleaner.halt();
            }
            this.poolSize = Math.max(poolSize, 0);
            this.maxSize = Math.max(maxSize, 0);
            this.expiryTime = Math.max(expiryTime, 0L);
            if (this.maxSize > 0 && this.maxSize < this.poolSize) {
                this.maxSize = this.poolSize;
            }
            this.resetHitCounter();
            TimeWrapper tw2 = null;
            for (TimeWrapper tw2 : this.free) {
                tw2.setLiveTime(expiryTime);
            }
            if (this.expiryTime > 0L) {
                long iVal = Math.min(5000L, this.expiryTime / 5L);
                this.cleaner = new Cleaner(this, iVal);
                this.cleaner.start();
            }
        }
        if (this.debug) {
            String info = "pool=" + this.poolSize + ",max=" + this.maxSize + ",expiry=";
            info = String.valueOf(info) + (this.expiryTime == 0L ? "none" : String.valueOf(this.expiryTime) + "ms");
            this.log("Parameters changed (" + info + ")");
        }
        this.fireParametersChangedEvent();
    }

    public final synchronized int getSize() {
        return this.free.size() + this.used.size();
    }

    public final synchronized int getCheckedOut() {
        return this.used.size();
    }

    public final synchronized int getFreeCount() {
        return this.free.size();
    }

    public final float getHitRate() {
        return this.requests == 0L ? 0.0f : (float)this.hits / (float)this.requests * 100.0f;
    }

    protected final void resetHitCounter() {
        this.hits = 0L;
        this.requests = 0L;
    }

    protected final void setAccessFIFO() {
        this.accessMethod = 1;
    }

    protected final void setAccessLIFO() {
        this.accessMethod = 2;
    }

    protected final void setAccessRandom() {
        this.accessMethod = 3;
    }

    protected Class getPoolClass() {
        return ArrayList.class;
    }

    public void finalize() {
        if (this.cleaner != null) {
            this.cleaner.halt();
            this.cleaner = null;
        }
        if (this.initer != null) {
            this.initer.halt();
            this.initer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() {
        int count = 0;
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            TimeWrapper tw = null;
            Iterator iter = this.free.iterator();
            while (iter.hasNext()) {
                tw = (TimeWrapper)iter.next();
                iter.remove();
                this.destroyObject((Reusable)tw.getObject());
                ++count;
            }
        }
        if (count > 0 && this.debug) {
            this.log("Flushed all spare items from pool");
        }
    }

    final synchronized boolean purge() {
        if (this.debug) {
            this.log("Checking for expired items");
        }
        int count = 0;
        TimeWrapper tw = null;
        Iterator iter = this.free.iterator();
        while (iter.hasNext()) {
            tw = (TimeWrapper)iter.next();
            if (!tw.isExpired()) continue;
            iter.remove();
            this.destroyObject((Reusable)tw.getObject());
            ++count;
        }
        return this.free.size() > 0 || count > 0;
    }

    public final void addObjectPoolListener(ObjectPoolListener x) {
        this.listeners.add(x);
    }

    public final void removeObjectPoolListener(ObjectPoolListener x) {
        this.listeners.remove(x);
    }

    private final void firePoolCheckOutEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ObjectPoolEvent poolEvent = new ObjectPoolEvent(this, 1);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ObjectPoolListener)iter.next()).poolCheckOut(poolEvent);
        }
    }

    private final void firePoolCheckInEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ObjectPoolEvent poolEvent = new ObjectPoolEvent(this, 2);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ObjectPoolListener)iter.next()).poolCheckIn(poolEvent);
        }
    }

    private final void fireMaxPoolLimitReachedEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ObjectPoolEvent poolEvent = new ObjectPoolEvent(this, 3);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ObjectPoolListener)iter.next()).maxPoolLimitReached(poolEvent);
        }
    }

    private final void fireMaxPoolLimitExceededEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ObjectPoolEvent poolEvent = new ObjectPoolEvent(this, 4);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ObjectPoolListener)iter.next()).maxPoolLimitExceeded(poolEvent);
        }
    }

    private final void fireMaxSizeLimitReachedEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ObjectPoolEvent poolEvent = new ObjectPoolEvent(this, 5);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ObjectPoolListener)iter.next()).maxSizeLimitReached(poolEvent);
        }
    }

    private final void fireMaxSizeLimitErrorEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ObjectPoolEvent poolEvent = new ObjectPoolEvent(this, 6);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ObjectPoolListener)iter.next()).maxSizeLimitError(poolEvent);
        }
    }

    private final void fireParametersChangedEvent() {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        ObjectPoolEvent poolEvent = new ObjectPoolEvent(this, 7);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ObjectPoolListener)iter.next()).poolParametersChanged(poolEvent);
        }
    }

    private final void firePoolReleasedEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ObjectPoolEvent poolEvent = new ObjectPoolEvent(this, 8);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ObjectPoolListener)iter.next()).poolReleased(poolEvent);
        }
    }

    final class Cleaner
    extends Thread {
        private ObjectPool pool;
        private long interval;
        private boolean stopped;

        Cleaner(ObjectPool pool, long interval) {
            StringBuilder stringBuilder = new StringBuilder("CleanerThread_");
            int n = cleanerCount;
            cleanerCount = n + 1;
            this.setName(stringBuilder.append(Integer.toString(n)).toString());
            this.pool = pool;
            this.interval = interval;
        }

        public void start() {
            this.stopped = false;
            super.start();
        }

        public void halt() {
            if (!this.isHalted()) {
                this.stopped = true;
                this.interrupt();
            }
        }

        public boolean isHalted() {
            return this.stopped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.pool.cleaner == Thread.currentThread() && !this.stopped) {
                ObjectPool objectPool = this.pool;
                synchronized (objectPool) {
                    if (!this.pool.purge()) {
                        try {
                            this.pool.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (this.stopped) continue;
                try {
                    Cleaner.sleep(this.interval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private class InitThread
    extends Thread {
        private int num;
        private boolean stopped = false;

        private InitThread(int num) {
            this.num = Math.min(ObjectPool.this.poolSize, Math.max(num, 0));
        }

        public void halt() {
            this.stopped = true;
        }

        public void run() {
            if (this.num > 0 && this.num <= ObjectPool.this.poolSize && ObjectPool.this.getSize() < this.num) {
                int count = 0;
                while (!this.stopped && ObjectPool.this.getSize() < this.num && this.num <= ObjectPool.this.poolSize) {
                    try {
                        Reusable o = ObjectPool.this.create();
                        if (o == null) {
                            throw new RuntimeException("Null item created");
                        }
                        ObjectPool.this.free.add(new TimeWrapper(null, o, ObjectPool.this.expiryTime));
                        ++count;
                        if (!ObjectPool.this.debug) continue;
                        ObjectPool.this.log("Initialized new item in pool");
                    }
                    catch (Exception ex) {
                        ObjectPool.this.log(ex, "Unable to initialize items in pool");
                        this.stopped = true;
                    }
                }
                if (ObjectPool.this.debug) {
                    ObjectPool.this.log("Initialized pool with " + count + " new item" + (count > 1 ? "s" : ""));
                }
            }
        }
    }
}

