/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.action;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.ExceptionHandler;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.RequestUtils;

public class RequestProcessor {
    public static final String INCLUDE_PATH_INFO = "javax.servlet.include.path_info";
    public static final String INCLUDE_SERVLET_PATH = "javax.servlet.include.servlet_path";
    protected HashMap actions = new HashMap();
    protected ModuleConfig moduleConfig = null;
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$struts$action$RequestProcessor == null ? (class$org$apache$struts$action$RequestProcessor = RequestProcessor.class$("org.apache.struts.action.RequestProcessor")) : class$org$apache$struts$action$RequestProcessor));
    protected ActionServlet servlet = null;
    static /* synthetic */ Class class$org$apache$struts$action$RequestProcessor;

    public void destroy() {
        HashMap hashMap = this.actions;
        synchronized (hashMap) {
            Iterator iterator = this.actions.values().iterator();
            while (iterator.hasNext()) {
                Action action = (Action)iterator.next();
                action.setServlet(null);
            }
            this.actions.clear();
        }
        this.servlet = null;
    }

    public void init(ActionServlet actionServlet, ModuleConfig moduleConfig) throws ServletException {
        HashMap hashMap = this.actions;
        synchronized (hashMap) {
            this.actions.clear();
        }
        this.servlet = actionServlet;
        this.moduleConfig = moduleConfig;
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string = this.processPath(httpServletRequest = this.processMultipart(httpServletRequest), httpServletResponse);
        if (string == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing a '" + httpServletRequest.getMethod() + "' for path '" + string + "'"));
        }
        this.processLocale(httpServletRequest, httpServletResponse);
        this.processContent(httpServletRequest, httpServletResponse);
        this.processNoCache(httpServletRequest, httpServletResponse);
        if (!this.processPreprocess(httpServletRequest, httpServletResponse)) {
            return;
        }
        this.processCachedMessages(httpServletRequest, httpServletResponse);
        ActionMapping actionMapping = this.processMapping(httpServletRequest, httpServletResponse, string);
        if (actionMapping == null) {
            return;
        }
        if (!this.processRoles(httpServletRequest, httpServletResponse, actionMapping)) {
            return;
        }
        ActionForm actionForm = this.processActionForm(httpServletRequest, httpServletResponse, actionMapping);
        this.processPopulate(httpServletRequest, httpServletResponse, actionForm, actionMapping);
        if (!this.processValidate(httpServletRequest, httpServletResponse, actionForm, actionMapping)) {
            return;
        }
        if (!this.processForward(httpServletRequest, httpServletResponse, actionMapping)) {
            return;
        }
        if (!this.processInclude(httpServletRequest, httpServletResponse, actionMapping)) {
            return;
        }
        Action action = this.processActionCreate(httpServletRequest, httpServletResponse, actionMapping);
        if (action == null) {
            return;
        }
        ActionForward actionForward = this.processActionPerform(httpServletRequest, httpServletResponse, action, actionForm, actionMapping);
        this.processForwardConfig(httpServletRequest, httpServletResponse, actionForward);
    }

    protected Action processActionCreate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ActionMapping actionMapping) throws IOException {
        String string = actionMapping.getType();
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Looking for Action instance for class " + string));
        }
        Action action = null;
        HashMap hashMap = this.actions;
        synchronized (hashMap) {
            action = (Action)this.actions.get(string);
            if (action != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"  Returning existing Action instance");
                }
                Action action2 = action;
                return action2;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"  Creating new Action instance");
            }
            try {
                action = (Action)RequestUtils.applicationInstance(string);
            }
            catch (Exception exception) {
                log.error((Object)this.getInternal().getMessage("actionCreate", (Object)actionMapping.getPath()), (Throwable)exception);
                httpServletResponse.sendError(500, this.getInternal().getMessage("actionCreate", (Object)actionMapping.getPath()));
                Action action3 = null;
                return action3;
            }
            action.setServlet(this.servlet);
            this.actions.put(string, action);
        }
        return action;
    }

    protected ActionForm processActionForm(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ActionMapping actionMapping) {
        ActionForm actionForm = RequestUtils.createActionForm(httpServletRequest, actionMapping, this.moduleConfig, this.servlet);
        if (actionForm == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Storing ActionForm bean instance in scope '" + actionMapping.getScope() + "' under attribute key '" + actionMapping.getAttribute() + "'"));
        }
        if ("request".equals(actionMapping.getScope())) {
            httpServletRequest.setAttribute(actionMapping.getAttribute(), (Object)actionForm);
        } else {
            HttpSession httpSession = httpServletRequest.getSession();
            httpSession.setAttribute(actionMapping.getAttribute(), (Object)actionForm);
        }
        return actionForm;
    }

    protected void processForwardConfig(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ForwardConfig forwardConfig) throws IOException, ServletException {
        if (forwardConfig == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("processForwardConfig(" + forwardConfig + ")"));
        }
        String string = forwardConfig.getPath();
        String string2 = null;
        string2 = string.startsWith("/") ? RequestUtils.forwardURL(httpServletRequest, forwardConfig, null) : string;
        if (forwardConfig.getRedirect()) {
            if (string2.startsWith("/")) {
                string2 = httpServletRequest.getContextPath() + string2;
            }
            httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(string2));
        } else {
            this.doForward(string2, httpServletRequest, httpServletResponse);
        }
    }

    protected ActionForward processActionPerform(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Action action, ActionForm actionForm, ActionMapping actionMapping) throws IOException, ServletException {
        try {
            return action.execute(actionMapping, actionForm, httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            return this.processException(httpServletRequest, httpServletResponse, exception, actionForm, actionMapping);
        }
    }

    protected void processCachedMessages(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            return;
        }
        ActionMessages actionMessages = (ActionMessages)httpSession.getAttribute("org.apache.struts.action.ACTION_MESSAGE");
        if (actionMessages != null && actionMessages.isAccessed()) {
            httpSession.removeAttribute("org.apache.struts.action.ACTION_MESSAGE");
        }
        if ((actionMessages = (ActionMessages)httpSession.getAttribute("org.apache.struts.action.ERROR")) != null && actionMessages.isAccessed()) {
            httpSession.removeAttribute("org.apache.struts.action.ERROR");
        }
    }

    protected void processContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = this.moduleConfig.getControllerConfig().getContentType();
        if (string != null) {
            httpServletResponse.setContentType(string);
        }
    }

    protected ActionForward processException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Exception exception, ActionForm actionForm, ActionMapping actionMapping) throws IOException, ServletException {
        ExceptionConfig exceptionConfig = actionMapping.findException(exception.getClass());
        if (exceptionConfig == null) {
            log.warn((Object)this.getInternal().getMessage("unhandledException", exception.getClass()));
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof ServletException) {
                throw (ServletException)((Object)exception);
            }
            throw new ServletException((Throwable)exception);
        }
        try {
            ExceptionHandler exceptionHandler = (ExceptionHandler)RequestUtils.applicationInstance(exceptionConfig.getHandler());
            return exceptionHandler.execute(exception, exceptionConfig, actionMapping, actionForm, httpServletRequest, httpServletResponse);
        }
        catch (Exception exception2) {
            throw new ServletException((Throwable)exception2);
        }
    }

    protected boolean processForward(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ActionMapping actionMapping) throws IOException, ServletException {
        String string = actionMapping.getForward();
        if (string == null) {
            return true;
        }
        this.internalModuleRelativeForward(string, httpServletRequest, httpServletResponse);
        return false;
    }

    protected boolean processInclude(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ActionMapping actionMapping) throws IOException, ServletException {
        String string = actionMapping.getInclude();
        if (string == null) {
            return true;
        }
        this.internalModuleRelativeInclude(string, httpServletRequest, httpServletResponse);
        return false;
    }

    protected void processLocale(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (!this.moduleConfig.getControllerConfig().getLocale()) {
            return;
        }
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession.getAttribute("org.apache.struts.action.LOCALE") != null) {
            return;
        }
        Locale locale = httpServletRequest.getLocale();
        if (locale != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(" Setting user locale '" + locale + "'"));
            }
            httpSession.setAttribute("org.apache.struts.action.LOCALE", (Object)locale);
        }
    }

    protected ActionMapping processMapping(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        ActionMapping actionMapping = (ActionMapping)this.moduleConfig.findActionConfig(string);
        if (actionMapping != null) {
            httpServletRequest.setAttribute("org.apache.struts.action.mapping.instance", (Object)actionMapping);
            return actionMapping;
        }
        ActionConfig[] actionConfigArray = this.moduleConfig.findActionConfigs();
        int n = 0;
        while (n < actionConfigArray.length) {
            if (actionConfigArray[n].getUnknown()) {
                actionMapping = (ActionMapping)actionConfigArray[n];
                httpServletRequest.setAttribute("org.apache.struts.action.mapping.instance", (Object)actionMapping);
                return actionMapping;
            }
            ++n;
        }
        String string2 = this.getInternal().getMessage("processInvalid", (Object)string);
        log.error((Object)string2);
        httpServletResponse.sendError(404, string2);
        return null;
    }

    protected HttpServletRequest processMultipart(HttpServletRequest httpServletRequest) {
        if (!"POST".equalsIgnoreCase(httpServletRequest.getMethod())) {
            return httpServletRequest;
        }
        String string = httpServletRequest.getContentType();
        if (string != null && string.startsWith("multipart/form-data")) {
            return new MultipartRequestWrapper(httpServletRequest);
        }
        return httpServletRequest;
    }

    protected void processNoCache(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (this.moduleConfig.getControllerConfig().getNocache()) {
            httpServletResponse.setHeader("Pragma", "No-cache");
            httpServletResponse.setHeader("Cache-Control", "no-cache,no-store,max-age=0");
            httpServletResponse.setDateHeader("Expires", 1L);
        }
    }

    protected String processPath(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string;
        String string2 = null;
        string2 = (String)httpServletRequest.getAttribute(INCLUDE_PATH_INFO);
        if (string2 == null) {
            string2 = httpServletRequest.getPathInfo();
        }
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        string2 = (String)httpServletRequest.getAttribute(INCLUDE_SERVLET_PATH);
        if (string2 == null) {
            string2 = httpServletRequest.getServletPath();
        }
        if (!string2.startsWith(string = this.moduleConfig.getPrefix())) {
            String string3 = this.getInternal().getMessage("processPath", (Object)httpServletRequest.getRequestURI());
            log.error((Object)string3);
            httpServletResponse.sendError(400, string3);
            return null;
        }
        string2 = string2.substring(string.length());
        int n = string2.lastIndexOf("/");
        int n2 = string2.lastIndexOf(".");
        if (n2 >= 0 && n2 > n) {
            string2 = string2.substring(0, n2);
        }
        return string2;
    }

    protected void processPopulate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ActionForm actionForm, ActionMapping actionMapping) throws ServletException {
        if (actionForm == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)" Populating bean properties from this request");
        }
        actionForm.setServlet(this.servlet);
        actionForm.reset(actionMapping, httpServletRequest);
        if (actionMapping.getMultipartClass() != null) {
            httpServletRequest.setAttribute("org.apache.struts.action.mapping.multipartclass", (Object)actionMapping.getMultipartClass());
        }
        RequestUtils.populate(actionForm, actionMapping.getPrefix(), actionMapping.getSuffix(), httpServletRequest);
        if (httpServletRequest.getParameter("org.apache.struts.taglib.html.CANCEL") != null || httpServletRequest.getParameter("org.apache.struts.taglib.html.CANCEL.x") != null) {
            httpServletRequest.setAttribute("org.apache.struts.action.CANCEL", (Object)Boolean.TRUE);
        }
    }

    protected boolean processPreprocess(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return true;
    }

    protected boolean processRoles(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ActionMapping actionMapping) throws IOException, ServletException {
        String[] stringArray = actionMapping.getRoleNames();
        if (stringArray == null || stringArray.length < 1) {
            return true;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (httpServletRequest.isUserInRole(stringArray[n])) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" User '" + httpServletRequest.getRemoteUser() + "' has role '" + stringArray[n] + "', granting access"));
                }
                return true;
            }
            ++n;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(" User '" + httpServletRequest.getRemoteUser() + "' does not have any required role, denying access"));
        }
        httpServletResponse.sendError(403, this.getInternal().getMessage("notAuthorized", (Object)actionMapping.getPath()));
        return false;
    }

    protected boolean processValidate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ActionForm actionForm, ActionMapping actionMapping) throws IOException, ServletException {
        String string;
        ActionErrors actionErrors;
        if (actionForm == null) {
            return true;
        }
        if (httpServletRequest.getAttribute("org.apache.struts.action.CANCEL") != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)" Cancelled transaction, skipping validation");
            }
            return true;
        }
        if (!actionMapping.getValidate()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)" Validating input form properties");
        }
        if ((actionErrors = actionForm.validate(actionMapping, httpServletRequest)) == null || actionErrors.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"  No errors detected, accepting input");
            }
            return true;
        }
        if (actionForm.getMultipartRequestHandler() != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"  Rolling back multipart request");
            }
            actionForm.getMultipartRequestHandler().rollback();
        }
        if ((string = actionMapping.getInput()) == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"  Validation failed but no input form available");
            }
            httpServletResponse.sendError(500, this.getInternal().getMessage("noInput", (Object)actionMapping.getPath()));
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Validation failed, returning to '" + string + "'"));
        }
        httpServletRequest.setAttribute("org.apache.struts.action.ERROR", (Object)actionErrors);
        if (this.moduleConfig.getControllerConfig().getInputForward()) {
            ActionForward actionForward = actionMapping.findForward(string);
            this.processForwardConfig(httpServletRequest, httpServletResponse, actionForward);
        } else {
            this.internalModuleRelativeForward(string, httpServletRequest, httpServletResponse);
        }
        return false;
    }

    protected void internalModuleRelativeForward(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        string = this.moduleConfig.getPrefix() + string;
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Delegating via forward to '" + string + "'"));
        }
        this.doForward(string, httpServletRequest, httpServletResponse);
    }

    protected void internalModuleRelativeInclude(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        string = this.moduleConfig.getPrefix() + string;
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Delegating via include to '" + string + "'"));
        }
        this.doInclude(string, httpServletRequest, httpServletResponse);
    }

    protected void doForward(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        RequestDispatcher requestDispatcher;
        if (httpServletRequest instanceof MultipartRequestWrapper) {
            httpServletRequest = ((MultipartRequestWrapper)httpServletRequest).getRequest();
        }
        if ((requestDispatcher = this.getServletContext().getRequestDispatcher(string)) == null) {
            httpServletResponse.sendError(500, this.getInternal().getMessage("requestDispatcher", (Object)string));
            return;
        }
        requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    protected void doInclude(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        RequestDispatcher requestDispatcher;
        if (httpServletRequest instanceof MultipartRequestWrapper) {
            httpServletRequest = ((MultipartRequestWrapper)httpServletRequest).getRequest();
        }
        if ((requestDispatcher = this.getServletContext().getRequestDispatcher(string)) == null) {
            httpServletResponse.sendError(500, this.getInternal().getMessage("requestDispatcher", (Object)string));
            return;
        }
        requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    protected MessageResources getInternal() {
        return this.servlet.getInternal();
    }

    protected ServletContext getServletContext() {
        return this.servlet.getServletContext();
    }

    protected void log(String string) {
        this.servlet.log(string);
    }

    protected void log(String string, Throwable throwable) {
        this.servlet.log(string, throwable);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

