/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.plugins;

import javax.servlet.ServletException;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.MessageResourcesConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.PlugInConfig;
import org.apache.struts.util.RequestUtils;

public class ModuleConfigVerifier
implements PlugIn {
    protected ModuleConfig config = null;
    protected ActionServlet servlet = null;
    private boolean fatal = true;

    public boolean isFatal() {
        return this.fatal;
    }

    public void setFatal(boolean bl) {
        this.fatal = bl;
    }

    public void destroy() {
    }

    public void init(ActionServlet actionServlet, ModuleConfig moduleConfig) throws ServletException {
        this.servlet = actionServlet;
        this.config = moduleConfig;
        boolean bl = true;
        this.log(actionServlet.getInternal().getMessage("configVerifying"));
        if (!this.verifyActionMappingClass()) {
            bl = false;
        }
        if (!this.verifyForwardConfigs()) {
            bl = false;
        }
        if (!this.verifyMessageResourcesConfigs()) {
            bl = false;
        }
        if (!this.verifyPlugInConfigs()) {
            bl = false;
        }
        this.log(actionServlet.getInternal().getMessage("configCompleted"));
        if (!bl && this.isFatal()) {
            throw new ServletException(actionServlet.getInternal().getMessage("configFatal"));
        }
    }

    protected void log(String string) {
        String string2 = "[" + this.config.getPrefix() + "]: " + string;
        this.servlet.log(string2);
    }

    protected boolean verifyActionMappingClass() {
        String string = this.config.getActionMappingClass();
        if (string == null) {
            this.log(this.servlet.getInternal().getMessage("verifyActionMappingClass.missing"));
            return false;
        }
        try {
            Class clazz = RequestUtils.applicationClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log(this.servlet.getInternal().getMessage("verifyActionMappingClass.invalid", (Object)string));
            return false;
        }
        return true;
    }

    protected boolean verifyForwardConfigs() {
        boolean bl = true;
        ForwardConfig[] forwardConfigArray = this.config.findForwardConfigs();
        int n = 0;
        while (n < forwardConfigArray.length) {
            String string = forwardConfigArray[n].getPath();
            if (string == null) {
                this.log(this.servlet.getInternal().getMessage("verifyForwardConfigs.missing", (Object)forwardConfigArray[n].getName()));
                bl = false;
            } else if (!string.startsWith("/")) {
                this.log(this.servlet.getInternal().getMessage("verifyForwardConfigs.invalid", (Object)string, (Object)forwardConfigArray[n].getName()));
            }
            ++n;
        }
        return bl;
    }

    protected boolean verifyMessageResourcesConfigs() {
        boolean bl = true;
        MessageResourcesConfig[] messageResourcesConfigArray = this.config.findMessageResourcesConfigs();
        int n = 0;
        while (n < messageResourcesConfigArray.length) {
            Object object;
            String string = messageResourcesConfigArray[n].getFactory();
            if (string == null) {
                this.log(this.servlet.getInternal().getMessage("verifyMessageResourcesConfigs.missing"));
                bl = false;
            } else {
                try {
                    object = RequestUtils.applicationClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.log(this.servlet.getInternal().getMessage("verifyMessageResourcesConfigs.invalid", (Object)string));
                    bl = false;
                }
            }
            object = messageResourcesConfigArray[n].getKey();
            if (object == null) {
                this.log(this.servlet.getInternal().getMessage("verifyMessageResourcesConfigs.key"));
            }
            ++n;
        }
        return bl;
    }

    protected boolean verifyPlugInConfigs() {
        boolean bl = true;
        PlugInConfig[] plugInConfigArray = this.config.findPlugInConfigs();
        int n = 0;
        while (n < plugInConfigArray.length) {
            String string = plugInConfigArray[n].getClassName();
            if (string == null) {
                this.log(this.servlet.getInternal().getMessage("verifyPlugInConfigs.missing"));
                bl = false;
            } else {
                try {
                    Class clazz = RequestUtils.applicationClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.log(this.servlet.getInternal().getMessage("verifyPlugInConfigs.invalid", (Object)string));
                    bl = false;
                }
            }
            ++n;
        }
        return bl;
    }
}

