/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.upload;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.upload.DiskFile;
import org.apache.struts.upload.MultipartElement;
import org.apache.struts.upload.MultipartIterator;
import org.apache.struts.upload.MultipartRequestHandler;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.apache.struts.util.ModuleUtils;

public class DiskMultipartRequestHandler
implements MultipartRequestHandler {
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$struts$upload$DiskMultipartRequestHandler == null ? (class$org$apache$struts$upload$DiskMultipartRequestHandler = DiskMultipartRequestHandler.class$("org.apache.struts.upload.DiskMultipartRequestHandler")) : class$org$apache$struts$upload$DiskMultipartRequestHandler));
    protected ActionServlet servlet;
    protected ActionMapping mapping;
    protected Hashtable fileElements;
    protected Hashtable textElements;
    protected Hashtable allElements;
    protected String tempDir;
    static /* synthetic */ Class class$org$apache$struts$upload$DiskMultipartRequestHandler;

    public void handleRequest(HttpServletRequest httpServletRequest) throws ServletException {
        ModuleConfig moduleConfig = ModuleUtils.getInstance().getModuleConfig(httpServletRequest);
        this.retrieveTempDir(moduleConfig);
        try {
            MultipartElement multipartElement;
            MultipartIterator multipartIterator = new MultipartIterator(httpServletRequest, moduleConfig.getControllerConfig().getBufferSize(), this.getMaxSize(moduleConfig.getControllerConfig().getMaxFileSize()), this.tempDir);
            this.textElements = new Hashtable();
            this.fileElements = new Hashtable();
            this.allElements = new Hashtable();
            while ((multipartElement = multipartIterator.getNextElement()) != null) {
                if (!multipartElement.isFile()) {
                    this.createTextElement(httpServletRequest, multipartElement);
                    continue;
                }
                this.createDiskFile(multipartElement);
            }
            if (multipartIterator.isMaxLengthExceeded()) {
                httpServletRequest.setAttribute("org.apache.struts.upload.MaxLengthExceeded", (Object)Boolean.TRUE);
            }
        }
        catch (IOException iOException) {
            throw new ServletException((Throwable)iOException);
        }
    }

    protected void createTextElement(HttpServletRequest httpServletRequest, MultipartElement multipartElement) {
        String[] stringArray;
        if (httpServletRequest instanceof MultipartRequestWrapper) {
            ((MultipartRequestWrapper)httpServletRequest).setParameter(multipartElement.getName(), multipartElement.getValue());
        }
        if ((stringArray = (String[])this.textElements.get(multipartElement.getName())) != null) {
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = multipartElement.getValue();
            stringArray = stringArray2;
        } else {
            stringArray = new String[]{multipartElement.getValue()};
        }
        this.textElements.put(multipartElement.getName(), stringArray);
        this.allElements.put(multipartElement.getName(), stringArray);
    }

    protected void createDiskFile(MultipartElement multipartElement) {
        File file = multipartElement.getFile();
        if (file.exists()) {
            DiskFile diskFile = new DiskFile(file.getAbsolutePath());
            diskFile.setContentType(multipartElement.getContentType());
            diskFile.setFileName(multipartElement.getFileName());
            diskFile.setFileSize((int)file.length());
            this.fileElements.put(multipartElement.getName(), diskFile);
            this.allElements.put(multipartElement.getName(), diskFile);
        }
    }

    public Hashtable getAllElements() {
        return this.allElements;
    }

    public Hashtable getTextElements() {
        return this.textElements;
    }

    public Hashtable getFileElements() {
        return this.fileElements;
    }

    public void rollback() {
        Enumeration enumeration = this.fileElements.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            DiskFile diskFile = (DiskFile)this.fileElements.get(string);
            diskFile.destroy();
        }
    }

    public void finish() {
        this.rollback();
    }

    public void setServlet(ActionServlet actionServlet) {
        this.servlet = actionServlet;
    }

    public void setMapping(ActionMapping actionMapping) {
        this.mapping = actionMapping;
    }

    public ActionServlet getServlet() {
        return this.servlet;
    }

    public ActionMapping getMapping() {
        return this.mapping;
    }

    protected long getMaxSize(String string) throws ServletException {
        long l = -1L;
        int n = 1;
        if (string.endsWith("K")) {
            n = 1024;
            string = string.substring(0, string.length() - 1);
        }
        if (string.endsWith("M")) {
            n = 0x100000;
            string = string.substring(0, string.length() - 1);
        } else if (string.endsWith("G")) {
            n = 0x40000000;
            string = string.substring(0, string.length() - 1);
        }
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ServletException("Invalid format for maximum file size");
        }
        return l * (long)n;
    }

    protected void retrieveTempDir(ModuleConfig moduleConfig) {
        ActionServlet actionServlet = this.getServlet();
        if (actionServlet != null) {
            ServletContext servletContext = actionServlet.getServletContext();
            try {
                this.tempDir = (String)servletContext.getAttribute("javax.servlet.context.tempdir");
            }
            catch (ClassCastException classCastException) {
                this.tempDir = ((File)servletContext.getAttribute("javax.servlet.context.tempdir")).getAbsolutePath();
            }
        }
        if (this.tempDir == null) {
            this.tempDir = moduleConfig.getControllerConfig().getTempDir();
            if (this.tempDir == null) {
                this.tempDir = System.getProperty("java.io.tmpdir");
                log.debug((Object)("DiskMultipartRequestHandler.handleRequest(): defaulting to java.io.tmpdir directory \"" + this.tempDir));
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

