/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.upload;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class MultipartBoundaryInputStream
extends InputStream {
    private static final byte NEWLINE_BYTE = 10;
    private static final byte CARRIAGE_RETURN = 13;
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final String DOUBLE_DASH_STRING = "--";
    private static final int DEFAULT_LINE_SIZE = 4096;
    private static final String TOKEN_EQUALS = "=";
    private static final char TOKEN_QUOTE = '\"';
    private static final char TOKEN_COLON = ':';
    private static final char TOKEN_SEMI_COLON = ';';
    private static final char TOKEN_SPACE = ' ';
    private static final String DEFAULT_CONTENT_DISPOSITION = "form-data";
    private static final String PARAMETER_NAME = "name";
    private static final String PARAMETER_FILENAME = "filename";
    private static final String PARAMETER_CHARSET = "charset";
    private static final String CONTENT_TYPE_TEXT_PLAIN = "text/plain";
    private static final String CONTENT_TYPE_APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String MESSAGE_INVALID_START = "Multipart data doesn't start with boundary";
    protected InputStream inputStream;
    protected String boundary;
    protected boolean boundaryEncountered;
    protected boolean finalBoundaryEncountered;
    protected boolean endOfStream;
    protected String elementContentDisposition;
    protected String elementName;
    protected String elementContentType;
    protected String elementFileName;
    protected String elementCharset;
    protected long maxLength = -1L;
    protected boolean maxLengthMet;
    protected long bytesRead;
    private byte[] boundaryBytes;
    private byte[] finalBoundaryBytes;
    private byte[] line;
    private int lineSize = 4096;
    private int lineLength;
    private boolean lineHasNewline;
    private boolean lineHasCarriage;
    private int lineIndex;

    public MultipartBoundaryInputStream() {
        this.resetStream();
    }

    public void setBoundary(String string) {
        this.boundary = DOUBLE_DASH_STRING + string;
        this.boundaryBytes = this.boundary.getBytes();
        this.finalBoundaryBytes = (this.boundary + DOUBLE_DASH_STRING).getBytes();
    }

    public void resetForNextBoundary() throws IOException {
        if (!this.finalBoundaryEncountered) {
            this.boundaryEncountered = false;
            this.resetCrlf();
            this.fillLine();
            this.readElementHeaders();
        }
    }

    public void setInputStream(InputStream inputStream) throws IOException {
        this.inputStream = inputStream;
        this.resetStream();
        this.readFirstElement();
    }

    public int read() throws IOException {
        if (!this.maxLengthMet && !this.boundaryEncountered) {
            return this.readFromLine();
        }
        return -1;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 > 0) {
            int n3 = this.read();
            if (n3 == -1 && (this.endOfStream || this.boundaryEncountered)) {
                return -1;
            }
            int n4 = 1;
            byArray[n++] = (byte)n3;
            while (n4 < n2 && ((n3 = this.read()) != -1 || n3 == -1 && !this.boundaryEncountered) && !this.maxLengthMet) {
                byArray[n++] = (byte)n3;
                ++n4;
            }
            return n4;
        }
        return -1;
    }

    public synchronized void mark(int n) {
        this.inputStream.mark(n);
    }

    public synchronized void reset() throws IOException {
        this.inputStream.reset();
    }

    public void setMaxLength(long l) {
        this.maxLength = l;
    }

    public long getMaxLength() {
        return this.maxLength;
    }

    public boolean isMaxLengthMet() {
        return this.maxLengthMet;
    }

    public String getElementContentDisposition() {
        return this.elementContentDisposition;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getElementCharset() {
        return this.elementCharset;
    }

    public String getElementContentType() {
        return this.elementContentType;
    }

    public String getElementFileName() {
        return this.elementFileName;
    }

    public boolean isElementFile() {
        return this.elementFileName != null;
    }

    public boolean isBoundaryEncountered() {
        return this.boundaryEncountered;
    }

    public boolean isFinalBoundaryEncountered() {
        return this.finalBoundaryEncountered;
    }

    public boolean isEndOfStream() {
        return this.endOfStream;
    }

    public void setLineSize(int n) {
        this.lineSize = n;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    private final void readFirstElement() throws IOException {
        this.fillLine();
        if (!this.boundaryEncountered) {
            throw new IOException(MESSAGE_INVALID_START);
        }
        this.fillLine();
        this.readElementHeaders();
    }

    private final void readElementHeaders() throws IOException {
        this.readContentDisposition();
        this.resetCrlf();
        boolean bl = this.readContentType();
        this.resetCrlf();
        if (bl) {
            this.skipCurrentLineIfBlank();
        }
    }

    private final void readContentDisposition() throws IOException {
        String string = this.readLine();
        if (string != null) {
            int n = string.indexOf(58);
            if (n != -1) {
                int n2 = string.indexOf(59);
                if (n2 != -1) {
                    this.elementContentDisposition = string.substring(n + 1, n2).trim();
                }
            } else {
                this.elementContentDisposition = DEFAULT_CONTENT_DISPOSITION;
            }
            this.elementName = this.parseForParameter(PARAMETER_NAME, string);
            this.elementFileName = this.parseForParameter(PARAMETER_FILENAME, string);
            if (this.elementFileName != null) {
                this.elementFileName = this.checkAndFixFilename(this.elementFileName);
            }
        }
    }

    private final String checkAndFixFilename(String string) {
        int n = (string = new File(string).getName()).indexOf(":");
        if (n == -1) {
            n = string.indexOf("\\\\");
        }
        int n2 = string.lastIndexOf("\\");
        if (n > -1 && n2 > -1) {
            string = string.substring(n2 + 1, string.length());
        }
        return string;
    }

    private final String parseForParameter(String string, String string2) {
        int n = string2.indexOf(string + TOKEN_EQUALS);
        if (n != -1) {
            int n2 = -1;
            int n3 = -1;
            if (string2.charAt(n += string.length() + 1) == '\"') {
                n2 = n + 1;
                int n4 = string2.indexOf(34, n2);
                if (n4 != -1) {
                    n3 = n4;
                }
            } else {
                int n5;
                n2 = n;
                int n6 = string2.indexOf(32, n2);
                n3 = n6 != -1 ? n6 : ((n5 = string2.indexOf(13, n2)) != -1 ? n5 : string2.length());
            }
            if (n2 != -1 && n3 != -1) {
                return string2.substring(n2, n3);
            }
        }
        return null;
    }

    private final boolean readContentType() throws IOException {
        String string = this.readLine();
        if (string != null) {
            if (string.length() > 2) {
                this.elementContentType = this.parseHeaderValue(string);
                if (this.elementContentType == null) {
                    this.elementContentType = CONTENT_TYPE_APPLICATION_OCTET_STREAM;
                }
                this.elementCharset = this.parseForParameter(PARAMETER_CHARSET, string);
                return true;
            }
            this.elementContentType = CONTENT_TYPE_TEXT_PLAIN;
        }
        return false;
    }

    private final String parseHeaderValue(String string) {
        int n = string.indexOf(58);
        if (n != -1) {
            int n2 = string.indexOf(59, n);
            int n3 = n2 != -1 ? n2 : string.indexOf(13, n);
            if (n3 == -1) {
                n3 = string.length();
            }
            return string.substring(n + 1, n3).trim();
        }
        return null;
    }

    private final void skipCurrentLineIfBlank() throws IOException {
        boolean bl = false;
        if (this.lineLength == 1) {
            if (this.line[0] == 10) {
                bl = true;
            }
        } else if (this.lineLength == 2 && this.equals(this.line, 0, 2, CRLF)) {
            bl = true;
        }
        if (bl && !this.endOfStream) {
            this.fillLine();
        }
    }

    private final void resetCrlf() {
        this.lineHasCarriage = false;
        this.lineHasNewline = false;
    }

    private final void resetStream() {
        this.line = new byte[this.lineSize];
        this.lineIndex = 0;
        this.lineLength = 0;
        this.lineHasCarriage = false;
        this.lineHasNewline = false;
        this.boundaryEncountered = false;
        this.finalBoundaryEncountered = false;
        this.endOfStream = false;
        this.maxLengthMet = false;
        this.bytesRead = 0L;
    }

    private final String readLine() throws IOException {
        String string = null;
        if (this.availableInLine() > 0) {
            string = new String(this.line, 0, this.lineLength);
            if (!this.endOfStream) {
                this.fillLine();
            }
        } else if (!this.endOfStream) {
            this.fillLine();
            string = this.readLine();
        }
        return string;
    }

    private final int readFromLine() throws IOException {
        if (!this.boundaryEncountered) {
            if (this.availableInLine() > 0) {
                return this.line[this.lineIndex++];
            }
            if (!this.endOfStream) {
                this.fillLine();
                return this.readFromLine();
            }
        }
        return -1;
    }

    private final int availableInLine() {
        return this.lineLength - this.lineIndex;
    }

    private final void fillLine() throws IOException {
        this.resetLine();
        if (!this.finalBoundaryEncountered && !this.endOfStream) {
            this.fillLineBuffer();
            this.checkForBoundary();
        }
    }

    private final void resetLine() {
        this.lineIndex = 0;
    }

    private final void fillLineBuffer() throws IOException {
        int n = 0;
        int n2 = 0;
        if (this.lineHasCarriage) {
            this.line[n2++] = 13;
            this.lineHasCarriage = false;
        }
        if (this.lineHasNewline) {
            this.line[n2++] = 10;
            this.lineHasNewline = false;
        }
        while (n2 < this.line.length && !this.maxLengthMet) {
            n = this.inputStream.read();
            this.byteRead();
            if (n != -1 || n == -1 && this.inputStream.available() > 0 && !this.maxLengthMet) {
                this.line[n2++] = (byte)n;
                if (n != 10) continue;
                this.lineHasNewline = true;
                if (--n2 <= 0 || this.line[n2 - 1] != 13) break;
                this.lineHasCarriage = true;
                --n2;
                break;
            }
            this.endOfStream = true;
            break;
        }
        this.lineLength = n2;
    }

    private final void byteRead() {
        ++this.bytesRead;
        if (this.maxLength > -1L && this.bytesRead >= this.maxLength) {
            this.maxLengthMet = true;
            this.endOfStream = true;
        }
    }

    private final void checkForBoundary() {
        this.boundaryEncountered = false;
        int n = this.lineLength;
        if (this.line[0] == 13 || this.line[0] == 10) {
            --n;
        }
        if (this.line[1] == 10) {
            --n;
        }
        int n2 = this.lineLength - n;
        if (n == this.boundaryBytes.length) {
            if (this.equals(this.line, n2, this.boundaryBytes.length, this.boundaryBytes)) {
                this.boundaryEncountered = true;
            }
        } else if (n == this.boundaryBytes.length + 2 && this.equals(this.line, n2, this.finalBoundaryBytes.length, this.finalBoundaryBytes)) {
            this.boundaryEncountered = true;
            this.finalBoundaryEncountered = true;
            this.endOfStream = true;
        }
    }

    private final boolean equals(byte[] byArray, int n, int n2, byte[] byArray2) {
        if (n2 != byArray2.length || byArray.length - n < n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (byArray[n + n3] != byArray2[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }
}

