/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.ActionServletWrapper;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.upload.MultipartRequestHandler;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.apache.struts.util.ModuleUtils;

public class RequestUtils {
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$struts$util$RequestUtils == null ? (class$org$apache$struts$util$RequestUtils = RequestUtils.class$("org.apache.struts.util.RequestUtils")) : class$org$apache$struts$util$RequestUtils));
    static /* synthetic */ Class class$org$apache$struts$util$RequestUtils;

    public static URL absoluteURL(HttpServletRequest httpServletRequest, String string) throws MalformedURLException {
        return new URL(RequestUtils.serverURL(httpServletRequest), httpServletRequest.getContextPath() + string);
    }

    public static Class applicationClass(String string) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = (class$org$apache$struts$util$RequestUtils == null ? (class$org$apache$struts$util$RequestUtils = RequestUtils.class$("org.apache.struts.util.RequestUtils")) : class$org$apache$struts$util$RequestUtils).getClassLoader();
        }
        return classLoader.loadClass(string);
    }

    public static Object applicationInstance(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return RequestUtils.applicationClass(string).newInstance();
    }

    public static ActionForm createActionForm(HttpServletRequest httpServletRequest, ActionMapping actionMapping, ModuleConfig moduleConfig, ActionServlet actionServlet) {
        String string = actionMapping.getAttribute();
        if (string == null) {
            return null;
        }
        String string2 = actionMapping.getName();
        FormBeanConfig formBeanConfig = moduleConfig.findFormBeanConfig(string2);
        if (formBeanConfig == null) {
            log.warn((Object)("No FormBeanConfig found under '" + string2 + "'"));
            return null;
        }
        ActionForm actionForm = RequestUtils.lookupActionForm(httpServletRequest, string, actionMapping.getScope());
        try {
            if (actionForm != null && RequestUtils.canReuseActionForm(actionForm, formBeanConfig)) {
                return actionForm;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.error((Object)actionServlet.getInternal().getMessage("formBean", (Object)formBeanConfig.getType()), (Throwable)classNotFoundException);
            return null;
        }
        return RequestUtils.createActionForm(formBeanConfig, actionServlet);
    }

    private static ActionForm lookupActionForm(HttpServletRequest httpServletRequest, String string, String string2) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Looking for ActionForm bean instance in scope '" + string2 + "' under attribute key '" + string + "'"));
        }
        ActionForm actionForm = null;
        HttpSession httpSession = null;
        if ("request".equals(string2)) {
            actionForm = (ActionForm)httpServletRequest.getAttribute(string);
        } else {
            httpSession = httpServletRequest.getSession();
            actionForm = (ActionForm)httpSession.getAttribute(string);
        }
        return actionForm;
    }

    private static boolean canReuseActionForm(ActionForm actionForm, FormBeanConfig formBeanConfig) throws ClassNotFoundException {
        if (actionForm == null) {
            return false;
        }
        boolean bl = false;
        String string = null;
        String string2 = null;
        if (formBeanConfig.getDynamic()) {
            string2 = ((DynaBean)actionForm).getDynaClass().getName();
            bl = string2.equals(formBeanConfig.getName());
            string = "DynaActionForm";
        } else {
            Class clazz = RequestUtils.applicationClass(formBeanConfig.getType());
            string2 = actionForm.getClass().getName();
            bl = clazz.isAssignableFrom(actionForm.getClass());
            string = "ActionForm";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Can recycle existing " + string + " instance " + "of type '" + string2 + "'?: " + bl));
            log.trace((Object)(" --> " + actionForm));
        }
        return bl;
    }

    public static ActionForm createActionForm(FormBeanConfig formBeanConfig, ActionServlet actionServlet) {
        if (formBeanConfig == null) {
            return null;
        }
        ActionForm actionForm = null;
        try {
            actionForm = formBeanConfig.createActionForm(actionServlet);
            if (log.isDebugEnabled()) {
                log.debug((Object)(" Creating new " + (formBeanConfig.getDynamic() ? "DynaActionForm" : "ActionForm") + " instance of type '" + formBeanConfig.getType() + "'"));
                log.trace((Object)(" --> " + actionForm));
            }
        }
        catch (Throwable throwable) {
            log.error((Object)actionServlet.getInternal().getMessage("formBean", (Object)formBeanConfig.getType()), throwable);
        }
        return actionForm;
    }

    public static Locale getUserLocale(HttpServletRequest httpServletRequest, String string) {
        Locale locale = null;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (string == null) {
            string = "org.apache.struts.action.LOCALE";
        }
        if (httpSession != null) {
            locale = (Locale)httpSession.getAttribute(string);
        }
        if (locale == null) {
            locale = httpServletRequest.getLocale();
        }
        return locale;
    }

    public static void populate(Object object, HttpServletRequest httpServletRequest) throws ServletException {
        RequestUtils.populate(object, null, null, httpServletRequest);
    }

    public static void populate(Object object, String string, String string2, HttpServletRequest httpServletRequest) throws ServletException {
        Object object2;
        Object object3;
        Object object4;
        HashMap<Object, String[]> hashMap = new HashMap<Object, String[]>();
        Enumeration enumeration = null;
        Map map = null;
        String string3 = httpServletRequest.getContentType();
        String string4 = httpServletRequest.getMethod();
        boolean bl = false;
        if (string3 != null && string3.startsWith("multipart/form-data") && string4.equalsIgnoreCase("POST")) {
            if (!(object instanceof ActionForm)) {
                throw new ServletException("bean that's supposed to be populated from a multipart request is not of type \"org.apache.struts.action.ActionForm\", but type \"" + object.getClass().getName() + "\"");
            }
            object4 = ((ActionForm)object).getServletWrapper();
            object3 = RequestUtils.getMultipartHandler(httpServletRequest);
            ((ActionForm)object).setMultipartRequestHandler((MultipartRequestHandler)object3);
            if (object3 != null) {
                bl = true;
                ((ActionServletWrapper)object4).setServletFor((MultipartRequestHandler)object3);
                object3.setMapping((ActionMapping)httpServletRequest.getAttribute("org.apache.struts.action.mapping.instance"));
                object3.handleRequest(httpServletRequest);
                object2 = (Boolean)httpServletRequest.getAttribute("org.apache.struts.upload.MaxLengthExceeded");
                if (object2 != null && ((Boolean)object2).booleanValue()) {
                    return;
                }
                map = RequestUtils.getAllParametersForMultipartRequest(httpServletRequest, (MultipartRequestHandler)object3);
                enumeration = Collections.enumeration(map.keySet());
            }
        }
        if (!bl) {
            enumeration = httpServletRequest.getParameterNames();
        }
        while (enumeration.hasMoreElements()) {
            object3 = object4 = (String)enumeration.nextElement();
            if (string != null) {
                if (!((String)object3).startsWith(string)) continue;
                object3 = ((String)object3).substring(string.length());
            }
            if (string2 != null) {
                if (!((String)object3).endsWith(string2)) continue;
                object3 = ((String)object3).substring(0, ((String)object3).length() - string2.length());
            }
            object2 = null;
            object2 = bl ? (Object)map.get(object4) : httpServletRequest.getParameterValues((String)object4);
            if (((String)object3).startsWith("org.apache.struts.")) continue;
            hashMap.put(object3, (String[])object2);
        }
        try {
            BeanUtils.populate((Object)object, hashMap);
        }
        catch (Exception exception) {
            throw new ServletException("BeanUtils.populate", (Throwable)exception);
        }
    }

    private static MultipartRequestHandler getMultipartHandler(HttpServletRequest httpServletRequest) throws ServletException {
        ModuleConfig moduleConfig;
        MultipartRequestHandler multipartRequestHandler = null;
        String string = (String)httpServletRequest.getAttribute("org.apache.struts.action.mapping.multipartclass");
        httpServletRequest.removeAttribute("org.apache.struts.action.mapping.multipartclass");
        if (string != null) {
            try {
                multipartRequestHandler = (MultipartRequestHandler)RequestUtils.applicationInstance(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.error((Object)("MultipartRequestHandler class \"" + string + "\" in mapping class not found, " + "defaulting to global multipart class"));
            }
            catch (InstantiationException instantiationException) {
                log.error((Object)("InstantiationException when instantiating MultipartRequestHandler \"" + string + "\", " + "defaulting to global multipart class, exception: " + instantiationException.getMessage()));
            }
            catch (IllegalAccessException illegalAccessException) {
                log.error((Object)("IllegalAccessException when instantiating MultipartRequestHandler \"" + string + "\", " + "defaulting to global multipart class, exception: " + illegalAccessException.getMessage()));
            }
            if (multipartRequestHandler != null) {
                return multipartRequestHandler;
            }
        }
        if ((string = (moduleConfig = ModuleUtils.getInstance().getModuleConfig(httpServletRequest)).getControllerConfig().getMultipartClass()) != null) {
            try {
                multipartRequestHandler = (MultipartRequestHandler)RequestUtils.applicationInstance(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ServletException("Cannot find multipart class \"" + string + "\"" + ", exception: " + classNotFoundException.getMessage());
            }
            catch (InstantiationException instantiationException) {
                throw new ServletException("InstantiationException when instantiating multipart class \"" + string + "\", exception: " + instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ServletException("IllegalAccessException when instantiating multipart class \"" + string + "\", exception: " + illegalAccessException.getMessage());
            }
            if (multipartRequestHandler != null) {
                return multipartRequestHandler;
            }
        }
        return multipartRequestHandler;
    }

    private static Map getAllParametersForMultipartRequest(HttpServletRequest httpServletRequest, MultipartRequestHandler multipartRequestHandler) {
        String string;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Hashtable hashtable = multipartRequestHandler.getAllElements();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            hashMap.put(string, hashtable.get(string));
        }
        if (httpServletRequest instanceof MultipartRequestWrapper) {
            httpServletRequest = ((MultipartRequestWrapper)httpServletRequest).getRequest();
            enumeration = httpServletRequest.getParameterNames();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                hashMap.put(string, httpServletRequest.getParameterValues(string));
            }
        } else {
            log.debug((Object)"Gathering multipart parameters for unwrapped request");
        }
        return hashMap;
    }

    public static String printableURL(URL uRL) {
        if (uRL.getHost() != null) {
            return uRL.toString();
        }
        String string = uRL.getFile();
        String string2 = uRL.getRef();
        if (string2 == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('#');
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public static String actionURL(HttpServletRequest httpServletRequest, ActionConfig actionConfig, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.endsWith("/*")) {
            stringBuffer.append(string.substring(0, string.length() - 2));
            stringBuffer.append(actionConfig.getPath());
        } else if (string.startsWith("*.")) {
            ModuleConfig moduleConfig = ModuleUtils.getInstance().getModuleConfig(httpServletRequest);
            stringBuffer.append(moduleConfig.getPrefix());
            stringBuffer.append(actionConfig.getPath());
            stringBuffer.append(string.substring(1));
        } else {
            throw new IllegalArgumentException(string);
        }
        return stringBuffer.toString();
    }

    public static String forwardURL(HttpServletRequest httpServletRequest, ForwardConfig forwardConfig) {
        return RequestUtils.forwardURL(httpServletRequest, forwardConfig, null);
    }

    public static String forwardURL(HttpServletRequest httpServletRequest, ForwardConfig forwardConfig, ModuleConfig moduleConfig) {
        if (moduleConfig == null) {
            moduleConfig = ModuleUtils.getInstance().getModuleConfig(httpServletRequest);
        }
        String string = forwardConfig.getPath();
        String string2 = moduleConfig.getPrefix();
        if (forwardConfig.getModule() != null && "/".equals(string2 = forwardConfig.getModule())) {
            string2 = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (forwardConfig.getContextRelative()) {
            if (!string.startsWith("/")) {
                stringBuffer.append("/");
            }
            stringBuffer.append(string);
            return stringBuffer.toString();
        }
        String string3 = moduleConfig.getControllerConfig().getForwardPattern();
        if (string3 == null) {
            stringBuffer.append(string2);
            if (!string.startsWith("/")) {
                stringBuffer.append("/");
            }
            stringBuffer.append(string);
        } else {
            boolean bl = false;
            int n = 0;
            while (n < string3.length()) {
                char c = string3.charAt(n);
                if (bl) {
                    switch (c) {
                        case 'M': {
                            stringBuffer.append(string2);
                            break;
                        }
                        case 'P': {
                            if (!string.startsWith("/")) {
                                stringBuffer.append("/");
                            }
                            stringBuffer.append(string);
                            break;
                        }
                        case '$': {
                            stringBuffer.append('$');
                            break;
                        }
                    }
                    bl = false;
                } else if (c == '$') {
                    bl = true;
                } else {
                    stringBuffer.append(c);
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public static URL requestURL(HttpServletRequest httpServletRequest) throws MalformedURLException {
        StringBuffer stringBuffer = RequestUtils.requestToServerUriStringBuffer(httpServletRequest);
        return new URL(stringBuffer.toString());
    }

    public static URL serverURL(HttpServletRequest httpServletRequest) throws MalformedURLException {
        StringBuffer stringBuffer = RequestUtils.requestToServerStringBuffer(httpServletRequest);
        return new URL(stringBuffer.toString());
    }

    public static StringBuffer requestToServerUriStringBuffer(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = RequestUtils.createServerUriStringBuffer(httpServletRequest.getScheme(), httpServletRequest.getServerName(), httpServletRequest.getServerPort(), httpServletRequest.getRequestURI());
        return stringBuffer;
    }

    public static StringBuffer requestToServerStringBuffer(HttpServletRequest httpServletRequest) {
        return RequestUtils.createServerStringBuffer(httpServletRequest.getScheme(), httpServletRequest.getServerName(), httpServletRequest.getServerPort());
    }

    public static StringBuffer createServerStringBuffer(String string, String string2, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n < 0) {
            n = 80;
        }
        stringBuffer.append(string);
        stringBuffer.append("://");
        stringBuffer.append(string2);
        if (string.equals("http") && n != 80 || string.equals("https") && n != 443) {
            stringBuffer.append(':');
            stringBuffer.append(n);
        }
        return stringBuffer;
    }

    public static StringBuffer createServerUriStringBuffer(String string, String string2, int n, String string3) {
        StringBuffer stringBuffer = RequestUtils.createServerStringBuffer(string, string2, n);
        stringBuffer.append(string3);
        return stringBuffer;
    }

    public static void selectModule(String string, HttpServletRequest httpServletRequest, ServletContext servletContext) {
        ModuleUtils.getInstance().selectModule(string, httpServletRequest, servletContext);
    }

    public static void selectModule(HttpServletRequest httpServletRequest, ServletContext servletContext) {
        ModuleUtils.getInstance().selectModule(httpServletRequest, servletContext);
    }

    public static String getModuleName(HttpServletRequest httpServletRequest, ServletContext servletContext) {
        return ModuleUtils.getInstance().getModuleName(httpServletRequest, servletContext);
    }

    public static String getModuleName(String string, ServletContext servletContext) {
        return ModuleUtils.getInstance().getModuleName(string, servletContext);
    }

    public static ModuleConfig getRequestModuleConfig(HttpServletRequest httpServletRequest) {
        return ModuleUtils.getInstance().getModuleConfig(httpServletRequest);
    }

    public static ModuleConfig getModuleConfig(HttpServletRequest httpServletRequest, ServletContext servletContext) {
        return ModuleUtils.getInstance().getModuleConfig(httpServletRequest, servletContext);
    }

    public static String[] getModulePrefixes(ServletContext servletContext) {
        return ModuleUtils.getInstance().getModulePrefixes(servletContext);
    }

    public static Map computeParameters(PageContext pageContext, String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) throws JspException {
        return TagUtils.getInstance().computeParameters(pageContext, string, string2, string3, string4, string5, string6, string7, bl);
    }

    public static String computeURL(PageContext pageContext, String string, String string2, String string3, Map map, String string4, boolean bl) throws MalformedURLException {
        return TagUtils.getInstance().computeURLWithCharEncoding(pageContext, string, string2, string3, null, null, map, string4, bl, false);
    }

    public static String computeURL(PageContext pageContext, String string, String string2, String string3, String string4, Map map, String string5, boolean bl) throws MalformedURLException {
        return TagUtils.getInstance().computeURL(pageContext, string, string2, string3, string4, null, map, string5, bl);
    }

    public static String computeURL(PageContext pageContext, String string, String string2, String string3, String string4, Map map, String string5, boolean bl, boolean bl2) throws MalformedURLException {
        return TagUtils.getInstance().computeURL(pageContext, string, string2, string3, string4, null, map, string5, bl, bl2);
    }

    public static String getActionMappingName(String string) {
        return TagUtils.getInstance().getActionMappingName(string);
    }

    public static String getActionMappingURL(String string, PageContext pageContext) {
        return TagUtils.getInstance().getActionMappingURL(string, pageContext);
    }

    public static Object lookup(PageContext pageContext, String string, String string2) throws JspException {
        return TagUtils.getInstance().lookup(pageContext, string, string2);
    }

    public static int getScope(String string) throws JspException {
        return TagUtils.getInstance().getScope(string);
    }

    public static Object lookup(PageContext pageContext, String string, String string2, String string3) throws JspException {
        return TagUtils.getInstance().lookup(pageContext, string, string2, string3);
    }

    public static Locale retrieveUserLocale(PageContext pageContext, String string) {
        return TagUtils.getInstance().getUserLocale(pageContext, string);
    }

    public static String message(PageContext pageContext, String string, String string2, String string3) throws JspException {
        return TagUtils.getInstance().message(pageContext, string, string2, string3);
    }

    public static String message(PageContext pageContext, String string, String string2, String string3, Object[] objectArray) throws JspException {
        return TagUtils.getInstance().message(pageContext, string, string2, string3, objectArray);
    }

    public static boolean present(PageContext pageContext, String string, String string2, String string3) throws JspException {
        return TagUtils.getInstance().present(pageContext, string, string2, string3);
    }

    public static String pageURL(HttpServletRequest httpServletRequest, String string) {
        ModuleConfig moduleConfig = ModuleUtils.getInstance().getModuleConfig(httpServletRequest);
        return TagUtils.getInstance().pageURL(httpServletRequest, string, moduleConfig);
    }

    public static void saveException(PageContext pageContext, Throwable throwable) {
        TagUtils.getInstance().saveException(pageContext, throwable);
    }

    public static ModuleConfig getModuleConfig(PageContext pageContext) {
        return TagUtils.getInstance().getModuleConfig(pageContext);
    }

    public static ActionMessages getActionMessages(PageContext pageContext, String string) throws JspException {
        return TagUtils.getInstance().getActionMessages(pageContext, string);
    }

    public static ActionErrors getActionErrors(PageContext pageContext, String string) throws JspException {
        return TagUtils.getInstance().getActionErrors(pageContext, string);
    }

    public static String encodeURL(String string) {
        return TagUtils.getInstance().encodeURL(string);
    }

    public static boolean isXhtml(PageContext pageContext) {
        String string = (String)pageContext.getAttribute("org.apache.struts.globals.XHTML", 1);
        return "true".equalsIgnoreCase(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

