/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.IOBuffer;
import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TDSVersion;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

final class DBComms
implements Runnable {
    static final byte TDS_RET_STAT = 121;
    static final byte TDS_PROCID = 124;
    static final byte TDS_COLMETADATA = -127;
    static final byte TDS_TABNAME = -92;
    static final byte TDS_COLINFO = -91;
    static final byte TDS_UNKNOWN_0xA7 = -89;
    static final byte TDS_UNKNOWN_0xA8 = -88;
    static final byte TDS_ORDER = -87;
    static final byte TDS_ERR = -86;
    static final byte TDS_MSG = -85;
    static final byte TDS_RETURN_VALUE = -84;
    static final byte TDS_LOGIN_ACK = -83;
    static final byte TDS_CONTROL = -82;
    static final byte TDS_ROW = -47;
    static final byte TDS_UNKNOWN_0xE2 = -30;
    static final byte TDS_ENV_CHG = -29;
    static final byte TDS_MSG50 = -27;
    static final byte TDS_RESULT = -18;
    static final byte TDS_DONE = -3;
    static final byte TDS_DONEPROC = -2;
    static final byte TDS_DONEINPROC = -1;
    static final int PROCID_SP_CURSOR = 1;
    static final int PROCID_SP_CURSOROPEN = 2;
    static final int PROCID_SP_CURSORPREPARE = 3;
    static final int PROCID_SP_CURSOREXECUTE = 4;
    static final int PROCID_SP_CURSORPREPEXEC = 5;
    static final int PROCID_SP_CURSORUNPREPARE = 6;
    static final int PROCID_SP_CURSORFETCH = 7;
    static final int PROCID_SP_CURSOROPTION = 8;
    static final int PROCID_SP_CURSORCLOSE = 9;
    static final int PROCID_SP_EXECUTESQL = 10;
    static final int PROCID_SP_PREPARE = 11;
    static final int PROCID_SP_EXECUTE = 12;
    static final int PROCID_SP_PREPEXEC = 13;
    static final int PROCID_SP_PREPEXECRPC = 14;
    static final int PROCID_SP_UNPREPARE = 15;
    public static final int LAST_PKT_CALCULATE = 0;
    public static final int LAST_PKT_FALSE = 2;
    public static final int PKT_BUFFER_HEADER_SIZE = 8;
    public static final int PKT_STREAM_HEADER_SIZE = 22;
    public static final byte PKT_QUERY = 1;
    public static final byte PKT_LOGON65 = 2;
    public static final byte PKT_DTC = 14;
    public static final byte PKT_LOGON70 = 16;
    public static final byte PKT_PRELOGIN = 18;
    public static final byte PKT_RPC = 3;
    public static final byte PKT_REPLY = 4;
    public static final byte PKT_CANCEL_REQ = 6;
    public static final int V7_PACKET_SIZE = 4096;
    public static final byte PKT_STATUS_NORMAL = 0;
    public static final byte PKT_STATUS_EOM = 1;
    public static final byte PKT_STATUS_ATTENTION_ACK = 2;
    public static final byte PKT_STATUS_IGNORE = 3;
    public static final byte PKT_STATUS_RESET_CONN = 8;
    public OutputStream streamOut;
    public InputStream streamIn;
    private TDSVersion tdsVersion;
    private SQLServerConnection con;
    private int packetsSent;
    private int msgsSent;
    private int packetsRecd;
    private int msgsRecd;
    private byte[] streamBuffer;
    private volatile int responseTimeoutSecs;
    private volatile boolean responseTimeoutActivated;
    private boolean lastSendWasACancel;
    private IOBuffer exclusiveUser;
    private Socket databaseSocket;
    private boolean socketOpen;
    private SQLCollation databaseCollation;
    private static Logger tdsDataLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.TDS.DATA");
    static final byte B_PRELOGIN_OPTION_VERSION = 0;
    static final byte B_PRELOGIN_OPTION_ENCRYPTION = 1;
    static final byte B_PRELOGIN_OPTION_INSTOPT = 2;
    static final byte B_PRELOGIN_OPTION_THREADID = 3;
    static final byte B_PRELOGIN_OPTION_MARS = 4;
    static final byte B_PRELOGIN_OPTION_TDSVERSION = 5;
    static final byte B_PRELOGIN_OPTION_TERMINATOR = -1;
    static final byte B_PRELOGIN_SSL_OFF = 0;
    static final byte B_PRELOGIN_SSL_ON = 1;
    static final byte B_PRELOGIN_SSL_NOT_SUPPORTED = 2;
    static final byte B_PRELOGIN_SSL_REQUIRED = 3;
    static final byte B_PRELOGIN_MESSAGE_LENGTH = 26;

    final boolean isLoggingTDSPackets() {
        return tdsDataLogger.isLoggable(Level.FINEST);
    }

    public DBComms(SQLServerConnection sQLServerConnection, String string, int n) throws SQLServerException, IOException {
        this.databaseSocket = new Socket(string, n);
        this.streamOut = this.databaseSocket.getOutputStream();
        this.streamIn = this.databaseSocket.getInputStream();
        this.Prelogin(false);
        this.init(sQLServerConnection);
        try {
            this.databaseSocket.setReceiveBufferSize(4096);
            this.databaseSocket.setSendBufferSize(4096);
            this.databaseSocket.setTcpNoDelay(true);
            this.databaseSocket.setKeepAlive(true);
        }
        catch (NoSuchMethodError noSuchMethodError) {
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        this.streamOut = this.databaseSocket.getOutputStream();
        this.streamIn = this.databaseSocket.getInputStream();
    }

    void Prelogin(boolean bl) throws SQLServerException {
        int n;
        bl = false;
        byte[] byArray = new byte[]{18, 1, 0, 26, 0, 0, 0, 0, 0, 0, 11, 0, 6, 1, 0, 17, 0, 1, -1, 0, 0, 0, 0, 0, 0, bl ? (byte)1 : 2};
        try {
            this.streamOut.write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_ioErrorSendingTDSPrelogin"), "08006", true);
        }
        byte[] byArray2 = new byte[4096];
        int n2 = 0;
        int n3 = 0;
        do {
            n = 0;
            try {
                n = this.streamIn.read(byArray2, n2, byArray2.length - n2);
            }
            catch (IOException iOException) {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_ioErrorReceivingTDSPrelogin"), "08006", true);
            }
            if (-1 == n) {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_incompleteResponseIsSQL2000"), "08006", true);
            }
            if ((n2 += n) < 8 || false != n3 || n >= (n3 = byArray2[2] << 8 | byArray2[3]) && 4 == byArray2[0] && 1 == byArray2[1]) continue;
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_incompleteResponseIsSQL2000"), "08006", true);
        } while (n2 < n3);
        n = 0;
        boolean bl2 = false;
        int n4 = 3;
        int n5 = 8;
        while (true) {
            byte by;
            if (n5 + 1 >= n3) {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_inCompleteTDSPrelogin"), "08006", true);
            }
            if (-1 == (by = byArray2[n5++])) break;
            if (n5 + 5 >= n3) {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_inCompleteTDSPrelogin"), "08006", true);
            }
            int n6 = byArray2[n5++] << 8;
            int n7 = n5++;
            int n8 = byArray2[n5++] << 8;
            if ((n6 += byArray2[n7] + 8) > n3 || n6 + (n8 += byArray2[n5++]) > n3) {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_inCompleteTDSPrelogin"), "08006", true);
            }
            switch (by) {
                case 0: {
                    if (n != 0) {
                        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_unexpectedServerVersion"), "08006", true);
                    }
                    if (6 != n8) {
                        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_malformedServerVersion"), "08006", true);
                    }
                    if (9 == byArray2[n6]) {
                        this.tdsVersion = new TDSVersion(114);
                    } else if (8 == byArray2[n6]) {
                        this.tdsVersion = new TDSVersion(113);
                    } else {
                        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_unsupportedServerVersion"), "08006", true);
                    }
                    n = 1;
                    break;
                }
                case 1: {
                    if (bl2) {
                        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_unexpectedEncryptionOption"), "08006", true);
                    }
                    if (1 != n8) {
                        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_malformedEncryptionOption"), "08006", true);
                    }
                    n4 = byArray2[n6];
                    bl2 = true;
                }
            }
        }
        if (n == 0 || !bl2) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_inCompleteTDSPrelogin"), "08006", true);
        }
        if (2 != n4) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_requiresSSL"), "08006", true);
        }
    }

    private void init(SQLServerConnection sQLServerConnection) {
        this.con = sQLServerConnection;
        this.streamBuffer = new byte[4096];
        this.socketOpen = true;
    }

    public void finalize() {
        this.close();
    }

    public void close() {
        if (!this.socketOpen) {
            return;
        }
        try {
            this.databaseSocket.close();
            this.socketOpen = false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    TDSVersion getTDSVersion() {
        return this.tdsVersion;
    }

    public int maxDataSize() {
        return 4088;
    }

    public synchronized void aquireExclusiveUse(IOBuffer iOBuffer) throws SQLServerException {
        if (this.exclusiveUser != null && this.exclusiveUser != iOBuffer) {
            SQLServerException.makeFromDriverError(this.con, null, SQLServerException.getErrString("R_operationRequiresSingleUser"), null, false);
        }
        this.exclusiveUser = iOBuffer;
    }

    public void transmit(byte by, IOBuffer iOBuffer, int n, int n2, boolean bl) throws SQLServerException {
        int n3 = 0;
        int n4 = 0;
        if (this.lastSendWasACancel) {
            this.eatCancelledNotification();
        }
        this.lastSendWasACancel = by == 6;
        int n5 = 0;
        n4 = by == 1 ? iOBuffer.nCharIndex * 2 : iOBuffer.nOutIndex;
        if (n4 == 0 && !this.lastSendWasACancel) {
            SQLServerException.makeFromDriverError(this.con, null, SQLServerException.getErrString("R_noDataTransmit"), null, false);
        }
        iOBuffer.nOutIndex = 0;
        iOBuffer.nCharIndex = 0;
        this.exclusiveUser = null;
        int n6 = 0;
        try {
            while (n4 > 0 || this.lastSendWasACancel) {
                int n7 = this.streamBuffer.length - 8;
                if (this.tdsVersion.isYukonOrLater() && !iOBuffer.sentFirstPacket() && 0 == n3 && (1 == by || 14 == by || 3 == by)) {
                    n7 -= 22;
                }
                int n8 = 0;
                if (n4 > n7) {
                    n8 = n7;
                } else {
                    n8 = n4;
                    if (n2 == 0) {
                        n6 = 1;
                    }
                }
                this.streamBuffer[0] = (byte)(by & 0xFF);
                this.streamBuffer[1] = (byte)(n6 & 0xFF);
                int n9 = n8 + 8;
                if (this.tdsVersion.isYukonOrLater() && !iOBuffer.sentFirstPacket() && 0 == n3 && (1 == by || 14 == by || 3 == by)) {
                    n9 += 22;
                }
                this.streamBuffer[2] = (byte)(n9 >> 8 & 0xFF);
                this.streamBuffer[3] = (byte)(n9 >> 0 & 0xFF);
                this.streamBuffer[4] = 0;
                this.streamBuffer[5] = 0;
                this.streamBuffer[6] = 0;
                this.streamBuffer[7] = 0;
                if (this.tdsVersion.isYukonOrLater() && !iOBuffer.sentFirstPacket() && 0 == n3 && (1 == by || 14 == by || 3 == by)) {
                    this.streamBuffer[8] = 22;
                    this.streamBuffer[9] = 0;
                    this.streamBuffer[10] = 0;
                    this.streamBuffer[11] = 0;
                    this.streamBuffer[12] = 18;
                    this.streamBuffer[13] = 0;
                    this.streamBuffer[14] = 0;
                    this.streamBuffer[15] = 0;
                    this.streamBuffer[16] = 2;
                    this.streamBuffer[17] = 0;
                    iOBuffer.getSQLServerConnection().getTransactionDescriptor().serialize(this.streamBuffer, 18);
                    this.streamBuffer[26] = 1;
                    this.streamBuffer[27] = 0;
                    this.streamBuffer[28] = 0;
                    this.streamBuffer[29] = 0;
                }
                if (by == 1) {
                    int n10 = 0;
                    char[] cArray = iOBuffer.charDataBuffer;
                    while (n10 < n8) {
                        char c = cArray[n5++];
                        this.streamBuffer[n9 - n8 + n10++] = (byte)(0xFF & c);
                        this.streamBuffer[n9 - n8 + n10++] = (byte)(c >> 8 & 0xFF);
                    }
                } else {
                    System.arraycopy(iOBuffer.binDataBuffer, n3, this.streamBuffer, n9 - n8, n8);
                }
                if (tdsDataLogger.isLoggable(Level.FINEST) && 16 != by) {
                    this.logTDSPacket(this.streamBuffer, 0, n9, "Sending TDS packet: " + n9 + " bytes");
                }
                this.streamOut.write(this.streamBuffer, 0, n9);
                if (this.lastSendWasACancel) break;
                n3 += n8;
                n4 -= n8;
                ++this.packetsSent;
            }
            this.streamOut.flush();
        }
        catch (IOException iOException) {
            if (this.con != null) {
                this.con.notifyPooledConnection(iOException);
            }
            String string = "";
            if (this.con != null) {
                string = string + "(" + this.con.connectionID + ") ";
                string = string + this.con.instanceId();
            }
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_transmitException"));
            Object[] objectArray = new Object[]{iOException.getMessage(), string};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), "08006", !bl);
        }
        ++this.msgsSent;
    }

    public void run() {
        try {
            for (int i = 0; i < this.responseTimeoutSecs; ++i) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                Thread.currentThread();
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        try {
            this.responseTimeoutActivated = true;
            IOBuffer iOBuffer = new IOBuffer(this, 4096);
            this.transmit((byte)6, iOBuffer, 0, 0, false);
        }
        catch (SQLServerException sQLServerException) {
            // empty catch block
        }
    }

    private void readError(String string, int n, int n2) throws SQLServerException {
        if (this.con != null) {
            this.con.notifyPooledConnection(new IOException(string));
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_errReadingInput"));
        Object[] objectArray = new Object[]{string, new Integer(n), new Integer(n2), new Integer(4096)};
        SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), "08006", true);
    }

    public void receive(byte by, IOBuffer iOBuffer, int n, boolean bl) throws SQLServerException {
        iOBuffer.resetInBuffer();
        boolean bl2 = true;
        int n2 = 0;
        int n3 = 16384;
        Thread thread = null;
        Throwable throwable = null;
        while (bl2) {
            try {
                int n4;
                Object[] objectArray;
                byte by2;
                int n5;
                int n6 = 0;
                if (n > 0) {
                    thread = new Thread(this);
                    thread.setDaemon(true);
                    this.responseTimeoutSecs = n;
                    this.responseTimeoutActivated = false;
                    thread.start();
                }
                while (n6 < 8) {
                    n5 = this.streamIn.read(this.streamBuffer, n6, 8 - n6);
                    if (n5 < 0) {
                        this.readError("Read packet header, Unexpected end of stream, readBytes:" + n5, n2, n6);
                        continue;
                    }
                    n6 += n5;
                }
                if (tdsDataLogger.isLoggable(Level.FINEST)) {
                    this.logTDSPacket(this.streamBuffer, 0, 8, "Received TDS packet header");
                }
                if (thread != null) {
                    thread.interrupt();
                    thread = null;
                }
                if ((by2 = this.streamBuffer[0]) != 4 && by2 != 2 && by2 != 1) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPacketHeader"));
                    objectArray = new Object[]{new Byte(by2), new Integer(n2), new Integer(n6)};
                    SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), "08006", true);
                }
                if ((n4 = (this.streamBuffer[3] & 0xFF | (this.streamBuffer[2] & 0xFF) << 8) - 8) < 0) {
                    objectArray = new MessageFormat(SQLServerException.getErrString("R_negativeDataPacketLength"));
                    Object[] objectArray2 = new Object[]{new Integer(n4), new Integer(n2), new Integer(n6), new Integer(n4)};
                    SQLServerException.makeFromDriverError(this.con, null, objectArray.format(objectArray2), "08006", true);
                }
                bl2 = this.streamBuffer[1] != 1;
                int n7 = this.streamBuffer[4] << 8 | this.streamBuffer[5];
                int n8 = iOBuffer.nRecvSize + n4;
                if (null == throwable && n8 > iOBuffer.binDataBuffer.length) {
                    try {
                        if (n8 > iOBuffer.binDataBuffer.length + n3) {
                            n3 = n8 - iOBuffer.binDataBuffer.length;
                        }
                        iOBuffer.extendByteBuffer(n3);
                        if ((n3 *= 4) > 0x400000) {
                            n3 = 0x400000;
                        }
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throwable = outOfMemoryError;
                        iOBuffer.binDataBuffer = null;
                        iOBuffer.extendByteBuffer(256);
                    }
                }
                n6 = 0;
                while (n6 < n4) {
                    if (null == throwable) {
                        n5 = this.streamIn.read(iOBuffer.binDataBuffer, iOBuffer.nRecvSize, n4 - n6);
                        if (tdsDataLogger.isLoggable(Level.FINEST)) {
                            this.logTDSPacket(iOBuffer.binDataBuffer, iOBuffer.nRecvSize, n5, "SPID " + n7 + ", Received TDS packet " + n2 + " payload: " + n5 + " bytes");
                        }
                    } else {
                        n5 = this.streamIn.read(this.streamBuffer, 0, n4 - n6);
                        if (tdsDataLogger.isLoggable(Level.FINEST)) {
                            this.logTDSPacket(this.streamBuffer, 0, n5, "SPID " + n7 + ", Ignored TDS packet " + n2 + " payload: " + n5 + " bytes");
                        }
                    }
                    if (n5 < 0) {
                        this.readError("Failed to read packet body", n2, n6);
                    }
                    n6 += n5;
                    iOBuffer.nRecvSize += n5;
                }
            }
            catch (IOException iOException) {
                if (thread != null) {
                    thread = null;
                    if (this.responseTimeoutActivated) {
                        SQLServerException.makeFromDriverError(this.con, null, SQLServerException.getErrString("R_queryTimedOut"), null, false);
                    }
                }
                if (this.con != null) {
                    this.con.notifyPooledConnection(iOException);
                }
                String string = "";
                if (this.con != null) {
                    string = string + "(" + this.con.connectionID + ") ";
                    string = string + this.con.instanceId();
                }
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_receiveException"));
                Object[] objectArray = new Object[]{iOException.getMessage(), string, new Integer(n2), new Integer(iOBuffer.nRecvSize), new Integer(4096)};
                SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), "08006", !bl);
            }
            ++n2;
        }
        ++this.msgsRecd;
        if (null != throwable && !this.lastSendWasACancel) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_outOfMemory"));
            Object[] objectArray = new Object[]{throwable.getMessage(), new Integer(iOBuffer.nRecvSize), new Long(Runtime.getRuntime().totalMemory())};
            SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, false);
        }
        if (this.lastSendWasACancel) {
            this.eatCancelledNotification();
            SQLServerException.makeFromDriverError(this.con, null, SQLServerException.getErrString("R_queryCancelled"), null, false);
        }
    }

    void logTDSPacket(byte[] byArray, int n, int n2, String string) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] cArray2 = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};
        char[] cArray3 = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};
        char[] cArray4 = new char[cArray3.length];
        System.arraycopy(cArray3, 0, cArray4, 0, cArray3.length);
        StringBuffer stringBuffer = new StringBuffer(string.length() + 4 * n2 + 4 * (1 + n2 / 16) + 80);
        stringBuffer.append(this.databaseSocket.getLocalAddress().toString() + ":" + this.databaseSocket.getLocalPort() + " Connection ");
        stringBuffer.append(this.con.connectionID);
        stringBuffer.append(", ");
        stringBuffer.append(string);
        stringBuffer.append("\r\n");
        int n3 = 0;
        while (true) {
            int n4;
            int n5;
            for (n5 = 0; n5 < 16 && n3 < n2; ++n5, ++n3) {
                n4 = (byArray[n3] + 256) % 256;
                cArray4[3 * n5] = cArray[n4 / 16];
                cArray4[3 * n5 + 1] = cArray[n4 % 16];
                cArray4[50 + n5] = cArray2[n4];
            }
            for (n4 = n5; n4 < 16; ++n4) {
                cArray4[3 * n4] = 32;
                cArray4[3 * n4 + 1] = 32;
            }
            stringBuffer.append(cArray4, 0, 50 + n5);
            if (n3 == n2) break;
            stringBuffer.append("\r\n");
        }
        tdsDataLogger.finest(stringBuffer.toString());
    }

    public void eatCancelledNotification() {
        try {
            do {
                if (this.streamIn.available() != 0) continue;
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.streamIn.available() == 0) break;
            } while (this.streamIn.read() >= 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean socketIsOpen() {
        return this.socketOpen;
    }

    SQLCollation getDatabaseCollation() {
        return this.databaseCollation;
    }

    String getDatabaseCharset() throws SQLServerException {
        if (null == this.databaseCollation) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_charSetNotAvailableForDatabase"), null, 0, true);
        }
        return this.databaseCollation.getCharset();
    }

    void setDatabaseCollation(SQLCollation sQLCollation) {
        this.databaseCollation = sQLCollation;
    }
}

