/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.parser.ASTIdentifier;
import org.apache.commons.jexl2.parser.ASTJexlScript;
import org.apache.commons.jexl2.parser.ASTReference;
import org.apache.commons.jexl2.parser.Node;
import org.apache.commons.jexl2.parser.Parser;

public class ExpressionCollectionParser {
    public static final Map<String, Expression> expressionCache = new HashMap<String, Expression>();
    public static final String COLLECTION_REFERENCE_SUFFIX = "_JxLsC_";
    private static final JexlEngine jexlEngine = new JexlEngine();
    private static ThreadLocal parser;
    private boolean jexlInnerCollectionsAccess;
    private String collectionExpression;
    private Collection collection;

    static {
        jexlEngine.setDebug(false);
        parser = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new Parser((Reader)new StringReader(";"));
            }
        };
    }

    public static void clearCache() {
        expressionCache.clear();
    }

    public ExpressionCollectionParser(JexlContext jexlContext, String expr, boolean jexlInnerCollectionsAccess) {
        try {
            this.jexlInnerCollectionsAccess = jexlInnerCollectionsAccess;
            ASTJexlScript tree = ((Parser)parser.get()).parse((Reader)new StringReader(expr), null);
            ArrayList references = new ArrayList();
            this.findReferences(references, (Node)tree);
            this.findCollection(jexlContext, references);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getCollectionExpression() {
        return this.collectionExpression;
    }

    public Collection getCollection() {
        return this.collection;
    }

    private void findReferences(List references, Node node) {
        if (node instanceof ASTReference) {
            references.add(node);
        }
        int childCount = node.jjtGetNumChildren();
        int i = 0;
        while (i < childCount) {
            this.findReferences(references, node.jjtGetChild(i));
            ++i;
        }
    }

    private void findCollection(JexlContext jexlContext, List references) {
        for (Node node : references) {
            String newExpression = this.findCollectionProperties(jexlContext, node);
            if (newExpression == null) continue;
            if (newExpression.endsWith(COLLECTION_REFERENCE_SUFFIX)) break;
            this.collectionExpression = newExpression;
            break;
        }
    }

    private String findCollectionProperties(JexlContext jexlContext, Node node) {
        int childCount = node.jjtGetNumChildren();
        String subExpr = null;
        int i = 0;
        while (i < childCount) {
            Node child = node.jjtGetChild(i);
            if (child instanceof ASTIdentifier) {
                ASTIdentifier ident = (ASTIdentifier)child;
                subExpr = subExpr == null ? ident.image : String.valueOf(subExpr) + "." + ident.image;
                if (this.jexlInnerCollectionsAccess && subExpr.endsWith(COLLECTION_REFERENCE_SUFFIX)) {
                    return subExpr;
                }
                try {
                    Object obj;
                    Expression e = expressionCache.get(subExpr);
                    if (e == null) {
                        e = jexlEngine.createExpression(subExpr);
                        expressionCache.put(subExpr, e);
                    }
                    if ((obj = e.evaluate(jexlContext)) instanceof Collection) {
                        this.collection = (Collection)obj;
                        return subExpr;
                    }
                }
                catch (Exception e) {
                    return null;
                }
            }
            ++i;
        }
        return null;
    }
}

