/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.parser;

import java.util.Collection;
import java.util.Map;
import net.sf.jxls.parser.ExpressionCollectionParser;
import net.sf.jxls.transformer.Configuration;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Property {
    protected static final Log log = LogFactory.getLog(Property.class);
    private Object bean;
    private String collectionName;
    private Collection collection;
    private String property;
    private Object propertyValue;
    Configuration config;

    public Property(String value) {
        this.propertyValue = value;
    }

    public Property(String property, Map beans, Configuration config) {
        this.property = property;
        this.config = config;
        this.propertyValue = this.getPropertyValue(beans);
    }

    public boolean isConstant() {
        return this.property == null;
    }

    public Object getPropertyValue(Map beans) {
        MapContext context = new MapContext(beans);
        ExpressionCollectionParser parser = new ExpressionCollectionParser((JexlContext)context, String.valueOf(this.property) + ";", this.config.isJexlInnerCollectionsAccess());
        if (parser.getCollection() == null) {
            this.propertyValue = null;
        } else {
            this.collectionName = parser.getCollectionExpression();
            this.collection = parser.getCollection();
            this.bean = null;
        }
        return this.propertyValue;
    }

    public boolean isCollection() {
        return this.collectionName != null;
    }

    public boolean isNull() {
        return this.getPropertyValue() == null;
    }

    public String getBeanName() {
        return null;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getProperty() {
        return this.property;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public void setCollection(Collection collection) {
        this.collection = collection;
    }

    public String getFullCollectionName() {
        return this.collectionName;
    }

    public String getPropertyNameAfterLastDot() {
        String propertyName = null;
        if (this.property != null) {
            int dotIndex = this.property.lastIndexOf(".");
            propertyName = dotIndex >= 0 ? this.property.substring(dotIndex + 1) : this.property;
        }
        return propertyName;
    }

    public String getPropertyNameAfterFirstDot() {
        String propertyName = null;
        if (this.property != null) {
            int dotIndex = this.property.indexOf(".");
            propertyName = dotIndex >= 0 ? this.property.substring(dotIndex + 1) : this.property;
        }
        return propertyName;
    }

    public String toString() {
        return "Property{property='" + this.property + "'}";
    }

    public Object getPropertyValue() {
        if (this.bean instanceof String) {
            return this.bean;
        }
        return this.propertyValue;
    }

    public void setPropertyValue(Object propertyValue) {
        this.propertyValue = propertyValue;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }
}

