/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.tag;

import org.apache.poi.ss.util.CellReference;

public class Point {
    int row;
    short col;

    public Point(int row, short col) {
        this.row = row;
        this.col = col;
    }

    public Point(String refCell) {
        CellReference cellReference = new CellReference(refCell);
        this.row = cellReference.getRow();
        this.col = cellReference.getCol();
    }

    public Point shift(int rowOffset, int colOffset) {
        return new Point(this.row + rowOffset, (short)(this.col + colOffset));
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public short getCol() {
        return this.col;
    }

    public void setCol(short col) {
        this.col = col;
    }

    public String getCellRef() {
        CellReference cellRef = new CellReference(this.row, (int)this.col, false, false);
        return cellRef.formatAsString();
    }

    public String toString() {
        return "(" + this.row + "," + this.col + ")";
    }

    public String toString(String sheetName) {
        CellReference cellRef = new CellReference(this.row, (int)this.col, false, false);
        String cellname = sheetName != null ? String.valueOf(sheetName) + "!" + cellRef.formatAsString() : cellRef.formatAsString();
        return cellname;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Point point = (Point)o;
        if (this.col != point.col) {
            return false;
        }
        return this.row == point.row;
    }

    public int hashCode() {
        int result = this.row;
        result = 29 * result + this.col;
        return result;
    }
}

