/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.util;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.sf.jxls.parser.Cell;
import net.sf.jxls.transformer.Row;
import net.sf.jxls.transformer.RowCollection;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;

public final class Util {
    protected static final Log log = LogFactory.getLog(Util.class);
    private static final String[][] ENTITY_ARRAY = new String[][]{{"quot", "34"}, {"amp", "38"}, {"lt", "60"}, {"gt", "62"}, {"apos", "39"}};
    private static Map xmlEntities = new HashMap();
    protected static final String regexCellRef = "[a-zA-Z]+[0-9]+";
    protected static final Pattern regexCellRefPattern;
    protected static final String regexCellCharPart = "[0-9]+";
    protected static final String regexCellDigitPart = "[a-zA-Z]+";
    protected static final String cellRangeSeparator = ":";

    static {
        int i = 0;
        while (i < ENTITY_ARRAY.length) {
            xmlEntities.put(ENTITY_ARRAY[i][1], ENTITY_ARRAY[i][0]);
            ++i;
        }
        regexCellRefPattern = Pattern.compile(regexCellRef);
    }

    public static void removeRowCollectionPropertiesFromRow(RowCollection rowCollection) {
        int startRow = rowCollection.getParentRow().getPoiRow().getRowNum();
        Sheet sheet = rowCollection.getParentRow().getSheet().getPoiSheet();
        int i = 0;
        int c = rowCollection.getDependentRowNumber();
        while (i <= c) {
            org.apache.poi.ss.usermodel.Row hssfRow = sheet.getRow(startRow + i);
            if (hssfRow.getFirstCellNum() >= 0 && hssfRow.getLastCellNum() >= 0) {
                int j = hssfRow.getFirstCellNum();
                short c2 = hssfRow.getLastCellNum();
                while (j <= c2) {
                    org.apache.poi.ss.usermodel.Cell cell = hssfRow.getCell(j);
                    Util.removeRowCollectionPropertyFromCell(cell, rowCollection.getCollectionProperty().getFullCollectionName());
                    ++j;
                }
            }
            ++i;
        }
    }

    private static void removeRowCollectionPropertyFromCell(org.apache.poi.ss.usermodel.Cell cell, String collectionName) {
        String regex = "[-+*/().A-Za-z_0-9\\s]*";
        if (cell != null && cell.getCellType() == 1) {
            String cellValue = cell.getRichStringCellValue().getString();
            String strToReplace = "\\$\\{" + regex + collectionName.replaceAll("\\.", "\\\\.") + "\\." + regex + "\\}";
            cell.setCellValue(cell.getSheet().getWorkbook().getCreationHelper().createRichTextString(cellValue.replaceAll(strToReplace, "")));
        }
    }

    public static void removeMergedRegion(Sheet sheet, CellRangeAddress region) {
        int index = Util.getMergedRegionIndex(sheet, region);
        if (index >= 0) {
            sheet.removeMergedRegion(index);
        }
    }

    private static int getMergedRegionIndex(Sheet sheet, CellRangeAddress mergedRegion) {
        int i = 0;
        int c = sheet.getNumMergedRegions();
        while (i < c) {
            CellRangeAddress region = Util.getMergedRegion(sheet, i);
            if (Util.areRegionsEqual(region, mergedRegion)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean areRegionsEqual(CellRangeAddress region1, CellRangeAddress region2) {
        if (region1 == null && region2 != null || region1 != null && region2 == null) {
            return false;
        }
        if (region1 == null) {
            return true;
        }
        return region1.getFirstColumn() == region2.getFirstColumn() && region1.getLastColumn() == region2.getLastColumn() && region1.getFirstRow() == region2.getFirstRow() && region2.getLastRow() == region2.getLastRow();
    }

    private static CellRangeAddress getMergedRegion(Sheet sheet, int i) {
        CellRangeAddress region = sheet.getMergedRegion(i);
        return region;
    }

    protected static boolean isNewMergedRegion(CellRangeAddress region, Collection mergedRegions) {
        for (CellRangeAddress cellRangeAddress : mergedRegions) {
            if (!Util.areRegionsEqual(cellRangeAddress, region)) continue;
            return false;
        }
        return true;
    }

    public static CellRangeAddress getMergedRegion(Sheet sheet, int rowNum, int cellNum) {
        int i = 0;
        int c = sheet.getNumMergedRegions();
        while (i < c) {
            CellRangeAddress merged = Util.getMergedRegion(sheet, i);
            if (Util.isRangeContainsCell(merged, rowNum, cellNum)) {
                return merged;
            }
            ++i;
        }
        return null;
    }

    public static boolean isRangeContainsCell(CellRangeAddress range, int row, int col) {
        return range.getFirstRow() <= row && range.getLastRow() >= row && range.getFirstColumn() <= col && range.getLastColumn() >= col;
    }

    public static boolean removeMergedRegion(Sheet sheet, int rowNum, int cellNum) {
        TreeSet<Integer> mergedRegionNumbersToRemove = new TreeSet<Integer>();
        int i = 0;
        int c = sheet.getNumMergedRegions();
        while (i < c) {
            CellRangeAddress merged = Util.getMergedRegion(sheet, i);
            if (Util.isRangeContainsCell(merged, rowNum, cellNum)) {
                mergedRegionNumbersToRemove.add(i);
            }
            ++i;
        }
        for (Integer regionNumber : mergedRegionNumbersToRemove) {
            sheet.removeMergedRegion(regionNumber.intValue());
        }
        return !mergedRegionNumbersToRemove.isEmpty();
    }

    public static void prepareCollectionPropertyInRowForDuplication(RowCollection rowCollection, String collectionItemName) {
        int startRow = rowCollection.getParentRow().getPoiRow().getRowNum();
        Sheet sheet = rowCollection.getParentRow().getSheet().getPoiSheet();
        int i = 0;
        int c = rowCollection.getDependentRowNumber();
        while (i <= c) {
            org.apache.poi.ss.usermodel.Row hssfRow = sheet.getRow(startRow + i);
            if (hssfRow.getFirstCellNum() >= 0 && hssfRow.getLastCellNum() >= 0) {
                int j = hssfRow.getFirstCellNum();
                short c2 = hssfRow.getLastCellNum();
                while (j <= c2) {
                    org.apache.poi.ss.usermodel.Cell cell = hssfRow.getCell(j);
                    Util.prepareCollectionPropertyInCellForDuplication(cell, rowCollection.getCollectionProperty().getFullCollectionName(), collectionItemName);
                    ++j;
                }
            }
            ++i;
        }
    }

    private static void prepareCollectionPropertyInCellForDuplication(org.apache.poi.ss.usermodel.Cell cell, String collectionName, String collectionItemName) {
        if (cell != null && cell.getCellType() == 1) {
            String cellValue = cell.getRichStringCellValue().getString();
            String newValue = Util.replaceCollectionProperty(cellValue, collectionName, collectionItemName);
            cell.setCellValue(cell.getSheet().getWorkbook().getCreationHelper().createRichTextString(newValue));
        }
    }

    private static String replaceCollectionProperty(String property, String collectionName, String newValue) {
        return property.replaceAll(collectionName, newValue);
    }

    public static void prepareCollectionPropertyInRowForContentDuplication(RowCollection rowCollection) {
        int i = 0;
        int c = rowCollection.getCells().size();
        while (i < c) {
            Cell cell = (Cell)rowCollection.getCells().get(i);
            Util.prepareCollectionPropertyInCellForDuplication(cell.getPoiCell(), rowCollection.getCollectionProperty().getFullCollectionName(), rowCollection.getCollectionItemName());
            ++i;
        }
    }

    public static void duplicateRowCollectionProperty(RowCollection rowCollection) {
        Collection collection = rowCollection.getCollectionProperty().getCollection();
        int rowNum = rowCollection.getParentRow().getPoiRow().getRowNum();
        org.apache.poi.ss.usermodel.Row srcRow = rowCollection.getParentRow().getPoiRow();
        Sheet sheet = rowCollection.getParentRow().getSheet().getPoiSheet();
        if (collection.size() > 1) {
            int i = 1;
            int c = collection.size();
            while (i < c) {
                org.apache.poi.ss.usermodel.Row destRow = sheet.getRow(rowNum + i);
                int j = 0;
                while (j < rowCollection.getCells().size()) {
                    Cell cell = (Cell)rowCollection.getCells().get(j);
                    if (!cell.isEmpty()) {
                        org.apache.poi.ss.usermodel.Cell destCell = destRow.getCell(cell.getPoiCell().getColumnIndex());
                        if (destCell == null) {
                            destCell = destRow.createCell(cell.getPoiCell().getColumnIndex());
                        }
                        Util.copyCell(srcRow.getCell(cell.getPoiCell().getColumnIndex()), destCell, false);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public static int duplicateRow(RowCollection rowCollection) {
        Collection collection = rowCollection.getCollectionProperty().getCollection();
        int row = rowCollection.getParentRow().getPoiRow().getRowNum();
        Sheet sheet = rowCollection.getParentRow().getSheet().getPoiSheet();
        if (collection.size() > 1) {
            if (rowCollection.getDependentRowNumber() == 0) {
                Util.shiftRows(sheet, row + 1, sheet.getLastRowNum(), collection.size() - 1);
                Util.duplicateStyle(rowCollection, row, row + 1, collection.size() - 1);
                Util.shiftUncoupledCellsUp(rowCollection);
            } else {
                int i = 0;
                int c = collection.size() - 1;
                while (i < c) {
                    Util.shiftCopyRowCollection(rowCollection);
                    ++i;
                }
                Util.shiftUncoupledCellsUp(rowCollection);
            }
        }
        return (collection.size() - 1) * (rowCollection.getDependentRowNumber() + 1);
    }

    private static void shiftCopyRowCollection(RowCollection rowCollection) {
        Sheet hssfSheet = rowCollection.getParentRow().getSheet().getPoiSheet();
        int startRow = rowCollection.getParentRow().getPoiRow().getRowNum();
        int num = rowCollection.getDependentRowNumber();
        Util.shiftRows(hssfSheet, startRow + num + 1, hssfSheet.getLastRowNum(), num + 1);
        Util.copyRowCollection(rowCollection);
    }

    private static void copyRowCollection(RowCollection rowCollection) {
        Sheet sheet = rowCollection.getParentRow().getSheet().getPoiSheet();
        int from = rowCollection.getParentRow().getPoiRow().getRowNum();
        int num = rowCollection.getDependentRowNumber() + 1;
        int to = from + num;
        HashSet<CellRangeAddress> mergedRegions = new HashSet<CellRangeAddress>();
        int i = from;
        while (i < to) {
            org.apache.poi.ss.usermodel.Row srcRow = sheet.getRow(i);
            org.apache.poi.ss.usermodel.Row destRow = sheet.getRow(to + i - from);
            if (destRow == null) {
                destRow = sheet.createRow(to + i - from);
            }
            if (srcRow.getHeight() >= 0) {
                destRow.setHeight(srcRow.getHeight());
            }
            if (srcRow.getFirstCellNum() >= 0 && srcRow.getLastCellNum() >= 0) {
                int j = srcRow.getFirstCellNum();
                short c2 = srcRow.getLastCellNum();
                while (j <= c2) {
                    org.apache.poi.ss.usermodel.Cell srcCell = srcRow.getCell(j);
                    if (srcCell != null) {
                        CellRangeAddress newMergedRegion;
                        org.apache.poi.ss.usermodel.Cell destCell = destRow.createCell(j);
                        Util.copyCell(srcCell, destCell, true);
                        CellRangeAddress mergedRegion = Util.getMergedRegion(sheet, i, j);
                        if (mergedRegion != null && Util.isNewMergedRegion(newMergedRegion = new CellRangeAddress(to - from + mergedRegion.getFirstRow(), to - from + mergedRegion.getLastRow(), mergedRegion.getFirstColumn(), mergedRegion.getLastColumn()), mergedRegions)) {
                            mergedRegions.add(newMergedRegion);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        for (CellRangeAddress region : mergedRegions) {
            sheet.addMergedRegion(region);
        }
    }

    private static void shiftUncoupledCellsUp(RowCollection rowCollection) {
        Row row = rowCollection.getParentRow();
        if (row.getCells().size() > rowCollection.getCells().size()) {
            int i = 0;
            while (i < row.getCells().size()) {
                Cell cell = (Cell)row.getCells().get(i);
                if (!rowCollection.containsCell(cell)) {
                    Util.shiftColumnUp(cell, row.getPoiRow().getRowNum() + rowCollection.getCollectionProperty().getCollection().size(), rowCollection.getCollectionProperty().getCollection().size() - 1);
                }
                ++i;
            }
        }
    }

    private static void shiftColumnUp(Cell cell, int startRow, int shiftNumber) {
        Sheet sheet = cell.getRow().getSheet().getPoiSheet();
        int cellNum = cell.getPoiCell().getColumnIndex();
        ArrayList<CellRangeAddress> hssfMergedRegions = new ArrayList<CellRangeAddress>();
        int i = startRow;
        int c = sheet.getLastRowNum();
        while (i <= c) {
            CellRangeAddress region = Util.getMergedRegion(sheet, i, cellNum);
            if (region != null && Util.isNewMergedRegion(region, hssfMergedRegions)) {
                hssfMergedRegions.add(region);
            }
            ++i;
        }
        i = startRow;
        while (i <= sheet.getLastRowNum()) {
            if (sheet.getRow(i).getCell(cellNum) != null) {
                org.apache.poi.ss.usermodel.Cell destCell = sheet.getRow(i - shiftNumber).getCell(cellNum);
                if (destCell == null) {
                    destCell = sheet.getRow(i - shiftNumber).createCell(cellNum);
                }
                Util.moveCell(sheet.getRow(i).getCell(cellNum), destCell);
            }
            ++i;
        }
        Iterator iterator = hssfMergedRegions.iterator();
        while (iterator.hasNext()) {
            Util.removeMergedRegion(sheet, (CellRangeAddress)iterator.next());
        }
        for (CellRangeAddress region : hssfMergedRegions) {
            CellRangeAddress newRegion = new CellRangeAddress(region.getFirstRow() - shiftNumber, region.getLastRow() - shiftNumber, region.getFirstColumn(), region.getLastColumn());
            sheet.addMergedRegion(newRegion);
        }
        i = sheet.getLastRowNum();
        while (sheet.getRow(i).getCell(cellNum) == null && i >= startRow) {
            --i;
        }
        int j = 0;
        while (j < shiftNumber && i >= startRow) {
            if (sheet.getRow(i).getCell(cellNum) != null) {
                sheet.getRow(i).removeCell(sheet.getRow(i).getCell(cellNum));
            }
            ++j;
            --i;
        }
    }

    private static void moveCell(org.apache.poi.ss.usermodel.Cell srcCell, org.apache.poi.ss.usermodel.Cell destCell) {
        destCell.setCellStyle(srcCell.getCellStyle());
        switch (srcCell.getCellType()) {
            case 1: {
                destCell.setCellValue(srcCell.getRichStringCellValue());
                break;
            }
            case 0: {
                destCell.setCellValue(srcCell.getNumericCellValue());
                break;
            }
            case 3: {
                destCell.setCellType(3);
                break;
            }
            case 4: {
                destCell.setCellValue(srcCell.getBooleanCellValue());
                break;
            }
            case 5: {
                destCell.setCellErrorValue(srcCell.getErrorCellValue());
                break;
            }
            case 2: {
                break;
            }
        }
        srcCell.setCellType(3);
    }

    private static void duplicateStyle(RowCollection rowCollection, int rowToCopy, int startRow, int num) {
        Sheet sheet = rowCollection.getParentRow().getSheet().getPoiSheet();
        HashSet<CellRangeAddress> mergedRegions = new HashSet<CellRangeAddress>();
        org.apache.poi.ss.usermodel.Row srcRow = sheet.getRow(rowToCopy);
        int i = startRow;
        while (i < startRow + num) {
            org.apache.poi.ss.usermodel.Row destRow = sheet.getRow(i);
            if (destRow == null) {
                destRow = sheet.createRow(i);
            }
            if (srcRow.getHeight() >= 0) {
                destRow.setHeight(srcRow.getHeight());
            }
            int j = 0;
            int c2 = rowCollection.getCells().size();
            while (j < c2) {
                Cell cell = (Cell)rowCollection.getCells().get(j);
                org.apache.poi.ss.usermodel.Cell hssfCell = cell.getPoiCell();
                if (hssfCell != null) {
                    CellRangeAddress newMergedRegion;
                    org.apache.poi.ss.usermodel.Cell newCell = destRow.createCell(hssfCell.getColumnIndex());
                    Util.copyCell(hssfCell, newCell, true);
                    CellRangeAddress mergedRegion = Util.getMergedRegion(sheet, rowToCopy, hssfCell.getColumnIndex());
                    if (mergedRegion != null && Util.isNewMergedRegion(newMergedRegion = new CellRangeAddress(i, i + mergedRegion.getLastRow() - mergedRegion.getFirstRow(), mergedRegion.getFirstColumn(), mergedRegion.getLastColumn()), mergedRegions)) {
                        mergedRegions.add(newMergedRegion);
                        sheet.addMergedRegion(newMergedRegion);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public static void copyRow(Sheet sheet, org.apache.poi.ss.usermodel.Row oldRow, org.apache.poi.ss.usermodel.Row newRow) {
        HashSet<CellRangeAddress> mergedRegions = new HashSet<CellRangeAddress>();
        if (oldRow.getHeight() >= 0) {
            newRow.setHeight(oldRow.getHeight());
        }
        if (oldRow.getFirstCellNum() >= 0 && oldRow.getLastCellNum() >= 0) {
            int j = oldRow.getFirstCellNum();
            short c = oldRow.getLastCellNum();
            while (j <= c) {
                org.apache.poi.ss.usermodel.Cell oldCell = oldRow.getCell(j);
                org.apache.poi.ss.usermodel.Cell newCell = newRow.getCell(j);
                if (oldCell != null) {
                    CellRangeAddress newMergedRegion;
                    if (newCell == null) {
                        newCell = newRow.createCell(j);
                    }
                    Util.copyCell(oldCell, newCell, true);
                    CellRangeAddress mergedRegion = Util.getMergedRegion(sheet, oldRow.getRowNum(), oldCell.getColumnIndex());
                    if (mergedRegion != null && Util.isNewMergedRegion(newMergedRegion = new CellRangeAddress(newRow.getRowNum(), newRow.getRowNum() + mergedRegion.getLastRow() - mergedRegion.getFirstRow(), mergedRegion.getFirstColumn(), mergedRegion.getLastColumn()), mergedRegions)) {
                        mergedRegions.add(newMergedRegion);
                        sheet.addMergedRegion(newMergedRegion);
                    }
                }
                ++j;
            }
        }
    }

    public static void copyRow(Sheet srcSheet, Sheet destSheet, org.apache.poi.ss.usermodel.Row srcRow, org.apache.poi.ss.usermodel.Row destRow) {
        TreeSet<CellRangeAddress> mergedRegions = new TreeSet<CellRangeAddress>();
        if (srcRow.getHeight() >= 0) {
            destRow.setHeight(srcRow.getHeight());
        }
        if (srcRow.getFirstCellNum() >= 0 && srcRow.getLastCellNum() >= 0) {
            int j = srcRow.getFirstCellNum();
            short c = srcRow.getLastCellNum();
            while (j <= c) {
                org.apache.poi.ss.usermodel.Cell oldCell = srcRow.getCell(j);
                org.apache.poi.ss.usermodel.Cell newCell = destRow.getCell(j);
                if (oldCell != null) {
                    CellRangeAddress newMergedRegion;
                    if (newCell == null) {
                        newCell = destRow.createCell(j);
                    }
                    Util.copyCell(oldCell, newCell, true);
                    CellRangeAddress mergedRegion = Util.getMergedRegion(srcSheet, srcRow.getRowNum(), oldCell.getColumnIndex());
                    if (mergedRegion != null && Util.isNewMergedRegion(newMergedRegion = new CellRangeAddress(mergedRegion.getFirstRow(), mergedRegion.getLastRow(), mergedRegion.getFirstColumn(), mergedRegion.getLastColumn()), mergedRegions)) {
                        mergedRegions.add(newMergedRegion);
                        destSheet.addMergedRegion(newMergedRegion);
                    }
                }
                ++j;
            }
        }
    }

    public static void copyRow(Sheet srcSheet, Sheet destSheet, org.apache.poi.ss.usermodel.Row srcRow, org.apache.poi.ss.usermodel.Row destRow, String expressionToReplace, String expressionReplacement) {
        HashSet<CellRangeAddress> mergedRegions = new HashSet<CellRangeAddress>();
        if (srcRow.getHeight() >= 0) {
            destRow.setHeight(srcRow.getHeight());
        }
        if (srcRow.getFirstCellNum() >= 0 && srcRow.getLastCellNum() >= 0) {
            int j = srcRow.getFirstCellNum();
            short c = srcRow.getLastCellNum();
            while (j <= c) {
                org.apache.poi.ss.usermodel.Cell oldCell = srcRow.getCell(j);
                org.apache.poi.ss.usermodel.Cell newCell = destRow.getCell(j);
                if (oldCell != null) {
                    CellRangeAddress newMergedRegion;
                    if (newCell == null) {
                        newCell = destRow.createCell(j);
                    }
                    Util.copyCell(oldCell, newCell, true, expressionToReplace, expressionReplacement);
                    CellRangeAddress mergedRegion = Util.getMergedRegion(srcSheet, srcRow.getRowNum(), oldCell.getColumnIndex());
                    if (mergedRegion != null && Util.isNewMergedRegion(newMergedRegion = new CellRangeAddress(mergedRegion.getFirstRow(), mergedRegion.getLastRow(), mergedRegion.getFirstColumn(), mergedRegion.getLastColumn()), mergedRegions)) {
                        mergedRegions.add(newMergedRegion);
                        destSheet.addMergedRegion(newMergedRegion);
                    }
                }
                ++j;
            }
        }
    }

    public static void copySheets(Sheet newSheet, Sheet sheet) {
        int maxColumnNum = 0;
        int i = sheet.getFirstRowNum();
        int c = sheet.getLastRowNum();
        while (i <= c) {
            org.apache.poi.ss.usermodel.Row srcRow = sheet.getRow(i);
            org.apache.poi.ss.usermodel.Row destRow = newSheet.createRow(i);
            if (srcRow != null) {
                Util.copyRow(sheet, newSheet, srcRow, destRow);
                if (srcRow.getLastCellNum() > maxColumnNum) {
                    maxColumnNum = srcRow.getLastCellNum();
                }
            }
            ++i;
        }
        i = 0;
        while (i <= maxColumnNum) {
            newSheet.setColumnWidth(i, sheet.getColumnWidth(i));
            ++i;
        }
    }

    public static void copySheets(Sheet newSheet, Sheet sheet, String expressionToReplace, String expressionReplacement) {
        int maxColumnNum = 0;
        int i = sheet.getFirstRowNum();
        int c = sheet.getLastRowNum();
        while (i <= c) {
            org.apache.poi.ss.usermodel.Row srcRow = sheet.getRow(i);
            org.apache.poi.ss.usermodel.Row destRow = newSheet.createRow(i);
            if (srcRow != null) {
                Util.copyRow(sheet, newSheet, srcRow, destRow, expressionToReplace, expressionReplacement);
                if (srcRow.getLastCellNum() > maxColumnNum) {
                    maxColumnNum = srcRow.getLastCellNum();
                }
            }
            ++i;
        }
        i = 0;
        while (i <= maxColumnNum) {
            newSheet.setColumnWidth(i, sheet.getColumnWidth(i));
            ++i;
        }
    }

    public static void copyCell(org.apache.poi.ss.usermodel.Cell oldCell, org.apache.poi.ss.usermodel.Cell newCell, boolean copyStyle) {
        if (copyStyle) {
            newCell.setCellStyle(oldCell.getCellStyle());
        }
        switch (oldCell.getCellType()) {
            case 1: {
                newCell.setCellValue(oldCell.getRichStringCellValue());
                break;
            }
            case 0: {
                newCell.setCellValue(oldCell.getNumericCellValue());
                break;
            }
            case 3: {
                newCell.setCellType(3);
                break;
            }
            case 4: {
                newCell.setCellValue(oldCell.getBooleanCellValue());
                break;
            }
            case 5: {
                newCell.setCellErrorValue(oldCell.getErrorCellValue());
                break;
            }
            case 2: {
                newCell.setCellFormula(oldCell.getCellFormula());
                break;
            }
        }
    }

    public static void copyCell(org.apache.poi.ss.usermodel.Cell oldCell, org.apache.poi.ss.usermodel.Cell newCell, boolean copyStyle, String expressionToReplace, String expressionReplacement) {
        if (copyStyle) {
            newCell.setCellStyle(oldCell.getCellStyle());
        }
        switch (oldCell.getCellType()) {
            case 1: {
                String oldValue = oldCell.getRichStringCellValue().getString();
                newCell.setCellValue(newCell.getSheet().getWorkbook().getCreationHelper().createRichTextString(oldValue.replaceAll(expressionToReplace, expressionReplacement)));
                break;
            }
            case 0: {
                newCell.setCellValue(oldCell.getNumericCellValue());
                break;
            }
            case 3: {
                newCell.setCellType(3);
                break;
            }
            case 4: {
                newCell.setCellValue(oldCell.getBooleanCellValue());
                break;
            }
            case 5: {
                newCell.setCellErrorValue(oldCell.getErrorCellValue());
                break;
            }
            case 2: {
                newCell.setCellFormula(oldCell.getCellFormula());
                break;
            }
        }
    }

    public static Object getProperty(Object bean, String propertyName) {
        Object value = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getting property=" + propertyName + " for bean=" + bean.getClass().getName()));
            }
            value = PropertyUtils.getProperty((Object)bean, (String)propertyName);
        }
        catch (IllegalAccessException e) {
            log.warn((Object)("Can't get property " + propertyName + " in the bean " + bean), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.warn((Object)("Can't get property " + propertyName + " in the bean " + bean), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.warn((Object)("Can't get property " + propertyName + " in the bean " + bean), (Throwable)e);
        }
        return value;
    }

    public static void writeToFile(String fileName, Workbook workbook) {
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(fileName));
            workbook.write((OutputStream)os);
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static CellStyle duplicateStyle(Workbook workbook, CellStyle style) {
        CellStyle newStyle = workbook.createCellStyle();
        newStyle.setAlignment(style.getAlignment());
        newStyle.setBorderBottom(style.getBorderBottom());
        newStyle.setBorderLeft(style.getBorderLeft());
        newStyle.setBorderRight(style.getBorderRight());
        newStyle.setBorderTop(style.getBorderTop());
        newStyle.setBottomBorderColor(style.getBottomBorderColor());
        newStyle.setDataFormat(style.getDataFormat());
        newStyle.setFillBackgroundColor(style.getFillBackgroundColor());
        newStyle.setFillForegroundColor(style.getFillForegroundColor());
        newStyle.setFillPattern(style.getFillPattern());
        newStyle.setFont(workbook.getFontAt(style.getFontIndex()));
        newStyle.setHidden(style.getHidden());
        newStyle.setIndention(style.getIndention());
        newStyle.setLeftBorderColor(style.getLeftBorderColor());
        newStyle.setLocked(style.getLocked());
        newStyle.setRightBorderColor(style.getRightBorderColor());
        newStyle.setTopBorderColor(style.getTopBorderColor());
        newStyle.setVerticalAlignment(style.getVerticalAlignment());
        newStyle.setWrapText(style.getWrapText());
        return newStyle;
    }

    public static String escapeAttributes(String tag) {
        if (tag == null) {
            return tag;
        }
        int i = 0;
        StringBuffer sb = new StringBuffer("");
        StringBuffer attrValue = new StringBuffer("");
        int expressionClosingSymbol = 125;
        int expressionStartSymbol = 123;
        boolean isAttrValue = false;
        int exprCount = 0;
        while (i < tag.length()) {
            if (!isAttrValue) {
                sb.append(tag.charAt(i));
                if (tag.charAt(i) == '\"') {
                    isAttrValue = true;
                    attrValue = new StringBuffer("");
                }
            } else if (tag.charAt(i) == '\"') {
                if (exprCount != 0) {
                    attrValue.append(tag.charAt(i));
                } else {
                    sb.append(Util.escapeXml(attrValue.toString()));
                    sb.append(tag.charAt(i));
                    isAttrValue = false;
                }
            } else {
                attrValue.append(tag.charAt(i));
                if (tag.charAt(i) == '}') {
                    --exprCount;
                } else if (tag.charAt(i) == '{') {
                    ++exprCount;
                }
            }
            ++i;
        }
        if (isAttrValue) {
            log.warn((Object)("Can't parse ambiguous quot in " + tag));
        }
        return sb.toString();
    }

    private static String escapeXml(String str) {
        if (str == null) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str.length() * 2);
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            String entityName = Util.getEntityName(ch);
            if (entityName == null) {
                if (ch > '\u007f') {
                    buf.append("&#");
                    buf.append((int)ch);
                    buf.append(';');
                } else {
                    buf.append(ch);
                }
            } else {
                buf.append('&');
                buf.append(entityName);
                buf.append(';');
            }
            ++i;
        }
        return buf.toString();
    }

    private static String getEntityName(char ch) {
        return (String)xmlEntities.get(Integer.toString(ch));
    }

    protected static void updateMergedRegionInRow(Sheet sheet, Set mergedRegions, int rowNum, int cellNum, int destCellNum, boolean removeSourceMergedRegion) {
        CellRangeAddress newMergedRegion;
        CellRangeAddress mergedRegion = Util.getMergedRegion(sheet, rowNum, cellNum);
        if (mergedRegion != null && Util.isNewMergedRegion(mergedRegion, mergedRegions) && Util.isNewMergedRegion(newMergedRegion = new CellRangeAddress(mergedRegion.getFirstRow(), mergedRegion.getLastRow(), mergedRegion.getFirstColumn() + destCellNum - cellNum, mergedRegion.getLastColumn() + destCellNum - cellNum), mergedRegions)) {
            mergedRegions.add(newMergedRegion);
            sheet.addMergedRegion(newMergedRegion);
            if (removeSourceMergedRegion) {
                Util.removeMergedRegion(sheet, mergedRegion);
            }
        }
    }

    public static void shiftCellsLeft(Sheet sheet, int startRow, int startCol, int endRow, int endCol, int shiftNumber, boolean removeSourceMergedRegion) {
        HashSet mergedRegions = new HashSet();
        int rowNum = startRow;
        while (rowNum <= endRow) {
            boolean doSetWidth = true;
            org.apache.poi.ss.usermodel.Row row = sheet.getRow(rowNum);
            if (row != null) {
                int colNum = startCol;
                while (colNum <= endCol) {
                    int destColNum;
                    org.apache.poi.ss.usermodel.Cell destCell;
                    org.apache.poi.ss.usermodel.Cell cell = row.getCell(colNum);
                    if (cell == null) {
                        cell = row.createCell(colNum);
                        doSetWidth = false;
                    }
                    if ((destCell = row.getCell(destColNum = colNum - shiftNumber)) == null) {
                        destCell = row.createCell(destColNum);
                    }
                    Util.copyCell(cell, destCell, true);
                    Util.updateMergedRegionInRow(sheet, mergedRegions, rowNum, colNum, destColNum, removeSourceMergedRegion);
                    if (doSetWidth) {
                        sheet.setColumnWidth(destCell.getColumnIndex(), Util.getWidth(sheet, cell.getColumnIndex()));
                    }
                    row.removeCell(cell);
                    row.createCell(colNum);
                    ++colNum;
                }
            }
            ++rowNum;
        }
    }

    static int getWidth(Sheet sheet, int col) {
        int width = sheet.getColumnWidth(col);
        if (width == sheet.getDefaultColumnWidth()) {
            width *= 256;
        }
        return width;
    }

    public static void shiftCellsRight(Sheet sheet, int startRow, int endRow, int startCol, int shiftNumber, boolean removeSourceMergedRegion) {
        HashSet mergedRegions = new HashSet();
        int rowNum = startRow;
        while (rowNum <= endRow) {
            org.apache.poi.ss.usermodel.Row row = sheet.getRow(rowNum);
            if (row != null) {
                int lastCellNum;
                int colNum = lastCellNum = row.getLastCellNum();
                while (colNum >= startCol) {
                    org.apache.poi.ss.usermodel.Cell cell;
                    int destColNum = colNum + shiftNumber;
                    org.apache.poi.ss.usermodel.Cell destCell = row.getCell(destColNum);
                    if (destCell == null) {
                        destCell = row.createCell(destColNum);
                    }
                    if ((cell = row.getCell(colNum)) == null) {
                        cell = row.createCell(colNum);
                    }
                    Util.copyCell(cell, destCell, true);
                    Util.updateMergedRegionInRow(sheet, mergedRegions, rowNum, colNum, destColNum, removeSourceMergedRegion);
                    row.removeCell(cell);
                    row.createCell(colNum);
                    --colNum;
                }
            }
            ++rowNum;
        }
    }

    public static void updateCellValue(Sheet sheet, int rowNum, int colNum, String cellValue) {
        org.apache.poi.ss.usermodel.Row hssfRow = sheet.getRow(rowNum);
        org.apache.poi.ss.usermodel.Cell hssfCell = hssfRow.getCell(colNum);
        hssfCell.setCellValue(hssfCell.getSheet().getWorkbook().getCreationHelper().createRichTextString(cellValue));
    }

    public static void copyPageSetup(Sheet destSheet, Sheet srcSheet) {
        Header header = srcSheet.getHeader();
        Footer footer = srcSheet.getFooter();
        if (footer != null) {
            destSheet.getFooter().setLeft(footer.getLeft());
            destSheet.getFooter().setCenter(footer.getCenter());
            destSheet.getFooter().setRight(footer.getRight());
        }
        if (header != null) {
            destSheet.getHeader().setLeft(header.getLeft());
            destSheet.getHeader().setCenter(header.getCenter());
            destSheet.getHeader().setRight(header.getRight());
        }
    }

    public static void copyPrintSetup(Sheet destSheet, Sheet srcSheet) {
        PrintSetup setup = srcSheet.getPrintSetup();
        if (setup != null) {
            destSheet.getPrintSetup().setLandscape(setup.getLandscape());
            destSheet.getPrintSetup().setPaperSize(setup.getPaperSize());
            destSheet.getPrintSetup().setScale(setup.getScale());
            destSheet.getPrintSetup().setFitWidth(setup.getFitWidth());
            destSheet.getPrintSetup().setFitHeight(setup.getFitHeight());
            destSheet.getPrintSetup().setFooterMargin(setup.getFooterMargin());
            destSheet.getPrintSetup().setHeaderMargin(setup.getHeaderMargin());
            destSheet.getPrintSetup().setPaperSize(setup.getPaperSize());
            destSheet.getPrintSetup().setPageStart(setup.getPageStart());
        }
    }

    public static void setPrintArea(Workbook resultWorkbook, int sheetNum) {
        int maxColumnNum = 0;
        int j = resultWorkbook.getSheetAt(sheetNum).getFirstRowNum();
        int c = resultWorkbook.getSheetAt(sheetNum).getLastRowNum();
        while (j <= c) {
            org.apache.poi.ss.usermodel.Row row = resultWorkbook.getSheetAt(sheetNum).getRow(j);
            if (row != null) {
                maxColumnNum = row.getLastCellNum();
            }
            ++j;
        }
        resultWorkbook.setPrintArea(sheetNum, 0, maxColumnNum, 0, resultWorkbook.getSheetAt(sheetNum).getLastRowNum());
    }

    public static boolean isColumnRange(List cells) {
        String firstCell = (String)cells.get(0);
        boolean isColumnRange = true;
        if (firstCell != null && firstCell.length() > 0) {
            String firstCellCharPart = firstCell.split(regexCellCharPart)[0];
            String firstCellDigitPart = firstCell.split(regexCellDigitPart)[1];
            int cellNumber = Integer.parseInt(firstCellDigitPart);
            int i = 1;
            int c = cells.size();
            while (i < c && isColumnRange) {
                String nextCell = (String)cells.get(i);
                String cellCharPart = nextCell.split(regexCellCharPart)[0];
                String cellDigitPart = nextCell.split(regexCellDigitPart)[1];
                if (!firstCellCharPart.equalsIgnoreCase(cellCharPart) || Integer.parseInt(cellDigitPart) != ++cellNumber) {
                    isColumnRange = false;
                }
                ++i;
            }
        }
        return isColumnRange;
    }

    public static boolean isRowRange(List cells) {
        String firstCell = (String)cells.get(0);
        boolean isRowRange = true;
        if (firstCell != null && firstCell.length() > 0) {
            String firstCellDigitPart = firstCell.split(regexCellDigitPart)[1];
            CellReference cellRef = new CellReference(firstCell);
            int cellNumber = cellRef.getCol();
            int i = 1;
            int c = cells.size();
            while (i < c && isRowRange) {
                String nextCell = (String)cells.get(i);
                String cellDigitPart = nextCell.split(regexCellDigitPart)[1];
                cellRef = new CellReference(nextCell);
                if (!firstCellDigitPart.equalsIgnoreCase(cellDigitPart) || cellRef.getCol() != ++cellNumber) {
                    isRowRange = false;
                }
                ++i;
            }
        }
        return isRowRange;
    }

    public static String buildCommaSeparatedListOfCells(String refSheetName, List cells) {
        StringBuilder listOfCellsBuilder = new StringBuilder();
        int i = 0;
        int c = cells.size() - 1;
        while (i < c) {
            String cell = (String)cells.get(i);
            listOfCellsBuilder.append(Util.getRefCellName(refSheetName, cell));
            listOfCellsBuilder.append(",");
            ++i;
        }
        listOfCellsBuilder.append(Util.getRefCellName(refSheetName, (String)cells.get(cells.size() - 1)));
        return listOfCellsBuilder.toString();
    }

    public static String detectCellRange(String refSheetName, List cells) {
        String firstCell;
        if (cells == null || cells.isEmpty()) {
            return "";
        }
        String range = firstCell = (String)cells.get(0);
        if (firstCell != null && firstCell.length() > 0) {
            if (Util.isRowRange(cells) || Util.isColumnRange(cells)) {
                String lastCell = (String)cells.get(cells.size() - 1);
                range = String.valueOf(Util.getRefCellName(refSheetName, firstCell)) + cellRangeSeparator + lastCell.toUpperCase();
            } else {
                range = Util.buildCommaSeparatedListOfCells(refSheetName, cells);
            }
        }
        return range;
    }

    public static String getRefCellName(String refSheetName, String cellName) {
        if (refSheetName == null) {
            return cellName.toUpperCase();
        }
        return String.valueOf(refSheetName) + "!" + cellName.toUpperCase();
    }

    public static void shiftRows(Sheet sheet, int startRow, int endRow, int shiftNum) {
        if (startRow <= endRow) {
            short[] rowHeights = Util.getRowHeights(sheet, startRow, endRow);
            sheet.shiftRows(startRow, endRow, shiftNum, false, false);
            Util.copyPositiveRowHeight(sheet, startRow, endRow, shiftNum, rowHeights);
        }
    }

    private static short[] getRowHeights(Sheet sheet, int startRow, int endRow) {
        if (endRow - startRow + 1 < 0) {
            return new short[0];
        }
        short[] rowHeights = new short[endRow - startRow + 1];
        int i = startRow;
        while (i <= endRow) {
            org.apache.poi.ss.usermodel.Row row = sheet.getRow(i);
            rowHeights[i - startRow] = row != null ? row.getHeight() : (short)-1;
            ++i;
        }
        return rowHeights;
    }

    static void copyPositiveRowHeight(Sheet sheet, int startRow, int endRow, int shiftNum, short[] rowHeights) {
        int i = startRow;
        while (i <= endRow) {
            org.apache.poi.ss.usermodel.Row destRow = sheet.getRow(i + shiftNum);
            if (destRow != null && rowHeights[i - startRow] >= 0) {
                destRow.setHeight(rowHeights[i - startRow]);
            }
            ++i;
        }
    }

    public static org.apache.poi.ss.usermodel.Cell getOrCreateCell(Sheet poiSheet, Integer rowNum, Integer cellNum) {
        org.apache.poi.ss.usermodel.Row row = poiSheet.getRow(rowNum.intValue());
        if (row == null) {
            row = poiSheet.createRow(rowNum.intValue());
        }
        org.apache.poi.ss.usermodel.Cell cell = row.getCell(cellNum.intValue(), org.apache.poi.ss.usermodel.Row.CREATE_NULL_AS_BLANK);
        return cell;
    }
}

