/*
 * Decompiled with CFR 0.152.
 */
package snaq.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import snaq.db.CacheConnection;
import snaq.db.ConnectionPoolEvent;
import snaq.db.ConnectionPoolListener;
import snaq.db.ConnectionValidator;
import snaq.db.PasswordDecoder;
import snaq.util.ObjectPool;
import snaq.util.ObjectPoolEvent;
import snaq.util.ObjectPoolEventAdapter;
import snaq.util.Reusable;

public class ConnectionPool
extends ObjectPool
implements Comparable {
    private String url;
    private String user;
    private String pass;
    private Properties props;
    private ConnectionValidator validator = new DefaultValidator();
    private PasswordDecoder decoder;
    private boolean cacheSS;
    private boolean cachePS;
    private boolean cacheCS;
    private List listeners = new ArrayList();
    String driverName = null;

    public ConnectionPool(String name, String driverName, int poolSize, int maxSize, long expiryTime, String url, String username, String password) {
        super(name, poolSize, maxSize, expiryTime);
        this.url = url;
        this.user = username;
        this.pass = password;
        this.props = null;
        this.driverName = driverName;
        this.setCaching(false);
        this.addObjectPoolListener(new EventRelay());
    }

    public ConnectionPool(String name, String driverName, int poolSize, int maxSize, long expiryTime, String url, Properties props) {
        this(name, driverName, poolSize, maxSize, expiryTime, url, null, null);
        this.props = props;
        this.pass = props.getProperty("password");
        this.addObjectPoolListener(new EventRelay());
    }

    protected Reusable create() throws SQLException, Exception {
        Connection con = null;
        CacheConnection ccon = null;
        try {
            block21: {
                if (this.props != null) {
                    if (this.decoder != null) {
                        this.props.setProperty("password", new String(this.decoder.decode(this.pass)));
                    }
                    this.log("Getting connection (properties): " + this.url);
                    con = DriverManager.getConnection(this.url, this.props);
                } else if (this.user != null) {
                    try {
                        if (this.decoder != null) {
                            this.log("Getting connection (user/enc.pass): " + this.url);
                            con = DriverManager.getConnection(this.url, this.user, new String(this.decoder.decode(this.pass)));
                            break block21;
                        }
                        try {
                            if (this.driverName == null) {
                                if (this.url.startsWith("jdbc:oracle:")) {
                                    Class.forName("oracle.jdbc.driver.OracleDriver");
                                } else if (this.url.startsWith("jdbc:mysql:")) {
                                    Class.forName("com.mysql.jdbc.Driver");
                                } else {
                                    throw new Exception("Driver not found: URL=" + this.url);
                                }
                            }
                            Class.forName(this.driverName);
                        }
                        catch (ClassNotFoundException ce) {
                            String s = "Driver not found: oracle.jdbc.driver.OracleDriver " + ce;
                            System.out.println(s);
                        }
                        this.log("Getting connection (user/pass): " + this.url);
                        con = DriverManager.getConnection(this.url, this.user, this.pass);
                    }
                    catch (SQLException sqle) {
                        System.out.println("url=" + this.url);
                        sqle.printStackTrace();
                        this.log("Failed to connect with standard authentication...trying with just JDBC URL");
                        this.log("Getting connection (URL only): " + this.url);
                        con = DriverManager.getConnection(this.url);
                    }
                } else {
                    con = DriverManager.getConnection(this.url);
                }
            }
            ccon = new CacheConnection(this, con);
            ccon.setCacheStatements(this.cacheSS);
            ccon.setCachePreparedStatements(this.cachePS);
            ccon.setCacheCallableStatements(this.cacheCS);
            this.log("Created a new connection");
            SQLWarning warn = con.getWarnings();
            while (warn != null) {
                this.log("Warning - " + warn.getMessage());
                warn = warn.getNextWarning();
            }
        }
        catch (SQLException sqle) {
            this.log(sqle, "Can't create a new connection for " + this.url);
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw sqle;
        }
        return ccon;
    }

    protected boolean isValid(Reusable o) {
        if (o == null) {
            return false;
        }
        if (this.validator == null) {
            return true;
        }
        try {
            boolean valid = this.validator.isValid((Connection)((Object)o));
            if (!valid) {
                this.fireValidationErrorEvent();
            }
            return valid;
        }
        catch (Exception e) {
            this.log(e, "Exception during validation");
            return false;
        }
    }

    public void setValidator(ConnectionValidator cv) {
        this.validator = cv;
    }

    public ConnectionValidator getValidator() {
        return this.validator;
    }

    public void setPasswordDecoder(PasswordDecoder pd) {
        this.decoder = pd;
    }

    public PasswordDecoder getPasswordDecoder() {
        return this.decoder;
    }

    protected void destroy(Reusable o) {
        if (o == null) {
            return;
        }
        try {
            ((CacheConnection)o).release();
            this.log("Destroyed connection");
        }
        catch (SQLException e) {
            this.log(e, "Can't destroy connection");
        }
    }

    /*
     * Unable to fully structure code
     */
    public Connection getConnection() throws SQLException {
        try {
            o = super.checkOut();
            if (o != null) {
                cc = (CacheConnection)o;
                cc.setOpen();
                return cc;
            }
            return null;
        }
        catch (Exception e) {
            this.log(e, "Error getting connection");
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            t = e.getCause();
            ** while (t != null)
        }
lbl-1000:
        // 1 sources

        {
            this.log(e, "Error getting connection");
            t = t.getCause();
            continue;
        }
lbl17:
        // 1 sources

        if (e.getMessage() == null) {
            throw new SQLException(e.getClass().getName());
        }
        throw new SQLException(e.getMessage());
    }

    public Connection getConnection(long timeout) throws SQLException {
        try {
            Reusable o = super.checkOut(timeout);
            if (o != null) {
                CacheConnection cc = (CacheConnection)o;
                cc.setOpen();
                return cc;
            }
            return null;
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            e.printStackTrace();
            this.log(e, "Error getting connection");
            throw new SQLException(e.getMessage());
        }
    }

    protected void freeConnection(Connection c) throws SQLException {
        if (c == null || !CacheConnection.class.isInstance(c)) {
            this.log("Attempt to return invalid item");
        } else {
            CacheConnection cc = (CacheConnection)c;
            super.checkIn((Reusable)((Object)c));
        }
    }

    public void setCaching(boolean b) {
        this.cachePS = this.cacheCS = b;
        this.cacheSS = this.cacheCS;
    }

    public void setCaching(boolean ss, boolean ps, boolean cs) {
        this.cacheSS = ss;
        this.cachePS = ps;
        this.cacheCS = cs;
    }

    public String toString() {
        return this.getName();
    }

    public int compareTo(Object o) {
        return this.toString().compareTo(((ConnectionPool)o).toString());
    }

    public final void addConnectionPoolListener(ConnectionPoolListener x) {
        this.listeners.add(x);
    }

    public final void removeConnectionPoolListener(ConnectionPoolListener x) {
        this.listeners.remove(x);
    }

    private final void fireValidationErrorEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ConnectionPoolEvent poolEvent = new ConnectionPoolEvent(this, 9);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ConnectionPoolListener)iter.next()).validationError(poolEvent);
        }
    }

    private final void firePoolCheckOutEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ConnectionPoolEvent poolEvent = new ConnectionPoolEvent(this, 1);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ConnectionPoolListener)iter.next()).poolCheckOut(poolEvent);
        }
    }

    private final void firePoolCheckInEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ConnectionPoolEvent poolEvent = new ConnectionPoolEvent(this, 2);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ConnectionPoolListener)iter.next()).poolCheckIn(poolEvent);
        }
    }

    private final void fireMaxPoolLimitReachedEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ConnectionPoolEvent poolEvent = new ConnectionPoolEvent(this, 3);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ConnectionPoolListener)iter.next()).maxPoolLimitReached(poolEvent);
        }
    }

    private final void fireMaxPoolLimitExceededEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ConnectionPoolEvent poolEvent = new ConnectionPoolEvent(this, 4);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ConnectionPoolListener)iter.next()).maxPoolLimitExceeded(poolEvent);
        }
    }

    private final void fireMaxSizeLimitReachedEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ConnectionPoolEvent poolEvent = new ConnectionPoolEvent(this, 5);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ConnectionPoolListener)iter.next()).maxSizeLimitReached(poolEvent);
        }
    }

    private final void fireMaxSizeLimitErrorEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ConnectionPoolEvent poolEvent = new ConnectionPoolEvent(this, 6);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ConnectionPoolListener)iter.next()).maxSizeLimitError(poolEvent);
        }
    }

    private final void fireParametersChangedEvent() {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        ConnectionPoolEvent poolEvent = new ConnectionPoolEvent(this, 7);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ConnectionPoolListener)iter.next()).poolParametersChanged(poolEvent);
        }
    }

    private final void firePoolReleasedEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ConnectionPoolEvent poolEvent = new ConnectionPoolEvent(this, 8);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ConnectionPoolListener)iter.next()).poolReleased(poolEvent);
        }
    }

    static class DefaultValidator
    implements ConnectionValidator {
        DefaultValidator() {
        }

        public boolean isValid(Connection con) {
            try {
                return !con.isClosed();
            }
            catch (SQLException e) {
                return false;
            }
        }
    }

    private final class EventRelay
    extends ObjectPoolEventAdapter {
        private EventRelay() {
        }

        public void poolCheckOut(ObjectPoolEvent evt) {
            ConnectionPool.this.firePoolCheckOutEvent();
        }

        public void poolCheckIn(ObjectPoolEvent evt) {
            ConnectionPool.this.firePoolCheckInEvent();
        }

        public void maxPoolLimitReached(ObjectPoolEvent evt) {
            ConnectionPool.this.fireMaxPoolLimitReachedEvent();
        }

        public void maxPoolLimitExceeded(ObjectPoolEvent evt) {
            ConnectionPool.this.fireMaxPoolLimitExceededEvent();
        }

        public void maxSizeLimitReached(ObjectPoolEvent evt) {
            ConnectionPool.this.fireMaxSizeLimitReachedEvent();
        }

        public void maxSizeLimitError(ObjectPoolEvent evt) {
            ConnectionPool.this.fireMaxSizeLimitErrorEvent();
        }

        public void poolParametersChanged(ObjectPoolEvent evt) {
            ConnectionPool.this.fireParametersChangedEvent();
        }

        public void poolReleased(ObjectPoolEvent evt) {
            ConnectionPool.this.firePoolReleasedEvent();
            ConnectionPool.this.listeners.clear();
        }
    }
}

