/*
 * Decompiled with CFR 0.152.
 */
package snaq.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import snaq.db.ConnectionPool;
import snaq.db.ConnectionValidator;
import snaq.db.PasswordDecoder;
import snaq.util.LogUtil;

public final class ConnectionPoolManager
extends LogUtil
implements Comparable {
    private static final String PROPERTIES_INSTANCE_KEY = "PROPERTIES_INSTANCE";
    private static final String DEFAULT_PROPERTIES_FILE = "/dbpool.properties";
    private static Hashtable managers = new Hashtable();
    private static ArrayList drivers = new ArrayList();
    private boolean released = false;
    private HashMap pools = new HashMap();
    protected int clients;
    private Object source;
    private Object key;

    private ConnectionPoolManager(Properties props, Object src) {
        this.source = src;
        this.init(props);
    }

    public String toString() {
        if (this.source instanceof String) {
            return "ConnectionPoolManager [CLASSPATH resource:" + this.source + "]";
        }
        if (this.source instanceof File) {
            return "ConnectionPoolManager [File:" + ((File)this.source).getAbsolutePath() + "]";
        }
        if (this.source instanceof Properties) {
            return "ConnectionPoolManager [Properties]";
        }
        return "ConnectionPoolManager [Unknown]";
    }

    public int compareTo(Object o) {
        return this.toString().compareTo(((ConnectionPoolManager)o).toString());
    }

    public static Enumeration instances() {
        return Collections.enumeration(ConnectionPoolManager.getInstances());
    }

    public static Set getInstances() {
        HashSet x = new HashSet();
        x.addAll(managers.values());
        return x;
    }

    public static synchronized ConnectionPoolManager getInstance(String propsFile) throws IOException {
        ConnectionPoolManager cpm;
        String s = propsFile.startsWith("/") ? propsFile : "/" + propsFile;
        Object o = managers.get(s);
        ConnectionPoolManager connectionPoolManager = cpm = o != null ? (ConnectionPoolManager)o : null;
        if (cpm == null || cpm.isReleased()) {
            cpm = new ConnectionPoolManager(ConnectionPoolManager.loadProperties(s), propsFile);
            cpm.key = s;
            managers.put(cpm.key, cpm);
        }
        ++cpm.clients;
        return cpm;
    }

    public static synchronized ConnectionPoolManager getInstance(File propsFile) throws IOException {
        ConnectionPoolManager cpm;
        Object o = managers.get(propsFile);
        ConnectionPoolManager connectionPoolManager = cpm = o != null ? (ConnectionPoolManager)o : null;
        if (cpm == null || cpm.isReleased()) {
            try {
                cpm = new ConnectionPoolManager(ConnectionPoolManager.loadProperties(propsFile), propsFile);
                cpm.key = propsFile;
                managers.put(cpm.key, cpm);
            }
            catch (IOException ioe) {
                if (ioe instanceof FileNotFoundException) {
                    System.err.println("Unable to find the properties file " + propsFile.getAbsolutePath());
                } else {
                    System.err.println("Error loading the properties file " + propsFile.getAbsolutePath());
                }
                ioe.printStackTrace();
                return null;
            }
        }
        ++cpm.clients;
        return cpm;
    }

    public static synchronized ConnectionPoolManager getInstance() throws IOException {
        ConnectionPoolManager cpm;
        Object o = managers.get(PROPERTIES_INSTANCE_KEY);
        ConnectionPoolManager connectionPoolManager = cpm = o != null ? (ConnectionPoolManager)o : null;
        if (cpm != null && !cpm.released) {
            ++cpm.clients;
        } else {
            cpm = ConnectionPoolManager.getInstance(DEFAULT_PROPERTIES_FILE);
        }
        return cpm;
    }

    public static synchronized void createInstance(Properties props) {
        ConnectionPoolManager cpm;
        Object o = managers.get(DEFAULT_PROPERTIES_FILE);
        ConnectionPoolManager connectionPoolManager = cpm = o != null ? (ConnectionPoolManager)o : null;
        if (cpm != null && !cpm.isReleased()) {
            throw new RuntimeException("Default properties file instance already exists");
        }
        cpm = new ConnectionPoolManager(props, props);
        cpm.key = PROPERTIES_INSTANCE_KEY;
        managers.put(cpm.key, cpm);
    }

    private static Properties loadProperties(File propsFile) throws IOException {
        if (!propsFile.exists()) {
            throw new FileNotFoundException(String.valueOf(propsFile.getAbsolutePath()) + " does not exist");
        }
        if (propsFile.isDirectory()) {
            throw new IOException("Error accessing properties file - " + propsFile.getAbsolutePath() + " is a directory");
        }
        FileInputStream is = new FileInputStream(propsFile);
        Properties props = new Properties();
        props.load(is);
        ((InputStream)is).close();
        return props;
    }

    private static Properties loadProperties(String propsResource) throws IOException {
        InputStream is = ConnectionPoolManager.class.getResourceAsStream(propsResource);
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException ioe) {
            System.err.println("Unable to load the properties file. Make sure " + propsResource + " is in the CLASSPATH.");
            ioe.printStackTrace();
            throw ioe;
        }
        return props;
    }

    private void init(Properties props) {
        String logFile = props.getProperty("logfile", "ConnectionPoolManager.log");
        String df = props.getProperty("dateformat", "EEE MMM dd hh:mm:ss.SSS ZZZ yyyy");
        try {
            this.setDateFormat(new SimpleDateFormat(df));
            this.setLog(new FileOutputStream(logFile, true));
        }
        catch (IOException e) {
            System.err.println("Can't open the log file: " + logFile);
        }
        this.loadDrivers(props);
        this.createPools(props);
    }

    private void loadDrivers(Properties props) {
        String driverClasses = props.getProperty("drivers");
        StringTokenizer st = new StringTokenizer(driverClasses, ",: \t\n\r\f");
        Enumeration<Driver> current = DriverManager.getDrivers();
        while (st.hasMoreElements()) {
            String driverClassName = st.nextToken().trim();
            try {
                boolean using = false;
                while (current.hasMoreElements()) {
                    String cName = current.nextElement().getClass().getName();
                    if (!cName.equals(driverClassName)) continue;
                    using = true;
                }
                if (using) continue;
                Driver driver = (Driver)Class.forName(driverClassName).newInstance();
                DriverManager.registerDriver(driver);
                drivers.add(driver);
                this.log("Registered JDBC driver " + driverClassName);
            }
            catch (Exception e) {
                this.log("Unable to register JDBC driver: " + driverClassName + ", Exception: " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void createPools(Properties props) {
        for (String string : props.keySet()) {
            Object o;
            void var22_26;
            int exp;
            int iSize;
            int mSize;
            if (!string.endsWith(".url")) continue;
            String poolName = string.substring(0, string.lastIndexOf("."));
            String url = props.getProperty(String.valueOf(poolName) + ".url");
            if (url == null) {
                this.log("No URL specified for " + poolName);
                continue;
            }
            String user = props.getProperty(String.valueOf(poolName) + ".user");
            user = user != null ? user.trim() : user;
            String pass = props.getProperty(String.valueOf(poolName) + ".password");
            pass = pass != null ? pass.trim() : pass;
            String poolSize = props.getProperty(String.valueOf(poolName) + ".maxpool", "0").trim();
            String maxSize = props.getProperty(String.valueOf(poolName) + ".maxconn", "0").trim();
            String init = props.getProperty(String.valueOf(poolName) + ".init", "0").trim();
            String expiry = props.getProperty(String.valueOf(poolName) + ".expiry", "0").trim();
            String validator = props.getProperty(String.valueOf(poolName) + ".validator");
            String decoder = props.getProperty(String.valueOf(poolName) + ".decoder");
            String logFile = props.getProperty(String.valueOf(poolName) + ".logfile");
            String dateformat = props.getProperty(String.valueOf(poolName) + ".dateformat");
            validator = validator != null ? validator.trim() : validator;
            boolean noCache = props.getProperty(String.valueOf(poolName) + ".cache", "true").trim().equalsIgnoreCase("false");
            boolean async = props.getProperty(String.valueOf(poolName) + ".async", "false").trim().equalsIgnoreCase("true");
            boolean poolDebug = props.getProperty(String.valueOf(poolName) + ".debug", "false").trim().equalsIgnoreCase("true");
            Properties poolProps = new Properties();
            String prefix = String.valueOf(poolName) + ".prop.";
            for (String string2 : props.keySet()) {
                if (!string2.startsWith(prefix)) continue;
                poolProps.setProperty(string2.substring(prefix.length()), props.getProperty(string2));
            }
            if (!poolProps.isEmpty() && user != null && !user.equals("")) {
                poolProps.setProperty("user", user);
                poolProps.setProperty("password", pass);
            } else {
                poolProps = null;
            }
            try {
                int n = Integer.valueOf(poolSize);
            }
            catch (NumberFormatException nfe) {
                this.log("Invalid maxpool value " + poolSize + " for " + poolName);
                boolean bl = false;
            }
            try {
                mSize = Integer.valueOf(maxSize);
            }
            catch (NumberFormatException nfe) {
                this.log("Invalid maxconn value " + maxSize + " for " + poolName);
                mSize = 0;
            }
            try {
                iSize = Integer.valueOf(init);
            }
            catch (NumberFormatException nfe) {
                this.log("Invalid initsize value " + init + " for " + poolName);
                iSize = 0;
            }
            try {
                exp = Integer.valueOf(expiry);
            }
            catch (NumberFormatException nfe) {
                this.log("Invalid expiry value " + expiry + " for " + poolName);
                exp = 0;
            }
            int n = Math.max((int)var22_26, 0);
            mSize = Math.max(mSize, 0);
            if (mSize > 0) {
                mSize = Math.max(mSize, n);
            }
            iSize = Math.min(Math.max(iSize, 0), n);
            exp = Math.max(exp, 0);
            ConnectionPool pool = null;
            pool = poolProps != null ? new ConnectionPool(poolName, null, n, mSize, exp * 1000, url, poolProps) : new ConnectionPool(poolName, null, n, mSize, exp * 1000, url, user, pass);
            try {
                SimpleDateFormat df = new SimpleDateFormat(dateformat);
                pool.setDateFormat(df);
            }
            catch (Exception e) {
                this.log("Invalid dateformat string specified: " + dateformat);
            }
            if (logFile != null && !logFile.equals("")) {
                File f = new File(logFile);
                if (f.exists() && f.isDirectory()) {
                    this.log("Invalid logfile specified for pool " + poolName + " - specified file is a directory");
                } else if (!f.exists() && !f.mkdirs()) {
                    this.log("Invalid logfile specified for pool " + poolName + " - cannot create file " + f.getAbsolutePath());
                }
                try {
                    pool.setLog(new FileOutputStream(f, true));
                }
                catch (FileNotFoundException fnfe) {
                    this.log(fnfe, "Invalid logfile specified for pool " + poolName);
                    pool.setLog(this.getLogStream());
                }
            } else {
                pool.setLog(this.getLogStream());
            }
            if (poolDebug) {
                this.log("Enabling debug info on pool " + poolName);
            }
            pool.setDebug(poolDebug);
            if (noCache) {
                this.log("Disabling caching on pool " + poolName);
            }
            pool.setCaching(!noCache);
            if (async) {
                this.log("Enabling asynchronous destruction on pool " + poolName);
            }
            pool.setAsyncDestroy(async);
            if (validator != null && !validator.equals("")) {
                try {
                    o = Class.forName(validator).newInstance();
                    if (o instanceof ConnectionValidator) {
                        pool.setValidator((ConnectionValidator)o);
                    }
                }
                catch (Exception ex) {
                    this.log("Unable to instantiate validator class for pool " + poolName + ": " + validator);
                }
            }
            if (decoder != null && !decoder.equals("")) {
                try {
                    o = Class.forName(decoder).newInstance();
                    if (o instanceof PasswordDecoder) {
                        pool.setPasswordDecoder((PasswordDecoder)o);
                    }
                }
                catch (Exception ex) {
                    this.log("Unable to instantiate password decoder class for pool " + poolName + ": " + decoder);
                }
            }
            HashMap ex = this.pools;
            synchronized (ex) {
                this.pools.put(poolName, pool);
            }
            String info = "pool=" + pool.getPoolSize() + ",max=" + pool.getMaxSize() + ",expiry=";
            info = String.valueOf(info) + (pool.getExpiryTime() == 0L ? "none" : String.valueOf(pool.getExpiryTime()) + "ms");
            this.log("Initialized pool " + poolName + " (" + info + ")");
            if (iSize <= 0) continue;
            pool.init(iSize);
        }
    }

    public ConnectionPool getPool(String name) {
        if (this.released) {
            throw new RuntimeException("Pool manager no longer valid for use");
        }
        return (ConnectionPool)this.pools.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionPool[] getPools() {
        HashMap hashMap = this.pools;
        synchronized (hashMap) {
            return this.pools.values().toArray(new ConnectionPool[0]);
        }
    }

    public Connection getConnection(String name) throws SQLException {
        if (this.released) {
            throw new RuntimeException("Pool manager no longer valid for use");
        }
        ConnectionPool pool = (ConnectionPool)this.pools.get(name);
        if (pool != null) {
            return pool.getConnection();
        }
        return null;
    }

    public Connection getConnection(String name, long time) throws SQLException {
        if (this.released) {
            throw new RuntimeException("Pool manager no longer valid for use");
        }
        ConnectionPool pool = (ConnectionPool)this.pools.get(name);
        if (pool != null) {
            return pool.getConnection(time);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() {
        if (--this.clients > 0) {
            return;
        }
        this.released = true;
        HashMap hashMap = this.pools;
        synchronized (hashMap) {
            for (ConnectionPool pool : this.pools.values()) {
                pool.releaseForcibly();
            }
        }
        if (managers.size() == 1) {
            for (Driver driver : drivers) {
                try {
                    DriverManager.deregisterDriver(driver);
                    this.log("Deregistered JDBC driver " + driver.getClass().getName());
                }
                catch (SQLException sqle) {
                    this.log(sqle, "Can't deregister JDBC driver: " + driver.getClass().getName());
                }
            }
        }
        managers.remove(this.key);
        super.close();
    }

    public synchronized boolean isReleased() {
        return this.released;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setValidator(ConnectionValidator cv) {
        HashMap hashMap = this.pools;
        synchronized (hashMap) {
            if (this.pools != null) {
                Iterator it = this.pools.values().iterator();
                while (it.hasNext()) {
                    ((ConnectionPool)it.next()).setValidator(cv);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLog(OutputStream out) {
        super.setLog(out);
        HashMap hashMap = this.pools;
        synchronized (hashMap) {
            if (this.pools != null) {
                Iterator it = this.pools.values().iterator();
                while (it.hasNext()) {
                    ((ConnectionPool)it.next()).setLog(out);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLog(PrintStream ps) {
        super.setLog(ps);
        HashMap hashMap = this.pools;
        synchronized (hashMap) {
            if (this.pools != null) {
                Iterator it = this.pools.values().iterator();
                while (it.hasNext()) {
                    ((ConnectionPool)it.next()).setLog(ps);
                }
            }
        }
    }
}

