/*
 * Decompiled with CFR 0.152.
 */
package snaq.db;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import snaq.db.CachedCallableStatement;
import snaq.db.CachedPreparedStatement;
import snaq.db.CachedStatement;
import snaq.db.ConnectionPool;
import snaq.db.StatementListener;
import snaq.util.Reusable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CacheConnection
implements Connection,
StatementListener,
Reusable {
    private static int DEFAULT_RESULTSET_TYPE = 1003;
    private static int DEFAULT_RESULTSET_CONCURRENCY = 1007;
    private static int DEFAULT_RESULTSET_HOLDABILITY = 1;
    protected ConnectionPool pool;
    protected Connection con;
    protected List ss = new ArrayList();
    protected List ssUsed = new ArrayList();
    protected Map ps = new HashMap();
    protected List psUsed = new ArrayList();
    protected Map cs = new HashMap();
    protected List csUsed = new ArrayList();
    protected List nonCachable = new ArrayList();
    private boolean cacheS;
    private boolean cacheP;
    private boolean cacheC;
    private int ssReq;
    private int ssHit;
    private int psReq;
    private int psHit;
    private int csReq;
    private int csHit;
    private boolean open = true;

    public CacheConnection(ConnectionPool pool, Connection con) {
        this.pool = pool;
        this.con = con;
        this.setCacheAll(true);
        this.csHit = 0;
        this.csReq = 0;
        this.psHit = 0;
        this.psReq = 0;
        this.ssHit = 0;
        this.ssReq = 0;
    }

    void setOpen() {
        this.open = true;
    }

    boolean isOpen() {
        return this.open;
    }

    public void setCacheStatements(boolean cache) {
        if (this.cacheS && !cache) {
            try {
                this.flushSpareStatements();
            }
            catch (SQLException sqle) {
                this.pool.log(sqle);
            }
        }
        this.cacheS = cache;
    }

    public void setCachePreparedStatements(boolean cache) {
        if (this.cacheP && !cache) {
            try {
                this.flushSparePreparedStatements();
            }
            catch (SQLException sqle) {
                this.pool.log(sqle);
            }
        }
        this.cacheP = cache;
    }

    public void setCacheCallableStatements(boolean cache) {
        if (this.cacheC && !cache) {
            try {
                this.flushSpareCallableStatements();
            }
            catch (SQLException sqle) {
                this.pool.log(sqle);
            }
        }
        this.cacheC = cache;
    }

    public void setCacheAll(boolean cache) {
        this.setCacheStatements(cache);
        this.setCachePreparedStatements(cache);
        this.setCacheCallableStatements(cache);
    }

    public boolean isCachingAllStatements() {
        return this.cacheS && this.cacheP && this.cacheC;
    }

    public boolean isCachingStatements() {
        return this.cacheS;
    }

    public boolean isCachingPreparedStatements() {
        return this.cacheP;
    }

    public boolean isCachingCallableStatements() {
        return this.cacheC;
    }

    public Connection getRawConnection() {
        return this.con;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(DEFAULT_RESULTSET_TYPE, DEFAULT_RESULTSET_CONCURRENCY, DEFAULT_RESULTSET_HOLDABILITY);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, DEFAULT_RESULTSET_HOLDABILITY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CachedStatement cs = null;
        if (!this.cacheS) {
            cs = new CachedStatement(this.con.createStatement());
            cs.setStatementListener(this);
            cs.setOpen();
        } else {
            List list = this.ss;
            synchronized (list) {
                ++this.ssReq;
                Iterator it = this.ss.iterator();
                while (it.hasNext()) {
                    CachedStatement x = (CachedStatement)it.next();
                    if (x.getResultSetType() != resultSetType || x.getResultSetConcurrency() != resultSetConcurrency || x.getResultSetHoldability() != resultSetHoldability) continue;
                    cs = x;
                    it.remove();
                }
                if (cs != null) {
                    cs.setOpen();
                    ++this.ssHit;
                    if (this.pool.isDebug()) {
                        this.pool.log("Statement cache hit [" + cs.getParametersString() + "] - " + this.calcHitRate(this.ssHit, this.ssReq));
                    }
                } else {
                    cs = new CachedStatement(this.con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
                    cs.setStatementListener(this);
                    cs.setOpen();
                    if (this.pool.isDebug()) {
                        this.pool.log("Statement cache miss [" + cs.getParametersString() + "] - " + this.calcHitRate(this.ssHit, this.ssReq));
                    }
                }
            }
        }
        this.ssUsed.add(cs);
        return cs;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, DEFAULT_RESULTSET_TYPE, DEFAULT_RESULTSET_CONCURRENCY, DEFAULT_RESULTSET_HOLDABILITY);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, DEFAULT_RESULTSET_HOLDABILITY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CachedPreparedStatement cps = null;
        if (!this.cacheP) {
            PreparedStatement st = this.con.prepareStatement(sql);
            cps = new CachedPreparedStatement(sql, st);
            cps.setStatementListener(this);
            cps.setOpen();
        } else {
            Map map = this.ps;
            synchronized (map) {
                ++this.psReq;
                List list = (List)this.ps.get(sql);
                if (list != null && !list.isEmpty()) {
                    Iterator it = list.iterator();
                    while (it.hasNext()) {
                        CachedPreparedStatement x = (CachedPreparedStatement)it.next();
                        if (x.getResultSetType() != resultSetType || x.getResultSetConcurrency() != resultSetConcurrency || x.getResultSetHoldability() != resultSetHoldability) continue;
                        cps = x;
                        it.remove();
                    }
                    if (list.isEmpty()) {
                        this.ps.remove(sql);
                    }
                }
                if (cps != null) {
                    cps.setOpen();
                    ++this.psHit;
                    if (this.pool.isDebug()) {
                        this.pool.log("PreparedStatement cache hit [" + sql + "," + cps.getParametersString() + "] - " + this.calcHitRate(this.psHit, this.psReq));
                    }
                } else {
                    cps = new CachedPreparedStatement(sql, this.con.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
                    cps.setStatementListener(this);
                    cps.setOpen();
                    if (this.pool.isDebug()) {
                        this.pool.log("PreparedStatement cache miss [" + sql + "," + cps.getParametersString() + "] - " + this.calcHitRate(this.psHit, this.psReq));
                    }
                }
            }
        }
        this.psUsed.add(cps);
        return cps;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, DEFAULT_RESULTSET_TYPE, DEFAULT_RESULTSET_CONCURRENCY, DEFAULT_RESULTSET_HOLDABILITY);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, DEFAULT_RESULTSET_HOLDABILITY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CachedCallableStatement ccs = null;
        if (!this.cacheC) {
            ccs = new CachedCallableStatement(sql, this.con.prepareCall(sql));
            ccs.setStatementListener(this);
            ccs.setOpen();
        } else {
            Map map = this.cs;
            synchronized (map) {
                ++this.csReq;
                List list = (List)this.cs.get(sql);
                if (list != null && !list.isEmpty()) {
                    Iterator it = list.iterator();
                    while (it.hasNext()) {
                        CachedCallableStatement x = (CachedCallableStatement)it.next();
                        if (x.getResultSetType() != resultSetType || x.getResultSetConcurrency() != resultSetConcurrency || x.getResultSetHoldability() != resultSetHoldability) continue;
                        ccs = x;
                        it.remove();
                    }
                    if (list.isEmpty()) {
                        this.cs.remove(sql);
                    }
                }
                if (ccs != null) {
                    ccs.setOpen();
                    ++this.csHit;
                    if (this.pool.isDebug()) {
                        this.pool.log("CallableStatement cache hit [" + sql + "," + ccs.getParametersString() + "] - " + this.calcHitRate(this.csHit, this.csReq));
                    }
                } else {
                    CallableStatement st = this.con.prepareCall(sql);
                    ccs = new CachedCallableStatement(sql, st);
                    ccs.setStatementListener(this);
                    ccs.setOpen();
                    if (this.pool.isDebug()) {
                        this.pool.log("CallableStatement cache miss [" + sql + "," + ccs.getParametersString() + "] - " + this.calcHitRate(this.csHit, this.csReq));
                    }
                }
            }
        }
        this.csUsed.add(ccs);
        return ccs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void statementClosed(CachedStatement s) throws SQLException {
        if (s instanceof CachedPreparedStatement) {
            Map map = this.ps;
            synchronized (map) {
                String key = ((CachedPreparedStatement)s).getSQLString();
                this.psUsed.remove(s);
                if (!this.cacheP) {
                    s.release();
                } else {
                    try {
                        s.recycle();
                        ArrayList<CachedStatement> list = (ArrayList<CachedStatement>)this.ps.get(key);
                        if (list == null) {
                            list = new ArrayList<CachedStatement>();
                            this.ps.put(key, list);
                        }
                        list.add(s);
                    }
                    catch (SQLException sqle) {
                        s.release();
                    }
                }
            }
        }
        if (s instanceof CachedCallableStatement) {
            Map map = this.cs;
            synchronized (map) {
                String key = ((CachedCallableStatement)s).getSQLString();
                this.csUsed.remove(s);
                if (!this.cacheC) {
                    s.release();
                } else {
                    try {
                        s.recycle();
                        ArrayList<CachedStatement> list = (ArrayList<CachedStatement>)this.cs.get(key);
                        if (list == null) {
                            list = new ArrayList<CachedStatement>();
                            this.cs.put(key, list);
                        }
                        list.add(s);
                    }
                    catch (SQLException sqle) {
                        s.release();
                    }
                }
            }
        }
        if (s instanceof CachedStatement) {
            List list = this.ss;
            synchronized (list) {
                this.ssUsed.remove(s);
                if (!this.cacheS) {
                    s.release();
                } else {
                    try {
                        s.recycle();
                        this.ss.add(s);
                    }
                    catch (SQLException sqle) {
                        s.release();
                    }
                }
            }
        }
    }

    private String calcHitRate(int hits, int reqs) {
        return reqs == 0 ? "" : String.valueOf((float)hits / (float)reqs * 100.0f) + "% hit rate";
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.con.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.con.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.con.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.con.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.con.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycle() throws SQLException {
        List list;
        int count;
        if (this.cacheS) {
            int n = count = this.ssUsed != null ? this.ssUsed.size() : 0;
            if (count > 0) {
                if (this.pool.isDebug()) {
                    this.pool.log("Cleaning " + count + " cached Statement" + (count > 1 ? "s" : ""));
                }
                list = this.ssUsed;
                synchronized (list) {
                    while (!this.ssUsed.isEmpty()) {
                        ((Statement)this.ssUsed.remove(0)).close();
                    }
                }
            }
        } else {
            this.flushOpenStatements();
            this.flushSpareStatements();
        }
        if (this.cacheP) {
            int n = count = this.psUsed != null ? this.psUsed.size() : 0;
            if (count > 0) {
                if (this.pool.isDebug()) {
                    this.pool.log("Cleaning " + count + " cached PreparedStatement" + (count > 1 ? "s" : ""));
                }
                list = this.psUsed;
                synchronized (list) {
                    while (!this.psUsed.isEmpty()) {
                        ((CachedPreparedStatement)this.psUsed.remove(0)).close();
                    }
                }
            }
        } else {
            this.flushOpenPreparedStatements();
            this.flushSparePreparedStatements();
        }
        if (this.cacheC) {
            int n = count = this.csUsed != null ? this.csUsed.size() : 0;
            if (count > 0) {
                if (this.pool.isDebug()) {
                    this.pool.log("Cleaning " + count + " cached CallableStatement" + (count > 1 ? "s" : ""));
                }
                list = this.csUsed;
                synchronized (list) {
                    while (!this.csUsed.isEmpty()) {
                        ((CachedCallableStatement)this.csUsed.remove(0)).close();
                    }
                }
            }
        } else {
            this.flushOpenCallableStatements();
            this.flushSpareCallableStatements();
        }
        this.flushOpenNonCachableStatements();
        if (!this.getAutoCommit()) {
            try {
                this.rollback();
            }
            catch (SQLException sqle) {
                this.pool.log(sqle);
            }
            this.setAutoCommit(true);
        }
        this.clearWarnings();
        Map tm = this.getTypeMap();
        if (tm != null) {
            tm.clear();
        }
    }

    @Override
    public void close() throws SQLException {
        if (!this.open) {
            throw new SQLException("Connection already closed");
        }
        this.open = false;
        this.pool.freeConnection(this);
    }

    public int getSpareStatementCount() {
        return this.ss.size();
    }

    public int getOpenStatementCount() {
        return this.ssUsed.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSparePreparedStatementCount() {
        int count = 0;
        Map map = this.ps;
        synchronized (map) {
            Iterator it = this.ps.values().iterator();
            while (it.hasNext()) {
                count += ((List)it.next()).size();
            }
        }
        return count;
    }

    public int getOpenPreparedStatementCount() {
        return this.psUsed.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSpareCallableStatementCount() {
        int count = 0;
        Map map = this.cs;
        synchronized (map) {
            Iterator it = this.cs.values().iterator();
            while (it.hasNext()) {
                count += ((List)it.next()).size();
            }
        }
        return count;
    }

    public int getOpenCallableStatementCount() {
        return this.csUsed.size();
    }

    public int getOpenNonCachableStatementCount() {
        return this.nonCachable.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushSpareStatements() throws SQLException {
        int count;
        int n = count = this.ss != null ? this.ss.size() : 0;
        if (count > 0) {
            if (this.pool.isDebug()) {
                this.pool.log("Closing " + count + " cached Statement" + (count > 1 ? "s" : ""));
            }
            List list = this.ss;
            synchronized (list) {
                while (!this.ss.isEmpty()) {
                    ((CachedStatement)this.ss.remove(0)).release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushOpenStatements() throws SQLException {
        int count;
        int n = count = this.ssUsed != null ? this.ssUsed.size() : 0;
        if (count > 0) {
            if (this.pool.isDebug()) {
                this.pool.log("Closing " + count + " open Statement" + (count > 1 ? "s" : ""));
            }
            List list = this.ssUsed;
            synchronized (list) {
                while (!this.ssUsed.isEmpty()) {
                    ((CachedStatement)this.ssUsed.remove(0)).release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushSparePreparedStatements() throws SQLException {
        int count;
        int n = count = this.ps != null ? this.ps.size() : 0;
        if (count > 0) {
            if (this.pool.isDebug()) {
                this.pool.log("Closing " + count + " cached PreparedStatement" + (count > 1 ? "s" : ""));
            }
            Map map = this.ps;
            synchronized (map) {
                for (List list : this.ps.values()) {
                    Iterator it = list.iterator();
                    while (it.hasNext()) {
                        ((CachedPreparedStatement)it.next()).release();
                    }
                }
                this.ps.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushOpenPreparedStatements() throws SQLException {
        int count;
        int n = count = this.psUsed != null ? this.psUsed.size() : 0;
        if (count > 0) {
            if (this.pool.isDebug()) {
                this.pool.log("Closing " + count + " open PreparedStatement" + (count > 1 ? "s" : ""));
            }
            List list = this.psUsed;
            synchronized (list) {
                while (!this.psUsed.isEmpty()) {
                    ((CachedPreparedStatement)this.psUsed.remove(0)).release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushSpareCallableStatements() throws SQLException {
        int count;
        int n = count = this.cs != null ? this.cs.size() : 0;
        if (count > 0) {
            if (this.pool.isDebug()) {
                this.pool.log("Closing " + count + " cached CallableStatement" + (count > 1 ? "s" : ""));
            }
            Map map = this.cs;
            synchronized (map) {
                for (List list : this.cs.values()) {
                    Iterator it = list.iterator();
                    while (it.hasNext()) {
                        ((CachedCallableStatement)it.next()).release();
                    }
                }
                this.cs.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushOpenCallableStatements() throws SQLException {
        int count;
        int n = count = this.csUsed != null ? this.csUsed.size() : 0;
        if (count > 0) {
            if (this.pool.isDebug()) {
                this.pool.log("Closing " + count + " open CallableStatement" + (count > 1 ? "s" : ""));
            }
            List list = this.csUsed;
            synchronized (list) {
                while (!this.csUsed.isEmpty()) {
                    ((CachedCallableStatement)this.csUsed.remove(0)).release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void flushOpenNonCachableStatements() throws SQLException {
        int count = this.nonCachable != null ? this.nonCachable.size() : 0;
        if (count <= 0) return;
        if (this.pool.isDebug()) {
            this.pool.log("Closing " + count + " open non-cachable Statement" + (count > 1 ? "s" : ""));
        }
        List list = this.nonCachable;
        synchronized (list) {
            while (true) {
                if (this.nonCachable.isEmpty()) {
                    return;
                }
                try {
                    ((Statement)this.nonCachable.remove(0)).close();
                }
                catch (SQLException sqle) {
                    this.pool.log(sqle);
                }
            }
        }
    }

    public void release() throws SQLException {
        this.open = false;
        ArrayList<SQLException> list = new ArrayList<SQLException>();
        try {
            this.flushSpareStatements();
            this.flushOpenStatements();
        }
        catch (SQLException e) {
            list.add(e);
        }
        try {
            this.flushSparePreparedStatements();
            this.flushOpenPreparedStatements();
        }
        catch (SQLException e) {
            list.add(e);
        }
        try {
            this.flushSpareCallableStatements();
            this.flushOpenCallableStatements();
        }
        catch (SQLException e) {
            list.add(e);
        }
        try {
            this.flushOpenNonCachableStatements();
        }
        catch (SQLException e) {
            list.add(e);
        }
        try {
            this.con.close();
        }
        catch (SQLException e) {
            list.add(e);
        }
        if (!list.isEmpty()) {
            SQLException sqle = new SQLException("Problem releasing connection resources");
            for (SQLException x : list) {
                sqle.setNextException(x);
                sqle = x;
            }
            throw sqle;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.con.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.con.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.con.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.con.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.con.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.con.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.con.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.con.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.con.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.con.clearWarnings();
    }

    public Map getTypeMap() throws SQLException {
        return this.con.getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.con.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.con.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.con.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.con.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.con.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.con.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.con.releaseSavepoint(savepoint);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement x = this.con.prepareStatement(sql, autoGeneratedKeys);
        this.nonCachable.add(x);
        return x;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement x = this.con.prepareStatement(sql, columnIndexes);
        this.nonCachable.add(x);
        return x;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement x = this.con.prepareStatement(sql, columnNames);
        this.nonCachable.add(x);
        return x;
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return null;
    }

    @Override
    public Array createArrayOf(String arg0, Object[] arg1) throws SQLException {
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        return null;
    }

    @Override
    public Clob createClob() throws SQLException {
        return null;
    }

    @Override
    public Struct createStruct(String arg0, Object[] arg1) throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return null;
    }

    @Override
    public String getClientInfo(String arg0) throws SQLException {
        return null;
    }

    @Override
    public boolean isValid(int arg0) throws SQLException {
        return false;
    }
}

