/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.internal.introspection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.jexl2.internal.introspection.ClassMap;
import org.apache.commons.jexl2.internal.introspection.MethodKey;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntrospectorBase {
    protected final Log rlog;
    private final Map<Class<?>, ClassMap> classMethodMaps = new HashMap();
    private ClassLoader loader;
    private final Map<MethodKey, Constructor<?>> constructorsMap = new HashMap();
    private final Map<String, Class<?>> constructibleClasses = new HashMap();
    private static final Constructor<?> CTOR_MISS = CacheMiss.class.getConstructors()[0];

    public IntrospectorBase(Log log) {
        this.rlog = log;
        this.loader = this.getClass().getClassLoader();
    }

    public Class<?> getClassByName(String className) {
        try {
            return Class.forName(className, false, this.loader);
        }
        catch (ClassNotFoundException xignore) {
            return null;
        }
    }

    public Method getMethod(Class<?> c, MethodKey key) {
        try {
            ClassMap classMap = this.getMap(c);
            return classMap.findMethod(key);
        }
        catch (MethodKey.AmbiguousException xambiguous) {
            if (this.rlog != null && this.rlog.isInfoEnabled()) {
                this.rlog.info((Object)("ambiguous method invocation: " + c.getName() + "." + key.debugString()), (Throwable)xambiguous);
            }
            return null;
        }
    }

    public Field getField(Class<?> c, String key) {
        ClassMap classMap = this.getMap(c);
        return classMap.findField(c, key);
    }

    public String[] getFieldNames(Class<?> c) {
        if (c == null) {
            return new String[0];
        }
        ClassMap classMap = this.getMap(c);
        return classMap.getFieldNames();
    }

    public String[] getMethodNames(Class<?> c) {
        if (c == null) {
            return new String[0];
        }
        ClassMap classMap = this.getMap(c);
        return classMap.getMethodNames();
    }

    public Method[] getMethods(Class<?> c, String methodName) {
        if (c == null) {
            return null;
        }
        ClassMap classMap = this.getMap(c);
        return classMap.get(methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoader(ClassLoader cloader) {
        ClassLoader previous = this.loader;
        if (cloader == null) {
            cloader = this.getClass().getClassLoader();
        }
        if (!cloader.equals(this.loader)) {
            Class clazz;
            Map.Entry<Object, Object> entry;
            Iterator<Map.Entry<Object, Object>> entries;
            Map<Object, Object> map = this.constructorsMap;
            synchronized (map) {
                entries = this.constructorsMap.entrySet().iterator();
                while (entries.hasNext()) {
                    entry = entries.next();
                    clazz = entry.getValue().getDeclaringClass();
                    if (!IntrospectorBase.isLoadedBy(previous, clazz)) continue;
                    entries.remove();
                    this.constructibleClasses.remove(entry.getKey().getMethod());
                }
            }
            map = this.classMethodMaps;
            synchronized (map) {
                entries = this.classMethodMaps.entrySet().iterator();
                while (entries.hasNext()) {
                    entry = entries.next();
                    clazz = (Class)entry.getKey();
                    if (!IntrospectorBase.isLoadedBy(previous, clazz)) continue;
                    entries.remove();
                }
            }
            this.loader = cloader;
        }
    }

    private static boolean isLoadedBy(ClassLoader loader, Class<?> clazz) {
        if (loader != null) {
            ClassLoader cloader = clazz.getClassLoader();
            while (cloader != null) {
                if (cloader.equals(loader)) {
                    return true;
                }
                cloader = cloader.getParent();
            }
        }
        return false;
    }

    public Constructor<?> getConstructor(MethodKey key) {
        return this.getConstructor(null, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constructor<?> getConstructor(Class<?> c, MethodKey key) {
        Constructor<?> ctor = null;
        Map<MethodKey, Constructor<?>> map = this.constructorsMap;
        synchronized (map) {
            block14: {
                ctor = this.constructorsMap.get(key);
                if (!CTOR_MISS.equals(ctor)) break block14;
                return null;
            }
            if (ctor == null) {
                String cname = key.getMethod();
                Class<?> clazz = this.constructibleClasses.get(cname);
                try {
                    if (clazz == null) {
                        clazz = c != null && c.getName().equals(key.getMethod()) ? c : this.loader.loadClass(cname);
                        this.constructibleClasses.put(cname, clazz);
                    }
                    LinkedList l = new LinkedList();
                    Constructor<?>[] constructorArray = clazz.getConstructors();
                    int n = constructorArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Constructor<?> ictor = constructorArray[n2];
                        l.add(ictor);
                        ++n2;
                    }
                    ctor = key.getMostSpecificConstructor(l);
                    if (ctor != null) {
                        this.constructorsMap.put(key, ctor);
                    } else {
                        this.constructorsMap.put(key, CTOR_MISS);
                    }
                }
                catch (ClassNotFoundException xnotfound) {
                    if (this.rlog != null && this.rlog.isInfoEnabled()) {
                        this.rlog.info((Object)("unable to find class: " + cname + "." + key.debugString()), (Throwable)xnotfound);
                    }
                    ctor = null;
                }
                catch (MethodKey.AmbiguousException xambiguous) {
                    if (this.rlog != null && this.rlog.isInfoEnabled()) {
                        this.rlog.info((Object)("ambiguous constructor invocation: " + cname + "." + key.debugString()), (Throwable)xambiguous);
                    }
                    ctor = null;
                }
            }
            return ctor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassMap getMap(Class<?> c) {
        Map<Class<?>, ClassMap> map = this.classMethodMaps;
        synchronized (map) {
            ClassMap classMap = this.classMethodMaps.get(c);
            if (classMap == null) {
                classMap = new ClassMap(c, this.rlog);
                this.classMethodMaps.put(c, classMap);
            }
            return classMap;
        }
    }

    private static class CacheMiss {
    }
}

