/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.XSNamespaceI;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.XSNamespace;

class T4CTTIxsnsop
extends T4CTTIfun {
    private OracleConnection.XSOperationCode operationCode;
    private byte[] sessionId;
    private XSNamespace[] namespaces;
    private XSNamespace[] outNamespaces;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Feb_23_16:38:22_PST_2010";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    T4CTTIxsnsop(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)3);
        this.setFunCode((short)172);
    }

    void doOXSNS(OracleConnection.XSOperationCode xSOperationCode, byte[] byArray, XSNamespace[] xSNamespaceArray, boolean bl) throws IOException, SQLException {
        if (bl) {
            this.setTTCCode((byte)3);
        } else {
            this.setTTCCode((byte)17);
        }
        this.operationCode = xSOperationCode;
        this.sessionId = byArray;
        this.namespaces = xSNamespaceArray;
        if (this.namespaces != null) {
            for (int i2 = 0; i2 < this.namespaces.length; ++i2) {
                ((XSNamespaceI)this.namespaces[i2]).doCharConversion(this.meg.conv);
            }
        }
        if (bl) {
            this.doRPC();
        } else {
            this.doPigRPC();
        }
    }

    void marshal() throws IOException {
        this.meg.marshalUB4(this.operationCode.getCode());
        boolean bl = false;
        if (this.sessionId != null && this.sessionId.length > 0) {
            bl = true;
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.sessionId.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        boolean bl2 = false;
        this.meg.marshalPTR();
        if (this.namespaces != null && this.namespaces.length > 0) {
            bl2 = true;
            this.meg.marshalUB4(this.namespaces.length);
        } else {
            this.meg.marshalUB4(0L);
        }
        this.meg.marshalPTR();
        if (bl) {
            this.meg.marshalB1Array(this.sessionId);
        }
        if (bl2) {
            for (int i2 = 0; i2 < this.namespaces.length; ++i2) {
                ((XSNamespaceI)this.namespaces[i2]).marshal(this.meg);
            }
        }
    }

    void readRPA() throws SQLException, IOException {
        this.outNamespaces = null;
        int n2 = (int)this.meg.unmarshalUB4();
        if (n2 > 0) {
            this.outNamespaces = new XSNamespace[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.outNamespaces[i2] = XSNamespaceI.unmarshal(this.meg);
            }
        }
    }

    XSNamespace[] getNamespaces() throws SQLException {
        return this.outNamespaces;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }
}

