/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.resources.ResourceManager;
import com.sun.jnlp.FileContentsImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

final class MeteredFileOutputStream
extends OutputStream {
    static String _message = null;
    private FileContentsImpl _contents;
    private long _written = 0L;
    private FileOutputStream _fis;

    MeteredFileOutputStream(File file, boolean bl, FileContentsImpl fileContentsImpl) throws FileNotFoundException {
        this._fis = new FileOutputStream(file.getAbsolutePath(), bl);
        this._contents = fileContentsImpl;
        this._written = file.length();
        if (_message == null) {
            _message = ResourceManager.getString((String)"api.persistence.filesizemessage");
        }
    }

    public void write(int n) throws IOException {
        this.checkWrite(1);
        this._fis.write(n);
        ++this._written;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.checkWrite(n2);
        this._fis.write(byArray, n, n2);
        this._written += (long)n2;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void close() throws IOException {
        this._fis.close();
        super.close();
    }

    public void flush() throws IOException {
        this._fis.flush();
        super.flush();
    }

    private void checkWrite(int n) throws IOException {
        if (this._written + (long)n > this._contents.getMaxLength()) {
            throw new IOException(_message);
        }
    }
}

