/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DTV;
import com.microsoft.sqlserver.jdbc.DTVImpl;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.IOBuffer;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import com.microsoft.sqlserver.jdbc.Util;
import java.text.MessageFormat;

final class Column {
    private TypeInfo typeInfo;
    private DTV updaterDTV;
    private DTV getterDTV = new DTV();
    String name;
    String tableName;
    private int jdbcUpdateType;

    final TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    Column(TypeInfo typeInfo, String string, String string2) {
        this.typeInfo = typeInfo;
        this.name = string;
        this.tableName = string2;
    }

    Column(String string) {
        this.name = string;
    }

    int setFromTDS(TypeInfo typeInfo, int n, byte[] byArray) throws SQLServerException {
        if (null == this.getterDTV) {
            this.getterDTV = new DTV();
        }
        return this.getterDTV.setFromTDS(typeInfo, n, byArray, true);
    }

    void setFilter(DTVImpl dTVImpl) {
        this.getterDTV.setImpl(dTVImpl);
    }

    boolean isNull() {
        return this.getterDTV.isNull();
    }

    Object getValue(int n) throws SQLServerException {
        return this.getterDTV.getValue(n);
    }

    Object getValue(int n, Object object) throws SQLServerException {
        return this.getterDTV.getValue(n, object);
    }

    byte getByte() throws SQLServerException {
        return this.getterDTV.getByte();
    }

    int getInt() throws SQLServerException {
        return this.getterDTV.getInt();
    }

    short getShort() throws SQLServerException {
        return this.getterDTV.getShort();
    }

    void updateValue(int n, Object object) throws SQLServerException {
        this.updateValue(n, object, null);
    }

    void updateValue(int n, Object object, Object object2) throws SQLServerException {
        int n2 = this.typeInfo.getNativeType();
        if (!DataTypes.canConvertToNativeTypeFromJDBCType(n2, this.typeInfo.getMaxLength(), n)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionFromTo"));
            Object[] objectArray = new Object[]{Util.javaSqlTypeToString(n), DataTypes.sqlNativeTypeToString(n2)};
            SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, true);
        }
        if (null == this.updaterDTV) {
            this.updaterDTV = new DTV();
        }
        this.updaterDTV.setValue(n, object, object2);
        this.jdbcUpdateType = this.updaterDTV.getJdbcType();
    }

    boolean hasUpdates() {
        return null != this.updaterDTV;
    }

    void cancelUpdates() {
        this.updaterDTV = null;
    }

    void sendByRPC(IOBuffer iOBuffer, int n) throws SQLServerException {
        if (null == this.updaterDTV) {
            return;
        }
        this.updaterDTV.sendByRPC(this.name, this.jdbcUpdateType, this.typeInfo.getNativeType(), this.typeInfo.getScale(), false, iOBuffer, n);
    }

    final void checkGetAsciiStream() throws SQLServerException {
        this.checkConvertsAsciiStream(true);
    }

    final void checkUpdateAsciiStream() throws SQLServerException {
        this.checkConvertsAsciiStream(false);
    }

    private void checkConvertsAsciiStream(boolean bl) throws SQLServerException {
        boolean bl2 = DataTypes.canConvertFromNativeTypeToAsciiStream(this.typeInfo);
        if (bl2 && DataTypes.isNonUnicode(this.typeInfo.getNativeType())) {
            bl2 = this.typeInfo.getSQLCollation().supportsAsciiConversion();
        }
        if (!bl2) {
            this.throwConversionError(this.typeInfo.getNativeType(), "AsciiStream", bl);
        }
    }

    final void checkGetBinaryStream() throws SQLServerException {
        this.checkConvertsBinaryStream(true);
    }

    final void checkUpdateBinaryStream() throws SQLServerException {
        this.checkConvertsBinaryStream(false);
    }

    private void checkConvertsBinaryStream(boolean bl) throws SQLServerException {
        if (!DataTypes.canConvertFromNativeTypeToBinaryStream(this.typeInfo)) {
            this.throwConversionError(this.typeInfo.getNativeType(), "BinaryStream", bl);
        }
    }

    final void checkGetCharacterStream() throws SQLServerException {
        this.checkConvertsCharacterStream(true);
    }

    final void checkUpdateCharacterStream() throws SQLServerException {
        this.checkConvertsCharacterStream(false);
    }

    private void checkConvertsCharacterStream(boolean bl) throws SQLServerException {
        if (!DataTypes.canConvertFromNativeTypeToCharStream(this.typeInfo)) {
            this.throwConversionError(this.typeInfo.getNativeType(), "CharacterStream", bl);
        }
    }

    private void throwConversionError(int n, String string, boolean bl) throws SQLServerException {
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionFromTo"));
        Object[] objectArray = new Object[2];
        objectArray[bl ? 0 : 1] = DataTypes.sqlNativeTypeToString(n);
        objectArray[bl ? 1 : 0] = string;
        SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, true);
    }
}

