/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DBComms;
import com.microsoft.sqlserver.jdbc.IOBuffer;
import com.microsoft.sqlserver.jdbc.PacketRequestor;
import com.microsoft.sqlserver.jdbc.Parameter;
import com.microsoft.sqlserver.jdbc.ParameterUtils;
import com.microsoft.sqlserver.jdbc.SQLServerCallableStatement;
import com.microsoft.sqlserver.jdbc.SQLServerConnectionSecurityManager;
import com.microsoft.sqlserver.jdbc.SQLServerDatabaseMetaData;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerPooledConnection;
import com.microsoft.sqlserver.jdbc.SQLServerPreparedStatement;
import com.microsoft.sqlserver.jdbc.SQLServerSavepoint;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.StreamError;
import com.microsoft.sqlserver.jdbc.StreamLoginAck;
import com.microsoft.sqlserver.jdbc.StreamPacket;
import com.microsoft.sqlserver.jdbc.TdsTransactionDescriptor;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.text.Format;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.XAConnection;

public class SQLServerConnection
extends IOBuffer
implements Connection,
Serializable {
    static final int STATTYPE_STATEMENT = 0;
    static final int STATTYPE_PREPARED = 1;
    static final int STATTYPE_CALLABLE = 2;
    public static final int TRANSACTION_SNAPSHOT = 4096;
    static final int MAX_FAILOVERS = 1;
    private boolean sendStringParametersAsUnicode = true;
    private boolean lastUpdateCount;
    private int nLockTimeout;
    private String selectMethod;
    Properties activeConnectionProperties;
    private String applicationName;
    private String instanceName;
    String sConnectURL;
    String sqlServerVersion;
    boolean xopenStates;
    private boolean databaseAutoCommitMode = true;
    private TdsTransactionDescriptor transactionDescriptor = new TdsTransactionDescriptor();
    boolean bIsOpen;
    int connectionID = 0;
    static final int maxDecimalPrecision = 38;
    private static int baseConnectionID = 0;
    private String sCatalog;
    private int transactionIsolationLevel = 2;
    private PacketRequestor[] packetRequestor;
    private SQLServerPooledConnection pooledConnectionParent;
    private DatabaseMetaData databaseMetaData;
    private int nNextSavePointId = 10000;
    private SQLServerConnectionSecurityManager securityManager;
    private Logger connectionlogger;
    private int nHoldability = 1;
    static final int MAX_SQL_LOGIN_NAME_WCHARS = 128;
    static final char[] OUT = new char[]{' ', 'O', 'U', 'T'};

    boolean sendStringParametersAsUnicode() {
        return this.sendStringParametersAsUnicode;
    }

    final String getSelectMethod() {
        return this.selectMethod;
    }

    SQLServerConnection() {
        super(null, 4096);
        this.init();
    }

    void setDatabaseAutoCommitMode(boolean bl) {
        boolean bl2 = this.connectionlogger.isLoggable(Level.FINE);
        if (bl2) {
            this.connectionlogger.fine("connection id  :" + this.connectionID + " Autocommitmode current :" + this.databaseAutoCommitMode + "new: " + bl);
        }
        this.databaseAutoCommitMode = bl;
    }

    private static synchronized int nextConnectionID() {
        return ++baseConnectionID;
    }

    void init() {
        this.connectionlogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerConnection");
        this.connectionID = SQLServerConnection.nextConnectionID();
        this.sCatalog = "master";
        this.packetRequestor = new PacketRequestor[5];
        for (int i = 0; i < 5; ++i) {
            this.packetRequestor[i] = new PacketRequestor();
        }
    }

    void NotImplemented() throws SQLServerException {
        SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_notSupported"), null, false);
    }

    void checkClosed() throws SQLServerException {
        if (!this.bIsOpen) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_connectionIsClosed"), null, false);
        }
    }

    private boolean booleanPropertyOn(String string, String string2) throws SQLServerException {
        if (null == string2) {
            return false;
        }
        String string3 = string2.toLowerCase(Locale.US);
        if (string3.equals("true")) {
            return true;
        }
        if (string3.equals("false")) {
            return false;
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidBooleanValue"));
        Object[] objectArray = new Object[]{new String(string)};
        SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray), null, false);
        return false;
    }

    private static String AppendNameValue(String string, String string2, String string3) {
        string = string + string2;
        string = string + " : ";
        string = string3 != null ? string + string3 : string + "no value set";
        string = string + "  ";
        return string;
    }

    private void ValidateMaxSQLLoginName(String string, String string2) throws SQLServerException {
        if (string2 != null && string2.length() > 128) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_propertyMaximumExceedsChars"));
            Object[] objectArray = new Object[]{string, new Integer(128)};
            SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray), null, false);
        }
    }

    Connection connect(Properties properties, SQLServerPooledConnection sQLServerPooledConnection) throws SQLServerException {
        Object object;
        String string = "";
        boolean bl = this.connectionlogger.isLoggable(Level.FINE);
        this.activeConnectionProperties = (Properties)properties.clone();
        this.pooledConnectionParent = sQLServerPooledConnection;
        String string2 = null;
        String string3 = null;
        string2 = "user";
        string3 = this.activeConnectionProperties.getProperty(string2);
        if (string3 == null) {
            string3 = "";
            this.activeConnectionProperties.setProperty(string2, string3);
        }
        this.ValidateMaxSQLLoginName(string2, string3);
        string2 = "password";
        string3 = this.activeConnectionProperties.getProperty(string2);
        if (string3 == null) {
            string3 = "";
            this.activeConnectionProperties.setProperty(string2, string3);
        }
        this.ValidateMaxSQLLoginName(string2, string3);
        string2 = "databaseName";
        string3 = this.activeConnectionProperties.getProperty(string2);
        this.ValidateMaxSQLLoginName(string2, string3);
        string2 = "loginTimeout";
        string3 = this.activeConnectionProperties.getProperty(string2);
        int n = 10000;
        String string4 = string3;
        if (null != string4 && string4.length() > 0) {
            Object[] objectArray;
            try {
                int n2 = Integer.parseInt(string4);
                if (n2 >= 0 && n2 <= 65535) {
                    if (n2 > 10) {
                        n = n2 * 1000;
                    }
                } else {
                    object = new MessageFormat(SQLServerException.getErrString("R_invalidTimeOut"));
                    objectArray = new Object[]{string4};
                    SQLServerException.makeFromDriverError(this, this, ((Format)object).format(objectArray), null, false);
                }
            }
            catch (NumberFormatException numberFormatException) {
                object = new MessageFormat(SQLServerException.getErrString("R_invalidTimeOut"));
                objectArray = new Object[]{string4};
                SQLServerException.makeFromDriverError(this, this, ((Format)object).format(objectArray), null, false);
            }
        }
        if ((string3 = this.activeConnectionProperties.getProperty(string2 = "serverName")) == null) {
            string3 = "localhost";
        }
        String string5 = "portNumber";
        object = this.activeConnectionProperties.getProperty(string5);
        int n3 = string3.indexOf(92);
        String string6 = null;
        String string7 = null;
        if (n3 >= 0) {
            string7 = string3.substring(n3 + 1, string3.length());
            this.ValidateMaxSQLLoginName("instanceName", string7);
            string3 = string3.substring(0, n3);
            if (object == null || ((String)object).equals("0")) {
                string6 = this.getInstancePort(string3, string7, n);
            }
        }
        this.activeConnectionProperties.setProperty(string2, string3);
        String string8 = this.activeConnectionProperties.getProperty("instanceName");
        if (null != string8) {
            string7 = string8;
        }
        if (string7 != null) {
            this.ValidateMaxSQLLoginName("instanceName", string7);
            if (object == null || ((String)object).equals("0")) {
                string6 = this.getInstancePort(string3, string7, n);
            }
            this.activeConnectionProperties.setProperty("instanceName", string7);
        }
        if (object == null || ((String)object).equals("0")) {
            object = string6 == null ? "1433" : string6;
        }
        this.activeConnectionProperties.setProperty(string5, (String)object);
        string2 = "applicationName";
        string3 = this.activeConnectionProperties.getProperty(string2);
        this.ValidateMaxSQLLoginName(string2, string3);
        string2 = "lastUpdateCount";
        string3 = this.activeConnectionProperties.getProperty(string2);
        if (string3 == null) {
            string3 = "true";
            this.activeConnectionProperties.setProperty(string2, string3);
        }
        if ((string3 = this.activeConnectionProperties.getProperty(string2 = "selectMethod")) == null) {
            string3 = "direct";
        }
        if (string3.equals("cursor") || string3.equals("direct")) {
            this.activeConnectionProperties.setProperty(string2, string3);
        } else {
            SQLServerException.makeFromDriverError(this, this, "Invalid selectMethod property value:" + string3, null, false);
        }
        string2 = "disableStatementPooling";
        string3 = this.activeConnectionProperties.getProperty(string2);
        if (string3 != null && !this.booleanPropertyOn(string2, string3)) {
            SQLServerException.makeFromDriverError(this, this, "Invalid disableStatementPooling property value:" + string3, null, false);
        }
        if ((string3 = this.activeConnectionProperties.getProperty(string2 = "integratedSecurity")) != null && this.booleanPropertyOn(string2, string3)) {
            SQLServerException.makeFromDriverError(this, this, "Invalid integratedSecurity property value:" + string3, null, false);
        }
        string2 = "workstationID";
        string3 = this.activeConnectionProperties.getProperty(string2);
        this.ValidateMaxSQLLoginName(string2, string3);
        for (int i = 0; i < 1; ++i) {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            int n4 = 0;
            try {
                n4 = new Integer(this.activeConnectionProperties.getProperty("portNumber"));
                if (n4 < 0 || n4 > 65535) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPortNumber"));
                    object5 = new Object[]{new Integer(n4)};
                    SQLServerException.makeFromDriverError(this, this, messageFormat.format(object5), null, false);
                }
            }
            catch (NumberFormatException numberFormatException) {
                object5 = new MessageFormat(SQLServerException.getErrString("R_invalidPortNumber"));
                object4 = new Object[]{this.activeConnectionProperties.getProperty("portNumber")};
                SQLServerException.makeFromDriverError(this, this, ((Format)object5).format(object4), null, false);
            }
            if (bl) {
                this.connectionlogger.fine("Calling securityManager.checkConnect(" + this.activeConnectionProperties.getProperty("serverName") + "," + n4 + ")");
            }
            this.securityManager = new SQLServerConnectionSecurityManager(this.activeConnectionProperties.getProperty("serverName"), n4);
            this.securityManager.checkConnect();
            if (bl) {
                this.connectionlogger.fine("securityManager.checkConnect succeeded.");
            }
            this.sendStringParametersAsUnicode = null == this.activeConnectionProperties.getProperty("sendStringParametersAsUnicode") ? true : this.booleanPropertyOn("sendStringParametersAsUnicode", this.activeConnectionProperties.getProperty("sendStringParametersAsUnicode"));
            this.lastUpdateCount = this.booleanPropertyOn("lastUpdateCount", this.activeConnectionProperties.getProperty("lastUpdateCount"));
            this.xopenStates = this.booleanPropertyOn("xopenStates", this.activeConnectionProperties.getProperty("xopenStates"));
            this.selectMethod = null;
            if (this.activeConnectionProperties.getProperty("selectMethod") != null && this.activeConnectionProperties.getProperty("selectMethod").length() > 0) {
                this.selectMethod = this.activeConnectionProperties.getProperty("selectMethod");
            }
            this.applicationName = Util.nameAndVersion(false);
            if (this.activeConnectionProperties.getProperty("applicationName") != null) {
                this.applicationName = this.activeConnectionProperties.getProperty("applicationName");
                this.ValidateMaxSQLLoginName("applicationName", this.applicationName);
            }
            int n5 = 0;
            if (this.activeConnectionProperties.getProperty("loginTimeout") != null && this.activeConnectionProperties.getProperty("loginTimeout").length() > 0) {
                try {
                    int n6 = new Integer(this.activeConnectionProperties.getProperty("loginTimeout"));
                    if (n6 >= 0 && n6 <= 65535) {
                        n5 = n6;
                    } else {
                        object4 = new MessageFormat(SQLServerException.getErrString("R_invalidTimeOut"));
                        object3 = new Object[]{this.activeConnectionProperties.getProperty("loginTimeout")};
                        SQLServerException.makeFromDriverError(this, this, ((Format)object4).format(object3), null, false);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    object4 = new MessageFormat(SQLServerException.getErrString("R_invalidTimeOut"));
                    object3 = new Object[]{this.activeConnectionProperties.getProperty("loginTimeout")};
                    SQLServerException.makeFromDriverError(this, this, ((Format)object4).format(object3), null, false);
                }
            }
            this.nLockTimeout = -1;
            if (this.activeConnectionProperties.getProperty("lockTimeout") != null && this.activeConnectionProperties.getProperty("lockTimeout").length() > 0) {
                try {
                    int n7 = new Integer(this.activeConnectionProperties.getProperty("lockTimeout"));
                    if (n7 >= -1) {
                        this.nLockTimeout = n7;
                    } else {
                        object4 = new MessageFormat(SQLServerException.getErrString("R_invalidLockTimeOut"));
                        object3 = new Object[]{this.activeConnectionProperties.getProperty("lockTimeout")};
                        SQLServerException.makeFromDriverError(this, this, ((Format)object4).format(object3), null, false);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    object4 = new MessageFormat(SQLServerException.getErrString("R_invalidLockTimeOut"));
                    object3 = new Object[]{this.activeConnectionProperties.getProperty("lockTimeout")};
                    SQLServerException.makeFromDriverError(this, this, ((Format)object4).format(object3), null, false);
                }
            }
            object5 = null;
            if (n5 == 0) {
                try {
                    this.setDbCom(new DBComms(this, this.activeConnectionProperties.getProperty("serverName"), n4));
                }
                catch (IOException iOException) {
                    object5 = iOException;
                }
            } else {
                object4 = new SQLServerConnectionThread(this, this.activeConnectionProperties.getProperty("serverName"), n4);
                object3 = new Thread((Runnable)object4);
                ((Thread)object3).setDaemon(true);
                ((Thread)object3).start();
                object2 = Thread.currentThread();
                int n8 = n5 * 10;
                for (int j = 0; j < n8; ++j) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.getDbCom() != null || ((SQLServerConnectionThread)object4).getConnectException() != null) break;
                }
                ((Thread)object3).interrupt();
                object5 = ((SQLServerConnectionThread)object4).getConnectException();
                if (null == object5 && this.getDbCom() == null) {
                    object5 = new IOException("Connection attempt timed out afer " + n5 + " seconds");
                }
            }
            if (object5 != null) {
                object4 = new MessageFormat(SQLServerException.getErrString("R_tcpipConnectionFailed"));
                object3 = new Object[]{""};
                object2 = ((Throwable)object5).toString();
                object2 = ((String)object2).replaceAll(this.activeConnectionProperties.getProperty("serverName"), "");
                String string9 = ((Format)object4).format(object3);
                string9 = string9 + " " + (String)object2;
                SQLServerException.makeFromDriverError(this, this, string9, "08001", false);
            }
            this.logon(this.activeConnectionProperties.getProperty("databaseName"), this.activeConnectionProperties.getProperty("user"), this.activeConnectionProperties.getProperty("password"), this.activeConnectionProperties.getProperty("databaseName"), this.applicationName, this.activeConnectionProperties.getProperty("workstationID"), this.sqlStatementForSettings(), n5);
        }
        this.bIsOpen = true;
        if (bl) {
            this.connectionlogger.fine("End of connect");
        }
        return this;
    }

    void connectionCommand(String string, String string2, boolean bl) throws SQLServerException {
        this.cbufferAppendString(string);
        this.sendCommand((byte)1, 0, bl);
        this.packetRequestor[0].setType((byte)-3);
        StreamPacket streamPacket = this.processPackets(this, this.packetRequestor, 1, string2, false);
    }

    String sqlStatementToInitialize() {
        String string = "";
        if (this.nLockTimeout > -1) {
            string = string + " set lock_timeout " + this.nLockTimeout;
        }
        return string;
    }

    void setCatalogName(String string) {
        if (string != null && string.length() > 0) {
            this.sCatalog = string;
        }
    }

    String sqlStatementToSetTransactionIsolationLevel() throws SQLServerException {
        String string = "set transaction isolation level ";
        switch (this.transactionIsolationLevel) {
            case 1: {
                string = string + " read uncommitted ";
                break;
            }
            case 2: {
                string = string + " read committed ";
                break;
            }
            case 4: {
                string = string + " repeatable read ";
                break;
            }
            case 8: {
                string = string + " serializable ";
                break;
            }
            case 4096: {
                string = string + " snapshot ";
                break;
            }
            default: {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidTransactionLevel"));
                Object[] objectArray = new Object[]{new Integer(this.transactionIsolationLevel)};
                SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray), null, false);
            }
        }
        return string;
    }

    String sqlStatementToSetCommit() {
        String string = this.databaseAutoCommitMode ? "set implicit_transactions off " : "set implicit_transactions on ";
        return string;
    }

    String sqlStatementForSettings() throws SQLServerException {
        String string = "";
        string = string + this.sqlStatementToInitialize() + " " + this.sqlStatementToSetTransactionIsolationLevel() + " " + this.sqlStatementToSetCommit();
        return string;
    }

    String getUrl() {
        return this.sConnectURL;
    }

    private Statement makeStatement(int n, String string, boolean bl, int n2, int n3) throws SQLServerException {
        if (n == 0) {
            return new SQLServerStatement(this, bl, n2, n3, this.lastUpdateCount);
        }
        if (n == 1) {
            return new SQLServerPreparedStatement(this, this.getDbCom(), string, bl, n2, n3, this.lastUpdateCount, this.sendStringParametersAsUnicode);
        }
        if (n == 2) {
            return new SQLServerCallableStatement(this, this.getDbCom(), string, bl, n2, n3, this.sendStringParametersAsUnicode);
        }
        return null;
    }

    public Statement createStatement() throws SQLServerException {
        this.checkClosed();
        return this.makeStatement(0, null, false, 1003, 1007);
    }

    SQLServerStatement createInternalStatement() throws SQLServerException {
        return (SQLServerStatement)this.makeStatement(0, null, true, 0, 0);
    }

    PreparedStatement createInternalPreparedStatement(String string) throws SQLServerException {
        PreparedStatement preparedStatement = (PreparedStatement)this.makeStatement(1, string, true, 0, 0);
        return preparedStatement;
    }

    SQLServerCallableStatement createInternalCallableStatement(String string) throws SQLServerException {
        return (SQLServerCallableStatement)this.makeStatement(2, string, true, 0, 0);
    }

    public PreparedStatement prepareStatement(String string) throws SQLServerException {
        this.checkClosed();
        return (PreparedStatement)this.makeStatement(1, string, false, 1003, 1007);
    }

    public CallableStatement prepareCall(String string) throws SQLServerException {
        this.checkClosed();
        return (CallableStatement)this.makeStatement(2, string, false, 1003, 1007);
    }

    public String nativeSQL(String string) throws SQLServerException {
        this.checkClosed();
        return string;
    }

    public void setAutoCommit(boolean bl) throws SQLServerException {
        this.checkClosed();
        if (bl == this.databaseAutoCommitMode) {
            return;
        }
        if (bl && !this.databaseAutoCommitMode) {
            this.sendCommit("setAutoCommit", false);
        }
        this.setDatabaseAutoCommitMode(bl);
        if (this.databaseAutoCommitMode) {
            return;
        }
        this.sendStartTran("setAutoCommit");
    }

    public boolean getAutoCommit() throws SQLServerException {
        this.checkClosed();
        return this.databaseAutoCommitMode;
    }

    final TdsTransactionDescriptor getTransactionDescriptor() {
        return this.transactionDescriptor;
    }

    private String conId() {
        String string = this.toString();
        int n = string.indexOf("@");
        if (n > 0) {
            string = "CON:" + string.substring(n, string.length());
        }
        return string;
    }

    void sendCommit(String string, boolean bl) throws SQLServerException {
        String string2 = "COMMIT TRAN";
        if (bl) {
            string2 = string2 + " IF @@TRANCOUNT = 0 BEGIN TRAN";
        }
        this.connectionCommand(string2, string, false);
    }

    void sendRollback(String string, boolean bl) throws SQLServerException {
        String string2 = "IF @@TRANCOUNT > 0 ROLLBACK TRAN";
        if (bl) {
            string2 = string2 + " IF @@TRANCOUNT = 0 BEGIN TRAN";
        }
        this.connectionCommand(string2, string, false);
    }

    void sendStartTran(String string) throws SQLServerException {
        this.connectionCommand("IF @@TRANCOUNT = 0 BEGIN TRAN ", string, false);
    }

    public void commit() throws SQLServerException {
        this.checkClosed();
        if (this.databaseAutoCommitMode) {
            return;
        }
        this.sendCommit("Connection.commit", true);
    }

    public void rollback() throws SQLServerException {
        this.checkClosed();
        if (this.databaseAutoCommitMode) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_cantInvokeRollback"), null, true);
        }
        this.sendRollback("Connection.rollback", true);
    }

    public void close() throws SQLServerException {
        if (!this.bIsOpen) {
            return;
        }
        if (this.connectionlogger.isLoggable(Level.FINE)) {
            this.connectionlogger.fine("Closing connection ID:" + this.connectionID);
        }
        this.bIsOpen = false;
        if (null != this.pooledConnectionParent) {
            if (!this.databaseAutoCommitMode && !(this.pooledConnectionParent instanceof XAConnection)) {
                this.connectionCommand("IF @@TRANCOUNT > 0 ROLLBACK TRAN", "close connection", false);
            }
            this.notifyPooledConnection(null);
            if (this.connectionlogger.isLoggable(Level.FINE)) {
                this.connectionlogger.fine("Connection closed and returned to connection pool ID: " + this.connectionID);
            }
        } else {
            this.getDbCom().close();
            this.setDbCom(null);
        }
    }

    public boolean isClosed() throws SQLServerException {
        return !this.bIsOpen;
    }

    public DatabaseMetaData getMetaData() throws SQLServerException {
        this.checkClosed();
        if (this.databaseMetaData == null) {
            this.databaseMetaData = new SQLServerDatabaseMetaData(this);
        }
        return this.databaseMetaData;
    }

    public void setReadOnly(boolean bl) throws SQLServerException {
        this.checkClosed();
    }

    public boolean isReadOnly() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public void setCatalog(String string) throws SQLServerException {
        this.checkClosed();
        if (string != null) {
            SQLServerStatement sQLServerStatement = this.createInternalStatement();
            sQLServerStatement.executeUpdate("use " + Util.escapeSQLId(string));
            this.sCatalog = string;
            sQLServerStatement.close();
        }
    }

    public String getCatalog() throws SQLServerException {
        this.checkClosed();
        return this.sCatalog;
    }

    public void setTransactionIsolation(int n) throws SQLServerException {
        this.checkClosed();
        if (!this.bIsOpen) {
            return;
        }
        if (this.getDbCom() == null || !this.getDbCom().socketIsOpen()) {
            return;
        }
        if (n == 0) {
            return;
        }
        this.transactionIsolationLevel = n;
        String string = this.sqlStatementToSetTransactionIsolationLevel();
        this.connectionCommand(string, "setTransactionIsolation", false);
    }

    public int getTransactionIsolation() throws SQLServerException {
        this.checkClosed();
        return this.transactionIsolationLevel;
    }

    public SQLWarning getWarnings() throws SQLServerException {
        this.checkClosed();
        if (this.sqlWarnings == null) {
            return null;
        }
        return (SQLWarning)this.sqlWarnings.elementAt(0);
    }

    public void clearWarnings() throws SQLServerException {
        this.checkClosed();
        this.sqlWarnings = null;
    }

    public Statement createStatement(int n, int n2) throws SQLServerException {
        this.checkClosed();
        return this.makeStatement(0, null, false, n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLServerException {
        this.checkClosed();
        return (PreparedStatement)this.makeStatement(1, string, false, n, n2);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLServerException {
        this.checkClosed();
        return (CallableStatement)this.makeStatement(2, string, false, n, n2);
    }

    public void setTypeMap(Map map) throws SQLServerException {
        this.NotImplemented();
    }

    public Map getTypeMap() throws SQLServerException {
        this.checkClosed();
        return new HashMap();
    }

    private final void logon(String string, String string2, String string3, String string4, String string5, String string6, String string7, int n) throws SQLServerException {
        this.build70Logon(string2, string3, string4, string5, string6);
        this.sendCommand((byte)16, n, false);
        PacketRequestor[] packetRequestorArray = new PacketRequestor[]{new PacketRequestor(-83)};
        StreamPacket streamPacket = this.processPackets(this, packetRequestorArray, packetRequestorArray.length, "Logon", false);
        if (streamPacket instanceof StreamLoginAck) {
            StreamLoginAck streamLoginAck = (StreamLoginAck)streamPacket;
            this.sqlServerVersion = streamLoginAck.sSQLServerVersion;
            this.changeSettings(string7);
        } else {
            SQLServerException.makeFromDriverError(this, this, ((StreamError)streamPacket).getMessage(), "08001", false);
        }
    }

    final void JTAUnenlistConnection() throws SQLServerException {
        this.bufferAppendShort((short)1);
        this.bufferAppendShort((short)0);
        this.sendCommand((byte)14, 0, false);
        PacketRequestor[] packetRequestorArray = new PacketRequestor[]{new PacketRequestor(-3)};
        StreamPacket streamPacket = this.processPackets(this, packetRequestorArray, packetRequestorArray.length, "MS_DTC", false);
    }

    final void JTAEnlistConnection(byte[] byArray) throws SQLServerException {
        if (byArray.length > Short.MAX_VALUE) {
            throw new SQLServerException(null, "Invalid transaction cookie length.", null, 0, true);
        }
        this.bufferAppendShort((short)1);
        this.bufferAppendShort((short)byArray.length);
        this.bufferAppendByteArray(byArray);
        this.sendCommand((byte)14, 0, false);
        PacketRequestor[] packetRequestorArray = new PacketRequestor[]{new PacketRequestor(-3)};
        StreamPacket streamPacket = this.processPackets(this, packetRequestorArray, packetRequestorArray.length, "MS_DTC", false);
    }

    private void changeSettings(String string) throws SQLServerException {
        this.cbufferAppendString(string);
        this.sendCommand((byte)1, 0, false);
        PacketRequestor[] packetRequestorArray = new PacketRequestor[]{new PacketRequestor(-3)};
        StreamPacket streamPacket = this.processPackets(this, packetRequestorArray, packetRequestorArray.length, "Change Settings", false);
    }

    private byte[] toUCS16(String string) throws SQLServerException {
        if (string == null) {
            return new byte[0];
        }
        int n = string.length();
        byte[] byArray = new byte[n * 2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            byte by = (byte)(c & 0xFF);
            byArray[n2++] = by;
            byArray[n2++] = (byte)(c >> 8 & 0xFF);
        }
        return byArray;
    }

    private byte[] encryptPassword(String string) {
        if (string == null) {
            string = "";
        }
        int n = string.length();
        byte[] byArray = new byte[n * 2];
        for (int i = 0; i < n; ++i) {
            byte by;
            byte by2;
            int n2 = string.charAt(i) ^ 0x5A5A;
            n2 = (n2 & 0xF) << 4 | (n2 & 0xF0) >> 4 | (n2 & 0xF00) << 4 | (n2 & 0xF000) >> 4;
            byArray[i * 2 + 1] = by2 = (byte)((n2 & 0xFF00) >> 8);
            byArray[i * 2 + 0] = by = (byte)(n2 & 0xFF);
        }
        return byArray;
    }

    private void build70Logon(String string, String string2, String string3, String string4, String string5) throws SQLServerException {
        int n;
        int n2;
        if (string5 == null || string5.length() == 0) {
            try {
                string5 = Util.lookupHostName();
            }
            catch (UnknownHostException unknownHostException) {
                SQLServerException.makeFromDriverError(this, this, unknownHostException.getMessage(), "08001", false);
            }
        }
        byte[] byArray = this.toUCS16(string5);
        byte[] byArray2 = this.toUCS16(string);
        byte[] byArray3 = this.encryptPassword(string2);
        int n3 = byArray3 != null ? byArray3.length : 0;
        byte[] byArray4 = this.toUCS16(string4);
        byte[] byArray5 = this.toUCS16(string5);
        byte[] byArray6 = this.toUCS16(string3);
        byte[] byArray7 = new byte[6];
        int n4 = 0;
        int n5 = 0;
        if (this.getDbCom().getTDSVersion().isYukonOrLater()) {
            n2 = 1913192450;
            n = 94;
        } else {
            n2 = 0x71000000;
            n = 86;
        }
        n4 = n3 + byArray.length + byArray2.length + byArray4.length + byArray5.length + byArray6.length + n;
        this.bufferAppendInt(n4);
        this.bufferAppendInt(n2);
        this.bufferAppendInt(4096);
        this.bufferAppendInt(0);
        this.bufferAppendInt(0);
        this.bufferAppendInt(0);
        this.bufferAppendByte((byte)-32);
        this.bufferAppendByte((byte)3);
        this.bufferAppendByte((byte)0);
        this.bufferAppendByte((byte)0);
        this.bufferAppendInt(0);
        this.bufferAppendInt(0);
        this.bufferAppendShort((short)n);
        this.bufferAppendShort((short)(string5 == null ? 0 : string5.length()));
        this.bufferAppendShort((short)(n + (n5 += byArray.length)));
        this.bufferAppendShort((short)(string == null ? 0 : string.length()));
        this.bufferAppendShort((short)(n + (n5 += byArray2.length)));
        this.bufferAppendShort((short)(string2 == null ? 0 : string2.length()));
        this.bufferAppendShort((short)(n + (n5 += n3)));
        this.bufferAppendShort((short)(string4 == null ? 0 : string4.length()));
        this.bufferAppendShort((short)(n + (n5 += byArray4.length)));
        this.bufferAppendShort((short)(string5 == null ? 0 : string5.length()));
        n5 += byArray5.length;
        this.bufferAppendShort((short)0);
        this.bufferAppendShort((short)0);
        this.bufferAppendShort((short)0);
        this.bufferAppendShort((short)0);
        this.bufferAppendShort((short)0);
        this.bufferAppendShort((short)0);
        this.bufferAppendShort((short)(n + n5));
        this.bufferAppendShort((short)(string3 == null ? 0 : string3.length()));
        n5 += byArray6.length;
        this.bufferAppendByteArray(byArray7);
        this.bufferAppendShort((short)0);
        this.bufferAppendShort((short)0);
        this.bufferAppendShort((short)0);
        this.bufferAppendShort((short)0);
        if (n2 >= 0x72000000) {
            this.bufferAppendShort((short)0);
            this.bufferAppendShort((short)0);
            this.bufferAppendInt(0);
        }
        this.bufferAppendByteArray(byArray);
        int n6 = this.nOutIndex;
        this.bufferAppendByteArray(byArray2);
        this.bufferAppendByteArray(byArray3);
        int n7 = this.nOutIndex - n6;
        this.bufferAppendByteArray(byArray4);
        this.bufferAppendByteArray(byArray5);
        this.bufferAppendByteArray(byArray6);
        if (this.getDbCom().isLoggingTDSPackets()) {
            byte[] byArray8 = (byte[])this.binDataBuffer.clone();
            for (int i = n6; i < n6 + n7; ++i) {
                byArray8[i] = -2;
            }
            this.getDbCom().logTDSPacket(byArray8, 0, this.nOutIndex, "Sending TDS packet: " + this.nOutIndex + " bytes");
        }
    }

    private void checkHoldability(int n) throws SQLServerException {
        if (n != 1) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_sqlServerHoldability"), null, false);
        }
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLServerException {
        this.checkClosed();
        this.checkHoldability(n3);
        return this.createStatement(n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLServerException {
        this.checkClosed();
        this.checkHoldability(n3);
        return this.prepareStatement(string, n, n2);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLServerException {
        this.checkClosed();
        this.checkHoldability(n3);
        return this.prepareCall(string, n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLServerException {
        this.checkClosed();
        SQLServerPreparedStatement sQLServerPreparedStatement = (SQLServerPreparedStatement)this.prepareStatement(string);
        sQLServerPreparedStatement.bRequestedGeneratedKeys = n == 1;
        return sQLServerPreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLServerException {
        this.checkClosed();
        if (nArray == null || nArray.length != 1) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        SQLServerPreparedStatement sQLServerPreparedStatement = (SQLServerPreparedStatement)this.prepareStatement(string);
        sQLServerPreparedStatement.bRequestedGeneratedKeys = true;
        return sQLServerPreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLServerException {
        this.checkClosed();
        if (stringArray == null || stringArray.length != 1) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        SQLServerPreparedStatement sQLServerPreparedStatement = (SQLServerPreparedStatement)this.prepareStatement(string);
        sQLServerPreparedStatement.bRequestedGeneratedKeys = true;
        return sQLServerPreparedStatement;
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLServerException {
        throw Util.notSupportedBySQLServer("releaseSavepoint");
    }

    public Savepoint setSavepoint(String string) throws SQLServerException {
        this.checkClosed();
        SQLServerSavepoint sQLServerSavepoint = new SQLServerSavepoint(this, string);
        this.connectionCommand("SAVE TRAN " + Util.escapeSQLId(sQLServerSavepoint.getLabel()), "setSavepoint", false);
        return sQLServerSavepoint;
    }

    public Savepoint setSavepoint() throws SQLServerException {
        this.checkClosed();
        SQLServerSavepoint sQLServerSavepoint = new SQLServerSavepoint(this, null);
        this.connectionCommand("SAVE TRAN " + Util.escapeSQLId(sQLServerSavepoint.getLabel()), "setSavepoint", false);
        return sQLServerSavepoint;
    }

    public void rollback(Savepoint savepoint) throws SQLServerException {
        this.checkClosed();
        this.connectionCommand("ROLLBACK TRAN " + Util.escapeSQLId(((SQLServerSavepoint)savepoint).getLabel()), "rollbackSavepoint", false);
    }

    public int getHoldability() throws SQLServerException {
        return this.nHoldability;
    }

    public void setHoldability(int n) throws SQLServerException {
        this.checkClosed();
        if (n == this.nHoldability) {
            return;
        }
        String string = "SET CURSOR_CLOSE_ON_COMMIT ";
        string = n == 1 ? string + "OFF" : string + "ON";
        this.connectionCommand(string, "setHoldability", false);
        this.nHoldability = n;
    }

    String buildParamTypeDefinitions(Parameter[] parameterArray) throws SQLServerException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = parameterArray.length;
        char[] cArray = new char[10];
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            int n2 = this.makeParamName(i, cArray, 0);
            for (int j = 0; j < n2; ++j) {
                stringBuffer.append(cArray[j]);
            }
            stringBuffer.append(' ');
            String string = parameterArray[i].getTypeDefinition(this.sendStringParametersAsUnicode);
            if (null == string) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_valueNotSetForParameter"));
                Object[] objectArray = new Object[]{new Integer(i + 1)};
                SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray), null, false);
            }
            stringBuffer.append(string);
            if (!parameterArray[i].isOutput()) continue;
            stringBuffer.append(" OUTPUT");
        }
        return stringBuffer.toString();
    }

    String replaceParameterMarkers(String string, Parameter[] parameterArray, boolean bl) throws SQLServerException {
        char[] cArray = new char[string.length() + parameterArray.length * (6 + OUT.length)];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            int n5 = ParameterUtils.scanSQLForChar('?', string, n2);
            string.getChars(n2, n5, cArray, n);
            n += n5 - n2;
            if (string.length() == n5) break;
            n += this.makeParamName(n3++, cArray, n);
            n2 = n5 + 1;
            if (!parameterArray[n4++].isOutput() || bl && n4 <= 1) continue;
            System.arraycopy(OUT, 0, cArray, n, OUT.length);
            n += OUT.length;
        }
        while (n < cArray.length) {
            cArray[n++] = 32;
        }
        return new String(cArray);
    }

    private int makeParamName(int n, char[] cArray, int n2) {
        cArray[n2 + 0] = 64;
        cArray[n2 + 1] = 80;
        if (n < 10) {
            cArray[n2 + 2] = (char)(48 + n);
            return 3;
        }
        if (n < 100) {
            int n3 = 2;
            while (true) {
                if (n < n3 * 10) {
                    cArray[n2 + 2] = (char)(48 + (n3 - 1));
                    cArray[n2 + 3] = (char)(48 + (n - (n3 - 1) * 10));
                    return 4;
                }
                ++n3;
            }
        }
        String string = "" + n;
        string.getChars(0, string.length(), cArray, n2 + 2);
        return 2 + string.length();
    }

    void notifyPooledConnection(Exception exception) {
        if (null != this.pooledConnectionParent) {
            this.pooledConnectionParent.notifyEvent(exception);
        }
    }

    void DetachFromPool() {
        this.pooledConnectionParent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getInstancePort(String string, String string2, int n) throws SQLServerException {
        Object[] objectArray;
        Object object;
        Object object2;
        Object object3;
        DatagramSocket datagramSocket = null;
        byte[] byArray = new byte[4096];
        int n2 = 1434;
        int n3 = n;
        int n4 = 0;
        try {
            object3 = (" " + string2).getBytes();
            object3[0] = 4;
            while (true) {
                datagramSocket = new DatagramSocket();
                object2 = new DatagramPacket((byte[])object3, ((byte[])object3).length, InetAddress.getByName(string), n2);
                datagramSocket.send((DatagramPacket)object2);
                datagramSocket.setSoTimeout(1000);
                object2 = new DatagramPacket(byArray, byArray.length);
                try {
                    datagramSocket.receive((DatagramPacket)object2);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (0 == n4 % 30 && this.connectionlogger.isLoggable(Level.FINE)) {
                        this.connectionlogger.fine("connection id  :" + this.connectionID + " Unexpected UDP timeout at " + (n4 + 1) + " seconds resolving instance port.  Target -> udp:" + InetAddress.getByName(string) + ":1434.");
                    }
                    ++n4;
                    n3 -= 1000;
                    if (null == datagramSocket) continue;
                    datagramSocket.close();
                    datagramSocket = null;
                    if (n3 > 0) continue;
                    throw socketTimeoutException;
                }
                break;
            }
            byArray = ((DatagramPacket)object2).getData();
        }
        catch (Exception exception) {
            object2 = new MessageFormat(SQLServerException.getErrString("R_failedConnection"));
            object = exception.toString();
            object = ((String)object).replaceAll(this.activeConnectionProperties.getProperty("serverName"), "");
            object = ((String)object).replaceAll(string2, "");
            objectArray = new Object[]{"", object};
            SQLServerException.makeFromDriverError(this, this, ((Format)object2).format(objectArray), "08001", false);
        }
        finally {
            if (null != datagramSocket) {
                datagramSocket.close();
            }
        }
        object3 = new String(byArray, 3, byArray.length - 3);
        int n5 = ((String)object3).indexOf("tcp;");
        if (-1 != n5) {
            int n6 = n5 + 4;
            int n7 = ((String)object3).indexOf(59, n6);
            String string3 = ((String)object3).substring(n6, n7);
            return string3;
        }
        object = new MessageFormat(SQLServerException.getErrString("R_notConfiguredToListentcpip"));
        objectArray = new Object[]{string2};
        SQLServerException.makeFromDriverError(this, this, ((Format)object).format(objectArray), "08001", false);
        return null;
    }

    int getNextSavepointId() {
        ++this.nNextSavePointId;
        return this.nNextSavePointId;
    }

    SQLServerConnectionSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    private final class SQLServerConnectionThread
    implements Runnable {
        private SQLServerConnection conn;
        private String serverName;
        private int portNumber;
        private Exception connectException;

        SQLServerConnectionThread(SQLServerConnection sQLServerConnection2, String string, int n) {
            this.conn = sQLServerConnection2;
            this.serverName = string;
            this.portNumber = n;
        }

        public void run() {
            try {
                this.connectException = null;
                this.conn.setDbCom(new DBComms(this.conn, this.serverName, this.portNumber));
            }
            catch (IOException iOException) {
                this.connectException = iOException;
            }
            catch (SQLServerException sQLServerException) {
                this.connectException = sQLServerException;
            }
        }

        Exception getConnectException() {
            return this.connectException;
        }
    }
}

